/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.ssc.AbstractConsignationInfo;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.ConsignationCollection;
import com.kingdee.eas.base.ssc.ConsignationEntryCollection;
import com.kingdee.eas.base.ssc.ConsignationEntryInfo;
import com.kingdee.eas.base.ssc.ConsignationFacadeFactory;
import com.kingdee.eas.base.ssc.ConsignationFactory;
import com.kingdee.eas.base.ssc.ConsignationInfo;
import com.kingdee.eas.base.ssc.ConsignationStatusEnum;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.IConsignation;
import com.kingdee.eas.base.ssc.IUser;
import com.kingdee.eas.base.ssc.ReminderTimeFacadeFactory;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractConsignationControllerBean;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConsignationControllerBean
extends AbstractConsignationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.ConsignationControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsignationInfo info = (ConsignationInfo)model;
        this.check(ctx, info);
        if (info.getStatus() == null) {
            info.setStatus(ConsignationStatusEnum.Submited);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        try {
            Map<String, String> title = this.getMessageTitle("ConsigSubmitTitle");
            Map<String, String> content = this.getMessageContent("ConsigSubmitContent", null);
            if (info.getConsigner() == null || info.getAssignee() == null) {
                return pk;
            }
            UserInfo sender = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getConsigner().getId().toString()));
            UserInfo receiver = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getAssignee().getId().toString()));
            Message message = this.createMessage(ctx, sender.getName(), receiver.getEasUserId(), title, content);
            this.sendMessage(message);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return pk;
    }

    private Map<String, String> getMessageTitle(String key) {
        HashMap<String, String> locale2MsgContent = new HashMap<String, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            locale2MsgContent.put(curLocale.toString(), ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCRec", (String)key, (Locale)curLocale));
        }
        return locale2MsgContent;
    }

    private Map<String, String> getMessageContent(String key, String param) {
        HashMap<String, String> locale2MsgContent = new HashMap<String, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            if (StringUtils.isEmpty((String)param)) {
                locale2MsgContent.put(curLocale.toString(), ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCRec", (String)key, (Locale)curLocale));
                continue;
            }
            String rec = ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCRec", (String)key, (Locale)curLocale);
            locale2MsgContent.put(curLocale.toString(), MessageFormat.format(rec, param));
        }
        return locale2MsgContent;
    }

    private void sendMessage(Message message) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        if (senderAgent.getState() != 1) {
            senderAgent.start();
        }
        senderAgent.sendMessage(message);
    }

    private Message createMessage(Context ctx, String senderName, String receiverId, Map<String, String> title, Map<String, String> content) {
        Message message = MessageFactory.newMessage((String)"kingdee.ssc");
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            message.setLocaleStringHeader("title", title.get(curLocale.toString()), curLocale);
            message.setLocaleStringHeader("body", content.get(curLocale.toString()), curLocale);
            message.setLocaleStringHeader("sender", senderName, curLocale);
        }
        message.setStringHeader("receiver", receiverId);
        message.setStringHeader("sourceID", null);
        return message;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ConsignationInfo info = (ConsignationInfo)model;
        ConsignationInfo oldInfo = this.getConsignationInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        if ("30".equals(oldInfo.getStatus().getValue()) || "40".equals(oldInfo.getStatus().getValue())) {
            throw new SSCException(SSCException.CANNOTUPDATE);
        }
        this.check(ctx, info);
        info.setStatus(ConsignationStatusEnum.Submited);
        super._update(ctx, pk, (IObjectValue)info);
        try {
            Map<String, String> title = this.getMessageTitle("ConsigSubmitTitle");
            Map<String, String> content = this.getMessageContent("ConsigSubmitContent", null);
            UserInfo sender = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getConsigner().getId().toString()));
            UserInfo receiver = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getAssignee().getId().toString()));
            Message message = this.createMessage(ctx, sender.getName(), receiver.getEasUserId(), title, content);
            this.sendMessage(message);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConsignationInfo info = ConsignationFactory.getLocalInstance(ctx).getConsignationInfo(pk);
        if ("30".equals(info.getStatus().getValue()) || "40".equals(info.getStatus().getValue())) {
            throw new SSCException(SSCException.CANNOTDELETE);
        }
        super.delete(ctx, pk);
    }

    private void check(Context ctx, ConsignationInfo info) throws BOSException, EASBizException {
        Timestamp begin = info.getBeginTime();
        Timestamp end = info.getEndTime();
        Date current = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String beginStr = df.format(begin);
        String endStr = df.format(end);
        String currStr = df.format(current);
        if (beginStr.compareTo(currStr) < 0) {
            throw new SSCException(SSCException.BEGINLESSCURRENT);
        }
        if (beginStr.compareTo(endStr) > 0) {
            throw new SSCException(SSCException.BEGINOVEREND);
        }
        FilterInfo assigneeFilter = this.buildReceiveAssigneeFilter(info);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(assigneeFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("consigner.id"));
        sic.add(new SelectorItemInfo("consigner.name"));
        sic.add(new SelectorItemInfo("consigner.number"));
        view.setSelector(sic);
        ConsignationCollection coll = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(view);
        if (coll.size() > 0) {
            StringBuffer consignerNames = new StringBuffer();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ConsignationInfo consignInfo = coll.get(i);
                consignerNames.append(consignInfo.getConsigner().getName()).append("\u3001");
            }
            throw new SSCException(SSCException.DUPCONSIGN, new Object[]{consignerNames.toString().substring(0, consignerNames.length() - 1)});
        }
    }

    @Override
    protected void _close(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add("consigner.isEnabled");
        sic.add("consigner.isStopAssign");
        sic.add(new SelectorItemInfo("consigner.id"));
        sic.add(new SelectorItemInfo("assignee.id"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        HashSet keySet = new HashSet();
        keySet.addAll(idList);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        ConsignationCollection coll = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).completeConsignation(coll.get(i));
        }
        this.updateCloseStatus(ctx, idList, "40", "30");
        RoleFactory.getLocalInstance(ctx).deleteTempConsignRole();
    }

    @Override
    protected void _receive(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        ConsignationCollection collection = new ConsignationCollection();
        IConsignation ic = ConsignationFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("consigner.id"));
        sic.add(new SelectorItemInfo("consigner.name"));
        sic.add(new SelectorItemInfo("consigner.number"));
        sic.add(new SelectorItemInfo("assignee.id"));
        sic.add(new SelectorItemInfo("assignee.name"));
        sic.add(new SelectorItemInfo("assignee.number"));
        sic.add(new SelectorItemInfo("assignee.shareCenterId"));
        sic.add(new SelectorItemInfo("beginTime"));
        sic.add(new SelectorItemInfo("endTime"));
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            ConsignationInfo info = ic.getConsignationInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)), sic);
            FilterInfo filterInfo = this.buildReceiveConsignerFilter(info);
            boolean isExists = ic.exists(filterInfo);
            if (isExists) {
                throw new SSCException(SSCException.RECEIVEDERROR, new Object[]{info.getAssignee().getName()});
            }
            FilterInfo filter = this.buildReceiveAssigneeFilter(info);
            boolean isExists1 = ic.exists(filter);
            if (isExists1) {
                throw new SSCException(SSCException.RECEIVEDASSIGNEEERROR, new Object[]{info.getConsigner().getName()});
            }
            collection.add(info);
        }
        this.updateStatus(ctx, idList, "20", "1");
        Boolean isEffected = false;
        String shareCenterNumber = "";
        for (int i = 0; i < collection.size(); ++i) {
            ConsignationInfo info = collection.get(i);
            if (info.getBeginTime().getTime() >= new Date().getTime() || info.getEndTime().getTime() <= new Date().getTime()) continue;
            isEffected = true;
            String shareCenterId = info.getAssignee().getShareCenterId();
            shareCenterNumber = ShareCenterUtils.getShareCenterInfo(ctx, shareCenterId).getNumber();
            break;
        }
        if (isEffected.booleanValue()) {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).consignateNew(shareCenterNumber);
        }
        try {
            IUser iUser = UserFactory.getLocalInstance(ctx);
            for (int i = 0; i < collection.size(); ++i) {
                ConsignationInfo info = collection.get(i);
                UserInfo sender = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(info.getAssignee().getId().toString()));
                UserInfo receiver = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(info.getConsigner().getId().toString()));
                Map<String, String> title = this.getMessageTitle("ConsigReciveTtile");
                Map<String, String> content = this.getMessageContent("ConsigRecevieContent", sender.getName());
                Message message = this.createMessage(ctx, sender.getName(), receiver.getEasUserId(), title, content);
                this.sendMessage(message);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private FilterInfo buildReceiveConsignerFilter(ConsignationInfo info) {
        FilterInfo filterInfo = new FilterInfo();
        String stId = info.getAssignee().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("consigner.id", (Object)stId));
        return this.buildFilter(info, filterInfo);
    }

    private FilterInfo buildReceiveAssigneeFilter(ConsignationInfo info) {
        FilterInfo filterInfo = new FilterInfo();
        String wtId = info.getConsigner().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("assignee.id", (Object)wtId));
        return this.buildFilter(info, filterInfo);
    }

    private FilterInfo buildFilter(ConsignationInfo info, FilterInfo filterInfo) {
        Timestamp begin = info.getBeginTime();
        Timestamp end = info.getEndTime();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"20"));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"30"));
        filterInfo.getFilterItems().add(new FilterItemInfo("beginTime", (Object)end, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endTime", (Object)begin, CompareType.GREATER_EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filterInfo.setMaskString("#0 and (#1 or #2) and (#3 and #4) and #5");
        } else {
            filterInfo.setMaskString("#0 and (#1 or #2) and (#3 and #4) ");
        }
        return filterInfo;
    }

    @Override
    protected void _refuse(Context ctx, List idList) throws BOSException, EASBizException {
        this.updateStatus(ctx, idList, "50", "1");
        try {
            IConsignation ic = ConsignationFactory.getLocalInstance(ctx);
            for (int i = 0; i < idList.size(); ++i) {
                ConsignationInfo info = ic.getConsignationInfo((IObjectPK)new ObjectUuidPK((String)idList.get(i)));
                UserInfo sender = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getAssignee().getId().toString()));
                UserInfo receiver = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getConsigner().getId().toString()));
                Map<String, String> title = this.getMessageTitle("ConsigRefuseTitle");
                Map<String, String> content = this.getMessageContent("ConsigRefuseContent", sender.getName());
                Message message = this.createMessage(ctx, sender.getName(), receiver.getEasUserId(), title, content);
                this.sendMessage(message);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateStatus(Context ctx, List idList, String newStatus, String oldStatus) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        String sql = "update t_ssc_consignation set fstatus=? where fid =? and FStatus = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Object id : idList) {
            paramList.add(new Object[]{newStatus, (String)id, oldStatus});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    private void updateCloseStatus(Context ctx, List idList, String newStatus, String oldStatus) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        String sql = "update t_ssc_consignation set fstatus=?,fendtime=? where fid =?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        for (Object id : idList) {
            paramList.add(new Object[]{newStatus, currentDate, (String)id});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    @Override
    protected IObjectValue _toWebConsignationInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AbstractConsignationInfo conInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("consigner.*"));
        tSelectColl.add(new SelectorItemInfo("assignee.*"));
        tSelectColl.add(new SelectorItemInfo("entrys.*"));
        tSelectColl.add(new SelectorItemInfo("entrys.bussType"));
        tSelectColl.add(new SelectorItemInfo("entrys.billType"));
        tSelectColl.add(new SelectorItemInfo("entrys.bussNum"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filterReLevel = new FilterInfo();
        filterReLevel.appendFilterItem("id", (Object)pk.toString());
        viewInfo.setFilter(filterReLevel);
        ConsignationCollection conCollection = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(viewInfo);
        if (conCollection != null && conCollection.size() > 0) {
            conInfo = conCollection.get(0);
        }
        if (conInfo == null) {
            return null;
        }
        ConsignationInfo conInfos = ConsignationFacadeFactory.getLocalInstance(ctx).createWebConsignationInfo(conInfo.getConsigner().getId().toString());
        ConsignationEntryCollection entry = conInfos.getEntrys();
        for (int i = 0; i < entry.size(); ++i) {
            ConsignationEntryInfo entryInfo = entry.get(i);
            for (int j = 0; j < conInfo.getEntrys().size(); ++j) {
                if (entryInfo.getTaskType().equals((Object)ConsignationTaskTypeEnum.shareJob)) {
                    String bussId = entryInfo.getBussType().getId().toString();
                    BussinessAttributeInfo bussType = conInfo.getEntrys().get(j).getBussType();
                    if (bussType == null || !bussId.equals(bussType.getId().toString())) continue;
                    entryInfo.setInt("isSelected", 1);
                    continue;
                }
                String billTypeId = entryInfo.getBillType().getId().toString();
                BillTypeInfo billType = conInfo.getEntrys().get(j).getBillType();
                if (billType == null || !billTypeId.equals(billType.getId().toString()) || !entryInfo.getTaskType().equals((Object)conInfo.getEntrys().get(j).getTaskType())) continue;
                entryInfo.setInt("isSelected", 1);
            }
        }
        conInfos.setConsigner(conInfo.getConsigner());
        conInfos.setAssignee(conInfo.getAssignee());
        conInfos.setBeginTime(conInfo.getBeginTime());
        conInfos.setEndTime(conInfo.getEndTime());
        conInfos.setId(conInfo.getId());
        return conInfos;
    }
}

