/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.ssc.CreditFilesInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewCollection;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditFilesControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class CreditFilesControllerBean
extends AbstractCreditFilesControllerBean {
    private static final long serialVersionUID = -4044383822382494425L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditFilesControllerBean");

    @Override
    protected void _manualEdit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CreditFilesInfo filesInfo = null;
        if (model instanceof CreditFilesInfo) {
            filesInfo = (CreditFilesInfo)model;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("creditRating.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filterReLevel = new FilterInfo();
        filterReLevel.appendFilterItem("id", (Object)pk.toString());
        viewInfo.setFilter(filterReLevel);
        CreditFilesNewCollection creditFilesColl = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewCollection(viewInfo);
        CreditFilesNewInfo oldCreditFiles = null;
        if (creditFilesColl != null && creditFilesColl.size() > 0) {
            oldCreditFiles = creditFilesColl.get(0);
        }
        if (filesInfo == null) {
            return;
        }
        if (oldCreditFiles != null) {
            CreditScoreInfo creditScore_new = (CreditScoreInfo)model.get("creditRating");
            BigDecimal score_new = (BigDecimal)model.get("creditScore");
            if (oldCreditFiles.getCreditScore() != null && oldCreditFiles.getCreditScore().compareTo(score_new) < 0) {
                if (!oldCreditFiles.getCreditRating().get("name_l2").equals(creditScore_new.get("name_l2"))) {
                    this.writeCreditLogs(ctx, creditScore_new, score_new, oldCreditFiles, filesInfo, 1);
                } else {
                    this.writeCreditLogs(ctx, creditScore_new, score_new, oldCreditFiles, filesInfo, 3);
                }
            } else if (oldCreditFiles.getCreditScore() != null && oldCreditFiles.getCreditScore().compareTo(score_new) > 0) {
                if (!oldCreditFiles.getCreditRating().get("name_l2").equals(creditScore_new.get("name_l2"))) {
                    this.writeCreditLogs(ctx, creditScore_new, score_new, oldCreditFiles, filesInfo, 2);
                } else {
                    this.writeCreditLogs(ctx, creditScore_new, score_new, oldCreditFiles, filesInfo, 4);
                }
                filesInfo.setUnqualifiedTotalNum(filesInfo.getUnqualifiedTotalNum() + 1);
            }
        }
        super._update(ctx, pk, model);
    }

    private void writeCreditLogs(Context ctx, CreditScoreInfo creditScore_new, BigDecimal score_new, CreditFilesNewInfo oldCreditFiles, CreditFilesInfo newCreditFiles, int i) {
        CreditLogInfo tCreditLogInfo = new CreditLogInfo();
        tCreditLogInfo.setCreditFilesNew(oldCreditFiles);
        tCreditLogInfo.setChangeSource(ChangeSourceEnum.manualUpdate);
        tCreditLogInfo.setOriginalGrade(oldCreditFiles.getCreditRating());
        tCreditLogInfo.setCurrentGrade(creditScore_new);
        tCreditLogInfo.setOriginalScore(oldCreditFiles.getCreditScore());
        tCreditLogInfo.setCurrentScore(score_new);
        tCreditLogInfo.setChangeScore(oldCreditFiles.getCreditScore().add(score_new.negate()).abs());
        if (oldCreditFiles.getCreditRating().get("name_l2").equals(creditScore_new.get("name_l2"))) {
            tCreditLogInfo.setChangGrade(0);
        } else {
            tCreditLogInfo.setChangGrade(Math.abs(oldCreditFiles.getCreditRating().getSeqNo() - creditScore_new.getSeqNo()));
        }
        tCreditLogInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tCreditLogInfo.setChangeDate(new Date());
        StringBuffer tDescription = new StringBuffer();
        if (i == 1) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.upgrade);
        } else if (i == 2) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.degrade);
        } else if (i == 3) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.bonusPoint);
        } else if (i == 4) {
            tCreditLogInfo.setCreditChangeType(CreditChangeTypeEnum.deduction);
        }
        String description = newCreditFiles.getDescription(newCreditFiles.getDefaultLocale()) == null ? "" : "\uff1a" + newCreditFiles.getDescription(newCreditFiles.getDefaultLocale());
        tDescription.append(" \u624b\u5de5\u4fee\u6539" + description + ",\u4ece" + Double.parseDouble(tCreditLogInfo.getOriginalScore().toString()) + "\u5206\u53d8\u66f4\u5230");
        tDescription.append(Double.parseDouble(tCreditLogInfo.getCurrentScore().toString()) + "\u5206,");
        tDescription.append("\u4ece" + oldCreditFiles.getCreditRating() + "\u7ea7\u53d8\u66f4\u5230");
        tDescription.append(tCreditLogInfo.getCurrentGrade() + "\u7ea7");
        tCreditLogInfo.setDescription(tDescription.toString());
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)tCreditLogInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"EASBizException \u624b\u5de5\u4fee\u6539\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"BOSException \u624b\u5de5\u4fee\u6539\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7", (Throwable)e);
        }
    }
}

