/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AbstractCreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditFilesCollection;
import com.kingdee.eas.base.ssc.CreditFilesFactory;
import com.kingdee.eas.base.ssc.CreditFilesInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditScoreFactory;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.ExtendERPFactory;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.IOrg;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFacadeFactory;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditFilesDataInitFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.ssc.tool.OrgRoleUserUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CreditFilesDataInitFacadeControllerBean
extends AbstractCreditFilesDataInitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditFilesDataInitFacadeControllerBean");

    @Override
    protected int _insertData(Context ctx, String extendERPId) throws BOSException {
        long start;
        String key = "[ctx.getAIS:" + ctx.getAIS() + ",erpId:" + extendERPId + "]";
        long tmp = start = System.currentTimeMillis();
        int count = 0;
        try {
            OrgFacadeFactory.getLocalInstance(ctx).synchroniseEasOrg(null, extendERPId);
            tmp = System.currentTimeMillis();
            logger.info((Object)(key + "\u540c\u6b65\u7ec4\u7ec7\u5f00\u9500:" + (tmp - start)));
            ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendERPId);
            HashMap<String, String> solution = new HashMap<String, String>();
            solution.put("orgId", "00000000-0000-0000-0000-000000000000CCE7AED4");
            solution.put("sorterType", "asc");
            solution.put("rowCount", "2147483647");
            solution.put("sorter", "number");
            solution.put("startIndex", "0");
            String erpData = service.getAdminUnitUser(ctx, extendERPId, JSONUtils.convertObjectToJson((Context)ctx, solution));
            JSONObject erpDataJson = new JSONObject(erpData);
            JSONArray usersArr = erpDataJson.getJSONArray("rows");
            logger.info((Object)("creditFiles user size : " + usersArr.length() + "..............."));
            HashMap<String, OrgInfo> orgCache = new HashMap<String, OrgInfo>();
            CreditFilesNewInfo info = null;
            CoreBaseCollection colls = new CoreBaseCollection();
            ExtendERPInfo extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)extendERPId)));
            CreditScoreInfo creditScoreInfo = this.getDefaultCreditRating(ctx);
            int orgNotExists = 0;
            StringBuffer orgBuf = new StringBuffer();
            CoreBaseCollection creditFiles = new CoreBaseCollection();
            int j = usersArr.length();
            for (int i = 0; i < j; ++i) {
                JSONObject user = usersArr.getJSONObject(i);
                if (CreditFilesFactory.getLocalInstance(ctx).exists("where userId = '" + user.getString("id") + "'")) continue;
                OrgInfo orgInfo = this.getUserInfoByexternOrgId(ctx, user.getString("adminOrgUnitId"), orgCache);
                if (null == orgInfo) {
                    ++orgNotExists;
                    orgBuf.append("'" + user.getString("adminOrgUnitId") + "',");
                    logger.info((Object)"creditFiles org not exists...............");
                    continue;
                }
                if (CreditFilesNewFactory.getLocalInstance(ctx).exists("where userAccount = '" + user.getString("number") + "'")) {
                    info = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfo("where userAccount = '" + user.getString("number") + "'");
                } else {
                    info = new CreditFilesNewInfo();
                    info.setId(BOSUuid.create((BOSObjectType)new CreditFilesNewInfo().getBOSType()));
                    info.setUserAccount(user.getString("number"));
                    info.setNumber(user.getString("number"));
                    info.setUserName(user.getString("name"));
                    info.setName(user.getString("name"));
                    try {
                        info.setUserEmail(user.getString("email"));
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (creditScoreInfo != null) {
                        info.setCreditScore(creditScoreInfo.getScore());
                        info.setCreditRating(creditScoreInfo);
                    } else {
                        info.setCreditScore(new BigDecimal(60));
                        info.setCreditRating(null);
                    }
                    info.setUnqualifiedTotalNum(0);
                    info.setThisYearUnqualifiedNum(0);
                }
                if ("EAS".equals(orgInfo.getExtendErp().getNumber())) {
                    info.setOrg(orgInfo);
                } else {
                    OrgCollection orgs = OrgFactory.getLocalInstance(ctx).getOrgCollection("where extendErp.id = 'mJERhy5OTjSHi8dBQ6ym8z29hzk=' and number = '" + orgInfo.getNumber() + "'");
                    if (orgs.size() > 0) {
                        info.setOrg(orgs.get(0));
                    }
                }
                CreditFilesInfo creditFileInfo = new CreditFilesInfo();
                creditFileInfo.setCreditFilesNew(info);
                creditFileInfo.setUserAccount(user.getString("number"));
                creditFileInfo.setUserName(user.getString("name"));
                creditFileInfo.setUserId(user.getString("id"));
                creditFileInfo.setUnqualifiedTotalNum(0);
                creditFileInfo.setThisYearUnqualifiedNum(0);
                creditFileInfo.setSourceSystem(extendERPInfo);
                creditFileInfo.setOrg(orgInfo);
                creditFiles.add((CoreBaseInfo)creditFileInfo);
                colls.add((CoreBaseInfo)info);
                ++count;
            }
            logger.info((Object)("creditFiles org not exists list : " + orgBuf.toString() + "..............."));
            logger.info((Object)("init " + count + " CreditFiles..............."));
            CreditFilesNewFactory.getLocalInstance(ctx).saveBatchData(colls);
            CreditFilesFactory.getLocalInstance(ctx).saveBatchData(creditFiles);
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        logger.info((Object)"init CreditFiles end...............");
        logger.info((Object)("init time = " + (end - start) + "........."));
        return count;
    }

    private OrgInfo getUserInfoByexternOrgId(Context ctx, String externOrgId, Map<String, OrgInfo> orgCache) throws BOSException, EASBizException, JSONException {
        OrgInfo org = null;
        if (null != externOrgId && !"".equals(externOrgId)) {
            if (orgCache.containsKey(externOrgId)) {
                org = orgCache.get(externOrgId);
            } else {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("extendErp.number");
                entityViewInfo.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                entityViewInfo.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)externOrgId, CompareType.EQUALS));
                CoreBaseCollection cols = OrgFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
                if (null != cols && cols.size() > 0) {
                    org = (OrgInfo)cols.get(0);
                    orgCache.put(externOrgId, org);
                } else {
                    return null;
                }
            }
        }
        return org;
    }

    private boolean initOrg(Context ctx, String extendERPId) throws BOSException, JSONException, EASBizException {
        boolean result = false;
        ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendERPId);
        String org = service.getAllFullOrgUnit(ctx, extendERPId, "");
        JSONObject orgJson = new JSONObject(org);
        JSONObject root = orgJson.getJSONObject("root");
        JSONArray children = orgJson.getJSONArray("children");
        children.put((Object)root);
        CoreBaseCollection colls = new CoreBaseCollection();
        logger.info((Object)("extern system orgs size: " + children.length() + "..............."));
        IOrg orgService = OrgFactory.getLocalInstance(ctx);
        try {
            int j = children.length();
            for (int i = 0; i < j; ++i) {
                JSONObject json = children.getJSONObject(i);
                if (orgService.exists("where orgID='" + json.getString("id") + "'")) continue;
                OrgInfo orgInfo = new OrgInfo();
                orgInfo.setOrgID(json.getString("id"));
                orgInfo.setName(json.getString("name"));
                orgInfo.setParent(json.getString("parent"));
                orgInfo.setNumber(json.getString("number"));
                orgInfo.setSimpleName("testInit");
                orgInfo.setIsLeaf((Boolean)json.get("isLeaf"));
                orgInfo.setLevel((Integer)json.get("level"));
                orgInfo.setDisplayName((String)json.get("displayName"));
                orgInfo.setLongNumber((String)json.get("longNumber"));
                colls.add((CoreBaseInfo)orgInfo);
            }
            logger.info((Object)("init " + colls.size() + "credit orgs..............."));
            orgService.addnewBatchData(colls);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected String _getUserCreditFilesData(Context ctx, String userAccount, String userName, String orgid, String parentOrgId, String orgNumber, String orgName, String extendERPId) throws BOSException {
        CreditFilesInfo info = null;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection tSelectColl = new SelectorItemCollection();
            tSelectColl.add(new SelectorItemInfo("*"));
            tSelectColl.add(new SelectorItemInfo("creditFilesNew.*"));
            viewInfo.setSelector(tSelectColl);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceSystem.id", (Object)extendERPId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("userAccount", (Object)userAccount, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)orgid, CompareType.EQUALS));
            CreditFilesCollection infos = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection(viewInfo);
            if (0 == infos.size()) {
                return null;
            }
            info = infos.get(0);
            if (info != null && info.size() != 0) {
                info.setCreditScore(info.getCreditFilesNew().getCreditScore());
                info.setCreditRating(info.getCreditFilesNew().getCreditRating());
            } else {
                info = new CreditFilesInfo();
                HashMap<String, String> externOrg = new HashMap<String, String>();
                externOrg.put("orgId", orgid);
                externOrg.put("orgParentId", parentOrgId);
                externOrg.put("orgName", orgName);
                externOrg.put("orgNumber", orgNumber);
                ExtendERPInfo erpInfo = (ExtendERPInfo)ExtendERPFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(extendERPId));
                info.setSourceSystem(erpInfo);
                info = new CreditFilesInfo();
                info.setUserAccount(userAccount);
                CreditScoreInfo csInfo = this.getDefaultCreditRating(ctx);
                if (csInfo != null) {
                    info.setCreditScore(csInfo.getScore());
                    info.setCreditRating(csInfo);
                } else {
                    info.setCreditScore(new BigDecimal(60));
                    info.setCreditRating(null);
                }
                info.setUnqualifiedTotalNum(0);
                info.setThisYearUnqualifiedNum(0);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info.toString();
    }

    private CreditScoreInfo getDefaultCreditRating(Context ctx) {
        CreditScoreInfo info = null;
        String oql = "where grade = 1";
        try {
            info = (CreditScoreInfo)CreditScoreFactory.getLocalInstance(ctx).getValue(oql);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    @Override
    protected Map _getCreditFilesUtil(Context ctx, String userId, String userAccount, String userName, String orgid, String parentOrgId, String orgNumber, String orgName, String extendERPId) throws BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("userAccount", userAccount);
        String localeStr = ctx.getLocale().toString();
        if (userName.indexOf("{") >= 0 && userName.indexOf("}") > 0) {
            HashMap userNameMap = JSONUtils.convertJsonToObject((Context)ctx, (String)userName);
            HashMap orgNameMap = JSONUtils.convertJsonToObject((Context)ctx, (String)orgName);
            userName = (String)userNameMap.get("userName_" + localeStr);
            orgName = (String)orgNameMap.get("orgName_" + localeStr);
        }
        params.put("userName", userName);
        params.put("orgid", orgid);
        params.put("orgNumber", orgNumber);
        params.put("orgName", orgName);
        params.put("parentOrgId", parentOrgId);
        params.put("extendERPId", extendERPId);
        String paramStr = JSONUtil.map2json(params);
        try {
            String result = this.getUserProfile(ctx, paramStr);
            logger.error((Object)("_getCreditFilesUtil result " + result));
            if (result != null && result.length() > 0) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                CreditFilesInfo info = (CreditFilesInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)result, CreditFilesInfo.class);
                resultMap.put("creditName", info.getCreditRating().getName());
                resultMap.put("creditNumber", info.getCreditRating().getNumber());
                resultMap.put("creditSeqNo", info.getCreditRating().getSeqNo());
                return resultMap;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            logger.error((Object)("_getCreditFilesUtil error " + ex.getMessage()));
            return null;
        }
        return null;
    }

    @Override
    protected String _getUserProfile(Context ctx, String params) throws BOSException {
        Map user = JSONUtil.jsonToMap(params);
        String userId = "";
        String userAccount = "";
        String userName = "";
        String orgid = "";
        String parentOrgId = "";
        String orgNumber = "";
        String orgName = "";
        String extendERPId = "";
        String email = "";
        if (null != user.get("userId") && !"null".equals(user.get("userId"))) {
            userId = user.get("userId").toString();
            if (user.size() == 1) {
                CreditFilesCollection creditFilesCollection = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection("select creditFilesNew.*, creditFilesNew.creditRating where userId = '" + userId + "'");
                return creditFilesCollection.isEmpty() ? "" : JSONUtils.convertObjectToJson((Context)ctx, (Object)creditFilesCollection.get(0).getCreditFilesNew());
            }
        } else {
            throw new BOSException((Throwable)new EASBizException(EASBizException.CHECKBLANK, new Object[]{"userId"}));
        }
        if (null != user.get("userAccount") && !"null".equals(user.get("userAccount"))) {
            userAccount = user.get("userAccount").toString();
        }
        if (null != user.get("userName") && !"null".equals(user.get("userName"))) {
            userName = user.get("userName").toString();
        }
        if (null != user.get("orgid") && !"null".equals(user.get("orgid"))) {
            orgid = user.get("orgid").toString();
        }
        if (null != user.get("parentOrgId") && !"null".equals(user.get("parentOrgId"))) {
            parentOrgId = user.get("parentOrgId").toString();
        }
        if (null != user.get("orgNumber") && !"null".equals(user.get("orgNumber"))) {
            orgNumber = user.get("orgNumber").toString();
        }
        if (null != user.get("orgName") && !"null".equals(user.get("orgName"))) {
            orgName = user.get("orgName").toString();
        }
        if (null != user.get("extendERPId") && !"null".equals(user.get("extendERPId"))) {
            extendERPId = user.get("extendERPId").toString();
        }
        if (null != user.get("userEmail") && !"null".equals(user.get("userEmail"))) {
            email = user.get("userEmail").toString();
        }
        AbstractCreditFilesNewInfo info = null;
        CreditFilesInfo entryInfo = null;
        try {
            ExtendERPInfo extendERPInfo = null;
            try {
                extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo("select *,orgExtendERPId.* where number = '" + extendERPId + "'");
                extendERPId = extendERPInfo.getId().toString();
            }
            catch (Exception e) {
                ObjectUuidPK uuid = new ObjectUuidPK(extendERPId);
                extendERPInfo = ExtendERPFactory.getLocalInstance(ctx).getExtendERPInfo("select *,orgExtendERPId.* where id = '" + uuid.toString() + "'");
            }
            extendERPInfo = extendERPInfo.getOrgExtendERPId();
            OrgInfo orgInfo = new OrgInfo();
            orgInfo.setOrgID(orgid);
            orgInfo.setName(orgName);
            orgInfo.setParent(parentOrgId);
            orgInfo.setNumber(orgNumber);
            orgInfo.setExtendErp(extendERPInfo);
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            if (CreditFilesFactory.getLocalInstance(ctx).exists("where userId = '" + userId + "' and sourceSystem = '" + extendERPId + "'")) {
                entryInfo = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection("select *, org.orgID, creditFilesNew.*, creditFilesNew.org.*, creditFilesNew.creditRating.* where userId = '" + userId + "' and sourceSystem = '" + extendERPId + "'").get(0);
                if (!StringUtils.isEmpty((String)orgid) && !entryInfo.getOrg().getOrgID().equals(orgid)) {
                    entryInfo.setOrg(this.getUserInfoByExternOrgId(ctx, orgInfo));
                    CreditFilesFactory.getLocalInstance(ctx).save((CoreBaseInfo)entryInfo);
                }
                info = entryInfo.getCreditFilesNew();
            } else {
                entryInfo = new CreditFilesInfo();
                entryInfo.setCreditFilesNew((CreditFilesNewInfo)info);
                entryInfo.setUserAccount(userAccount);
                entryInfo.setUserName(userName);
                entryInfo.setUserId(userId);
                entryInfo.setUnqualifiedTotalNum(0);
                entryInfo.setThisYearUnqualifiedNum(0);
                entryInfo.setSourceSystem(extendERPInfo);
                entryInfo.setOrg(this.getUserInfoByExternOrgId(ctx, orgInfo));
                if (CreditFilesNewFactory.getLocalInstance(ctx).exists("where userAccount = '" + userAccount + "'")) {
                    info = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfo("select *, creditRating.id, creditRating.seqNo, creditRating.name, creditRating.number where userAccount = '" + userAccount + "'");
                } else {
                    info = new CreditFilesNewInfo();
                    info.setId(BOSUuid.create((BOSObjectType)new CreditFilesNewInfo().getBOSType()));
                    CreditScoreInfo creditScoreInfo = this.getDefaultCreditRating(ctx);
                    if (creditScoreInfo != null) {
                        info.setCreditScore(creditScoreInfo.getScore());
                        info.setCreditRating(creditScoreInfo);
                    } else {
                        info.setCreditScore(new BigDecimal(60));
                        info.setCreditRating(null);
                    }
                    info.setUnqualifiedTotalNum(0);
                    info.setThisYearUnqualifiedNum(0);
                }
                entryInfo.setCreditFilesNew((CreditFilesNewInfo)info);
                cu.setCU(cu);
                CreditFilesFactory.getLocalInstance(ctx).save((CoreBaseInfo)entryInfo);
            }
            entryInfo.setUnqualifiedTotalNum(info.getUnqualifiedTotalNum());
            entryInfo.setThisYearUnqualifiedNum(info.getThisYearUnqualifiedNum());
            entryInfo.setCreditRating(info.getCreditRating());
            entryInfo.setCreditScore(info.getCreditScore());
            if ("EAS".equals(extendERPInfo.getNumber())) {
                if (null == orgInfo.getId()) {
                    info.setOrg(this.getUserInfoByExternOrgId(ctx, orgInfo));
                } else {
                    info.setOrg(orgInfo);
                }
            } else {
                OrgCollection orgs = OrgFactory.getLocalInstance(ctx).getOrgCollection("where extendErp.id = 'mJERhy5OTjSHi8dBQ6ym8z29hzk=' and number = '" + orgInfo.getNumber() + "'");
                if (orgs.size() > 0) {
                    info.setOrg(orgs.get(0));
                }
            }
            info.setUserAccount(userAccount);
            info.setUserName(userName);
            info.setName(userName);
            info.setNumber(userAccount);
            info.setUserEmail(email);
            info.setCU(cu);
            CreditFilesNewFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        CreditFilesNewInfo rtInfo = new CreditFilesNewInfo();
        rtInfo.setId(info.getId());
        rtInfo.setOrg(info.getOrg());
        rtInfo.setUserAccount(info.getUserAccount());
        rtInfo.setUserName(info.getUserName());
        rtInfo.setCreditScore(info.getCreditScore());
        rtInfo.setCreditRating(info.getCreditRating());
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)rtInfo);
    }

    private OrgInfo getUserInfoByExternOrgId(Context ctx, OrgInfo orgInfo) throws BOSException {
        try {
            if (null != orgInfo && !"".equals(orgInfo.getOrgID())) {
                String orgID = orgInfo.getOrgID();
                String number = orgInfo.getNumber();
                String extendErpId = orgInfo.getExtendErp().getId().toString();
                ExtendERPInfo extendErp = orgInfo.getExtendErp();
                if (OrgRoleUserUtils.isImportOrg(ctx, orgInfo)) {
                    orgInfo = OrgRoleUserUtils.getOrgByNumber(ctx, extendErpId, number);
                    if (orgInfo == null) {
                        throw new BOSException("\u81ea\u52a8\u5f15\u5165\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u96c6\u56e2\u7ba1\u7406\u5458\u5f15\u5165\u7ec4\u7ec7\uff01");
                    }
                    orgInfo.setExtendErp(extendErp);
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)orgInfo);
                    orgInfo.setId(BOSUuid.create((BOSObjectType)orgInfo.getBOSType()));
                    if (OrgFactory.getLocalInstance(ctx).exists("where orgID='" + orgInfo.getParent() + "'")) {
                        OrgInfo parentInfo = OrgFactory.getLocalInstance(ctx).getOrgInfo("where orgID='" + orgInfo.getParent() + "' and extenderp.id='" + extendErpId + "'");
                        orgInfo.setParentId(parentInfo);
                    }
                    CoreBaseCollection orgAddColl = new CoreBaseCollection();
                    orgAddColl.add((CoreBaseInfo)orgInfo);
                    OrgFactory.getLocalInstance(ctx).addnewBatchData(orgAddColl);
                } else {
                    orgInfo = OrgFactory.getLocalInstance(ctx).getOrgInfo("where orgID='" + orgID + "' and extenderp.id='" + extendErpId + "'");
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("\u540c\u6b65\u7ec4\u7ec7\u9519\u8bef\uff01" + (Object)((Object)e)));
        }
        return orgInfo;
    }
}

