/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.eas.base.ssc.CreditParamsCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryInfo;
import com.kingdee.eas.base.ssc.CreditParamsFactory;
import com.kingdee.eas.base.ssc.CreditParamsInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditParamsFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.InfluenceCreditTypeEnum;
import com.kingdee.eas.base.ssc.tool.cache.SSCCacheManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CreditParamsFacadeControllerBean
extends AbstractCreditParamsFacadeControllerBean {
    private static final long serialVersionUID = 3649215943022579462L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditParamsFacadeControllerBean");
    private static final String DEFAULT_CREDITPARAMS = "default_credit_params";

    private CreditParamsInfo getCreditParamsInCache(Context ctx, String scId) throws BOSException {
        Object cacheObj = SSCCacheManager.getValue("creditParamsCacheMap_creditParam");
        if (null == cacheObj) {
            cacheObj = new Properties();
            SSCCacheManager.put("creditParamsCacheMap_creditParam", cacheObj);
        }
        Object creditParams = null;
        creditParams = ((Properties)cacheObj).get(scId);
        if (null == creditParams) {
            creditParams = ((Properties)cacheObj).get(DEFAULT_CREDITPARAMS);
        }
        if (null == creditParams) {
            CreditParamsCollection creditParamsCol = CreditParamsFactory.getLocalInstance(ctx).getCreditParamsCollection("select *, entrys.* where shareCenter.id = '" + scId + "'");
            if (creditParamsCol != null && !creditParamsCol.isEmpty()) {
                creditParams = creditParamsCol.get(0);
                ((Properties)cacheObj).put(scId, creditParams);
            } else {
                creditParamsCol = CreditParamsFactory.getLocalInstance(ctx).getCreditParamsCollection("select *, entrys.* where shareCenter.id is null");
                creditParams = creditParamsCol.get(0);
                ((Properties)cacheObj).put(DEFAULT_CREDITPARAMS, creditParams);
            }
        }
        return (CreditParamsInfo)creditParams;
    }

    @Override
    protected Map _getCreditParamsCacheMap(Context ctx, String scId) throws BOSException, EASBizException {
        return (Map)SSCCacheManager.getValue("creditParamsCacheMap_creditParam");
    }

    @Override
    protected CustomCacheService _getCustomCache(Context ctx, String scId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected CreditParamsInfo _getCreditParamsInfoInCache(Context ctx, String scId) throws BOSException, EASBizException {
        return this.getCreditParamsInCache(ctx, scId);
    }

    @Override
    protected void _updateCreditParams(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"*****creditParams*****\u4fdd\u5b58\u540e\u6e05\u7a7a\u7f13\u5b58*****");
        try {
            SSCCacheManager.clearCache("creditParamsCacheMap_creditParam");
        }
        catch (Exception e) {
            logger.error((Object)("*****creditParams*****\u4fdd\u5b58\u540e\u6e05\u7a7a\u7f13\u5b58 -- $Error$ --*****" + e.getMessage()), (Throwable)e);
        }
    }

    private boolean whetherInfluence(CreditParamsInfo creditParamsInfo, InfluenceCreditTypeEnum type) throws BOSException, EASBizException {
        if (creditParamsInfo != null) {
            if (InfluenceCreditTypeEnum.sharedAudit.equals((Object)type)) {
                return creditParamsInfo.isSharedAudit();
            }
            if (InfluenceCreditTypeEnum.sharedReview.equals((Object)type)) {
                return creditParamsInfo.isSharedReview();
            }
            if (InfluenceCreditTypeEnum.auditQuality.equals((Object)type)) {
                return creditParamsInfo.isAuditQuality();
            }
        } else {
            NumericExceptionSubItem item = new NumericExceptionSubItem("creditParams is null!", "\u8bf7\u5148\u914d\u7f6e\u4fe1\u7528\u53c2\u6570!");
            throw new EASBizException(item);
        }
        return false;
    }

    @Override
    protected boolean _whetherInfluenceCreditInCache(Context ctx, String scId, InfluenceCreditTypeEnum type) throws BOSException, EASBizException {
        CreditParamsInfo creditParamsInfo = this.getCreditParamsInCache(ctx, scId);
        return this.whetherInfluence(creditParamsInfo, type);
    }

    @Override
    protected boolean _whetherInfluenceCredit(Context ctx, String scId, InfluenceCreditTypeEnum type) throws BOSException, EASBizException {
        CreditParamsInfo creditParamsInfo = this.getCreditParamsInCache(ctx, scId);
        return this.whetherInfluence(creditParamsInfo, type);
    }

    @Override
    protected int _countFilterRuleByBillTypeId(Context ctx, String scId, String billTypeId) throws BOSException, EASBizException {
        try {
            String sql = "SELECT COUNT(DFR.FID) NUM FROM T_SSC_DATAFILTERINGRULEENTRY DFR INNER JOIN T_SSC_CREDITPARAMSENTRY CP ON DFR.FPARENTID = CP.FDATAFILTERINGRULE INNER JOIN T_SSC_CREDITPARAMS CPS ON CP.FParentID = CPS.FID WHERE  CPS.FSHARECENTERID = '" + scId + "' AND CP.FBILLTYPEID = '" + billTypeId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                Integer count = rowSet.getInt("NUM");
                return count;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    protected Map _getFilteringSql(Context ctx, String scId, List billTypeIds, String baseSql) throws BOSException, EASBizException {
        CreditParamsInfo creditParamsInfo = this.getCreditParamsInCache(ctx, scId);
        if (creditParamsInfo != null) {
            HashMap<String, String> result = null;
            try {
                result = new HashMap<String, String>();
                for (Object btid : billTypeIds) {
                    result.put(btid.toString(), this.getSql(ctx, scId, btid.toString(), baseSql));
                    logger.info((Object)("-----&&****\u5355\u636e\u7c7b\u578bID\uff1a" + btid.toString() + "  SQL: " + baseSql));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return result;
        }
        NumericExceptionSubItem item = new NumericExceptionSubItem("creditParams is null!", "\u8bf7\u5148\u914d\u7f6e\u4fe1\u7528\u53c2\u6570!");
        throw new EASBizException(item);
    }

    private String getSql(Context ctx, String scId, String billTypeId, String baseSql) throws EASBizException, BOSException, SQLException {
        String sql = "SELECT DFR.FID,DFR.FLEFTBRACKET,DFR.FPROPERTY,DFR.FCOMPARISONOPER,DFR.FCOMPARISONVALUE,DFR.FRIGHTBRACKET,DFR.FLOGICALCONDITION,DFR.FPROPERTYTYPE FROM T_SSC_DATAFILTERINGRULEENTRY DFR INNER JOIN T_SSC_CREDITPARAMSENTRY CP ON DFR.FPARENTID = CP.FDATAFILTERINGRULE INNER JOIN T_SSC_CREDITPARAMS CPS ON CP.FParentID = CPS.FID WHERE CPS.FSHARECENTERID = '" + scId + "' AND CP.FBILLTYPEID = '" + billTypeId + "' order by DFR.fseq";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String leftBracket = null;
        String property = null;
        String comparisonOper = null;
        String comparisonValue = null;
        String rightBracket = null;
        String logicalCondition = null;
        String propertyType = null;
        StringBuffer dynCondition = new StringBuffer();
        ArrayList<String> comparisonValues = new ArrayList<String>();
        String querySql = baseSql = " " + baseSql.toUpperCase();
        while (rowSet.next()) {
            leftBracket = rowSet.getString("FLEFTBRACKET");
            property = rowSet.getString("FPROPERTY");
            comparisonOper = rowSet.getString("FCOMPARISONOPER");
            comparisonValue = rowSet.getString("FCOMPARISONVALUE");
            rightBracket = rowSet.getString("FRIGHTBRACKET");
            logicalCondition = rowSet.getString("FLOGICALCONDITION");
            propertyType = rowSet.getString("FPROPERTYTYPE");
            if (comparisonOper != null) {
                comparisonOper = comparisonOper.toUpperCase().trim();
            }
            dynCondition.append(leftBracket == null ? "" : leftBracket);
            if ("1".equals(propertyType)) {
                dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDIGIVALUE ").append(comparisonOper).append(" ").append(Double.parseDouble(comparisonValue)).append(" ] ");
            } else {
                if ("<>".equals(comparisonOper)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE <> '^' or DV.FDINAMICVALUE IS NULL] ]");
                } else if ("NOT LIKE".equals(comparisonOper)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE NOT LIKE '%^%' or DV.FDINAMICVALUE IS NULL] ]");
                } else {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDINAMICVALUE ").append(comparisonOper);
                    if ("IN".equals(comparisonOper) || "NOT IN".equals(comparisonOper)) {
                        dynCondition.append(" ['^'] ");
                    } else if ("LIKE".equals(comparisonOper)) {
                        dynCondition.append(" '%^%'");
                    } else {
                        dynCondition.append(" '^'");
                    }
                    dynCondition.append(" ] ");
                }
                comparisonValues.add(comparisonValue);
            }
            dynCondition.append(rightBracket == null ? "" : rightBracket);
            if (rowSet.isLast()) continue;
            if (StringUtils.isEmpty((String)logicalCondition)) {
                dynCondition.append("AND");
                continue;
            }
            dynCondition.append(logicalCondition.toUpperCase());
        }
        ArrayList<SQLInfo> sqlInfos = new ArrayList<SQLInfo>();
        this.parseDynamicCondition(dynCondition.toString(), sqlInfos);
        querySql = this.generateSQLByInfo(baseSql, sqlInfos);
        int i = 0;
        while (querySql.indexOf("^") > -1) {
            querySql = querySql.replaceFirst("\\^", (String)comparisonValues.get(i));
            ++i;
        }
        return querySql;
    }

    private String generateSQLByInfo(String baseSql, List<SQLInfo> sqlInfos) {
        if (sqlInfos.isEmpty()) {
            return baseSql;
        }
        StringBuffer allSql = new StringBuffer("(");
        StringBuffer tmpSql = null;
        String joinType = null;
        String infoSql = null;
        for (SQLInfo info : sqlInfos) {
            joinType = info.getJoinType();
            infoSql = info.getSql();
            joinType = "AND".equals(joinType) ? " INTERSECT " : ("OR".equals(joinType) ? ") UNION (" : "");
            if (infoSql.indexOf("AND") > -1) {
                allSql.append("(");
                ArrayList<SQLInfo> tempInfos = new ArrayList<SQLInfo>();
                infoSql = infoSql.substring(1, infoSql.length() - 1);
                this.parseDynamicCondition(infoSql, tempInfos);
                allSql.append(this.generateSQLByInfo(baseSql, tempInfos).replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
                continue;
            }
            tmpSql = new StringBuffer("(");
            tmpSql.append(baseSql);
            if (baseSql.indexOf("WHERE") > -1) {
                tmpSql.append(" AND ");
            } else {
                tmpSql.append(" WHERE ");
            }
            tmpSql.append(infoSql.replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
            allSql.append(tmpSql);
        }
        return allSql.append(")").toString();
    }

    private void parseDynamicCondition(String dynSql, List<SQLInfo> infos) {
        if ("".equals(dynSql.trim())) {
            return;
        }
        int leftBracketPoint = dynSql.indexOf("(");
        int andPoint = dynSql.indexOf("AND");
        int orPoint = dynSql.indexOf("OR");
        if (leftBracketPoint > -1) {
            if (andPoint > -1) {
                if (leftBracketPoint < andPoint) {
                    if (orPoint > -1) {
                        if (leftBracketPoint < orPoint) {
                            this.parseBracket(dynSql, leftBracketPoint, infos);
                        } else {
                            this.parseOr(dynSql, orPoint, infos);
                        }
                    } else {
                        this.parseBracket(dynSql, leftBracketPoint, infos);
                    }
                } else if (orPoint > -1) {
                    if (andPoint < orPoint) {
                        this.parseAnd(dynSql, andPoint, infos);
                    } else {
                        this.parseOr(dynSql, orPoint, infos);
                    }
                } else {
                    this.parseAnd(dynSql, andPoint, infos);
                }
            } else if (orPoint > -1) {
                if (leftBracketPoint < orPoint) {
                    this.parseBracket(dynSql, leftBracketPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseBracket(dynSql, leftBracketPoint, infos);
            }
        } else if (andPoint > -1) {
            if (orPoint > -1) {
                if (andPoint < orPoint) {
                    this.parseAnd(dynSql, andPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseAnd(dynSql, andPoint, infos);
            }
        } else if (orPoint > -1) {
            this.parseOr(dynSql, orPoint, infos);
        } else {
            SQLInfo info = new SQLInfo();
            info.setSql(dynSql);
            infos.add(info);
            return;
        }
    }

    private void parseOr(String dynSql, int orPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, orPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("OR");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 2, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    private void parseAnd(String dynSql, int andPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, andPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("AND");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 3, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    private void parseBracket(String dynSql, int leftBracketPoint, List<SQLInfo> infos) {
        int nextPoint = dynSql.indexOf(")");
        String temp = dynSql.substring(leftBracketPoint, nextPoint + 1);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length(), dynSql.length());
            int andJoinPoint = dynSql.indexOf("AND");
            int orJoinPoint = dynSql.indexOf("OR");
            if (andJoinPoint > -1) {
                if (orJoinPoint > -1) {
                    if (andJoinPoint < orJoinPoint) {
                        info.setJoinType("AND");
                        infos.add(info);
                        dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    } else {
                        info.setJoinType("OR");
                        infos.add(info);
                        dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    }
                } else {
                    info.setJoinType("AND");
                    infos.add(info);
                    dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                    this.parseDynamicCondition(dynSql, infos);
                }
            } else if (orJoinPoint > -1) {
                info.setJoinType("OR");
                infos.add(info);
                dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                this.parseDynamicCondition(dynSql, infos);
            }
        } else {
            infos.add(info);
        }
    }

    @Override
    protected String _getBatchFilterSql(Context ctx, String scId, String tableName, String billTypeTableName) throws BOSException {
        try {
            CreditParamsEntryCollection tCrParamEntityColl = this.getCreditParamsInCache(ctx, scId).getEntrys();
            StringBuffer tBatchSql = new StringBuffer();
            for (int index = 0; index < tCrParamEntityColl.size(); ++index) {
                CreditParamsEntryInfo tCreParamEntryInfo = tCrParamEntityColl.get(index);
                String tBillTypeId = tCreParamEntryInfo.getBillType().getId().toString();
                String parentRuleId = tCreParamEntryInfo.getDataFilteringRule();
                if (index == 0) {
                    tBatchSql.append("and exists ( ");
                } else {
                    tBatchSql.append("union all");
                }
                StringBuffer dynCondition = new StringBuffer();
                ArrayList<String> comparisonValues = new ArrayList<String>();
                StringBuffer tStrSql = new StringBuffer();
                tStrSql.append("SELECT DFR.FID,DFR.FLEFTBRACKET,DFR.FPROPERTY,DFR.FCOMPARISONOPER,DFR.FCOMPARISONVALUE,DFR.FRIGHTBRACKET,DFR.FLOGICALCONDITION ,DYN.FTYPE ");
                tStrSql.append("FROM T_SSC_DATAFILTERINGRULEENTRY DFR left join T_SSC_DynamicAttribute DYN on DFR.FpropertyId = DYN.Fid ");
                tStrSql.append(" where DFR.FPARENTID = ? ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tStrSql.toString(), (Object[])new Object[]{parentRuleId});
                while (rowSet.next()) {
                    String leftBracket = rowSet.getString("FLEFTBRACKET");
                    String property = rowSet.getString("FPROPERTY");
                    String comparisonOper = rowSet.getString("FCOMPARISONOPER");
                    String comparisonValue = rowSet.getString("FCOMPARISONVALUE");
                    String rightBracket = rowSet.getString("FRIGHTBRACKET");
                    String logicalCondition = rowSet.getString("FLOGICALCONDITION");
                    String ftype = rowSet.getString("FTYPE");
                    if (comparisonOper != null) {
                        comparisonOper = comparisonOper.toUpperCase().trim();
                    }
                    dynCondition.append(leftBracket == null ? "" : leftBracket);
                    if ("1".equals(ftype)) {
                        dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDIGIVALUE ").append(comparisonOper).append(" ").append(Double.parseDouble(comparisonValue)).append(" ] ");
                    } else {
                        if ("<>".equals(comparisonOper)) {
                            dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE <> '^' or DV.FDINAMICVALUE IS NULL] ]");
                        } else if ("NOT LIKE".equals(comparisonOper)) {
                            dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE NOT LIKE '%^%' or DV.FDINAMICVALUE IS NULL] ]");
                        } else {
                            dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDINAMICVALUE ").append(comparisonOper);
                            if ("IN".equals(comparisonOper) || "NOT IN".equals(comparisonOper)) {
                                dynCondition.append(" ['^'] ");
                            } else if ("LIKE".equals(comparisonOper)) {
                                dynCondition.append(" '%^%'");
                            } else {
                                dynCondition.append(" '^'");
                            }
                            dynCondition.append(" ] ");
                        }
                        comparisonValues.add(comparisonValue);
                    }
                    dynCondition.append(rightBracket == null ? "" : rightBracket);
                    if (rowSet.isLast()) continue;
                    if (StringUtils.isEmpty((String)logicalCondition)) {
                        dynCondition.append("AND");
                        continue;
                    }
                    dynCondition.append(logicalCondition.toUpperCase());
                }
                if (!StringUtils.isEmpty((String)dynCondition.toString())) {
                    ArrayList<SQLInfo> sqlInfos = new ArrayList<SQLInfo>();
                    this.parseDynamicCondition(dynCondition.toString(), sqlInfos);
                    StringBuffer tSql = new StringBuffer();
                    tSql.append(" select 1 from t_ssc_dynvaluehis DV,t_ssc_dynamicAttribute DT WHERE DV.fdynamicidid = DT.fid and DV.fjobidid = " + tableName + ".fid and " + billTypeTableName + ".fbilltypeid = '" + tBillTypeId + "' ");
                    String querySql = this.generateSQLByInfo(tSql.toString(), sqlInfos);
                    int i = 0;
                    while (querySql.indexOf("^") > -1) {
                        querySql = querySql.replaceFirst("\\^", (String)comparisonValues.get(i));
                        ++i;
                    }
                    tBatchSql.append(querySql);
                    continue;
                }
                tBatchSql.append("(select 1 from t_ssc_user where fnumber = 'sscAdmin' and " + billTypeTableName + ".fbilltypeid = '" + tBillTypeId + "' ) ");
            }
            if (!StringUtils.isEmpty((String)tBatchSql.toString())) {
                tBatchSql.append(" )");
            }
            return tBatchSql.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException();
        }
    }

    class SQLInfo {
        private String sql;
        private String joinType;

        SQLInfo() {
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getJoinType() {
            return this.joinType;
        }

        public void setJoinType(String joinType) {
            this.joinType = joinType;
        }

        public String toString() {
            return "SQL: " + this.sql + "\r\nJoinType: " + this.joinType;
        }
    }
}

