/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.GroupCollection;
import com.kingdee.eas.base.ssc.GroupFactory;
import com.kingdee.eas.base.ssc.GroupInfo;
import com.kingdee.eas.base.ssc.GroupRoleFactory;
import com.kingdee.eas.base.ssc.GroupRoleInfo;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleUserFactory;
import com.kingdee.eas.base.ssc.RoleUserInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.UserCollection;
import com.kingdee.eas.base.ssc.UserGroupCollection;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractGroupControllerBean;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GroupControllerBean
extends AbstractGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.GroupControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GroupInfo groupInfo = (GroupInfo)model;
        if (StringUtils.isBlank((String)groupInfo.getShareCenterId())) {
            groupInfo.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        }
        return super._addnew(ctx, (IObjectValue)groupInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberOrNameDup(ctx, model, "name");
        if (model.get("workload") == null) {
            model.setInt("workload", 0);
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectCollection _getUsersInGroup(Context ctx, String id, String longNumber, String language) throws BOSException {
        UserCollection userCollection = new UserCollection();
        IRowSet rowset = null;
        try {
            String sql = "select distinct u.fid,u.fname_" + language + ",u.fnumber,u.fisenabled,u.fdescription_" + language + ",u.fsimplename from t_ssc_user u,t_ssc_group g,t_ssc_usergroup ug where u.fid = ug.fuserid and g.fid = ug.fgroupid ";
            if (longNumber != null) {
                sql = sql + " and (g.flongnumber like ? or g.fid = ?)";
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{longNumber + "!%", id});
            } else {
                sql = sql + " and g.fid = ?";
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
            }
            UserInfo userInfo = null;
            while (rowset.next()) {
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowset.getString("fid")));
                userInfo.setName(rowset.getString("fname_" + language));
                userInfo.setNumber(rowset.getString("fnumber"));
                userInfo.setIsEnabled(rowset.getBoolean("fisenabled"));
                userInfo.setDescription(rowset.getString("fdescription_" + language));
                userInfo.setSimpleName(rowset.getString("fsimplename"));
                userCollection.add(userInfo);
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return userCollection;
    }

    @Override
    protected Map<String, IObjectPK[]> _groupTheUsers(Context ctx, String[] userIDs, String[] groupIDs, String[] longNumbers) throws BOSException, EASBizException {
        if (longNumbers == null) {
            return null;
        }
        String queryCondition = this.getQueryCondition(groupIDs, longNumbers);
        String sql = "select distinct fid from t_ssc_group " + queryCondition;
        ArrayList<String> gidList = new ArrayList<String>();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            int i = 0;
            while (rowset.next()) {
                gidList.add(rowset.getString("fid"));
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this._groupUsers(ctx, userIDs, gidList.toArray(new String[gidList.size()]));
    }

    @Override
    protected Map<String, IObjectPK[]> _groupUsers(Context ctx, String[] userIDs, String[] groupIDs) throws BOSException, EASBizException {
        if (userIDs == null || groupIDs == null) {
            return null;
        }
        HashMap<String, IObjectPK[]> retMap = new HashMap<String, IObjectPK[]>();
        try {
            int index;
            int ulen = userIDs.length;
            int glen = groupIDs.length;
            Object[] params = new Object[ulen + glen];
            StringBuffer sb = new StringBuffer();
            sb.append(" select u.fid ufid,g.fid gfid");
            sb.append(" from t_ssc_user u,t_ssc_group g,t_ssc_usergroup ug");
            sb.append(" where u.fid = ug.fuserid and g.fid = ug.fgroupid");
            sb.append(" and u.fid in (");
            for (index = 0; index < ulen; ++index) {
                sb.append("?,");
                params[index] = userIDs[index];
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            sb.append(" and g.fid in (");
            int j = 0;
            while (j < glen) {
                sb.append("?,");
                params[index] = groupIDs[j];
                ++j;
                ++index;
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            HashMap<String, ArrayList<String>> groupUserMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> ufids = null;
            String gfid = null;
            while (rowset.next()) {
                gfid = rowset.getString("gfid");
                ufids = (ArrayList<String>)groupUserMap.get(gfid);
                if (ufids == null) {
                    ufids = new ArrayList<String>();
                }
                ufids.add(rowset.getString("ufid"));
                groupUserMap.put(gfid, ufids);
            }
            CoreBaseCollection userGroupCollection = new CoreBaseCollection();
            UserGroupInfo userGroupInfo = null;
            GroupInfo groupInfo = null;
            UserInfo userInfo = null;
            ArrayList<String> addedGids = new ArrayList<String>();
            for (String uid : userIDs) {
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)uid));
                boolean isDefaultGrou = false;
                if (!UserGroupFactory.getLocalInstance(ctx).exists("where user.id='" + uid + "'")) {
                    isDefaultGrou = true;
                }
                for (int i = 0; i < groupIDs.length; ++i) {
                    if (groupUserMap.get(groupIDs[i]) != null && ((List)groupUserMap.get(groupIDs[i])).contains(uid)) continue;
                    addedGids.add(groupIDs[i]);
                    groupInfo = new GroupInfo();
                    groupInfo.setId(BOSUuid.read((String)groupIDs[i]));
                    userGroupInfo = new UserGroupInfo();
                    userGroupInfo.setGroup(groupInfo);
                    userGroupInfo.setUser(userInfo);
                    if (i == 0) {
                        userGroupInfo.setIsDefaultGroup(isDefaultGrou);
                    } else {
                        userGroupInfo.setIsDefaultGroup(false);
                    }
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)userGroupInfo);
                    userGroupCollection.add((CoreBaseInfo)userGroupInfo);
                }
            }
            if (!userGroupCollection.isEmpty()) {
                IObjectPK[] ugpks = UserGroupFactory.getLocalInstance(ctx).addnewBatchData(userGroupCollection);
                retMap.put("userGroup", ugpks);
                IObjectPK[] rupks = this.assignGroupRoleToUser(ctx, userIDs, addedGids.toArray());
                retMap.put("roleUser", rupks);
            }
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @Override
    protected Map<String, IObjectPK[]> _assignRoles(Context ctx, String[] roleIDs, String[] groupIDs) throws BOSException, EASBizException {
        if (roleIDs == null || groupIDs == null) {
            return null;
        }
        String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        HashMap<String, IObjectPK[]> retMap = new HashMap<String, IObjectPK[]>();
        try {
            String roleInCondition = this.getSqlINCondition(roleIDs);
            String groupInCondition = this.getSqlINCondition(groupIDs);
            String sql = "select r.fid rfid,g.fid gfid from t_ssc_role r,t_ssc_group g,t_ssc_grouprole gr where r.fid = gr.froleid and g.fid = gr.fgroupid and r.fid in " + roleInCondition + " and g.fid in " + groupInCondition;
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> rfids = null;
            String gfid = null;
            while (rowset.next()) {
                gfid = rowset.getString("gfid");
                rfids = (ArrayList<String>)map.get(gfid);
                if (rfids == null) {
                    rfids = new ArrayList<String>();
                }
                rfids.add(rowset.getString("rfid"));
                map.put(gfid, rfids);
            }
            CoreBaseCollection groupRoles = new CoreBaseCollection();
            GroupRoleInfo groupRoleInfo = null;
            GroupInfo groupInfo = null;
            RoleInfo roleInfo = null;
            ArrayList<String> addedGids = new ArrayList<String>();
            boolean isExistGroupRoleRelation = false;
            for (String rid : roleIDs) {
                roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)rid));
                for (String gid : groupIDs) {
                    addedGids.add(gid);
                    if (map.get(gid) != null && ((List)map.get(gid)).contains(rid)) continue;
                    groupInfo = new GroupInfo();
                    groupInfo.setId(BOSUuid.read((String)gid));
                    groupRoleInfo = new GroupRoleInfo();
                    groupRoleInfo.setGroup(groupInfo);
                    groupRoleInfo.setRole(roleInfo);
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)groupRoleInfo);
                    groupRoles.add((CoreBaseInfo)groupRoleInfo);
                }
            }
            if (!groupRoles.isEmpty()) {
                IObjectPK[] grpks = GroupRoleFactory.getLocalInstance(ctx).addnewBatchData(groupRoles);
                retMap.put("groupRole", grpks);
            }
            Object[] gids = addedGids.toArray();
            sql = "select distinct fuserid from t_ssc_usergroup where fgroupid in " + this.getSqlINCondition(gids) + " and fuserid in (select fid from t_ssc_user where fsharecenterid = '" + shareCenterId + "')";
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> userIDs = new ArrayList<String>();
            while (rowset.next()) {
                userIDs.add(rowset.getString("fuserid"));
            }
            if (!userIDs.isEmpty()) {
                IObjectPK[] rupks = this.assignGroupRoleToUser(ctx, userIDs.toArray(), gids);
                retMap.put("roleUser", rupks);
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retMap;
    }

    @Override
    protected Map<String, IObjectPK[]> _assignRoleToGroup(Context ctx, String[] roleIDs, String[] groupIDs, String[] longNumbers) throws BOSException, EASBizException {
        if (longNumbers == null) {
            return null;
        }
        String queryCondition = this.getQueryCondition(groupIDs, longNumbers);
        String sql = "select distinct fid from t_ssc_group " + queryCondition;
        ArrayList<String> gidList = new ArrayList<String>();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            int i = 0;
            while (rowset.next()) {
                gidList.add(rowset.getString("fid"));
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this._assignRoles(ctx, roleIDs, gidList.toArray(new String[gidList.size()]));
    }

    @Override
    protected boolean _relieveUserGroupRelation(Context ctx, String groupId, String[] userIds) throws BOSException {
        int i;
        Object[] params = new Object[userIds.length + 1];
        StringBuffer ugsql = new StringBuffer("");
        ugsql.append(" delete from t_ssc_usergroup where fgroupid = ? ");
        params[0] = groupId;
        ugsql.append(" and fuserid in ( ");
        for (i = 0; i < userIds.length; ++i) {
            ugsql.append("?,");
            params[i + 1] = userIds[i];
        }
        ugsql.deleteCharAt(ugsql.length() - 1).append(")");
        DbUtil.execute((Context)ctx, (String)ugsql.toString(), (Object[])params);
        for (i = 0; i < userIds.length; ++i) {
            try {
                Object[] param = new Object[]{userIds[i]};
                String sql = "select count(*)  from t_ssc_usergroup  t1  right join T_SSC_GroupRole t2  on t1.FGROUPID  = t2.FGROUPID  where t1.fuserid = '" + userIds[i] + "' ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rs.next()) continue;
                int count = rs.getInt(1);
                if (count == 0) {
                    StringBuffer ursql = new StringBuffer("");
                    ursql.append("delete from t_ssc_roleuser where froleidid in ");
                    ursql.append("(select froleid from t_ssc_grouprole where fgroupid = ?) ");
                    ursql.append("and fuseridid = ");
                    ursql.append("?");
                    Object[] obj = new Object[]{groupId, userIds[i]};
                    DbUtil.execute((Context)ctx, (String)ursql.toString(), (Object[])obj);
                }
                if (count != 1) continue;
                String updateSql = "update t_ssc_usergroup set FISDEFAULTGROUP  = '1' where fuserid = '" + userIds[i] + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return true;
    }

    @Override
    protected boolean _relieveGroupRoleRelation(Context ctx, String groupId, String[] groupRoleIds) throws BOSException {
        String inCondition = this.getSqlINCondition(groupRoleIds);
        StringBuffer grsql = new StringBuffer("");
        grsql.append("delete from t_ssc_grouprole where fgroupid = '").append(groupId).append("' ").append("and fid in ").append(inCondition);
        StringBuffer ursql = new StringBuffer("");
        StringBuffer querySql = new StringBuffer("");
        querySql.append("select fuseridid from t_ssc_roleuser where fuseridid in ").append("(select fuserid from t_ssc_userGroup where fgroupid = '").append(groupId).append("') ").append("and froleidid in ").append("(SELECT FROLEID  FROM T_SSC_GroupRole where fid in ").append(inCondition).append(") ");
        DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        ursql.append("delete from t_ssc_roleuser where fuseridid in ").append("(select fuserid from t_ssc_userGroup where fgroupid = '").append(groupId).append("') ").append("and froleidid in ").append("(SELECT FROLEID  FROM T_SSC_GroupRole where fid in ").append(inCondition).append(") ").append(" and fuseridid  in (SELECT T1.FUSERID FROM T_SSC_USERGROUP t1 inner join T_ssc_grouprole  t2 on T1.FGROUPID = T2.FGROUPID where T2.FROLEID  in ( select FROLEID from T_SSC_GroupRole  where  FID in " + inCondition + ")  GROUP BY T1.fuserid HAVING COUNT(*) = 1)");
        String sql = ursql + ";" + grsql + ";";
        DbUtil.execute((Context)ctx, (String)sql);
        return true;
    }

    @Override
    protected String _deleteGroup(Context ctx, String groupId) throws BOSException, EASBizException {
        String result = null;
        String sql = "select count(s.fid) num from t_ssc_group s,t_ssc_group p where p.fid = s.fparentid and p.fid = '" + groupId + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                if (rowSet.getInt("num") > 0) {
                    result = "\u8be5\u7528\u6237\u7ec4\u5b58\u5728\u5b50\u7528\u6237\u7ec4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!";
                } else {
                    boolean isExistsUsers = UserGroupFactory.getLocalInstance(ctx).exists("where group.id = '" + groupId + "'");
                    if (isExistsUsers) {
                        result = "\u8be5\u7528\u6237\u7ec4\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!";
                    } else {
                        sql = "delete from t_ssc_grouprole where fgroupid = '" + groupId + "';delete from t_ssc_group where fid = '" + groupId + "';";
                        DbUtil.execute((Context)ctx, (String)sql);
                        result = "\u5220\u9664\u6210\u529f";
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected IObjectCollection _getAllUsers(Context ctx, String colModel, String searchValue) throws BOSException {
        String shareCenterId = null;
        try {
            shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        StringBuffer filter = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        if (colModel != null && colModel.length() > 0) {
            Pattern pattern = Pattern.compile("'\\w+\\.?\\w+'");
            Matcher matcher = pattern.matcher(colModel);
            String value = null;
            while (matcher.find()) {
                value = matcher.group(0).replace("'", "").toLowerCase();
                value = value.replace("name", "name_" + language);
                if ((value = value.replace("description", "description_" + language)).indexOf(".") < 0) {
                    filter.append("ug.f");
                } else {
                    if (value.matches("user\\.\\w+")) {
                        value = value.replace("user", "u");
                    } else if (value.matches("group\\.\\w+")) {
                        value = value.replace("group", "g");
                    }
                    value = value.replace(".", ".f");
                }
                filter.append("").append(value).append(" like '%").append(searchValue).append("%' or ");
            }
        }
        StringBuffer userSql = new StringBuffer();
        userSql.append("select u.fid userid,u.fname_").append(language).append(" uname,").append("u.fdescription_").append(language).append(" udesc,").append("u.fnumber unumber,u.fisenabled uenable,u.FApproveCoe uApproveCoe,u.fisstopassign ustopassign,u.fstopAssignStartTime stopAssignStartTime,u.fstopAssignEndTime stopAssignEndTime,g.FWorkload workload,g.fname_").append(language).append(" gname,").append("g.fid gid,ug.fid ugid,ug.fisdefaultgroup,u.fisReceiveAssignJobMsg from t_ssc_user u ").append("left join t_ssc_usergroup ug on u.fid = ug.fuserid ").append("left join t_ssc_group g on ug.fgroupid = g.fid ").append(" where u.fShareCenterId = '").append(shareCenterId).append("'").append(" and u.fnumber != 'sscAdmin'");
        if (filter.length() > 0) {
            userSql.append(" and (").append(filter.substring(0, filter.lastIndexOf("or"))).append(")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)userSql.toString());
        try {
            UserGroupCollection userGroups = new UserGroupCollection();
            UserInfo userInfo = null;
            GroupInfo groupInfo = null;
            UserGroupInfo userGroupInfo = null;
            while (rowSet.next()) {
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("userid")));
                userInfo.setName(rowSet.getString("uname"), ctx.getLocale());
                userInfo.setDescription(rowSet.getString("udesc"), ctx.getLocale());
                userInfo.setNumber(rowSet.getString("unumber"));
                userInfo.setIsEnabled(rowSet.getBoolean("uenable"));
                userInfo.setApproveCoe(rowSet.getBigDecimal("uApproveCoe"));
                userInfo.setIsStopAssign(StopAssignEnum.getEnum(rowSet.getString("ustopassign")));
                userInfo.setStopAssignStartTime(rowSet.getTimestamp("stopAssignStartTime"));
                userInfo.setStopAssignEndTime(rowSet.getTimestamp("stopAssignEndTime"));
                userInfo.setIsReceiveAssignJobMsg(rowSet.getBoolean("fisReceiveAssignJobMsg"));
                groupInfo = new GroupInfo();
                if (rowSet.getString("gid") != null) {
                    groupInfo.setId(BOSUuid.read((String)rowSet.getString("gid")));
                }
                groupInfo.setName(rowSet.getString("gname"), ctx.getLocale());
                groupInfo.setWorkload(rowSet.getInt("workload"));
                userGroupInfo = new UserGroupInfo();
                userGroupInfo.setUser(userInfo);
                userGroupInfo.setGroup(groupInfo);
                userGroupInfo.setIsDefaultGroup(rowSet.getBoolean("fisdefaultgroup"));
                if (rowSet.getString("ugid") != null) {
                    userGroupInfo.setId(BOSUuid.read((String)rowSet.getString("ugid")));
                }
                userGroups.add(userGroupInfo);
            }
            return userGroups;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Map _SaveGroup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap<String, EASBizException> resultMap = new HashMap<String, EASBizException>();
        if (model != null && model.get("name") != null && model.get("number") != null) {
            String oldNumber = null;
            if (model.get("id") != null) {
                String gid = model.get("id").toString();
                Boolean isExists = GroupFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(gid));
                if (isExists.booleanValue()) {
                    GroupInfo group = GroupFactory.getLocalInstance(ctx).getGroupInfo((IObjectPK)new ObjectUuidPK(gid));
                    oldNumber = group.getNumber();
                }
            }
            String number = model.get("number").toString();
            String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            boolean isExists = GroupFactory.getLocalInstance(ctx).exists("where number = '" + number + "' and shareCenterId = '" + shareCenterId + "'");
            if (isExists && (oldNumber == null || !number.equals(oldNumber))) {
                NumericExceptionSubItem item = new NumericExceptionSubItem("bs.ssc.group.groupNumberIsExists", "\u7f16\u7801\u5df2\u5b58\u5728!");
                EASBizException exception = new EASBizException(item);
                resultMap.put("error", exception);
            } else {
                IObjectPK objectPK = GroupFactory.getLocalInstance(ctx).submit((CoreBaseInfo)model);
                resultMap.put("success", (EASBizException)objectPK);
            }
        } else {
            NumericExceptionSubItem item = new NumericExceptionSubItem("bs.ssc.group.nameOrNumberIsNull", "\u540d\u79f0\u548c\u7f16\u7801\u5fc5\u987b\u586b\u5199!");
            EASBizException exception = new EASBizException(item);
            resultMap.put("error", exception);
        }
        return resultMap;
    }

    @Override
    protected IObjectCollection _getUsersbyUserGroupIds(Context ctx, String[] userGroupIds) throws BOSException {
        String inCondition = this.getSqlINCondition(userGroupIds);
        String oql = "select id,user.id,user.isEnabled where id in " + inCondition;
        UserGroupCollection userGroupCollection = UserGroupFactory.getLocalInstance(ctx).getUserGroupCollection(oql);
        return userGroupCollection;
    }

    private String getSqlINCondition(Object[] items) {
        if (items != null && items.length > 0) {
            StringBuffer condition = new StringBuffer("(");
            for (int i = 0; i < items.length; ++i) {
                condition.append("'").append(items[i]).append("'");
                if (i >= items.length - 1) continue;
                condition.append(",");
            }
            return condition.append(")").toString();
        }
        return "('')";
    }

    private IObjectPK[] assignGroupRoleToUser(Context ctx, Object[] userIDs, Object[] groupIDs) throws BOSException, EASBizException {
        IObjectPK[] pks = null;
        try {
            String inCondition = this.getSqlINCondition(groupIDs);
            String sql = "select distinct froleid from t_ssc_grouprole where fgroupid in " + inCondition;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> groupRoleIds = new ArrayList<String>();
            while (rowSet.next()) {
                groupRoleIds.add(rowSet.getString("froleid"));
            }
            if (!groupRoleIds.isEmpty()) {
                CoreBaseCollection roleUserInfos = new CoreBaseCollection();
                for (Object uid : userIDs) {
                    sql = "select froleidid from t_ssc_roleuser where fuseridid = ?";
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{uid});
                    ArrayList<String> roleIds = new ArrayList<String>();
                    while (rowSet.next()) {
                        roleIds.add(rowSet.getString("froleidid"));
                    }
                    RoleUserInfo roleUserInfo = null;
                    UserInfo userInfo = null;
                    RoleInfo roleInfo = null;
                    String role = null;
                    userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)uid.toString()));
                    for (int i = 0; i < groupRoleIds.size(); ++i) {
                        role = (String)groupRoleIds.get(i);
                        if (roleIds.contains(role)) continue;
                        roleUserInfo = new RoleUserInfo();
                        roleInfo = new RoleInfo();
                        roleInfo.setId(BOSUuid.read((String)role));
                        roleUserInfo.setRoleID(roleInfo);
                        roleUserInfo.setUserID(userInfo);
                        roleUserInfo.setByGroup(true);
                        FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)roleUserInfo);
                        roleUserInfos.add((CoreBaseInfo)roleUserInfo);
                    }
                }
                if (!roleUserInfos.isEmpty()) {
                    pks = RoleUserFactory.getLocalInstance(ctx).addnewBatchData(roleUserInfos);
                }
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pks;
    }

    private String getQueryCondition(Object[] groupIDs, Object[] longNumbers) {
        if (longNumbers != null || groupIDs != null) {
            StringBuffer condition = new StringBuffer(" where ");
            if (longNumbers.length > 0) {
                condition.append("flongnumber like ");
                for (int i = 0; i < longNumbers.length; ++i) {
                    condition.append("'").append(longNumbers[i]).append("!%'");
                    if (i >= longNumbers.length - 1) continue;
                    condition.append(" or flongnumber like ");
                }
                if (groupIDs.length > 0) {
                    condition.append(" or ");
                }
            }
            if (groupIDs.length > 0) {
                String inGroupcond = this.getSqlINCondition(groupIDs);
                condition.append("fid in ").append(inGroupcond);
            }
            return condition.toString();
        }
        return "";
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberOrNameDup(ctx, model, "name");
    }

    private void _checkNumberOrNameDup(Context ctx, IObjectValue model, String numberOrName) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        if ("number".equals(numberOrName)) {
            filter.appendFilterItem("number", (Object)treeModel.getNumber());
        } else {
            filter.appendFilterItem("name", (Object)treeModel.getName());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS));
        filter.appendFilterItem("shareCenterId", (Object)ShareCenterUtils.getShareCenterIdByCtx(ctx));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        GroupCollection results = this.getGroupCollection(ctx, view);
        if (results != null && results.size() > 0 && !"number".equals(numberOrName)) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u540d\u79f0\u5df2\u5b58\u5728\uff01"));
        }
    }
}

