/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.DynamicValueCollection;
import com.kingdee.eas.base.ssc.DynamicValueFactory;
import com.kingdee.eas.base.ssc.JobLevelRuleCollection;
import com.kingdee.eas.base.ssc.JobLevelRuleFactory;
import com.kingdee.eas.base.ssc.JobLevelRuleInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.AbstractJobLevelRuleControllerBean;
import com.kingdee.eas.base.ssc.common.script.custom.ScriptEngineUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import org.apache.log4j.Logger;

public class JobLevelRuleControllerBean
extends AbstractJobLevelRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.JobLevelRuleControllerBean");

    @Override
    protected String _getJobLevelByAttrid(Context ctx, String attrid, String jobId, String shareCenterId) throws BOSException {
        String ret = null;
        boolean isCustomerLevelRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityViewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bussType.id", (Object)attrid));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)shareCenterId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        entityViewInfo.setSelector(selector);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("priority"));
        entityViewInfo.setSorter(sorterItemCollection);
        JobLevelRuleCollection jobLevelRuleInfoCollection = JobLevelRuleFactory.getLocalInstance(ctx).getJobLevelRuleCollection(entityViewInfo);
        JobLevelRuleInfo JobLevelRuleinfo = null;
        for (int i = 0; i < jobLevelRuleInfoCollection.size(); ++i) {
            JobLevelRuleinfo = jobLevelRuleInfoCollection.get(i);
            isCustomerLevelRule = this.customerAssignJob(ctx, jobId, JobLevelRuleinfo);
            if (!isCustomerLevelRule) continue;
            ret = JobLevelRuleinfo.getAllotPriority().getId().toString();
            return ret;
        }
        return ret;
    }

    private boolean customerAssignJob(Context ctx, String jobId, JobLevelRuleInfo JobLevelRuleinfo) throws BOSException {
        Object assignUser = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityViewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("jobID.id", (Object)jobId));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("dynamicID.*");
        entityViewInfo.setSelector(selectorItemCollection);
        DynamicValueCollection dynamicValueCollection = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueCollection(entityViewInfo);
        if (dynamicValueCollection == null || dynamicValueCollection.size() == 0) {
            return false;
        }
        String script = JobLevelRuleinfo.getScript();
        Boolean assignResult = ScriptEngineUtil.isRuleMatch(script, dynamicValueCollection);
        return assignResult;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JobLevelRuleInfo info = (JobLevelRuleInfo)model;
        DataBaseInfo dbInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        info.setShareCenterId(dbInfo.getId().toString());
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkPriorityDup(ctx, (JobLevelRuleInfo)model);
        ((JobLevelRuleInfo)model).setIsEnable(true);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JobLevelRuleInfo jobLevelRuleInfo;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((jobLevelRuleInfo = (JobLevelRuleInfo)model).getBussType() != null) {
            filterItem = new FilterItemInfo("bussType", (Object)jobLevelRuleInfo.getBussType().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (jobLevelRuleInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)jobLevelRuleInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        JobLevelRuleInfo info = (JobLevelRuleInfo)model;
        DataBaseInfo dbInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkPriorityDup(ctx, (JobLevelRuleInfo)model);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void _checkPriorityDup(Context ctx, JobLevelRuleInfo jobLevelRuleInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("priority", (Object)jobLevelRuleInfo.getPriority(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (jobLevelRuleInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)jobLevelRuleInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (jobLevelRuleInfo.getBussType() != null) {
            filterItem = new FilterItemInfo("bussType", (Object)jobLevelRuleInfo.getBussType().getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (jobLevelRuleInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)jobLevelRuleInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            throw new SSCException(SSCException.ALLOTRULE_DUPLICATED);
        }
    }
}

