/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobLevelFactory;
import com.kingdee.eas.base.ssc.JobLevelInfo;
import com.kingdee.eas.base.ssc.PredictJobPoolFacadeFactory;
import com.kingdee.eas.base.ssc.PredictJobPoolFactory;
import com.kingdee.eas.base.ssc.PredictJobPoolInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractPredictJobPoolFacadeControllerBean;
import com.kingdee.eas.base.ssc.thread.PredictJobPoolThread;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.PredictPoolJobUtil;
import com.kingdee.eas.base.ssc.tool.PreditJobUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class PredictJobPoolFacadeControllerBean
extends AbstractPredictJobPoolFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.PredictJobPoolFacadeControllerBean");
    private static ExecutorService threadPool = PredictJobPoolFacadeControllerBean.getThreadPool();

    private static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newFixedThreadPool(20);
        }
        return threadPool;
    }

    @Override
    protected void _exectue(Context ctx, Set jobIdSet) throws BOSException, EASBizException {
        ExecutorService executors = PredictJobPoolFacadeControllerBean.getThreadPool();
        executors.execute(new PredictJobPoolThread(ctx, jobIdSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _exectuePreditJob(Context ctx, Set jobIdSet) throws BOSException, EASBizException {
        if (null == jobIdSet || jobIdSet.isEmpty()) {
            return PreditJobEnum.FALSE.name();
        }
        ArrayList<String> jobIdList = new ArrayList<String>();
        try {
            List list = PredictJobPoolFacadeFactory.getLocalInstance(ctx).queryPredictJobByID(jobIdSet);
            for (int i = 0; i < list.size(); ++i) {
                try {
                    JobInfo job = (JobInfo)list.get(i);
                    String jobID = job.getId().toString();
                    jobIdList.add(jobID);
                    if (job.getShareCenterID() == null || job.isAutoApprove()) {
                        logger.error((Object)"predictJob shareCenterId is null or isAutoApprove");
                        continue;
                    }
                    if (job.getJoblevel() == null) {
                        logger.error((Object)"....joblevel is null...");
                        JobLevelInfo jobLevelInfo = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK("oEKiy//QT7SGRdYOrQbr7tuj7Hc="));
                        job.setJoblevel(jobLevelInfo);
                    }
                    if (!this.callbackToOriginalPerso(ctx, job) && !this.customAssign(ctx, job) && !this.defAssign(ctx, job)) continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            String string = PreditJobEnum.FALSE.name();
            return string;
        }
        finally {
            if (jobIdList != null && !jobIdList.isEmpty()) {
                String sqlStr = FormatUtils.list2Sql(jobIdList);
                String sql = "update t_ssc_jobext set fisAssigning = '0' where fjobid in " + sqlStr;
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        return PreditJobEnum.TRUE.name();
    }

    private boolean defAssign(Context ctx, JobInfo job) throws Exception, EASBizException, BOSException {
        List<UserInfo> defAssignUserList = PreditJobUtils.defAssignJob(ctx, job);
        if (defAssignUserList != null && !defAssignUserList.isEmpty()) {
            for (UserInfo defUserInfo : defAssignUserList) {
                this.add2PreditJobPoll(ctx, job, defUserInfo);
                logger.info((Object)(" ;handleRejectedJob user : [" + defUserInfo.getNumber() + "]--[" + defUserInfo.getId().toString() + "]"));
            }
        }
        return true;
    }

    private boolean customAssign(Context ctx, JobInfo job) throws BOSException, Exception {
        Map<String, Object> map = PreditJobUtils.getCustomerAssignUser(ctx, job);
        boolean matchRule = (Boolean)map.get("matchRule");
        if (map.get("assignUser") != null) {
            List assignUserList = (List)map.get("assignUser");
            for (UserInfo assignUser : assignUserList) {
                logger.info((Object)("\u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.****assignUser****" + assignUser.getNumber() + ",userId:" + assignUser.getId()));
                this.add2PreditJobPoll(ctx, job, assignUser);
                logger.info((Object)("_exectuePreditJob \u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219 ; user : [" + assignUser.getNumber() + "]--[" + assignUser.getId().toString() + "]"));
            }
            return true;
        }
        if (matchRule) {
            logger.info((Object)" _exectuePreditJob \u7b26\u5408\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219.\u4f46\u662f\u5e76\u6ca1\u6709\u53ef\u5206\u914d\u7684\u4eba\u5458.\u4e0d\u5c1d\u8bd5\u9ed8\u8ba4\u5206\u914d\u89c4\u5219\u4e86.\u5206\u914d\u5931\u8d25!");
            return true;
        }
        return false;
    }

    private boolean callbackToOriginalPerso(Context ctx, JobInfo job) throws EASBizException, BOSException {
        UserInfo info;
        if (PreditJobUtils.isCallbackToOriginalPerso(ctx, job.getShareCenterID().getId().toString()) && null != (info = PreditJobUtils.handleRejectedJob(ctx, job))) {
            if (!SSCUtil.checkPermission(ctx, info, job)) {
                SSCUtil.genAndAllotCompelRole(ctx, job.getBussAttrID().getId().toString(), info.getId().toString(), info.getShareCenterId(), false);
                logger.info((Object)(info.getId().toString() + "\u5206\u914d" + job.getBussAttrID().getId().toString() + "\u6743\u9650\u6210\u529f"));
            }
            this.add2PreditJobPoll(ctx, job, info);
            logger.info((Object)(" ;_exectuePreditJob handleRejectedJob user : [" + info.getNumber() + "]--[" + info.getId().toString() + "]"));
            return true;
        }
        return false;
    }

    private void add2PreditJobPoll(Context ctx, JobInfo job, UserInfo info) throws EASBizException, BOSException {
        PredictJobPoolInfo predictJobPoolInfo = new PredictJobPoolInfo();
        predictJobPoolInfo.setJob(job);
        predictJobPoolInfo.setUser(info);
        PredictJobPoolFactory.getLocalInstance(ctx).addnew(predictJobPoolInfo);
    }

    @Override
    protected List _queryPredictJobByID(Context ctx, Set jobIdSet) throws BOSException, EASBizException {
        return PredictPoolJobUtil.queryPredictJobByID(ctx, jobIdSet);
    }

    @Override
    protected List _queryPreditJobs(Context ctx, Set bussAttrIdSet, String shareCenterId, int topJobCount) throws BOSException, EASBizException {
        return PredictPoolJobUtil.queryPreditJobs(ctx, bussAttrIdSet, shareCenterId, topJobCount);
    }

    static enum PreditJobEnum {
        TRUE,
        FALSE;

    }
}

