/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.GroupInfo;
import com.kingdee.eas.base.ssc.QOverDueTaskCollection;
import com.kingdee.eas.base.ssc.QOverDueTaskFactory;
import com.kingdee.eas.base.ssc.QOverDueTaskInfo;
import com.kingdee.eas.base.ssc.QTaskEfficiencyFactory;
import com.kingdee.eas.base.ssc.QTaskEfficiencyInfo;
import com.kingdee.eas.base.ssc.QToDayEfficiencyRankCollection;
import com.kingdee.eas.base.ssc.QToDayEfficiencyRankFactory;
import com.kingdee.eas.base.ssc.QToDayEfficiencyRankInfo;
import com.kingdee.eas.base.ssc.QToDayTaskRankCollection;
import com.kingdee.eas.base.ssc.QToDayTaskRankFactory;
import com.kingdee.eas.base.ssc.QToDayTaskRankInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractQDataReflushFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QDataReflushFacadeControllerBean
extends AbstractQDataReflushFacadeControllerBean {
    private static final long serialVersionUID = 5938119528583271707L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.QDataReflushFacadeControllerBean");

    @Override
    protected void _flushAllData(Context ctx) throws BOSException, EASBizException {
        this.flushTodayTaskRank(ctx);
        this.flushTodayEfficiencyRank(ctx);
        this.flushOverDueTask(ctx);
        this.flushYesterdayTaskEfficiency(ctx);
    }

    @Override
    protected void _flushTodayTaskRank(Context ctx) throws BOSException {
        CoreBaseCollection addColls = new CoreBaseCollection();
        QToDayTaskRankCollection updateColls = new QToDayTaskRankCollection();
        String curDay = DateUtil.getCurDayDate();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT jh.FPERSONNELIDID FUserId,jhe.fgroupid FGroupId,count(1) FTask,max(jh.FShareCenterId) FShareCenterId,sum(jh.FSTANDARDCOE) FCalculateTask");
        sb.append(" FROM T_ssc_jobhis jh");
        sb.append(" left join t_ssc_jobhisext jhe on jh.fid = jhe.FJOBID ");
        sb.append(" where jh.FCOMPLETETME >= {ts'" + curDay + "'}");
        sb.append(" and jh.fautoApprove=0");
        sb.append(" group by jh.FPERSONNELIDID,jhe.fgroupid");
        sb.append(" order by ftask desc,FUserId asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                StringBuffer oql = new StringBuffer("where date>={ts'" + curDay + "'}");
                QToDayTaskRankInfo info = new QToDayTaskRankInfo();
                if (StringUtils.isBlank((String)rs.getString("FUserId"))) {
                    info.setUser(null);
                    oql.append(" and user.id is null");
                } else {
                    info.setUser(new UserInfo(BOSUuid.read((String)rs.getString("FUserId"))));
                    oql.append(" and user.id ='" + rs.getString("FUserId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FGroupId"))) {
                    info.setGroup(null);
                    oql.append(" and group.id is null");
                } else {
                    info.setGroup(new GroupInfo(BOSUuid.read((String)rs.getString("FGroupId"))));
                    oql.append(" and group.id ='" + rs.getString("FGroupId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FShareCenterId"))) {
                    info.setOrg(null);
                } else {
                    FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)rs.getString("FShareCenterId")));
                    info.setOrg(orgInfo);
                }
                info.setCalculateTask(rs.getDouble("FCalculateTask"));
                info.setTask(rs.getInt("FTask"));
                info.setRank(rs.getRow());
                info.setDate(new Timestamp(new Date().getTime()));
                if (QToDayTaskRankFactory.getLocalInstance(ctx).exists(oql.toString())) {
                    info.setId(QToDayTaskRankFactory.getLocalInstance(ctx).getQToDayTaskRankInfo(oql.toString()).getId());
                    updateColls.add(info);
                    continue;
                }
                addColls.add((CoreBaseInfo)info);
            }
            if (!addColls.isEmpty()) {
                QToDayTaskRankFactory.getLocalInstance(ctx).addnewBatchData(addColls);
            }
            if (!updateColls.isEmpty()) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (int i = 0; i < updateColls.size(); ++i) {
                    QToDayTaskRankInfo info = updateColls.get(i);
                    paramsList.add(new Object[]{info.getTask(), info.getCalculateTask(), info.getRank(), info.getDate(), info.getId().toString()});
                }
                String updateSql = "update T_SSC_QToDayTaskRank set ftask=?,fcalculateTask=?,frank=?,fdate=? where fId=?";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _flushTodayEfficiencyRank(Context ctx) throws BOSException {
        CoreBaseCollection addColls = new CoreBaseCollection();
        QToDayEfficiencyRankCollection updateColls = new QToDayEfficiencyRankCollection();
        String curDay = DateUtil.getCurDayDate();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FUserId,FGroupId,case when fhours = 0 then 0 else ftasks/fhours*fratio end FEfficiency,FShareCenterId,ftasks,fhours");
        sb.append(" FROM v_ssc_efficiency");
        sb.append(" where fdate >= {ts'" + curDay + "'}");
        sb.append(" order by fefficiency desc,fhours asc,FUserId asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                QToDayEfficiencyRankInfo info = new QToDayEfficiencyRankInfo();
                StringBuffer oql = new StringBuffer("where date>={ts'" + curDay + "'}");
                if (StringUtils.isBlank((String)rs.getString("FUserId"))) {
                    info.setUser(null);
                    oql.append(" and user.id is null");
                } else {
                    info.setUser(new UserInfo(BOSUuid.read((String)rs.getString("FUserId"))));
                    oql.append(" and user.id ='" + rs.getString("FUserId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FGroupId"))) {
                    info.setGroup(null);
                    oql.append(" and group.id is null");
                } else {
                    info.setGroup(new GroupInfo(BOSUuid.read((String)rs.getString("FGroupId"))));
                    oql.append(" and group.id ='" + rs.getString("FGroupId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FShareCenterId"))) {
                    info.setOrg(null);
                } else {
                    FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)rs.getString("FShareCenterId")));
                    info.setOrg(orgInfo);
                }
                info.setEfficiency(rs.getDouble("FEfficiency"));
                info.setTask(rs.getInt("ftasks"));
                info.setTime(rs.getBigDecimal("fhours"));
                info.setRank(rs.getRow());
                info.setDate(new Timestamp(new Date().getTime()));
                if (QToDayEfficiencyRankFactory.getLocalInstance(ctx).exists(oql.toString())) {
                    info.setId(QToDayEfficiencyRankFactory.getLocalInstance(ctx).getQToDayEfficiencyRankInfo(oql.toString()).getId());
                    updateColls.add(info);
                    continue;
                }
                addColls.add((CoreBaseInfo)info);
            }
            if (!addColls.isEmpty()) {
                QToDayEfficiencyRankFactory.getLocalInstance(ctx).addnewBatchData(addColls);
            }
            if (!updateColls.isEmpty()) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (int i = 0; i < updateColls.size(); ++i) {
                    QToDayEfficiencyRankInfo info = updateColls.get(i);
                    paramsList.add(new Object[]{info.getEfficiency(), info.getTask(), info.getTime(), info.getRank(), info.getDate(), info.getId().toString()});
                }
                String updateSql = "update T_SSC_QToDayEfficiencyRank set FEfficiency=?,ftask=?,ftime=?,frank=?,fdate=? where fid = ?";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _flushYesterdayTaskEfficiency(Context ctx) throws BOSException {
        try {
            String yesterday = DateUtil.getYesterdayDate();
            if (QTaskEfficiencyFactory.getLocalInstance(ctx).exists("where date >= {ts'" + yesterday + "'}")) {
                return;
            }
            CoreBaseCollection addColls = new CoreBaseCollection();
            String curDay = DateUtil.getCurDayDate();
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT u.FSHARECENTERID FShareCenterId,count(1) FUser,max(o.fdate) FDate,sum(o.fworktask+o.fovertimetask) FTask");
            sb.append(" FROM T_SSC_OnGuardTime o");
            sb.append(" left join t_ssc_user u on o.fuserid = u.FID ");
            sb.append(" where o.fdate < {ts'" + curDay + "'}");
            sb.append(" and o.fdate >= {ts'" + yesterday + "'}");
            sb.append(" group by u.FSHARECENTERID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)rs.getString("FShareCenterId")));
                QTaskEfficiencyInfo info = new QTaskEfficiencyInfo();
                info.setOrg(orgInfo);
                info.setUser(rs.getInt("FUser"));
                info.setTask(rs.getInt("FTask"));
                info.setDate(rs.getTimestamp("FDate"));
                info.setAvgTask((double)rs.getInt("FTask") * 1.0 / (double)rs.getInt("FUser"));
                addColls.add((CoreBaseInfo)info);
            }
            if (!addColls.isEmpty()) {
                QTaskEfficiencyFactory.getLocalInstance(ctx).addnewBatchData(addColls);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _flushOverDueTask(Context ctx) throws BOSException {
        CoreBaseCollection addColls = new CoreBaseCollection();
        QOverDueTaskCollection updateColls = new QOverDueTaskCollection();
        String curDay = DateUtil.getCurDayDate();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT max(jh.fshareCenterId) FShareCenterId,jh.FPERSONNELIDID FUserId,jhe.fgroupid FGroupId,count(1) FTask,sum(case when jh.FISEXPIRED = '1' then 1 else 0 end) FOverDue");
        sb.append(" FROM T_ssc_jobhis jh");
        sb.append(" left join t_ssc_jobhisext jhe on jh.fid = jhe.fjobid");
        sb.append(" where jh.FCOMPLETETME >= {ts'" + curDay + "'}");
        sb.append(" group by jh.FPERSONNELIDID,jhe.fgroupid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                QOverDueTaskInfo info = new QOverDueTaskInfo();
                StringBuffer oql = new StringBuffer("where date>={ts'" + curDay + "'}");
                if (StringUtils.isBlank((String)rs.getString("FUserId"))) {
                    info.setUser(null);
                    oql.append(" and user.id is null");
                } else {
                    info.setUser(new UserInfo(BOSUuid.read((String)rs.getString("FUserId"))));
                    oql.append(" and user.id ='" + rs.getString("FUserId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FGroupId"))) {
                    info.setGroup(null);
                    oql.append(" and group.id is null");
                } else {
                    info.setGroup(new GroupInfo(BOSUuid.read((String)rs.getString("FGroupId"))));
                    oql.append(" and group.id ='" + rs.getString("FGroupId") + "'");
                }
                if (StringUtils.isBlank((String)rs.getString("FShareCenterId"))) {
                    info.setOrg(null);
                } else {
                    FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)rs.getString("FShareCenterId")));
                    info.setOrg(orgInfo);
                }
                info.setTask(rs.getInt("FTask"));
                info.setOverDue(rs.getInt("FOverDue"));
                info.setProportion((double)rs.getInt("FOverDue") * 100.0 / (double)rs.getInt("FTask"));
                info.setDate(new Timestamp(new Date().getTime()));
                if (QOverDueTaskFactory.getLocalInstance(ctx).exists(oql.toString())) {
                    info.setId(QOverDueTaskFactory.getLocalInstance(ctx).getQOverDueTaskInfo(oql.toString()).getId());
                    updateColls.add(info);
                    continue;
                }
                addColls.add((CoreBaseInfo)info);
            }
            if (!addColls.isEmpty()) {
                QOverDueTaskFactory.getLocalInstance(ctx).addnewBatchData(addColls);
            }
            if (!updateColls.isEmpty()) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (int i = 0; i < updateColls.size(); ++i) {
                    QOverDueTaskInfo info = updateColls.get(i);
                    paramsList.add(new Object[]{info.getProportion(), info.getTask(), info.getOverDue(), info.getDate(), info.getId().toString()});
                }
                String updateSql = "update T_SSC_QOverDueTask set FProportion=?,FTask=?,FOverDue=?,fdate=? where fId=?";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

