/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SSCSendMessageCallBack {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SSCSendMessageCallBack");

    public static void sendMessageAndEmail(Context ctx, JobInfo jobInfo) {
        try {
            Map map = SSCSendMessageCallBack.getSendMessageMap(ctx, jobInfo);
            SSCSendMessageCallBack.sendMessage(ctx, map);
            SSCSendMessageCallBack.sendMail(ctx, map);
        }
        catch (Exception e) {
            logger.error((Object)("SSCSendMessageCallBack  sendMessageAndEmail error" + e));
            e.printStackTrace();
        }
    }

    private static Map getSendMessageMap(Context ctx, JobInfo jobInfo) throws BOSException, SQLException {
        String receiver = "";
        StringBuffer sb = new StringBuffer();
        sb.append("  select a.feasuserid from t_ssc_user a inner join t_ssc_jobhis b on a.fid = b.fpersonnelidid  ");
        sb.append(" where b.flevel = ? and b.FBillID = ? ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{1, jobInfo.getBillID()});
        if (tIRowSet.next()) {
            receiver = tIRowSet.getString(1);
        }
        String subject = jobInfo.getSubject();
        HashMap<String, String> map = new HashMap<String, String>();
        String title = "\u5ba1\u6279\u4efb\u52a1\u6253\u56de\u63d0\u9192\u6d88\u606f";
        String body = "\u5355\u636e" + subject + "\u5df2\u7ecf\u88ab\u6253\u56de\uff0c\u8bf7\u60a8\u5c3d\u5feb\u5904\u7406\uff01";
        String sender = "administrator";
        map.put("title", title);
        map.put("body", body);
        map.put("receiver", receiver);
        map.put("sender", sender);
        return map;
    }

    private static void sendMessage(Context ctx, Map map) {
        Message message = SSCSendMessageCallBack.createMessage(ctx, map);
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        if (senderAgent.getState() != 1) {
            senderAgent.start();
        }
        senderAgent.sendMessage(message);
    }

    private static void sendMail(Context ctx, Map map) throws EASBizException, BOSException, SQLException {
        String title = (String)map.get("title");
        String body = (String)map.get("body");
        String receiver = (String)map.get("receiver");
        String email = "";
        StringBuffer tStrBuffer = new StringBuffer();
        tStrBuffer.append("select a.femail from t_bd_person a inner join t_pm_user b on a.fid = b.fpersonid  ");
        tStrBuffer.append("where b.fid = ? ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)tStrBuffer.toString(), (Object[])new Object[]{receiver});
        if (tIRowSet.next()) {
            email = tIRowSet.getString(1);
        }
        if (!StringUtils.isEmpty((String)email)) {
            MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)body, (String)email, null, null, null);
        }
    }

    private static Message createMessage(Context context, Map map) {
        String title = (String)map.get("title");
        String body = (String)map.get("body");
        String sender = (String)map.get("sender");
        String receiver = (String)map.get("receiver");
        Message message = MessageFactory.newMessage((String)"kingdee.wssc");
        if (context != null) {
            message.setStringHeader("databaseCenter", context.getAIS());
            message.setStringHeader("solution", context.getSolution());
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        message.setLocaleStringHeader("title", title, new Locale("L2"));
        message.setLocaleStringHeader("body", body, new Locale("L2"));
        message.setLocaleStringHeader("sender", sender, new Locale("L2"));
        message.setStringHeader("receiver", receiver);
        return message;
    }
}

