/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.CheckResultEnum;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFactory;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.SampleTaskStateEnum;
import com.kingdee.eas.base.ssc.TaskStateTimeFactory;
import com.kingdee.eas.base.ssc.TaskStateTimeInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractSampleLibraryQualityTaskFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.CheckSchemeTimeType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class SampleLibraryQualityTaskFacadeControllerBean
extends AbstractSampleLibraryQualityTaskFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SampleLibraryQualityTaskFacadeControllerBean");

    @Override
    protected void _updateTaskStateN(Context ctx, String taskId, SampleTaskStateEnum taskStateN, String userId, String rectificationInstruction) throws BOSException, EASBizException {
        SampleLibraryQualityTaskInfo info = new SampleLibraryQualityTaskInfo();
        info.setId(BOSUuid.read((String)taskId));
        info.setTaskStateN(taskStateN);
        info.setRectifyInstruction(rectificationInstruction);
        info.setReviseDate(new Date());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("taskStateN"));
        selector.add(new SelectorItemInfo("rectifyInstruction"));
        selector.add(new SelectorItemInfo("reviseDate"));
        SampleLibraryQualityTaskFactory.getRemoteInstance().updatePartial(info, selector);
        Operation operation = SampleTaskStateEnum.CallBack.equals((Object)taskStateN) ? Operation.Reject : Operation.RectifyCfing;
        this.taskStateChange(operation, taskId, userId, rectificationInstruction, "", "", null);
    }

    private void taskStateChange(Operation operation, String taskId, String userId, String advice, String unqualifyText, String rectifyUser, CheckResultEnum checkResult) throws BOSException, EASBizException {
        TaskStateTimeInfo tsInfo = new TaskStateTimeInfo();
        tsInfo.setTaskID(taskId);
        tsInfo.setOperation(operation);
        tsInfo.setOperationAdvice(advice);
        tsInfo.setChangeTime(new Time(System.currentTimeMillis()));
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        tsInfo.setOperatorId(userInfo);
        if (!StringUtils.isEmpty((Object)rectifyUser)) {
            UserInfo rectifyuserInfo = new UserInfo();
            rectifyuserInfo.setId(BOSUuid.read((String)rectifyUser));
            tsInfo.setRectifyUser(rectifyuserInfo);
        }
        tsInfo.setUnqualifyText(unqualifyText);
        tsInfo.setCheckResult(checkResult);
        TaskStateTimeFactory.getRemoteInstance().addnew((CoreBaseInfo)tsInfo);
    }

    @Override
    protected Timestamp[] _getQueryTimeParams(Context ctx, CheckSchemeInfo checkSchemeInfo) throws BOSException, EASBizException {
        CheckSchemeTimeType timeType = checkSchemeInfo.getCheckSchemeTimeType();
        Timestamp beginDate = null;
        Timestamp endDate = null;
        Calendar calendar = Calendar.getInstance();
        if (CheckSchemeTimeType.yesterDay.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeYesterDay2.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -2);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeYesterDay3.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -3);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.week.equals((Object)timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeWeek.equals((Object)timeType)) {
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -6);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.month.equals((Object)timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.set(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeMonth.equals((Object)timeType)) {
            calendar.set(5, 1);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(2, -1);
            calendar.add(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.years.equals((Object)timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.set(6, 1);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.lastYear.equals((Object)timeType)) {
            calendar.set(6, 1);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(1, -1);
            calendar.add(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.between.equals((Object)timeType)) {
            calendar.setTime(checkSchemeInfo.getBeginCheckRangeTime());
            beginDate = this.getFirstTime(calendar);
            calendar.setTime(checkSchemeInfo.getEndCheckRangeTime());
            endDate = this.getLastTime(calendar);
        }
        Timestamp[] timeParams = new Timestamp[]{beginDate, endDate};
        return timeParams;
    }

    private Timestamp getFirstTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private Timestamp getLastTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    protected boolean _sendMsg(Context ctx, IObjectValue SampleLibraryQualityTaskInfo2) throws BOSException, EASBizException {
        return false;
    }
}

