/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.CreditFilesInfo;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireCollection;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireFactory;
import com.kingdee.eas.base.ssc.SatisfactionBillInquireInfo;
import com.kingdee.eas.base.ssc.SatisfactionSettingFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingInfo;
import com.kingdee.eas.base.ssc.app.AbstractSatisfactionBillInquireToTaskFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.SatisfactionHisAssess;
import com.kingdee.eas.base.ssc.app.SatisfactionHisSendEnum;
import com.kingdee.eas.base.ssc.app.easLogin.WSContext;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceBill;
import com.kingdee.eas.base.ssc.app.erp.eas.CommonUtil;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.mail.SendMail;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SatisfactionBillInquireToTaskFacadeControllerBean
extends AbstractSatisfactionBillInquireToTaskFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SatisfactionBillInquireToTaskFacadeControllerBean");

    @Override
    protected boolean _getSatisfactionBillInquireTask(Context ctx) throws BOSException, EASBizException {
        boolean success = this._getSatisfactionBillInquireTaskNew(ctx, "");
        return success;
    }

    @Override
    protected boolean _getSatisfactionBillInquireTaskNew(Context ctx, String shareCenterNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)shareCenterNumber)) {
            List<DataBaseInfo> list = ShareCenterUtils.getAllValidShareCenterInfo(ctx);
            for (int i = 0; i < list.size(); ++i) {
                DataBaseInfo shareCenterInfo = list.get(i);
                String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterInfo.getId().toString()), (String)"SSC_SatisfactionControl");
                if (!"true".equals(isSatisfaction)) continue;
                this.dealSatisfactionBill(ctx, shareCenterInfo.getId().toString());
            }
            return true;
        }
        DataBaseInfo shareCenterInfo = ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber);
        String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterInfo.getId().toString()), (String)"SSC_SatisfactionControl");
        if (!"true".equals(isSatisfaction)) {
            return false;
        }
        this.dealSatisfactionBill(ctx, shareCenterInfo.getId().toString());
        return true;
    }

    private boolean dealSatisfactionBill(Context ctx, String shareCenterId) {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)shareCenterId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("satisfactionHisSend", (Object)SatisfactionHisSendEnum.unSend));
            filter.getFilterItems().add(new FilterItemInfo("isEvaluate", (Object)SatisfactionHisAssess.nuAssess));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("jobhisid.id");
            sic.add("jobhisid.subject");
            sic.add("jobhisid.billID");
            sic.add("jobhisid.bussAttrID");
            sic.add("jobhisid.bussAttrID.billType");
            view.setFilter(filter);
            view.setSelector(sic);
            SatisfactionBillInquireCollection coll = SatisfactionBillInquireFactory.getLocalInstance(ctx).getSatisfactionBillInquireCollection(view);
            CoreBaseCollection core = new CoreBaseCollection();
            SatisfactionSettingInfo setInfo = new SatisfactionSettingInfo();
            setInfo = SatisfactionSettingFactory.getLocalInstance(ctx).getValueBySCOrg(H.PK(shareCenterId));
            for (int i = 0; i < coll.size(); ++i) {
                try {
                    SatisfactionBillInquireInfo sbInfo = coll.get(i);
                    JobHisInfo jobHisInfo = sbInfo.getJobhisid();
                    CreditFilesNewInfo creditFilesInfo = JobUtils.getCreditFilesByJobHis(ctx, jobHisInfo);
                    this.toSendMailNew(ctx, creditFilesInfo, jobHisInfo, this.getBillTypeInfoByJobHis(ctx, jobHisInfo), setInfo);
                    sbInfo.setSatisfactionHisSend(SatisfactionHisSendEnum.hisSend);
                    sbInfo.setSendOfdate(new Timestamp(new Date().getTime()));
                    core.add((CoreBaseInfo)sbInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)(e + "--\u5355\u6761\u6570\u636e\u53d1\u9001\u5931\u8d25\u4e0d\u80fd\u5f71\u54cd\u6574\u4f53\u56de\u6eda---"));
                }
            }
            SatisfactionBillInquireFactory.getLocalInstance(ctx).update(core);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return true;
    }

    private BillTypeInfo getBillTypeInfoByJobHis(Context ctx, JobHisInfo jobHisInfo) throws Exception {
        BillTypeInfo billTypeInfo = jobHisInfo.getBussAttrID().getBillType();
        if (null != billTypeInfo) {
            return billTypeInfo;
        }
        StringBuffer sb = new StringBuffer(500);
        sb.append(" select bt.fid from t_ssc_job jb inner join T_SSC_BUSSINESSATTRIBUTE ba ");
        sb.append(" on jb.FBUSSATTRIDID = ba.FID  inner join T_SSC_BILLTYPE bt on ba.FBILLTYPEID = bt.FID  ");
        sb.append(" where jb.FID ='" + jobHisInfo.getId().toString() + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rs.next()) {
            return BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(rs.getString(1)));
        }
        throw new BOSException();
    }

    private void toSendMailNew(Context ctx, CreditFilesNewInfo creditFilesInfo, JobHisInfo jobhis, BillTypeInfo billType, SatisfactionSettingInfo setInfo) {
        try {
            String userAccount = setInfo.getUserAccount();
            String userPassword = setInfo.getUserPassword();
            String emailSMTP = setInfo.getEmailSMTP();
            String emailPort = setInfo.getEmailPort();
            String senderEmail = setInfo.getSenderEmail();
            String senderName = setInfo.getSenderName();
            String repHostIP = setInfo.getRepHostIP();
            String repHostPort = setInfo.getRepHostPort();
            String billID = jobhis.getBillID();
            String billNumber = "";
            ExtendERPInfo extendERPInfo = ERPUtil.getExtendERPInfo(ctx, jobhis.getId().toString());
            try {
                ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendERPInfo.getId().toString());
                if (service == null) {
                    throw new BOSException("can not find ERPWebServiceImpl");
                }
                if (!(service instanceof ERPWebServiceBill)) {
                    throw new BOSException(service + " is not a instanceof AbstractERPWebService!");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                ArrayList<String> list = new ArrayList<String>(1);
                map.put("billId", billID);
                list.add("number");
                map.put("list", list);
                String result = ((ERPWebServiceBill)((Object)service)).getBillAttribute(ctx, extendERPInfo, JSONUtils.convertObjectToJson((Context)ctx, map));
                HashMap resultMap = JSONUtils.convertJsonToObject((Context)ctx, (String)result);
                billNumber = (String)resultMap.get("number");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("\u60a8\u7684\u5355\u636e: ");
            sb.append(jobhis.getSubject());
            sb.append(" \u5171\u4eab\u5ba1\u6279\u5df2\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u8fdb\u884c\u8bc4\u4ef7\uff01\n\n");
            sb.append("http://");
            sb.append(repHostIP);
            sb.append(":");
            sb.append(repHostPort);
            sb.append("/eassso/login?service=");
            String url = "http://" + repHostIP + ":" + repHostPort + "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.base.ssc.satisfactionAppraise&waf2skin=easbase&billID=" + billID + "&billNumber=" + billNumber;
            sb.append(URLEncoder.encode(url, "UTF-8"));
            String email = creditFilesInfo.getUserEmail();
            if (StringUtils.isBlank((String)email)) {
                logger.error((Object)("**********\u7528\u6237email***********email:" + email));
                return;
            }
            SendMail.sendMessage(emailSMTP, emailPort, senderEmail, senderName, userAccount, userPassword, email, null, "\u6ee1\u610f\u5ea6\u8c03\u67e5", sb.toString(), null, null);
        }
        catch (Exception e) {
            logger.error((Object)("\u6ee1\u610f\u5ea6\u90ae\u4ef6\u53d1\u9001\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
    }

    private void toSendMail(Context ctx, CreditFilesInfo creditFilesInfo, JobHisInfo jobhis, BillTypeInfo billType) {
    }

    private void toSendMail(Context ctx, SatisfactionBillInquireInfo Info, ExtendERPInfo extendERPInfo) {
        try {
            WSContext svcCtx = CommonUtil.loginEAS(ctx, extendERPInfo);
            String sessionId = svcCtx.getSessionId();
            if (StringUtils.isEmpty((String)sessionId)) {
                logger.error((Object)"login EAS Fail");
            }
            Service service = new Service();
            Call call = svcCtx.getCall(true);
            call.setMaintainSession(true);
            String address = EASCfgUtil.getValue(ctx, extendERPInfo, "eas.vemail.url");
            call.setTargetEndpointAddress(address);
            call.setOperationName("sendEmail");
            call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
            logger.error((Object)("*****sendMail*******" + address));
            String content = "ssss";
            boolean bl = (Boolean)call.invoke(new Object[]{content});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Date strToDate(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(str);
        }
        catch (Exception e) {
            logger.error((Object)"\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u65e5\u671f\u5931\u8d25", (Throwable)e);
        }
        return date;
    }

    private Date getBeforeDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }
}

