/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryFactory;
import com.kingdee.eas.base.ssc.SatisfactionDimensionEntryInfo;
import com.kingdee.eas.base.ssc.app.AbstractSatisfactionReportFacadeControllerBean;
import com.kingdee.eas.base.ssc.chart.CategoriesTag;
import com.kingdee.eas.base.ssc.chart.CategoryTag;
import com.kingdee.eas.base.ssc.chart.ChartTag;
import com.kingdee.eas.base.ssc.chart.DatasetTag;
import com.kingdee.eas.base.ssc.chart.FusionChart;
import com.kingdee.eas.base.ssc.chart.SetTag;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterPermissionOrgUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SatisfactionReportFacadeControllerBean
extends AbstractSatisfactionReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SatisfactionReportFacadeControllerBean");
    private String totalSatis = "totalSatis";

    @Override
    protected String _getChartsDataPie2D(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        String shareCenter = (String)solutionMap.get("shareCenter");
        String dimensionId = (String)solutionMap.get("dimensionId");
        boolean defaultDimension = this.isDefaultDimension(ctx, dimensionId);
        StringBuffer sql = this.getSql(ctx, startDate, endDate, shareCenter, dimensionId, defaultDimension, null);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String fmy = StringUtils.cnulls((String)rowSet.getString("fmy"), (String)"0");
                String my = StringUtils.cnulls((String)rowSet.getString("my"), (String)"0");
                String yb = StringUtils.cnulls((String)rowSet.getString("yb"), (String)"0");
                String bmy = StringUtils.cnulls((String)rowSet.getString("bmy"), (String)"0");
                String fbmy = StringUtils.cnulls((String)rowSet.getString("fbmy"), (String)"0");
                map.put("fmy", fmy);
                map.put("my", my);
                map.put("yb", yb);
                map.put("bmy", bmy);
                map.put("fbmy", fbmy);
                list.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, list);
    }

    private StringBuffer getSql(Context ctx, String startDate, String endDate, String shareCenter, String dimensionId, boolean defaultDimension, String billTypeId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(temp.fmy) fmy,max(temp.my) my,max(temp.yb) yb,max(temp.bmy) bmy,max(temp.fbmy) fbmy from ( ");
        if (!defaultDimension) {
            sql.append(" select case when T2.FEvaluateResult = '0' then  sum(1) end as fmy, ");
            sql.append(" case when T2.FEvaluateResult = '1' then sum(1) end  as my, ");
            sql.append(" case when T2.FEvaluateResult = '2' then sum(1) end  as yb, ");
            sql.append(" case when T2.FEvaluateResult = '3' then sum(1)  end  as bmy, ");
            sql.append(" case when T2.FEvaluateResult = '4' then sum(1)  end  as fbmy ");
            sql.append(" from T_SSC_SatisfactionBillInquire T1 left join T_SSC_StfcBillInquireDimsEntry T2 on T1.FID = T2.FParent where FIsEvaluate='1' ");
        } else {
            sql.append(" select case when T1.FEvaluateResult = '0' then  sum(1) end as fmy, ");
            sql.append(" case when T1.FEvaluateResult = '1' then sum(1) end  as my, ");
            sql.append(" case when T1.FEvaluateResult = '2' then sum(1) end  as yb, ");
            sql.append(" case when T1.FEvaluateResult = '3' then sum(1)  end  as bmy, ");
            sql.append(" case when T1.FEvaluateResult = '4' then sum(1)  end  as fbmy ");
            sql.append(" from T_SSC_SatisfactionBillInquire T1 where FIsEvaluate='1' ");
        }
        if (!StringUtils.isEmpty((String)billTypeId)) {
            sql.append(" and fbilltypeid='");
            sql.append(billTypeId).append("' ");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and fevaluateOfdate >=").append(this.dateToTsDate(startDate));
            sql.append(" and fevaluateOfdate <=").append(this.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)shareCenter)) {
            sql.append(" and fshareCenterId in (" + shareCenter + ")");
        } else {
            String EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
            String shareCenterIDs = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, "5f023d47-57c3-40d8-98c0-8d59f216afe6PERMITEM");
            sql.append(" and fshareCenterId in (" + shareCenterIDs + ")");
        }
        if (!defaultDimension) {
            sql.append(" and T2.FDimension = '" + dimensionId + "'");
            sql.append(" group by T2.FEvaluateResult )temp ");
        } else {
            sql.append(" group by T1.FEvaluateResult )temp ");
        }
        return sql;
    }

    private boolean isDefaultDimension(Context ctx, String dimensionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dimensionId)) {
            return true;
        }
        SatisfactionDimensionEntryInfo satisfactionDimensionEntryInfo = SatisfactionDimensionEntryFactory.getLocalInstance(ctx).getSatisfactionDimensionEntryInfo(H.PK(dimensionId));
        return satisfactionDimensionEntryInfo.getNumber().equals(this.totalSatis);
    }

    @Override
    protected String _getChartsDataPie3D(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        String shareCenter = (String)solutionMap.get("shareCenter");
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(temp.yes) yes,max(temp.no) no from ( ");
        sql.append(" select case when FAutoEvaluate = '1' then  sum(1) end as yes, ");
        sql.append(" case when FAutoEvaluate = '2' then sum(1) end  as no ");
        sql.append(" from T_SSC_SatisfactionBillInquire where FIsEvaluate='1' ");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and fevaluateOfdate >=").append(this.dateToTsDate(startDate));
            sql.append(" and fevaluateOfdate <=").append(this.dateToTsDate(endDate));
        }
        if (!StringUtils.isEmpty((String)shareCenter)) {
            sql.append(" and fshareCenterId in (" + shareCenter + ")");
        } else {
            String EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
            String shareCenterIDs = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, "5f023d47-57c3-40d8-98c0-8d59f216afe6PERMITEM");
            sql.append(" and fshareCenterId in (" + shareCenterIDs + ")");
        }
        sql.append(" group by FAutoEvaluate )temp ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList list = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String yes = StringUtils.cnulls((String)rowSet.getString("yes"), (String)"0");
                String no = StringUtils.cnulls((String)rowSet.getString("no"), (String)"0");
                map.put("yes", yes);
                map.put("no", no);
                list.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, list);
    }

    @Override
    protected String _getChartsDataMSCombi2D(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        String shareCenter = (String)solutionMap.get("shareCenter");
        String dimensionId = (String)solutionMap.get("dimensionId");
        List listX = this.getBillType(ctx, shareCenter);
        String date = this.getDataset(ctx, listX, startDate, endDate, shareCenter, dimensionId);
        return date;
    }

    private String getDataset(Context ctx, List listX, String startDate, String endDate, String shareCenter, String dimensionId) {
        try {
            ArrayList<String> fmyList = new ArrayList<String>();
            ArrayList<String> myList = new ArrayList<String>();
            ArrayList<String> ybList = new ArrayList<String>();
            ArrayList<String> bmyList = new ArrayList<String>();
            ArrayList<String> fbmyList = new ArrayList<String>();
            CategoriesTag category = new CategoriesTag();
            boolean defaultDimension = this.isDefaultDimension(ctx, dimensionId);
            for (int i = 0; i < listX.size(); ++i) {
                Map map = (Map)listX.get(i);
                String str1 = (String)map.get("billtypename");
                String str2 = (String)map.get("billtypeid");
                CategoryTag cate = new CategoryTag(str1, str1);
                category.addCategory(cate);
                StringBuffer sql = this.getSql(ctx, startDate, endDate, shareCenter, dimensionId, defaultDimension, str2);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    String fmy = StringUtils.cnulls((String)rs.getString("fmy"), (String)"0");
                    String my = StringUtils.cnulls((String)rs.getString("my"), (String)"0");
                    String yb = StringUtils.cnulls((String)rs.getString("yb"), (String)"0");
                    String bmy = StringUtils.cnulls((String)rs.getString("bmy"), (String)"0");
                    String fbmy = StringUtils.cnulls((String)rs.getString("fbmy"), (String)"0");
                    fmyList.add(fmy);
                    myList.add(my);
                    ybList.add(yb);
                    bmyList.add(bmy);
                    fbmyList.add(fbmy);
                }
            }
            DatasetTag dataset = new DatasetTag();
            List<CategoryTag> ct = category.takeCategoryNoVLine();
            FusionChart fc = new FusionChart();
            fc.setChart(this.getChart());
            fc.addCategories(category);
            fc.addDataSet(this.getDataset(ct, fmyList, 0));
            fc.addDataSet(this.getDataset(ct, myList, 1));
            fc.addDataSet(this.getDataset(ct, ybList, 2));
            fc.addDataSet(this.getDataset(ct, bmyList, 3));
            fc.addDataSet(this.getDataset(ct, fbmyList, 4));
            return fc.toJSONString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ChartTag getChart() {
        ChartTag chart = new ChartTag();
        chart.setXaxisName("\u5355\u636e\u7c7b\u578b");
        chart.setCaption("\u5355\u636e\u6ee1\u610f\u5ea6\u5206\u6790");
        chart.setFormatNumber("0");
        chart.setFormatNumberScale("0");
        chart.setBaseFontSize("13");
        chart.setOutCnvBaseFontSize("13");
        chart.setOutCnvBaseFontColor("00A3D3");
        return chart;
    }

    public DatasetTag getDataset(List<CategoryTag> ct, List list, int index) {
        DatasetTag dataset = new DatasetTag();
        for (int i = 0; i < ct.size(); ++i) {
            SetTag settag = new SetTag();
            String value = list.get(i).toString();
            if (Integer.parseInt(value) > 0) {
                settag.setValue(value);
            } else {
                settag.setValue("");
            }
            dataset.addSetTag(settag);
        }
        if (index == 0) {
            dataset.setSeriesName("\u7279\u522b\u6ee1\u610f");
        } else if (index == 1) {
            dataset.setSeriesName("\u6ee1\u610f");
        } else if (index == 2) {
            dataset.setSeriesName("\u4e00\u822c");
        } else if (index == 3) {
            dataset.setSeriesName("\u4e0d\u6ee1\u610f");
        } else {
            dataset.setSeriesName("\u975e\u5e38\u4e0d\u6ee1\u610f");
        }
        return dataset;
    }

    public CategoriesTag getCategories(Map<String, String> userinfo) {
        CategoriesTag category = new CategoriesTag();
        for (Map.Entry<String, String> entry : userinfo.entrySet()) {
            CategoryTag cate = new CategoryTag(entry.getValue(), entry.getKey());
            category.addCategory(cate);
        }
        return category;
    }

    private List getBillType(Context ctx, String shareCenterId) {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            sb.append(" select tb.fname_l2 billtypename,tb.fid billtypeid,tb.fnumber billtypenum");
            sb.append(" from T_SSC_SatisfactionS tss inner join T_SSC_SatisfactionSE ts on tss.FID = ts.FParentID");
            sb.append(" inner join t_ssc_billtype tb ");
            sb.append(" on ts.fbilltypename=tb.fid ");
            sb.append(" where 1=1");
            sb.append(" and tss.FSCOrg = " + shareCenterId);
            sb.append(" and tb.fid in(" + this.getBillTypeIdsByShareCenter(shareCenterId) + ") ");
        } else {
            sb.append("select T1.fname_l2 billtypename,T1.fid billtypeid,T1.fnumber billtypenum from t_ssc_billtype T1 where exists (select 1 from T_SSC_SatisfactionSE T2 where T1.FID = T2.FBillTypeName)");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            ArrayList list = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String billtypename = rs.getString("billtypename");
                String billtypeid = rs.getString("billtypeid");
                String billtypenum = rs.getString("billtypenum");
                map.put("billtypename", billtypename);
                map.put("billtypeid", billtypeid);
                map.put("billtypenum", billtypenum);
                list.add(map);
            }
            return list;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private String getBillTypeIdsByShareCenter(String shareCenterId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" select distinct sb.fid from T_SSC_SysAttrOrgSCMap sa ");
        buffer.append(" inner join t_org_sharecenterorgunit os on sa.fsharecenterid=os.fid ");
        buffer.append(" inner join t_ssc_systemAttribute ss on ss.FID =sa.fsystemattributeid ");
        buffer.append(" inner join T_SSC_BILLTYPE sb on sb.FSYSATTRID =ss.fid ");
        buffer.append(" where os.fid in (" + shareCenterId + ")");
        return buffer.toString();
    }

    public String dateToTsDate(String dateStr) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date d2 = format.parse(dateStr);
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "{ts'" + format2.format(d2) + "'}";
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    protected String _getRelativeReportDate(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String showEnum = (String)solutionMap.get("showEnum");
        String contrastEnum = (String)solutionMap.get("contrastEnum");
        String billTypeId = (String)solutionMap.get("billTypeId");
        String shareCenter = (String)solutionMap.get("shareCenter");
        String date = this.getXCoordinate(ctx, showEnum, contrastEnum, billTypeId, shareCenter);
        return date;
    }

    private String getXCoordinate(Context ctx, String showEnum, String contrastEnum, String billTypeId, String shareCenter) throws BOSException {
        Map yearMap = this.getYearMap(showEnum);
        if ("1".equals(contrastEnum)) {
            List myListA = this.getCountList_byM(ctx, yearMap.get("year_A").toString(), 2, 1, 0, billTypeId, shareCenter);
            List countListA = this.getCountList_byM(ctx, yearMap.get("year_A").toString(), 5, 1, 0, billTypeId, shareCenter);
            List myListB = this.getCountList_byM(ctx, yearMap.get("year_B").toString(), 2, 1, 0, billTypeId, shareCenter);
            List countListB = this.getCountList_byM(ctx, yearMap.get("year_B").toString(), 5, 1, 0, billTypeId, shareCenter);
            List satisfactionA = this.getsatisfaction(myListA, countListA, 12);
            List satisfactionB = this.getsatisfaction(myListB, countListB, 12);
            List growthRate = this.getGrowthRate(myListA, myListB, 12);
            int countA = this.getBeforeYearCount(ctx, Integer.parseInt(yearMap.get("year_A").toString()) - 1, 1, billTypeId, shareCenter);
            int countB = this.getBeforeYearCount(ctx, Integer.parseInt(yearMap.get("year_B").toString()) - 1, 1, billTypeId, shareCenter);
            List MoMGrowthA = this.getMoMGrowth(myListA, countA, 12);
            List MoMGrowthB = this.getMoMGrowth(myListB, countB, 12);
            CategoriesTag category = new CategoriesTag();
            for (int i = 1; i < 13; ++i) {
                CategoryTag cate = new CategoryTag(i + "\u6708");
                category.addCategory(cate);
            }
            List<CategoryTag> ct = category.takeCategoryNoVLine();
            FusionChart fc = new FusionChart();
            ChartTag chartTag = this.getChartTag();
            fc.setChart(chartTag);
            fc.addCategories(category);
            DatasetTag datasetTag1 = this.getDatasetTag(ct, satisfactionA, yearMap.get("year_A").toString() + "\u6ee1\u610f\u7387", "COLUMN");
            DatasetTag datasetTag2 = this.getDatasetTag(ct, satisfactionB, yearMap.get("year_B").toString() + "\u6ee1\u610f\u7387", "COLUMN");
            DatasetTag datasetTag3 = this.getDatasetTag(ct, growthRate, "\u540c\u6bd4\u589e\u957f", "LINE");
            DatasetTag datasetTag4 = this.getDatasetTag(ct, MoMGrowthA, yearMap.get("year_A").toString() + "\u73af\u6bd4\u589e\u957f", "LINE");
            DatasetTag datasetTag5 = this.getDatasetTag(ct, MoMGrowthB, yearMap.get("year_B").toString() + "\u73af\u6bd4\u589e\u957f", "LINE");
            fc.addDataSet(datasetTag1);
            fc.addDataSet(datasetTag2);
            fc.addDataSet(datasetTag3);
            fc.addDataSet(datasetTag4);
            fc.addDataSet(datasetTag5);
            return fc.toJSONString();
        }
        List myListA = this.getCountList_byM(ctx, yearMap.get("year_A").toString(), 2, 3, 2, billTypeId, shareCenter);
        List countListA = this.getCountList_byM(ctx, yearMap.get("year_A").toString(), 5, 3, 2, billTypeId, shareCenter);
        List myListB = this.getCountList_byM(ctx, yearMap.get("year_B").toString(), 2, 3, 2, billTypeId, shareCenter);
        List countListB = this.getCountList_byM(ctx, yearMap.get("year_B").toString(), 5, 3, 2, billTypeId, shareCenter);
        List satisfactionA = this.getsatisfaction(myListA, countListA, 4);
        List satisfactionB = this.getsatisfaction(myListB, countListB, 4);
        List growthRate = this.getGrowthRate(myListA, myListB, 4);
        int countA = this.getBeforeYearCount(ctx, Integer.parseInt(yearMap.get("year_A").toString()) - 1, 2, billTypeId, shareCenter);
        int countB = this.getBeforeYearCount(ctx, Integer.parseInt(yearMap.get("year_B").toString()) - 1, 2, billTypeId, shareCenter);
        List MoMGrowthA = this.getMoMGrowth(myListA, countA, 4);
        List MoMGrowthB = this.getMoMGrowth(myListB, countB, 4);
        CategoriesTag category = new CategoriesTag();
        for (int i = 1; i < 5; ++i) {
            CategoryTag cate = new CategoryTag(i + "\u5b63\u5ea6");
            category.addCategory(cate);
        }
        List<CategoryTag> ct = category.takeCategoryNoVLine();
        FusionChart fc = new FusionChart();
        ChartTag chartTag = this.getChartTag();
        fc.setChart(chartTag);
        fc.addCategories(category);
        DatasetTag datasetTag1 = this.getDatasetTag(ct, satisfactionA, yearMap.get("year_A").toString() + "\u6ee1\u610f\u7387", "COLUMN");
        DatasetTag datasetTag2 = this.getDatasetTag(ct, satisfactionB, yearMap.get("year_B").toString() + "\u6ee1\u610f\u7387", "COLUMN");
        DatasetTag datasetTag3 = this.getDatasetTag(ct, growthRate, "\u540c\u6bd4\u589e\u957f", "LINE");
        DatasetTag datasetTag4 = this.getDatasetTag(ct, MoMGrowthA, yearMap.get("year_A").toString() + "\u73af\u6bd4\u589e\u957f", "LINE");
        DatasetTag datasetTag5 = this.getDatasetTag(ct, MoMGrowthB, yearMap.get("year_B").toString() + "\u73af\u6bd4\u589e\u957f", "LINE");
        fc.addDataSet(datasetTag1);
        fc.addDataSet(datasetTag2);
        fc.addDataSet(datasetTag3);
        fc.addDataSet(datasetTag4);
        fc.addDataSet(datasetTag5);
        return fc.toJSONString();
    }

    private DatasetTag getDatasetTag(List<CategoryTag> ct, List list, String seriesName, String renderAsType) {
        DatasetTag dataset = new DatasetTag();
        for (int i = 0; i < ct.size(); ++i) {
            SetTag settag = new SetTag();
            String value = list.get(i).toString();
            settag.setValue(value);
            dataset.addSetTag(settag);
        }
        dataset.setParentYAxis("P");
        dataset.setSeriesName(seriesName);
        dataset.setRenderAs(renderAsType);
        return dataset;
    }

    private ChartTag getChartTag() {
        ChartTag chart = new ChartTag();
        chart.setCaption("\u5355\u636e\u6ee1\u610f\u5ea6\u5bf9\u6bd4\u5206\u6790");
        chart.setSetAdaptiveYMin("0");
        chart.setYaxisName("\u6ee1\u610f\u5ea6\u767e\u5206\u6bd4");
        chart.setNumberSuffix("%");
        return chart;
    }

    private List getMoMGrowth(List myListA, int count, int i) {
        ArrayList<Object> moMGrowthList = new ArrayList<Object>();
        for (int j = 0; j < i; ++j) {
            if (j == 0) {
                if (count != 0) {
                    if ((Integer)myListA.get(j) == 0) {
                        moMGrowthList.add("");
                        continue;
                    }
                    moMGrowthList.add(Math.round(((Integer)myListA.get(j) - count) * 100 / count));
                    continue;
                }
                moMGrowthList.add("");
                continue;
            }
            int num = (Integer)myListA.get(j - 1);
            int con = (Integer)myListA.get(j);
            if (num != 0) {
                if (num == 0) {
                    moMGrowthList.add("");
                    continue;
                }
                moMGrowthList.add(Math.round((con - num) * 100 / num));
                continue;
            }
            moMGrowthList.add("");
        }
        return moMGrowthList;
    }

    private int getBeforeYearCount(Context ctx, int i, int j, String billTypeId, String shareCenter) {
        StringBuffer sb = new StringBuffer();
        sb.append("  select count(1) as my  from T_SSC_SatisfactionBillInquire ");
        sb.append(" where FIsEvaluate='1' and  (FEvaluateResult='0' or  FEvaluateResult='1') ");
        sb.append(" and fevaluateOfdate>=");
        if (j == 1) {
            sb.append(this.dateToTsDate(i + "/" + 12 + "/01 00:00:00"));
        } else {
            sb.append(this.dateToTsDate(i + "/" + 10 + "/01 00:00:00"));
        }
        if (!StringUtils.isEmpty((String)billTypeId)) {
            sb.append(" and fbilltypeid in (" + billTypeId + ")");
        }
        if (!StringUtils.isEmpty((String)shareCenter)) {
            sb.append(" and fsharecenterid in (" + shareCenter + ")");
        }
        sb.append(" and fevaluateOfdate<=");
        sb.append(this.dateToTsDate(this.getLastDayOfMonth(i, 12) + " 23:59:59"));
        int count = 0;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.next()) {
                count = rs.getInt("my");
            }
            return count;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private List getGrowthRate(List myListA, List myListB, int i) {
        ArrayList<Object> growthRate = new ArrayList<Object>();
        for (int j = 0; j < i; ++j) {
            int myA = (Integer)myListA.get(j);
            int myB = (Integer)myListB.get(j);
            if (myB != 0) {
                growthRate.add(Math.round((myA - myB) * 100 / myB));
                continue;
            }
            growthRate.add("");
        }
        return growthRate;
    }

    private List getsatisfaction(List myListA, List umyListA, int i) {
        ArrayList<Object> satisfaction = new ArrayList<Object>();
        for (int j = 0; j < i; ++j) {
            int my = Integer.parseInt(myListA.get(j).toString());
            int umy = Integer.parseInt(umyListA.get(j).toString());
            int satisy = 0;
            if (umy != 0) {
                satisy = Math.round(my * 100 / umy);
                satisfaction.add(satisy);
                continue;
            }
            satisfaction.add("");
        }
        return satisfaction;
    }

    private List getCountList_byM(Context ctx, String yearMap, int comparValue, int adding, int rice, String billTypeId, String shareCenterId) throws BOSException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= 12; i += adding) {
            StringBuffer sb = new StringBuffer();
            sb.append("  select count(1) as my  from T_SSC_SatisfactionBillInquire ");
            sb.append(" where FIsEvaluate='1' ");
            if (2 == comparValue) {
                sb.append(" and (FEvaluateResult='0' or FEvaluateResult='1') ");
            } else {
                sb.append(" and (FEvaluateResult='0' or FEvaluateResult='1' or FEvaluateResult='2' or FEvaluateResult='3' or FEvaluateResult='4') ");
            }
            sb.append(" and fevaluateOfdate>=");
            sb.append(this.dateToTsDate(yearMap + "/" + i + "/01 00:00:00"));
            sb.append(" and fevaluateOfdate<=");
            sb.append(this.dateToTsDate(this.getLastDayOfMonth(Integer.parseInt(yearMap), i + rice) + " 23:59:59"));
            if (!StringUtils.isEmpty((String)billTypeId)) {
                sb.append(" and fbilltypeid in (" + billTypeId + ")");
            }
            if (!StringUtils.isEmpty((String)shareCenterId)) {
                sb.append(" and fsharecenterid in (" + shareCenterId + ")");
            } else {
                String EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
                String shareCenterIDs = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, "ec39b040-1715-4f13-a322-f397d6048586PERMITEM");
                sb.append(" and fshareCenterId in (" + shareCenterIDs + ")");
            }
            int count = 0;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) {
                    count = rs.getInt("my");
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            list.add(count);
        }
        return list;
    }

    public String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    private Map getYearMap(String showEnum) {
        int year_B;
        int year_A;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if ("1".equals(showEnum)) {
            Calendar year_a = Calendar.getInstance();
            year_A = year_a.get(1);
            Calendar year_b = Calendar.getInstance();
            year_b.add(1, -1);
            year_B = year_b.get(1);
        } else {
            Calendar year_a = Calendar.getInstance();
            year_a.add(1, -1);
            year_A = year_a.get(1);
            Calendar year_b = Calendar.getInstance();
            year_b.add(1, -2);
            year_B = year_b.get(1);
        }
        map.put("year_A", year_A);
        map.put("year_B", year_B);
        return map;
    }

    public List GetShareCenterIdList(Context ctx, String permissionId) {
        String EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
        String sql = " SELECT DISTINCT FORGID FROM T_PM_UserOrgPerm WHERE FOWNER = '" + EASUserId + "' AND FPERMITEMID = '" + permissionId + "' ";
        ArrayList<String> list = new ArrayList<String>();
        String shareCenterId = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                shareCenterId = rs.getString("FORGID");
                list.add(shareCenterId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

