/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserGroupCollection;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractTaskHomeFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.QueryDataCallable;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TaskHomeFacadeControllerBean
extends AbstractTaskHomeFacadeControllerBean {
    private static final long serialVersionUID = 3656700996678870604L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.TaskHomeFacadeControllerBean");
    private static ExecutorService executorService = new ThreadPoolExecutor(7, 7, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100));

    @Override
    protected String _getStatisticsData(Context ctx, Map params) throws BOSException, EASBizException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = df.format(new Date());
        String todayStart = "{ts'" + dateString + " 00:00:00'}";
        String todayEnd = "{ts'" + dateString + " 23:59:59'}";
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(case when tmp.fjobpoolingtype='2' and tmp.fexpirestate=1 and tmp.fautoApprove='0' then 1 end) expired,");
        sql.append(" sum(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' then 1 end) deal,");
        sql.append(" sum(case when tmp.fjobpoolingtype='1' and tmp.fautoApprove='0' then 1 end) untreated,");
        sql.append(" max(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' and tmp.fexpirestate=1 then tmp.fbussattridid end) expired_bizid,");
        sql.append(" max(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' then tmp.fbussattridid end) deal_bizid, ");
        sql.append(" max(case when tmp.fjobpoolingtype='1' and tmp.fautoApprove='0' then tmp.fbussattridid end) untreated_bizid");
        sql.append(" from ");
        sql.append(this.getStatisticsSql(ctx, params, "t_ssc_job"));
        StringBuilder sql2 = new StringBuilder();
        sql2.append("select max(case when tmp.fjobpoolingtype='3' and tmp.fcompletetme >= " + todayStart + " and tmp.fcompletetme <= " + todayEnd + " then tmp.fbussattridid end) complete_bizid, ");
        sql2.append("sum(case when tmp.fjobpoolingtype='3' and tmp.fcompletetme >= " + todayStart + " and tmp.fcompletetme <= " + todayEnd + " then 1 end) complete");
        sql2.append(" from ");
        sql2.append(this.getStatisticsSql(ctx, params, "t_ssc_jobhis"));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next() && rowSet2.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("untreated", StringUtils.cnulls((String)rowSet.getString("untreated"), (String)"0"));
                map.put("deal", StringUtils.cnulls((String)rowSet.getString("deal"), (String)"0"));
                map.put("expired_bizid", StringUtils.cnulls((String)rowSet.getString("expired_bizid")));
                map.put("untreated_bizid", StringUtils.cnulls((String)rowSet.getString("untreated_bizid")));
                map.put("deal_bizid", StringUtils.cnulls((String)rowSet.getString("deal_bizid")));
                map.put("complete", StringUtils.cnulls((String)rowSet2.getString("complete"), (String)"0"));
                map.put("complete_field", StringUtils.cnulls((String)rowSet2.getString("complete_bizid")));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    private Object getStatisticsSql(Context ctx, Map params, String table) throws BOSException {
        StringBuilder ret = new StringBuilder("(");
        String userID = (String)params.get("userid");
        String sql = " select tj.fid as fid, tj.fjobpoolingtype as fjobpoolingtype, tj.fexpirestate as fexpirestate,tj.fbussattridid as fbussattridid,tj.fautoApprove as fautoApprove,tj.fjobstate as fjobstate,tj.fcompletetme as fcompletetme from " + table + " tj ";
        String biz_role_type = (String)params.get("bizTypeId");
        ArrayList<String> bizAdminTypeIds = new ArrayList<String>();
        ArrayList<String> bizTypeIds = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)biz_role_type)) {
            List bizTypeList = JSONArray.parseArray((String)biz_role_type, Map.class);
            if (bizTypeList.size() == 0) {
                ret.append(sql);
            } else {
                for (Map map : bizTypeList) {
                    String bizTypeId = (String)map.get("key");
                    String bizroleType = (String)map.get("value");
                    if (bizroleType.equals("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=")) {
                        bizTypeIds.add(bizTypeId);
                        continue;
                    }
                    bizAdminTypeIds.add(bizTypeId);
                }
                if (!bizTypeIds.isEmpty()) {
                    ret.append(this.getSql(ctx, sql, userID, bizTypeIds, false));
                } else if (!bizAdminTypeIds.isEmpty()) {
                    ret.append(this.getSql(ctx, sql, userID, bizAdminTypeIds, true));
                }
            }
        }
        ret.append(") tmp ");
        return ret.toString();
    }

    private String getSql(Context ctx, String sql, String userID, List<String> bussAttrIds, boolean isBizAdmin) throws BOSException {
        String shareCenterID = null;
        try {
            shareCenterID = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String isManageOrgControl = "false";
        if (isBizAdmin) {
            try {
                isManageOrgControl = ParamManager.getParamValue(null, null, (String)"SSC_ManagerOrgControl");
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        StringBuilder ret = new StringBuilder();
        boolean needUnion = false;
        for (String bussAttrId : bussAttrIds) {
            if (needUnion) {
                ret.append(" union all ");
            } else {
                needUnion = true;
            }
            ret.append(sql);
            ret.append("where (tj.fbussattridid ='" + bussAttrId + "' and tj.fsharecenterid = '" + shareCenterID + "'");
            if (Boolean.valueOf(isManageOrgControl).booleanValue()) {
                ret.append(" and tj.forgidid in (").append(this.getPermissionOrg(ctx, userID, bussAttrId, isBizAdmin)).append(") ");
            }
            if (!isBizAdmin) {
                ret.append(" and tj.fpersonnelidid = '" + userID + "'");
            }
            ret.append(")");
            ret.append(" union all ");
            ret.append(sql);
            ret.append(" where tj.fsharecenterid is null and tj.fbussattridid = '" + bussAttrId + "' and tj.fjobpoolingtype = '1'");
        }
        return ret.toString();
    }

    private String getPermissionOrg(Context ctx, String userID, String bussAttrId, boolean isBizAdmin) {
        if (StringUtils.isEmpty((String)userID)) {
            userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select ro.forgidid ");
        sql.append(" from t_ssc_roleorg ro ");
        sql.append(" left outer join t_ssc_role r on ro.froleidid = r.fid ");
        sql.append(" left outer join t_ssc_rolebussattr rb on r.fid = rb.fparentid ");
        sql.append(" left outer join t_ssc_roleuser ru on r.fid = ru.froleidid ");
        sql.append(" where ru.fuseridid = '").append(userID).append("' ");
        if (!StringUtils.isEmpty((String)bussAttrId)) {
            sql.append(" and rb.fbussnameid ='").append(bussAttrId).append("'");
        }
        if (isBizAdmin) {
            sql.append(" and r.froletypeidid = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ");
        } else {
            sql.append(" and r.froletypeidid = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' ");
        }
        return sql.toString();
    }

    protected String _getStatisticsData2(Context ctx, Map params) throws BOSException, EASBizException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = df.format(new Date());
        String todayStart = "{ts'" + dateString + " 00:00:00'}";
        String todayEnd = "{ts'" + dateString + " 23:59:59'}";
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(case when tmp.fjobpoolingtype='2' and tmp.fexpirestate=1 and tmp.fautoApprove='0' then 1 end) expired,");
        sql.append(" sum(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' then 1 end) deal,");
        sql.append(" sum(case when tmp.fjobpoolingtype='1' and tmp.fautoApprove='0' then 1 end) untreated,");
        sql.append(" max(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' and tmp.fexpirestate=1 then tmp.fbussattridid end) expired_bizid,");
        sql.append(" max(case when tmp.fjobpoolingtype='2' and tmp.fautoApprove='0' then tmp.fbussattridid end) deal_bizid, ");
        sql.append(" max(case when tmp.fjobpoolingtype='1' and tmp.fautoApprove='0' then tmp.fbussattridid end) untreated_bizid");
        sql.append(" from ");
        sql.append(this.getStatisticsSql(ctx, params, "t_ssc_job"));
        StringBuilder sql2 = new StringBuilder();
        sql2.append("select max(case when tmp.fjobpoolingtype='3' and tmp.fcompletetme >= " + todayStart + " and tmp.fcompletetme <= " + todayEnd + " then tmp.fbussattridid end) complete_bizid, ");
        sql2.append("sum(case when tmp.fjobpoolingtype='3' and tmp.fcompletetme >= " + todayStart + " and tmp.fcompletetme <= " + todayEnd + " then 1 end) complete");
        sql2.append(" from ");
        sql2.append(this.getStatisticsSql(ctx, params, "t_ssc_jobhis"));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next() && rowSet2.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("untreated", StringUtils.cnulls((String)rowSet.getString("untreated"), (String)"0"));
                map.put("deal", StringUtils.cnulls((String)rowSet.getString("deal"), (String)"0"));
                map.put("expired_bizid", StringUtils.cnulls((String)rowSet.getString("expired_bizid")));
                map.put("untreated_bizid", StringUtils.cnulls((String)rowSet.getString("untreated_bizid")));
                map.put("deal_bizid", StringUtils.cnulls((String)rowSet.getString("deal_bizid")));
                map.put("complete", StringUtils.cnulls((String)rowSet2.getString("complete"), (String)"0"));
                map.put("complete_field", StringUtils.cnulls((String)rowSet2.getString("complete_bizid")));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    private static String getCurMonthFirstDay() {
        Date temp = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        temp = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(temp);
    }

    @Override
    protected Map _getCurMonthQuality(Context ctx, Map params) throws BOSException, EASBizException {
        int callbackNum = 0;
        int taskTotalNum = 0;
        int expiredNum = 0;
        try {
            Map<String, Integer> curMonthQuality0 = this.getCurMonthQuality0(ctx, params);
            expiredNum = curMonthQuality0.get("expired");
            taskTotalNum = curMonthQuality0.get("taskTotal");
            Map<String, Integer> curMonthQuality1 = this.getCurMonthQuality1(ctx, params);
            callbackNum = curMonthQuality1.get("callback");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("expired", expiredNum);
        result.put("callback", callbackNum);
        result.put("taskTotal", taskTotalNum);
        return result;
    }

    protected Map<String, Integer> getCurMonthQuality0(Context ctx, Map params) throws BOSException, SQLException {
        String curMonthFirstDay = TaskHomeFacadeControllerBean.getCurMonthFirstDay();
        StringBuilder expired = new StringBuilder();
        expired.append("SELECT FISEXPIRED,count(1) total FROM T_ssc_jobhis where FPERSONNELIDID = ? and fautoApprove='0' and FCOMPLETETME >= {ts'" + curMonthFirstDay + "'}  group by FISEXPIRED");
        int expiredNum = 0;
        int taskTotalNum = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)expired.toString(), (Object[])new Object[]{params.get("userId")});
        while (rs.next()) {
            if (rs.getString("FISEXPIRED").equals("1")) {
                expiredNum = rs.getInt("total");
            }
            taskTotalNum += rs.getInt("total");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("expired", expiredNum);
        result.put("taskTotal", taskTotalNum);
        return result;
    }

    protected Map<String, Integer> getCurMonthQuality1(Context ctx, Map params) throws BOSException, SQLException {
        int callbackNum = 0;
        String curMonthFirstDay = TaskHomeFacadeControllerBean.getCurMonthFirstDay();
        StringBuilder callback = new StringBuilder();
        callback.append(" SELECT count(1) FROM T_ssc_jobhis jh,t_ssc_jobhisext jhe");
        callback.append(" where jh.FID = jhe.FJOBID ");
        callback.append(" and jh.FPersonnelIDID = ?");
        callback.append(" and jhe.FIsMissJob = 1");
        callback.append(" and jh.fautoApprove=0 ");
        callback.append(" and jh.FCOMPLETETME >= {ts'" + curMonthFirstDay + "'}");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)callback.toString(), (Object[])new Object[]{params.get("userId")});
        if (rs.next()) {
            callbackNum = rs.getInt(1);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("callback", callbackNum);
        return result;
    }

    protected Map getAvgAndMaxNum(Context ctx, String userId) throws BOSException, SQLException, EASBizException {
        String groupId = "";
        if (UserGroupFactory.getLocalInstance(ctx).exists("where user.id='" + userId + "'")) {
            UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + userId + "'");
            groupId = userGroupInfo.getGroup().getId().toString();
        }
        HashMap<String, Number> result = new HashMap<String, Number>();
        Integer avgTasks = null;
        BigDecimal avgDealHours = null;
        String curDay = DateUtil.getCurDayDate();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT fworkload");
        sql.append(" FROM T_ssc_group");
        sql.append(" where fid=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{groupId});
        if (rs.next()) {
            avgTasks = rs.getInt(1);
        }
        sql = new StringBuffer();
        sql.append(" SELECT avg(jhe.fapprovetime/1000/60) avgDealHours");
        sql.append(" FROM t_ssc_jobhis jh,t_ssc_jobhisext jhe");
        sql.append(" where jh.fid = jhe.fjobid");
        sql.append(" and jhe.fapprovetime is not null");
        sql.append(" and jh.fautoApprove=0");
        sql.append(" and jh.FCOMPLETETME >= {ts'" + curDay + "'}");
        sql.append(" and jhe.fgroupId=?");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{groupId});
        if (rs.next() && (avgDealHours = rs.getBigDecimal(1)) != null) {
            avgDealHours = avgDealHours.setScale(2, 4);
        }
        result.put("avgTasks", avgTasks);
        result.put("avgDealHours", avgDealHours);
        return result;
    }

    @Override
    protected Map _getEfficiency(Context ctx, Map params) throws BOSException, EASBizException {
        Map result = new HashMap();
        try {
            String userId = params.get("userId").toString();
            result = this.getAvgAndMaxNum(ctx, userId);
            result.putAll(this.getEfficiency0(ctx, userId));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected Map getEfficiency0(Context ctx, String userId) throws SQLException, BOSException {
        HashMap<String, Number> result = new HashMap<String, Number>();
        Integer tasks = 0;
        BigDecimal hours = new BigDecimal(0);
        String curDay = DateUtil.getCurDayDate();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(1) tasks,avg(jhe.fapprovetime/1000/60) hours");
        sql.append(" FROM t_ssc_jobhis jh,t_ssc_jobhisext jhe");
        sql.append(" where jh.fid = jhe.fjobid");
        sql.append(" and jh.fautoApprove=0 ");
        sql.append(" and jh.FCOMPLETETME >= {ts'" + curDay + "'}");
        sql.append(" and jh.FPERSONNELIDID=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId});
        if (rs.next()) {
            tasks = rs.getInt(1);
            hours = rs.getBigDecimal(2);
            if (hours == null) {
                hours = new BigDecimal(0);
            }
        }
        result.put("tasks", tasks);
        result.put("hours", hours.setScale(2, 4));
        return result;
    }

    @Override
    protected Map _getEfficiencyRank(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        try {
            String userId = params.get("userId").toString();
            String groupId = "";
            if (UserGroupFactory.getLocalInstance(ctx).exists("where user.id='" + userId + "'")) {
                UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + userId + "'");
                groupId = userGroupInfo.getGroup().getId().toString();
            }
            String curDay = DateUtil.getCurDayDate();
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT u.fid userId,u.FNAME_l2 as userName, ");
            sb.append(" (case when e.fhours>0 then e.FRatio * e.ftasks/e.fhours else 0 end) as EFFICIENCY,u.Fnumber as userAccount");
            sb.append(" FROM v_ssc_efficiency e,t_ssc_user u");
            sb.append(" where e.fdate >= {ts'" + curDay + "'}");
            sb.append(" and e.fuserid = u.FID ");
            sb.append(" and fgroupid= ?");
            sb.append(" order by EFFICIENCY desc");
            ArrayList efficiencyList = new ArrayList();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{groupId});
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userName", rs.getString(2));
                map.put("efficiency", rs.getBigDecimal(3));
                map.put("userAccount", rs.getString(4));
                map.put("rank", rs.getRow());
                efficiencyList.add(map);
                if (!rs.getString(1).equals(userId)) continue;
                result.put("curUserEfficiency", map);
            }
            result.put("groupEfficiency", efficiencyList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getTaskDate(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Map tempReuslt;
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT count(1) deal,");
            sql.append(" sum(case when fexpirestate=1 then 1 else 0 end) expired,");
            sql.append(" sum(case when FJOBSTATE = '0' then 1 else 0 end) concernPause,");
            sql.append(" sum(case when FJOBSTATE = '1' then 1 else 0 end) concernReScan,");
            sql.append(" sum(case when FJOBSTATE = '7' then 1 else 0 end) concernReUpload");
            sql.append(" FROM T_ssc_job");
            sql.append(" where FPERSONNELIDID = ?");
            sql.append(" and fjobpoolingtype='2' ");
            sql.append(" and fautoApprove=0 ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{params.get("userId").toString()});
            if (rowSet.next()) {
                map.put("deal", rowSet.getInt("deal"));
                map.put("expired", rowSet.getInt("expired"));
                int concernPause = rowSet.getInt("concernPause");
                map.put("concernPause", concernPause);
                int concernReScan = rowSet.getInt("concernReScan");
                map.put("concernReScan", concernReScan);
                int concernReUpload = rowSet.getInt("concernReUpload");
                map.put("concernReUpload", concernReUpload);
                map.put("concern", concernPause + concernReScan + concernReUpload);
            }
            if ((tempReuslt = (Map)params.get(BizTaskHome.pTempRs)) != null && tempReuslt.get(BizTaskHome.pComplete) != null) {
                map.put("completed", Integer.parseInt(tempReuslt.get(BizTaskHome.pComplete).toString()));
            } else {
                String curDay = DateUtil.getCurDayDate();
                StringBuilder sql2 = new StringBuilder();
                sql2.append(" SELECT count(1) completed FROM T_ssc_jobhis");
                sql2.append(" where FPERSONNELIDID = ?");
                sql2.append(" and fautoApprove=0 ");
                sql2.append(" and FCOMPLETETME >= {ts'" + curDay + "'}");
                IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])new Object[]{params.get("userId").toString()});
                if (rowSet2.next()) {
                    map.put("completed", rowSet2.getInt("completed"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @Override
    protected boolean _isReachStandard(Context ctx, Map params) throws BOSException, EASBizException {
        try {
            Map tempReuslt;
            String curDay = DateUtil.getCurDayDate();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT count(1) completed FROM T_ssc_jobhis");
            sql.append(" where FPERSONNELIDID = ?");
            sql.append(" and fautoApprove=0 ");
            sql.append(" and FCOMPLETETME >= {ts'" + curDay + "'}");
            int completed = 0;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{params.get("userId").toString()});
            if (rowSet.next()) {
                completed = rowSet.getInt(1);
            }
            if ((tempReuslt = (Map)params.get(BizTaskHome.pTempRs)) != null) {
                tempReuslt.put(BizTaskHome.pComplete, completed);
            }
            int workload = 0;
            UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + params.get("userId").toString() + "'");
            if (userGroupInfo != null && userGroupInfo.getGroup() != null) {
                workload = userGroupInfo.getGroup().getWorkload();
            }
            if (completed >= workload) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return false;
    }

    @Override
    protected Map _getEfficiencyRankTopAndLast5(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        String adminId = params.get("userId").toString();
        List top5 = this.getEfficiencyRankTop5(ctx, adminId, true);
        List last5 = this.getEfficiencyRankTop5(ctx, adminId, false);
        result.put("efficiencyTop5", top5);
        result.put("efficiencyLast5", last5);
        return result;
    }

    private List getEfficiencyRankTop5(Context ctx, String adminId, boolean isTop) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        ArrayList efficiencyList = new ArrayList();
        try {
            String curDay = DateUtil.getCurDayDate();
            String planing = "";
            String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
            planing = isManageOrgControl.equals("true") ? FormatUtils.list2Sql(this.getUserByAdminBizAndOrg(ctx, adminId)) : FormatUtils.list2Sql(this.getBizByAdminPlaning(ctx, adminId));
            planing = StringUtils.isEmpty((String)planing) ? "('')" : planing;
            UserGroupCollection useGroupCollection = UserGroupFactory.getLocalInstance(ctx).getUserGroupCollection("select *,user.*,group.* where user.id in " + planing + " order by user.id,isdefaultgroup desc,group.name");
            StringBuffer groups = new StringBuffer();
            HashMap<String, String> usergroup = new HashMap<String, String>();
            String groupTable = "";
            if (useGroupCollection != null && useGroupCollection.size() > 0) {
                for (int i = 0; i < useGroupCollection.size(); ++i) {
                    UserGroupInfo userGroupInfo = useGroupCollection.get(i);
                    if (usergroup.containsKey(userGroupInfo.getUser().getId().toString())) continue;
                    usergroup.put(userGroupInfo.getUser().getId().toString(), userGroupInfo.getGroup().getId().toString());
                }
                for (Map.Entry entry : usergroup.entrySet()) {
                    groups.append(" select '" + (String)entry.getKey() + "' fuserid,'" + (String)entry.getValue() + "' fgroupId union all");
                }
                groupTable = groups.substring(0, groups.length() - 10);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT top 5 u.FNAME_l2 as userName,g.FNAME_l2 as groupName,case when e.fhours = 0 then 0 else e.FRatio * e.ftasks/e.fhours end as EFFICIENCY");
            if (groupTable.equals("")) {
                sb.append(" FROM v_ssc_efficiency e,t_ssc_user u,t_ssc_userGroup ug,t_ssc_group g");
            } else {
                sb.append(" FROM v_ssc_efficiency e,t_ssc_user u,(" + groupTable + ") ug,t_ssc_group g");
            }
            sb.append(" where e.fdate >= {ts'" + curDay + "'}");
            sb.append(" and e.fuserid = u.FID");
            sb.append(" and ug.fuserid = u.FID");
            sb.append(" and ug.fgroupId = g.FID");
            sb.append(" and u.fid in" + planing);
            if (isTop) {
                sb.append(" order by EFFICIENCY desc");
            } else {
                sb.append(" order by EFFICIENCY asc");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[0]);
            logger.error((Object)("sql:" + sb.toString()));
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userName", rs.getString(1));
                map.put("groupName", rs.getString(2));
                map.put("efficiency", rs.getBigDecimal(3));
                map.put("rank", rs.getRow());
                efficiencyList.add(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        long endTime = System.currentTimeMillis();
        return efficiencyList;
    }

    private List<String> getBizByAdminPlaning(Context ctx, String adminId) throws EASBizException {
        long startTime = System.currentTimeMillis();
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("  select distinct users.FID id ");
            sb.append("    from t_ssc_user users ");
            sb.append("   inner join T_SSC_ROLEUSER ru ");
            sb.append("      on users.fid = ru.FUSERIDID ");
            sb.append("   inner join T_SSC_ROLE role ");
            sb.append("      on role.fid = ru.FROLEIDID ");
            sb.append("   inner join T_SSC_ROLETYPE ty ");
            sb.append("      on ty.fid = role.FROLETYPEIDID ");
            sb.append("   inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("      on rb.FPARENTID = role.FID ");
            sb.append("   inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("      on bs.fid = rb.FBUSSNAMEID ");
            sb.append("   where users.FSHARECENTERID = ? ");
            sb.append("     and ty.FID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' ");
            sb.append("     and role.FNUMBER NOT LIKE '%addForCompel%' ");
            sb.append("     and bs.FID in ");
            sb.append("         (select distinct bs.FID ");
            sb.append("            from t_ssc_user users ");
            sb.append("           inner join T_SSC_ROLEUSER ru ");
            sb.append("              on users.fid = ru.FUSERIDID ");
            sb.append("           inner join T_SSC_ROLE role ");
            sb.append("              on role.fid = ru.FROLEIDID ");
            sb.append("           inner join T_SSC_ROLETYPE ty ");
            sb.append("              on ty.fid = role.FROLETYPEIDID ");
            sb.append("           inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("              on rb.FPARENTID = role.FID ");
            sb.append("           inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("              on bs.fid = rb.FBUSSNAMEID ");
            sb.append("          where users.FID = ? ");
            sb.append("            and ty.FID = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ");
            sb.append("            and role.fnumber not like '%addForCompel%') ");
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(adminId));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userInfo.getShareCenterId(), adminId});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        long endTime = System.currentTimeMillis();
        return bizList;
    }

    @Override
    protected Map _getUserDimission(Context ctx, Map params) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String adminId = params.get("userId").toString();
            String sql = "";
            StringBuffer sb = new StringBuffer();
            String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
            sql = isManageOrgControl.equals("true") ? FormatUtils.list2Sql(this.getUserByAdminBizAndOrg(ctx, adminId)) : FormatUtils.list2Sql(this.getBizByAdmin(ctx, adminId));
            sql = StringUtils.isEmpty((String)sql) ? "('')" : sql;
            sb.append(" SELECT sum(case when fdimission=1 then 1 else 0 end) working,");
            sb.append(" sum(case when fdimission=0 then 1 else 0 end) leave");
            sb.append(" FROM t_ssc_user");
            sb.append(" where fid in" + sql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            logger.error((Object)("sql:" + sb.toString()));
            if (rs.next()) {
                result.put("working", rs.getString(1));
                result.put("leave", rs.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected Map _getPendingTask(Context ctx, Map params) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String userId = params.get("userId").toString();
        Float hourOfWorkDate = Float.valueOf(8.0f);
        try {
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            String shareCenterID = userInfo.getShareCenterId();
            String workDateOrgID = ShareCenterUtils.getEntrustOrgIDByShareCenterID(ctx, shareCenterID);
            StringBuffer sb = new StringBuffer();
            sb.append(" select fhourOfWorkDate");
            sb.append(" from T_WorkCalendar");
            sb.append(" where FOrgUnitID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{workDateOrgID});
            while (rs.next()) {
                hourOfWorkDate = Float.valueOf(rs.getFloat(1));
            }
            String sql = FormatUtils.list2Sql(this.getBizByAdmin(ctx, userId));
            String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
            String orgSql = "";
            if (isManageOrgControl.equals("true")) {
                orgSql = " inner join ( " + this.getOrgBussSqlByUserIdInnerJoin(ctx, userId) + " ) temp on t_ssc_job.FBUSSATTRIDID = temp.bussid and t_ssc_job.forgidid = temp.orgid ";
            }
            sql = StringUtils.isEmpty((String)sql) ? "('')" : sql;
            sb = new StringBuffer();
            sb.append(" SELECT sum(case when FCOSTWORKTIME <=" + hourOfWorkDate + " then 1 else 0 end) withinOneDay,");
            sb.append(" sum(case when FCOSTWORKTIME <=" + 2.0f * hourOfWorkDate.floatValue() + " then 1 else 0 end) withinTwoDay,");
            sb.append(" sum(case when FCOSTWORKTIME <=" + 3.0f * hourOfWorkDate.floatValue() + " then 1 else 0 end) withinThreeDay,");
            sb.append(" sum(case when FCOSTWORKTIME >" + 3.0f * hourOfWorkDate.floatValue() + " then 1 else 0 end) beyondThreeDay");
            sb.append(" FROM T_ssc_job");
            sb.append(orgSql);
            sb.append(" where FPERSONNELIDID in" + sql);
            sb.append(" and fshareCenterId = '" + shareCenterID + "' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            logger.error((Object)("sql:" + sb.toString()));
            while (rs.next()) {
                result.put("withinOneDay", rs.getInt(1));
                result.put("withinTwoDay", rs.getInt(2));
                result.put("withinThreeDay", rs.getInt(3));
                result.put("beyondThreeDay", rs.getInt(4));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        long endTime = System.currentTimeMillis();
        return result;
    }

    private int getUserCompeletTarget(Context ctx, Map params) throws BOSException, EASBizException {
        try {
            Map tempReuslt;
            String curDay = DateUtil.getCurDayDate();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT count(1) completed FROM T_ssc_jobhis");
            sql.append(" where FPERSONNELIDID = ?");
            sql.append(" and fautoApprove=0 ");
            sql.append(" and FCOMPLETETME >= {ts'" + curDay + "'}");
            int completed = 0;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{params.get("userId").toString()});
            if (rowSet.next()) {
                completed = rowSet.getInt(1);
            }
            if ((tempReuslt = (Map)params.get(BizTaskHome.pTempRs)) != null) {
                tempReuslt.put(BizTaskHome.pComplete, completed);
            }
            int workload = 0;
            UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + params.get("userId").toString() + "'and isDefaultGroup='1'");
            if (userGroupInfo != null && userGroupInfo.getGroup() != null) {
                workload = userGroupInfo.getGroup().getWorkload();
            }
            return workload == 0 ? -1 : (completed - workload >= 0 ? 1 : 0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return 0;
    }

    @Override
    protected Map _getExceptionTask(Context ctx, Map params) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String userId = params.get("userId").toString();
        try {
            String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            String sql = FormatUtils.list2Sql(this.getBizByAdmin(ctx, userId));
            sql = StringUtils.isEmpty((String)sql) ? "('')" : sql;
            List<String> biz = this.getBizBussByAdmin(ctx, userId);
            String bizBussByAdmin = "('')";
            if (biz != null && !biz.isEmpty()) {
                bizBussByAdmin = FormatUtils.list2Sql(biz);
            }
            String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
            String orgSql = "";
            if (isManageOrgControl.equals("true")) {
                orgSql = " inner join ( " + this.getOrgBussSqlByUserIdInnerJoin(ctx, userId) + " ) temp on t_ssc_job.FBUSSATTRIDID = temp.bussid and t_ssc_job.forgidid = temp.orgid ";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT count(1) total,");
            sb.append(" sum(case when FJOBSTATE = '0' then 1 else 0 end) pause,");
            sb.append(" sum(case when FJOBSTATE = '1' then 1 else 0 end) reScan,");
            sb.append(" sum(case when FJOBSTATE = '7' then 1 else 0 end) reUpLoad");
            sb.append(" FROM T_ssc_job");
            sb.append(orgSql);
            sb.append(" where fjobpoolingtype='2'");
            sb.append(" and fautoApprove='0'");
            sb.append(" and FPERSONNELIDID in" + sql);
            sb.append(" and fshareCenterId = '" + shareCenterId + "'");
            sb.append(" and FBussAttrIDID in" + bizBussByAdmin);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            logger.error((Object)("sql:" + sb.toString()));
            while (rs.next()) {
                result.put("total", rs.getInt(1));
                result.put("pause", rs.getInt(2));
                result.put("reScan", rs.getInt(3));
                result.put("reUpLoad", rs.getInt(4));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        long endTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected Map _getTaskManageDate(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        String userId = params.get("userId").toString();
        try {
            String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            List buss = this.getBizByAdmin(ctx, userId);
            String bizByAdmin = "('')";
            if (buss != null && !buss.isEmpty()) {
                bizByAdmin = FormatUtils.list2Sql(buss);
            }
            List<String> biz = this.getBizBussByAdmin(ctx, userId);
            String bizBussByAdmin = "('')";
            if (biz != null && !biz.isEmpty()) {
                bizBussByAdmin = FormatUtils.list2Sql(biz);
            }
            String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
            String orgSql = "";
            if (isManageOrgControl.equals("true")) {
                orgSql = " inner join ( " + this.getOrgBussSqlByUserIdInnerJoin(ctx, userId) + " ) temp on t_ssc_job.FBUSSATTRIDID = temp.bussid and t_ssc_job.forgidid = temp.orgid ";
            }
            map.putAll(this.getDealNum(ctx, bizBussByAdmin, shareCenterId, isManageOrgControl, userId));
            map.putAll(this.getCurDayCompleteNum(ctx, orgSql, bizBussByAdmin, shareCenterId));
            map.putAll(this.getToAssignNum(ctx, orgSql, bizBussByAdmin, shareCenterId));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map getDealNum(Context ctx, String bizBussByAdmin, String shareCenterId, String isManageOrgControl, String userId) throws SQLException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT sum(case when fjobpoolingtype='2' then 1 else 0 end) deal,");
        sql.append(" sum(case when fjobpoolingtype='2' and fexpirestate=1 then 1 else 0 end) expired");
        sql.append(" FROM T_ssc_job JOB");
        if (isManageOrgControl.equals("true")) {
            sql.append(" LEFT OUTER JOIN V_SSC_UserAdminBussAttrOrg AS UABAO ON JOB.FBussAttrIDID = UABAO.FBussAttrId AND JOB.FOrgIDID = UABAO.FOrgId");
            sql.append(" where JOB.fautoApprove='0'");
            sql.append(" and JOB.FshareCenterId = '" + shareCenterId + "' ");
            sql.append(" and UABAO.FUSERID = '" + userId + "'");
        } else {
            sql.append(" where JOB.fautoApprove='0'");
            sql.append(" and JOB.FshareCenterId = '" + shareCenterId + "' ");
            sql.append(" and JOB.FBussAttrIDID in" + bizBussByAdmin);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.next()) {
            map.put("deal", rowSet.getString("deal"));
            map.put("expired", rowSet.getString("expired"));
        }
        return map;
    }

    private Map getCurDayCompleteNum(Context ctx, String orgSql, String bizBussByAdmin, String shareCenterId) throws SQLException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String curDay = DateUtil.getCurDayDate();
        StringBuilder sql2 = new StringBuilder();
        sql2.append(" SELECT count(1) completed FROM T_ssc_jobhis");
        sql2.append(orgSql);
        sql2.append(" where FCOMPLETETME >= {ts'" + curDay + "'}");
        sql2.append(" and FBussAttrIDID in" + bizBussByAdmin);
        sql2.append(" and FshareCenterId = '" + shareCenterId + "' ");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString().replace("t_ssc_job", "t_ssc_jobhis"));
        if (rowSet2.next()) {
            map.put("completed", rowSet2.getString("completed"));
        }
        return map;
    }

    private Map getToAssignNum(Context ctx, String orgSql, String bizBussByAdmin, String shareCenterId) throws SQLException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sql3 = new StringBuilder();
        sql3.append(" SELECT ");
        sql3.append(" sum(case when fjobpoolingtype='1' then 1 else 0 end) pending");
        sql3.append(" FROM T_ssc_job");
        sql3.append(orgSql);
        sql3.append(" where fautoApprove='0'");
        sql3.append(" and FBussAttrIDID in" + bizBussByAdmin);
        sql3.append(" and (FshareCenterId = '" + shareCenterId + "' or FshareCenterId is null ) ");
        IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)sql3.toString());
        if (rowSet3.next()) {
            map.put("pending", rowSet3.getString("pending"));
        }
        return map;
    }

    private List<String> getBizBussByAdmin(Context ctx, String adminId) {
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct bs.FID ");
            sb.append("    from t_ssc_user users ");
            sb.append("   inner join T_SSC_ROLEUSER ru ");
            sb.append("      on users.fid = ru.FUSERIDID ");
            sb.append("   inner join T_SSC_ROLE role ");
            sb.append("      on role.fid = ru.FROLEIDID ");
            sb.append("   inner join T_SSC_ROLETYPE ty ");
            sb.append("      on ty.fid = role.FROLETYPEIDID ");
            sb.append("   inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("      on rb.FPARENTID = role.FID ");
            sb.append("   inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("      on bs.fid = rb.FBUSSNAMEID ");
            sb.append("   where users.FID = ? ");
            sb.append("     and ty.FID = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{adminId});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return bizList;
    }

    private List<String> getOrgIdByAdmin(Context ctx, String adminId) {
        ArrayList<String> orgList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct ro.FORGIDID from t_ssc_user users ");
            sb.append(" inner join T_SSC_ROLEUSER ru on users.fid = ru.FUSERIDID ");
            sb.append(" inner join T_SSC_ROLE role  on role.fid = ru.FROLEIDID ");
            sb.append(" inner join T_SSC_RoleType c on c.FID = role.FROLETYPEIDID ");
            sb.append(" inner join T_SSC_ROLEOrg ro on ru.FROLEIDID = ro.FROLEIDID  ");
            sb.append(" where users.FID = ?  and c.fid = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{adminId});
            while (rs.next()) {
                orgList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return orgList;
    }

    private String getOrgBussSqlByUserIdExists(Context ctx, String userId) {
        String sql = "select 1 from ( SELECT ORG.FID orgid, BUSSINESSATTRIBUTE.FID bussid FROM T_SSC_Org ORG  LEFT OUTER JOIN T_SSC_RoleOrg ROLEORG ON ORG.FID = ROLEORG.FOrgIDID  LEFT OUTER JOIN (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid ) tem ON ROLEORG.FRoleIDID = tem.FID LEFT OUTER JOIN T_SSC_RoleUser  ROLEUSER ON tem.FID = ROLEUSER.FRoleIDID  LEFT OUTER JOIN T_SSC_BussinessAttribute  BUSSINESSATTRIBUTE ON tem.fbussnameid = BUSSINESSATTRIBUTE.FID LEFT OUTER JOIN T_SSC_User u ON ROLEUSER.FUserIDID = u.FID  where u.FID='" + userId + "' and tem.froletypeidid='hEw8bwRNR8qPRPajcUdX4C0WZ4A=' ) temp where t_ssc_job.FBUSSATTRIDID = temp.bussid and t_ssc_job.forgidid = temp.orgid";
        return sql;
    }

    private String getOrgBussSqlByUserIdInnerJoin(Context ctx, String userId) {
        String sql = "select fbussattrid bussid,forgid orgid from V_SSC_UserAdminBussAttrOrg where fuserid = '" + userId + "' and fbussattrid is not null and forgid is not null ";
        return sql;
    }

    @Override
    protected Map _getTaskManageAllDate(Context ctx, Map params) throws BOSException, EASBizException {
        Map map = new HashMap();
        String isManageOrgControl = ParamManager.getParamValue((Context)ctx, null, (String)"SSC_ManagerOrgControl");
        map = isManageOrgControl.equals("true") ? this.futureGetData(ctx, params) : this.normalGetData(ctx, params);
        return map;
    }

    private Map futureGetData(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Map> map = new HashMap<String, Map>();
        try {
            Class<?> TaskHomeClass = Class.forName("com.kingdee.eas.base.ssc.app.TaskHomeFacadeControllerBean");
            Object owner = TaskHomeClass.newInstance();
            Object[] args = new Object[]{ctx, params};
            Future<Map> ft2 = executorService.submit(new QueryDataCallable(owner, "_getPendingTask", args));
            Future<Map> ft3 = executorService.submit(new QueryDataCallable(owner, "_getExceptionTask", args));
            Future<Map> ft4 = executorService.submit(new QueryDataCallable(owner, "_getEfficiencyRankTopAndLast5", args));
            Future<Map> ft5 = executorService.submit(new QueryDataCallable(owner, "_getUserDimission", args));
            String userId = params.get("userId").toString();
            String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            List buss = this.getBizByAdmin(ctx, userId);
            String bizByAdmin = "('')";
            if (buss != null && !buss.isEmpty()) {
                bizByAdmin = FormatUtils.list2Sql(buss);
            }
            List<String> biz = this.getBizBussByAdmin(ctx, userId);
            String bizBussByAdmin = "('')";
            if (biz != null && !biz.isEmpty()) {
                bizBussByAdmin = FormatUtils.list2Sql(biz);
            }
            String orgSql = " inner join ( " + this.getOrgBussSqlByUserIdInnerJoin(ctx, userId) + " ) temp on t_ssc_job.FBUSSATTRIDID = temp.bussid and t_ssc_job.forgidid = temp.orgid ";
            args = new Object[]{ctx, bizBussByAdmin, shareCenterId, "true", userId};
            Future<Map> ft1 = executorService.submit(new QueryDataCallable(owner, "getDealNum", args));
            args = new Object[]{ctx, orgSql, bizBussByAdmin, shareCenterId};
            Future<Map> ft6 = executorService.submit(new QueryDataCallable(owner, "getCurDayCompleteNum", args));
            Future<Map> ft7 = executorService.submit(new QueryDataCallable(owner, "getToAssignNum", args));
            HashMap taskMap = new HashMap();
            taskMap.putAll(this.handleFuture(ft1));
            taskMap.putAll(this.handleFuture(ft6));
            taskMap.putAll(this.handleFuture(ft7));
            map.put("taskManageDate", taskMap);
            map.put("pendingTask", this.handleFuture(ft2));
            map.put("exceptionTask", this.handleFuture(ft3));
            map.put("efficiencyRankTopAndLast5", this.handleFuture(ft4));
            map.put("userDimission", this.handleFuture(ft5));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return map;
    }

    private Map handleFuture(Future<Map> f) {
        try {
            return f.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            f.cancel(true);
        }
        catch (ExecutionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            f.cancel(true);
        }
        catch (TimeoutException e) {
            logger.error((Object)("\u67e5\u8be2\u8d85\u65f6\uff1a" + e.getMessage()), (Throwable)e);
            f.cancel(true);
        }
        return new HashMap();
    }

    private Map normalGetData(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("taskManageDate", this._getTaskManageDate(ctx, params));
        map.put("pendingTask", this._getPendingTask(ctx, params));
        map.put("exceptionTask", this._getExceptionTask(ctx, params));
        map.put("efficiencyRankTopAndLast5", this._getEfficiencyRankTopAndLast5(ctx, params));
        map.put("userDimission", this._getUserDimission(ctx, params));
        return map;
    }

    private List getBizByAdmin(Context ctx, String adminId) throws EASBizException {
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("  select distinct users.FID id ");
            sb.append("    from t_ssc_user users ");
            sb.append("   inner join T_SSC_ROLEUSER ru ");
            sb.append("      on users.fid = ru.FUSERIDID ");
            sb.append("   inner join T_SSC_ROLE role ");
            sb.append("      on role.fid = ru.FROLEIDID ");
            sb.append("   inner join T_SSC_ROLETYPE ty ");
            sb.append("      on ty.fid = role.FROLETYPEIDID ");
            sb.append("   inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("      on rb.FPARENTID = role.FID ");
            sb.append("   inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("      on bs.fid = rb.FBUSSNAMEID ");
            sb.append("   where users.FSHARECENTERID = ? ");
            sb.append("     and ty.FID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' ");
            sb.append("     and bs.FID in ");
            sb.append("         (select distinct bs.FID ");
            sb.append("            from t_ssc_user users ");
            sb.append("           inner join T_SSC_ROLEUSER ru ");
            sb.append("              on users.fid = ru.FUSERIDID ");
            sb.append("           inner join T_SSC_ROLE role ");
            sb.append("              on role.fid = ru.FROLEIDID ");
            sb.append("           inner join T_SSC_ROLETYPE ty ");
            sb.append("              on ty.fid = role.FROLETYPEIDID ");
            sb.append("           inner join T_SSC_ROLEBUSSATTR rb ");
            sb.append("              on rb.FPARENTID = role.FID ");
            sb.append("           inner join T_SSC_BUSSINESSATTRIBUTE bs ");
            sb.append("              on bs.fid = rb.FBUSSNAMEID ");
            sb.append("          where users.FID = ? ");
            sb.append("            and ty.FID = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=') ");
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(adminId));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userInfo.getShareCenterId(), adminId});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return bizList;
    }

    private List getUserByAdminBizAndOrg(Context ctx, String adminId) throws EASBizException {
        ArrayList<String> bizList = new ArrayList<String>();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select distinct a.FID from t_ssc_user a ");
            sb.append("inner join T_SSC_ROLEUSER b on a.FID = b.FUSERIDID ");
            sb.append("inner join T_SSC_ROLE role  on role.fid = b.FROLEIDID ");
            sb.append("inner join T_SSC_RoleType c on c.FID = role.FROLETYPEIDID ");
            sb.append("inner join t_ssc_roleorg d on b.FROLEIDID = d.FROLEIDID ");
            sb.append("inner join T_SSC_ROLEBUSSATTR rb on rb.FPARENTID = role.FID  ");
            sb.append("where c.fid = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A=' and role.FNUMBER NOT LIKE '%addForCompel%' and a.FSHARECENTERID = ? ");
            sb.append("and exists ( ");
            sb.append("select 1 from ( ");
            sb.append("select  rb.FBUSSNAMEID,d.FORGIDID  from t_ssc_user a ");
            sb.append("inner join T_SSC_ROLEUSER b on a.FID = b.FUSERIDID ");
            sb.append("inner join T_SSC_ROLE role  on role.fid = b.FROLEIDID ");
            sb.append("inner join T_SSC_RoleType c on c.FID = role.FROLETYPEIDID ");
            sb.append("inner join t_ssc_roleorg d on b.FROLEIDID = d.FROLEIDID ");
            sb.append("inner join T_SSC_ROLEBUSSATTR rb on rb.FPARENTID = role.FID  ");
            sb.append("where a.fid = ? and c.fid = 'hEw8bwRNR8qPRPajcUdX4C0WZ4A=' and role.FNUMBER NOT LIKE '%addForCompel%'  and a.FSHARECENTERID = ? ");
            sb.append(") temp where rb.FBUSSNAMEID = temp.FBUSSNAMEID  and d.FORGIDID = temp.FORGIDID ");
            sb.append(") ");
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(adminId));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userInfo.getShareCenterId(), adminId, userInfo.getShareCenterId()});
            while (rs.next()) {
                bizList.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return bizList;
    }

    @Override
    protected Map _getTaskAllDate(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap tempResult = new HashMap();
        params.put(BizTaskHome.pTempRs, tempResult);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isReachStandard", this.getUserCompeletTarget(ctx, params));
        try {
            Class<?> TaskHomeClass = Class.forName("com.kingdee.eas.base.ssc.app.TaskHomeFacadeControllerBean");
            Object owner = TaskHomeClass.newInstance();
            Object[] args = new Object[]{ctx, params};
            Future<Map> ft1 = executorService.submit(new QueryDataCallable(owner, "_getTaskDate", args));
            Future<Map> ft2 = executorService.submit(new QueryDataCallable(owner, "getCurMonthQuality0", args));
            Future<Map> ft3 = executorService.submit(new QueryDataCallable(owner, "getCurMonthQuality1", args));
            Future<Map> ft6 = executorService.submit(new QueryDataCallable(owner, "_getEfficiencyRank", args));
            args = new Object[]{ctx, params.get("userId").toString()};
            Future<Map> ft4 = executorService.submit(new QueryDataCallable(owner, "getEfficiency0", args));
            Future<Map> ft5 = executorService.submit(new QueryDataCallable(owner, "getAvgAndMaxNum", args));
            Map ft2Map = this.handleFuture(ft2);
            ft2Map.putAll(this.handleFuture(ft3));
            Map ft4Map = this.handleFuture(ft4);
            ft4Map.putAll(this.handleFuture(ft5));
            result.put("taskDate", this.handleFuture(ft1));
            result.put("curMonthQualityDate", ft2Map);
            result.put("efficiencyDate", ft4Map);
            result.put("efficiencyRankDate", this.handleFuture(ft6));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return result;
    }

    static class BizTaskHome {
        public static String pTempRs = "PTEMPRS";
        public static String pComplete = "PCOMPLETE";

        BizTaskHome() {
        }
    }
}

