/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.RunkUser;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SysParamMgerInfo;
import com.kingdee.eas.base.ssc.UserGroupCollection;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.app.AbstractTaskReportFacadeControllerBean;
import com.kingdee.eas.base.ssc.common.FormatUtil;
import com.kingdee.eas.base.ssc.report.RptConstant;
import com.kingdee.eas.base.ssc.shr.bean.RealDataFetcher;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.base.ssc.tool.ParamCheckUtil;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.base.ssc.tool.SSCStringUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterPermissionOrgUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.TaskReportUtil;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TaskReportFacadeControllerBean
extends AbstractTaskReportFacadeControllerBean {
    private static final long serialVersionUID = -9010836319445992272L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.TaskReportFacadeControllerBean");

    @Override
    protected String _getRunkData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startIndex = (String)solutionMap.get("startIndex");
        startIndex = startIndex == null ? "0" : startIndex;
        String rowCount = (String)solutionMap.get("rowCount");
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = null;
        try {
            sql = TaskReportUtil.getRunkDataSql(ctx, solutionMap);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        List<Object> runkList = new ArrayList();
        List<RunkUser> dataList = this.getEndRunkList(ctx, this.getList(ctx, rowSet), solutionMap);
        if (isAll) {
            runkList = dataList;
        } else {
            int index = Integer.parseInt(startIndex);
            int row = Integer.parseInt(rowCount);
            for (int i = Integer.parseInt(startIndex); i < index + row && dataList != null && i < dataList.size(); ++i) {
                runkList.add(dataList.get(i));
            }
        }
        int totalCount = 0;
        if (dataList != null) {
            totalCount = dataList.size();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", runkList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getUserRunk(Context ctx, String solution) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solution);
        String shareCenterID = (String)solutionMap.get("shareCenter.id");
        if (!"isReport".equalsIgnoreCase((String)solutionMap.get("isReport")) && StringUtils.isEmpty((String)shareCenterID)) {
            try {
                shareCenterID = ShareCenterUtils.getShareCenterIdByCtx(ctx);
            }
            catch (SSCException e) {
                throw new BOSException((Throwable)((Object)e));
            }
            solutionMap.put("shareCenter.id", shareCenterID);
        }
        String dealer = (String)solutionMap.get("dealer");
        String sql = null;
        try {
            sql = TaskReportUtil.getRunkDataSql(ctx, solutionMap);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int size = 0;
        List<RunkUser> dataList = this.getEndRunkList(ctx, this.getList(ctx, rowSet), solutionMap);
        logger.error((Object)("\u4e2a\u4eba\u4efb\u52a1\u6392\u540d\u8868" + JSONUtils.convertObjectToJson((Context)ctx, dataList)));
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                String _userid = dataList.get(i).getUserid();
                map.put(_userid, ++size);
            }
        }
        if (map.containsKey(dealer)) {
            return map.get(dealer).toString();
        }
        return "\u65e0";
    }

    @Override
    protected String _getRunkChartsData(Context ctx, String solution) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solution);
        String sql = null;
        try {
            sql = TaskReportUtil.getRunkDataSql(ctx, solutionMap);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        List<RunkUser> dataList = this.getEndRunkList(ctx, this.getList(ctx, rowSet), solutionMap);
        logger.error((Object)("\u4e2a\u4eba\u4efb\u52a1\u6392\u540d\u8868" + JSONUtils.convertObjectToJson((Context)ctx, dataList)));
        return JSONUtils.convertObjectToJson((Context)ctx, dataList);
    }

    private List getList(Context ctx, IRowSet rowSet) {
        ArrayList runkList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userid", rowSet.getString("userid"));
                map.put("username", rowSet.getString("username"));
                map.put("userno", rowSet.getString("userno"));
                map.put("tasksum", rowSet.getString("tasksum"));
                map.put("timelong", rowSet.getString("timelong"));
                runkList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return runkList;
    }

    @Override
    protected String _getOnGuradTimeData(Context ctx, String params) throws BOSException, EASBizException {
        HashMap paramsMap = JSONUtils.convertJsonToObject((Context)ctx, (String)params);
        String filterItems = (String)paramsMap.get("filterItems");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.ssc.app.OnGuardTimeQuery"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int datefirst = filterItems.indexOf("date");
        int rightdatebegin = filterItems.indexOf("right", datefirst);
        String beginDate = filterItems.substring(rightdatebegin + 8, rightdatebegin + 18);
        datefirst = filterItems.indexOf("date", datefirst + 4);
        rightdatebegin = filterItems.indexOf("right", datefirst);
        String endDate = filterItems.substring(rightdatebegin + 8, rightdatebegin + 18);
        int groupBegin = filterItems.indexOf("group.id");
        StringBuffer groupids = new StringBuffer();
        while (groupBegin > 0) {
            int rightGropBegin = filterItems.indexOf("right", groupBegin);
            int rightGropEnd = filterItems.indexOf("}", groupBegin);
            String groupid = filterItems.substring(rightGropBegin + 8, rightGropEnd - 1);
            groupids.append("'").append(groupid).append("'").append(",");
            groupBegin = filterItems.indexOf("group.id", rightGropEnd);
        }
        int userBegin = filterItems.indexOf("user.id");
        StringBuffer userids = new StringBuffer();
        while (userBegin > 0) {
            int rightGropBegin = filterItems.indexOf("right", userBegin);
            int rightGropEnd = filterItems.indexOf("}", userBegin);
            String groupid = filterItems.substring(rightGropBegin + 8, rightGropEnd - 1);
            userids.append("'").append(groupid).append("'").append(",");
            userBegin = filterItems.indexOf("user.id", rightGropEnd);
        }
        int shareCenterBegin = filterItems.indexOf("user.shareCenterId");
        StringBuffer shareCenterids = new StringBuffer();
        while (shareCenterBegin > 0) {
            int rightGropBegin = filterItems.indexOf("right", shareCenterBegin);
            int rightGropEnd = filterItems.indexOf("}", shareCenterBegin);
            String groupid = filterItems.substring(rightGropBegin + 8, rightGropEnd - 1);
            shareCenterids.append("'").append(groupid).append("'").append(",");
            shareCenterBegin = filterItems.indexOf("user.shareCenterId", rightGropEnd);
        }
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS_EQUALS));
        String groupid = "";
        if (groupids.length() > 0) {
            groupid = groupids.deleteCharAt(groupids.length() - 1).toString();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupid, CompareType.INNER));
        }
        if (userids.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userids.deleteCharAt(userids.length() - 1).toString(), CompareType.INNER));
        }
        String sharecenters = "";
        if (shareCenterids.length() > 0 && shareCenterids.indexOf("\"") > 0) {
            sharecenters = shareCenterids.toString().substring(1, shareCenterids.length() - 2);
            sharecenters = sharecenters.replaceAll("\"", "'");
            filter.getFilterItems().add(new FilterItemInfo("user.shareCenterId", (Object)sharecenters, CompareType.INNER));
        } else if (shareCenterids.length() > 0) {
            sharecenters = shareCenterids.deleteCharAt(shareCenterids.length() - 1).toString();
            filter.getFilterItems().add(new FilterItemInfo("user.shareCenterId", (Object)sharecenters, CompareType.INNER));
        }
        view.setFilter(filter);
        exec.setObjectView(view);
        RealDataFetcher currentRdf = RealDataFetcher.createInstance(exec, 0, 1000);
        List currentList = currentRdf.getData();
        for (int i = 0; i < currentList.size(); ++i) {
            Object o = currentList.get(i);
            Map info = (Map)o;
            if (info.get("group.name") == null) {
                info.put("group.name", "");
            }
            info.put("hours", ((BigDecimal)info.get("hours")).setScale(2, RoundingMode.HALF_UP));
            info.put("overTimeHours", ((BigDecimal)info.get("overTimeHours")).setScale(2, RoundingMode.HALF_UP));
            info.put("workHours", ((BigDecimal)info.get("workHours")).setScale(2, RoundingMode.HALF_UP));
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("rows", currentList);
        return JSONUtils.convertObjectToJson((Context)ctx, map);
    }

    private List<RunkUser> getEndRunkList(Context ctx, List<Map<String, String>> runkList, Map solutionMap) {
        int size = runkList.size();
        if (size > 0) {
            ArrayList<RunkUser> list = new ArrayList<RunkUser>();
            for (int i = 0; i < runkList.size(); ++i) {
                RunkUser runkUser = new RunkUser();
                Map<String, String> map = runkList.get(i);
                runkUser.setUserid(map.get("userid"));
                runkUser.setUsername(map.get("username"));
                runkUser.setUserno(map.get("userno"));
                float tasksum = Float.parseFloat(map.get("tasksum"));
                runkUser.setTasksum(tasksum);
                float timelong = Float.parseFloat(map.get("timelong"));
                runkUser.setTimelong(timelong);
                float effe1 = timelong > 0.0f ? tasksum / timelong : 0.0f;
                BigDecimal b = new BigDecimal(effe1);
                float effe2 = b.setScale(2, 4).floatValue();
                runkUser.setEffe(effe2);
                runkUser.setTaskScore(new BigDecimal(100.0 / (double)size * (double)(size - i - 1 + 1)).setScale(2, 4).floatValue());
                runkUser.setTaskrunk(i + 1);
                list.add(runkUser);
            }
            float jobCount = 0.7f;
            float efficiency = 0.3f;
            String permissionId = (String)solutionMap.get("permissionId");
            String EASUserId = (String)solutionMap.get("EASUserId");
            List<String> shareCenterList = this.isOneShareCenter(ctx, EASUserId, permissionId);
            if (shareCenterList.size() == 1) {
                solutionMap.put("shareCenter.id", shareCenterList.get(0));
            }
            if (!StringUtils.isEmpty((String)((String)solutionMap.get("shareCenter.id")))) {
                try {
                    String shareCenterId = (String)solutionMap.get("shareCenter.id");
                    SysParamMgerInfo sysInfo = ShareCenterUtils.getSysParamMgerInfo(ctx, shareCenterId);
                    jobCount = (float)sysInfo.getJobCount() / 100.0f;
                    efficiency = (float)sysInfo.getEfficiency() / 100.0f;
                }
                catch (Exception shareCenterId) {
                    // empty catch block
                }
            }
            List<RunkUser> effeList = this.mySortEffe(list);
            for (int i = 0; i < effeList.size(); ++i) {
                RunkUser runkUser = effeList.get(i);
                runkUser.setEffeScore(new BigDecimal(100.0 / (double)size * (double)(size - i - 1 + 1)).setScale(2, 4).floatValue());
                runkUser.setEfferunk(i + 1);
                float runk1 = runkUser.getTaskScore() * jobCount + runkUser.getEffeScore() * efficiency;
                BigDecimal b = new BigDecimal(runk1);
                float runk2 = b.setScale(2, 4).floatValue();
                runkUser.setScore(runk2);
            }
            List<RunkUser> scoreList = this.myScoreEffe(list);
            for (int i = 0; i < scoreList.size(); ++i) {
                RunkUser runkUser = scoreList.get(i);
                runkUser.setRunk(i + 1);
            }
            String runk = solutionMap.get("runk") + "";
            if (!StringUtils.isEmpty((String)runk) && runk.startsWith("top")) {
                int returnSize = runk.equals("top10") ? 10 : 20;
                returnSize = Math.min(scoreList.size(), returnSize);
                scoreList = scoreList.subList(0, returnSize);
            }
            return scoreList;
        }
        ArrayList<RunkUser> l = new ArrayList<RunkUser>();
        return l;
    }

    private List<String> isOneShareCenter(Context ctx, String EASUserId, String permissionId) {
        ArrayList<String> shareCenterList = new ArrayList();
        try {
            shareCenterList = ShareCenterPermissionOrgUtil.getShareCenter(ctx, EASUserId, permissionId);
        }
        catch (BOSException e1) {
            logger.error((Object)"\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\u5931\u8d25");
        }
        return shareCenterList;
    }

    private List<RunkUser> myScoreEffe(List<RunkUser> arr) {
        RunkUser temp = null;
        boolean exchange = false;
        for (int i = 0; i < arr.size(); ++i) {
            exchange = false;
            for (int j = arr.size() - 2; j >= i; --j) {
                if (!(arr.get(j + 1).getScore() > arr.get(j).getScore())) continue;
                temp = arr.get(j + 1);
                arr.set(j + 1, arr.get(j));
                arr.set(j, temp);
                exchange = true;
            }
            if (!exchange) break;
        }
        return arr;
    }

    private List<RunkUser> mySortEffe(List<RunkUser> arr) {
        RunkUser temp = null;
        boolean exchange = false;
        for (int i = 0; i < arr.size(); ++i) {
            exchange = false;
            for (int j = arr.size() - 2; j >= i; --j) {
                if (!(arr.get(j + 1).getEffe() > arr.get(j).getEffe())) continue;
                temp = arr.get(j + 1);
                arr.set(j + 1, arr.get(j));
                arr.set(j, temp);
                exchange = true;
            }
            if (!exchange) break;
        }
        return arr;
    }

    @Override
    protected String _getBizData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String shareCenterID = null;
        try {
            shareCenterID = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        solutionMap.put("shareCenter.id", shareCenterID);
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = TaskReportUtil.getBizSelectSql(ctx, solutionMap) + TaskReportUtil.getBizFromSql(solutionMap) + TaskReportUtil.getBizWhereSql(solutionMap) + TaskReportUtil.getBizGroupBySql(solutionMap) + TaskReportUtil.getOrderBySql(solutionMap);
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        } else {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql));
        }
        ArrayList bizList = new ArrayList();
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (stat_dimension.indexOf("showBizType") > -1) {
                    map.put("bizType", rowSet.getString("bizType"));
                    map.put("bizTypeId", rowSet.getString("bizTypeId"));
                }
                if (stat_dimension.indexOf("showOrgName") > -1) {
                    map.put("orgname", rowSet.getString("orgname"));
                    map.put("orgId", rowSet.getString("orgId"));
                }
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("timely", StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0"));
                map.put("tasksum", rowSet.getString("tasksum"));
                bizList.add(map);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getBizChartsData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String shareCenterID = null;
        try {
            shareCenterID = ShareCenterUtils.getShareCenterIdByCtx(ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        solutionMap.put("shareCenter.id", shareCenterID);
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String sql = TaskReportUtil.getBizSelectSql(ctx, solutionMap) + TaskReportUtil.getBizFromSql(solutionMap) + TaskReportUtil.getBizWhereSql(solutionMap) + TaskReportUtil.getBizGroupBySql(solutionMap) + TaskReportUtil.getBizOrderbySql(solutionMap);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(RptConstant.PERIOD_BYYEAR, rowSet.getString(RptConstant.PERIOD_BYYEAR));
                map.put(RptConstant.PERIOD_BYMONTH, rowSet.getString(RptConstant.PERIOD_BYMONTH));
                if (period.equals(RptConstant.PERIOD_BYDAY)) {
                    map.put(RptConstant.PERIOD_BYDAY, rowSet.getString(RptConstant.PERIOD_BYDAY));
                }
                String expired = StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0");
                String timely = StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0");
                map.put("expired", expired);
                map.put("timely", timely);
                map.put("bizType", rowSet.getString("bizType"));
                map.put("orgname", rowSet.getString("orgname"));
                map.put("tasksum", rowSet.getString("tasksum"));
                map.put("timelong", rowSet.getString("timelong"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getBizDetailData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = TaskReportUtil.getBizSelectSql(ctx, solutionMap) + TaskReportUtil.getBizFromSql(solutionMap) + TaskReportUtil.getBizWhereSql(solutionMap) + TaskReportUtil.getBizGroupBySql(solutionMap) + TaskReportUtil.getOrderBySql(solutionMap);
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        } else {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql));
        }
        ArrayList bizList = new ArrayList();
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("username", rowSet.getString("username"));
                map.put("userno", rowSet.getString("userno"));
                map.put("bizType", rowSet.getString("bizType"));
                map.put("orgname", rowSet.getString("orgname"));
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("timely", StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0"));
                map.put("tasksum", rowSet.getString("tasksum"));
                bizList.add(map);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getBizOrgData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String userid = (String)solutionMap.get("userid");
        String roleType = (String)solutionMap.get("roleType");
        String sql = TaskReportUtil.getBizOrgSql(userid, roleType);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("orgName", rowSet.getString("orgName"));
                map.put("orgId", rowSet.getString("orgId"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getBizTypeData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String userid = (String)solutionMap.get("userid");
        String sql = TaskReportUtil.getBizTypeAllSql(userid);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bizTypeId", rowSet.getString("bizTypeId"));
                map.put("bizType", rowSet.getString("bizType"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getBizTypeAndRoleType(Context ctx, String userId) throws BOSException {
        String sql = TaskReportUtil.getBizTypeAndRoleTypeSql(userId);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bizTypeId", rowSet.getString("bizTypeId"));
                map.put("bizType", rowSet.getString("bizType"));
                map.put("roleTypeId", rowSet.getString("roleTypeId"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getRoleType(Context ctx, String userId) throws BOSException {
        String sql = TaskReportUtil.getRoleTypeSql(userId);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        String roleType = "hEw8bwRNR8qPRPajcUdX4C0WZ4A=";
        try {
            if (rowSet.size() == 2) {
                roleType = RptConstant.Role_TYPE_BIZ_AND_ADMIN;
                return roleType;
            }
            while (rowSet.next()) {
                roleType = rowSet.getString("roleTypeId");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return roleType;
    }

    @Override
    protected String _getTaskProData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        String sqlNew = this.getTaskPro(ctx, solutionMap);
        if (isAll) {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sqlNew);
        } else {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sqlNew, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sqlNew));
        }
        ArrayList bizList = new ArrayList();
        int totalCount = 0;
        try {
            DecimalFormat df = new DecimalFormat("#0.0000");
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (stat_dimension.indexOf("showBizType") > -1) {
                    String bizTypeId = rowSet.getString("bizTypeId");
                    String bizType = rowSet.getString("bizType");
                    map.put("bizType", bizType);
                    map.put("bizTypeId", bizTypeId);
                }
                if (stat_dimension.indexOf("showOrgName") > -1) {
                    String orgname = rowSet.getString("orgname");
                    String orgId = rowSet.getString("orgId");
                    map.put("orgname", orgname);
                    map.put("orgId", orgId);
                }
                if (stat_dimension.indexOf("showDealPerson") > -1) {
                    String username = rowSet.getString("username");
                    String userno = rowSet.getString("userno");
                    map.put("username", username);
                    map.put("userno", userno);
                }
                String finish = StringUtils.cnulls((String)rowSet.getString("finish"), (String)"0");
                String untreated = StringUtils.cnulls((String)rowSet.getString("untreated"), (String)"0");
                String deal = StringUtils.cnulls((String)rowSet.getString("deal"), (String)"0");
                BigDecimal _finish = new BigDecimal(finish);
                BigDecimal _untreated = new BigDecimal(untreated);
                BigDecimal _deal = new BigDecimal(deal);
                if (_finish.add(_untreated).add(_deal).doubleValue() == 0.0) continue;
                String rate_finish = df.format(_finish.setScale(8, 5).divide(_finish.add(_untreated).add(_deal), 8, 5).multiply(new BigDecimal(100))) + "%";
                String rate_untreated = df.format(_untreated.setScale(8, 5).divide(_finish.add(_untreated).add(_deal), 8, 5).multiply(new BigDecimal(100))) + "%";
                String rate_deal = df.format(_deal.setScale(8, 5).divide(_finish.add(_untreated).add(_deal), 8, 5).multiply(new BigDecimal(100))) + "%";
                map.put("finish_rate", rate_finish);
                map.put("untreated_rate", rate_untreated);
                map.put("deal_rate", rate_deal);
                map.put("finish", finish);
                map.put("untreated", untreated);
                map.put("deal", deal);
                bizList.add(map);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getTaskProChartsData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String gg = this.getTaskProChar(ctx, solutionMap);
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)gg);
        ArrayList bizList = new ArrayList();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (rowSet.next()) {
                int finish = Integer.parseInt(StringUtils.cnulls((String)rowSet.getString("finish"), (String)"0"));
                int untreated = Integer.parseInt(StringUtils.cnulls((String)rowSet.getString("untreated"), (String)"0"));
                int deal = Integer.parseInt(StringUtils.cnulls((String)rowSet.getString("deal"), (String)"0"));
                map.put("finish", finish);
                map.put("untreated", untreated);
                map.put("deal", deal);
            }
            bizList.add(map);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getPersonalData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List bizList = new ArrayList();
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = null;
        try {
            sql = TaskReportUtil.getTaskPersonalPageSql(solutionMap, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            bizList = this.getPersonalPageData(ctx, solutionInfo, null);
            Collections.sort(bizList, this.getSortObByReportData((String)solutionMap.get("dynamicfilter")));
            result.put("rows", bizList);
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
        rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql));
        int totalCount = 0;
        try {
            ArrayList<Map> recList = new ArrayList<Map>();
            while (rowSet.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
                    String bizTypeId = rowSet.getString("bizTypeId");
                    rec.put("bizTypeId", bizTypeId);
                }
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
                    String orgId = rowSet.getString("orgId");
                    rec.put("orgId", orgId);
                }
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
                    String userId = rowSet.getString("userId");
                    rec.put("userId", userId);
                }
                recList.add(rec);
            }
            if (recList.size() > 0) {
                bizList = this.getPersonalPageData(ctx, solutionInfo, recList);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Collections.sort(bizList, this.getSortObByReportData((String)solutionMap.get("dynamicfilter")));
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private Comparator<HashMap> getSortObByReportData(String dynamicfilter) {
        final String[] split = dynamicfilter.split(",");
        if (split.length > 1 && "showDealPerson".equals(split[split.length - 1])) {
            String tempor = split[split.length - 1];
            for (int i = split.length - 1; i > 0; --i) {
                split[i] = split[i - 1];
            }
            split[0] = tempor;
        }
        return new Comparator<HashMap>(){

            @Override
            public int compare(HashMap o1, HashMap o2) {
                for (int i = 0; i < split.length; ++i) {
                    int i1;
                    if (!("showDealPerson".equals(split[i]) ? (i1 = ((String)o1.get("userno")).compareTo((String)o2.get("userno"))) != 0 : ("showBizType".equals(split[i]) ? (i1 = ((String)o1.get("bizType")).compareTo((String)o2.get("bizType"))) != 0 : "showOrgName".equals(split[i]) && (i1 = ((String)o1.get("orgname")).compareTo((String)o2.get("orgname"))) != 0))) continue;
                    return i1;
                }
                return 0;
            }
        };
    }

    @Override
    protected Map _getTaskQualityData(Context ctx, Map param) throws BOSException {
        String userIds;
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        int iStartIndex = 0;
        int iRowCount = 0;
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList bizList = new ArrayList();
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = null;
        try {
            sql = TaskReportUtil.getTaskQualitySql(param, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        int objLen = 0;
        ArrayList<String> para = new ArrayList<String>();
        String orgIds = (String)param.get("orgId");
        if (!StringUtils.isEmpty((String)orgIds)) {
            objLen += SSCUtil.objectLength(orgIds);
            para.addAll(Arrays.asList(orgIds.split(",")));
        } else {
            String shareCenterId = (String)param.get("shareCenter.id");
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            if (StringUtils.isEmpty((String)shareCenterId)) {
                String org = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId).replace("'", "");
                objLen += SSCUtil.objectLength(org);
                para.addAll(Arrays.asList(org.split(",")));
            } else {
                objLen += SSCUtil.objectLength(shareCenterId);
                para.addAll(Arrays.asList(shareCenterId.split(",")));
            }
        }
        String bizTypeIds = (String)param.get("bizTypeId");
        if (!StringUtils.isEmpty((String)bizTypeIds)) {
            objLen += SSCUtil.objectLength(SSCUtil.objectLength(bizTypeIds));
            para.addAll(Arrays.asList(bizTypeIds.split(",")));
        }
        if (!StringUtils.isEmpty((String)(userIds = (String)param.get("userId")))) {
            objLen += SSCUtil.objectLength(SSCUtil.objectLength(userIds));
            para.addAll(Arrays.asList(userIds.split(",")));
        }
        Object[] obj = new Object[para.size()];
        for (int i = 0; i < para.size(); ++i) {
            obj[i] = para.get(i);
        }
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            iStartIndex = 0;
            iRowCount = Integer.MAX_VALUE;
        }
        rowSet = SSCDbUtil.executeQuery(ctx, sql, obj, iStartIndex, iRowCount);
        rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql), (Object[])obj);
        int totalCount = 0;
        try {
            String dynamicfilter = (String)param.get("dynamicfilter");
            DecimalFormat df = new DecimalFormat("##.00");
            while (rowSet.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                if (dynamicfilter.contains("dealPerson")) {
                    rec.put("userId", rowSet.getString("userId"));
                    rec.put("username", rowSet.getString("username"));
                }
                if (dynamicfilter.contains("orgName")) {
                    rec.put("orgname", rowSet.getString("orgname"));
                    rec.put("orgId", rowSet.getString("orgId"));
                }
                if (dynamicfilter.contains("bizType")) {
                    rec.put("bizType", rowSet.getString("bizType"));
                    rec.put("bizTypeId", rowSet.getString("bizTypeId"));
                }
                rec.put("dealCount", rowSet.getString("dealCount"));
                rec.put("unpassCount", rowSet.getString("unpassCount"));
                rec.put("unpassRate", this._getRate(rowSet, "dealCount", "unpassCount", df));
                rec.put("rescanCount", rowSet.getString("rescanCount"));
                rec.put("rescanRate", this._getRate(rowSet, "dealCount", "rescanCount", df));
                rec.put("suspendCount", rowSet.getString("suspendCount"));
                rec.put("suspendRate", this._getRate(rowSet, "dealCount", "suspendCount", df));
                rec.put("exceptCount", rowSet.getString("exceptCount"));
                rec.put("exceptRate", this._getRate(rowSet, "dealCount", "exceptCount", df));
                bizList.add(rec);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    private String _getRate(IRowSet rowSet, String denominator, String molecular, DecimalFormat df) {
        String ret = "0";
        try {
            Integer den = rowSet.getInt(denominator);
            Double mol = rowSet.getDouble(molecular);
            if (mol == 0.0) {
                return ret;
            }
            Double r = mol / (double)den.intValue() * 100.0;
            ret = df.format(r);
        }
        catch (SQLException e) {
            logger.error((Object)("\u4efb\u52a1\u8d28\u91cf\u5206\u6790\u62a5\u8868" + molecular + "\u89e3\u6790\u9519\u8bef"), (Throwable)e);
        }
        return ret;
    }

    protected List getPersonalPageData(Context ctx, String solutionInfo, List<Map> pageList) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        startDate = startDate.replaceAll("/", "-");
        endDate = endDate.replaceAll("/", "-");
        java.util.Date start = null;
        java.util.Date end = null;
        HashSet<String> dateSet = new HashSet<String>();
        long datediff = 1L;
        try {
            String dateStr;
            start = DateTimeUtils.parseDate((String)startDate);
            end = DateTimeUtils.parseDate((String)endDate);
            int end_year = DateTimeUtils.getYear((java.util.Date)end);
            int end_month = DateTimeUtils.getMonth((java.util.Date)end);
            int end_day = DateTimeUtils.getDay((java.util.Date)end);
            String end_str = end_year + RptConstant.DATE_SPLIT + end_month;
            if (period.equals(RptConstant.PERIOD_BYDAY)) {
                datediff = DateTimeUtils.dateDiff((String)"d", (java.util.Date)start, (java.util.Date)end) + 1L;
                while (DateTimeUtils.getYear((java.util.Date)start) != DateTimeUtils.getYear((java.util.Date)end) || DateTimeUtils.getMonth((java.util.Date)start) != DateTimeUtils.getMonth((java.util.Date)end) || DateTimeUtils.getDay((java.util.Date)start) != DateTimeUtils.getDay((java.util.Date)end)) {
                    dateStr = DateTimeUtils.getYear((java.util.Date)start) + RptConstant.DATE_SPLIT + DateTimeUtils.getMonth((java.util.Date)start) + RptConstant.DATE_SPLIT + DateTimeUtils.getDay((java.util.Date)start);
                    dateStr = FormatUtil.getNumberDateStr(dateStr);
                    dateSet.add(dateStr);
                    start = DateTimeUtils.addDay((java.util.Date)start, (long)1L);
                }
                end_str = FormatUtil.getNumberDateStr(end_str + RptConstant.DATE_SPLIT + end_day);
                dateSet.add(end_str);
            } else {
                datediff = DateTimeUtils.dateDiff((String)"m", (java.util.Date)start, (java.util.Date)end) + 1L;
                while (DateTimeUtils.getYear((java.util.Date)start) != DateTimeUtils.getYear((java.util.Date)end) || DateTimeUtils.getMonth((java.util.Date)start) != DateTimeUtils.getMonth((java.util.Date)end)) {
                    dateStr = DateTimeUtils.getYear((java.util.Date)start) + RptConstant.DATE_SPLIT + DateTimeUtils.getMonth((java.util.Date)start);
                    dateStr = FormatUtil.getNumberDateStr(dateStr);
                    dateSet.add(dateStr);
                    start = DateTimeUtils.addMonth((java.util.Date)start, (int)1);
                }
                end_str = FormatUtil.getNumberDateStr(end_str);
                dateSet.add(end_str);
            }
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String sql = null;
        try {
            sql = TaskReportUtil.getTaskPersonalSql(solutionMap, pageList, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = null;
        rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Map> bizList = new ArrayList<Map>();
        try {
            DecimalFormat df = new DecimalFormat("#0.0000");
            HashMap<String, Map<String, BigDecimal>> dimMap = new HashMap<String, Map<String, BigDecimal>>();
            while (rowSet.next()) {
                Object last_taskCount;
                Map<String, BigDecimal> map = null;
                String dim_key = "";
                String bizTypeId = "";
                String orgId = "";
                String userId = "";
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
                    dim_key = bizTypeId = rowSet.getString("bizTypeId");
                }
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
                    orgId = rowSet.getString("orgId");
                    dim_key = dim_key + orgId;
                }
                if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
                    userId = rowSet.getString("userId");
                    dim_key = dim_key + userId;
                }
                if (dimMap.containsKey(dim_key)) {
                    map = (Map)dimMap.get(dim_key);
                } else {
                    map = new HashMap();
                    if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
                        String bizType = rowSet.getString("bizType");
                        map.put("bizType", (BigDecimal)((Object)bizType));
                        map.put("bizTypeId", (BigDecimal)((Object)bizTypeId));
                    }
                    if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
                        String orgname = rowSet.getString("orgname");
                        map.put("orgname", (BigDecimal)((Object)orgname));
                        map.put("orgId", (BigDecimal)((Object)orgId));
                    }
                    if (stat_dimension.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
                        String username = rowSet.getString("username");
                        String userno = rowSet.getString("userno");
                        map.put("username", (BigDecimal)((Object)username));
                        map.put("userno", (BigDecimal)((Object)userno));
                        map.put("userId", (BigDecimal)((Object)userId));
                    }
                }
                int byYear = rowSet.getInt("byYear");
                int byMonth = rowSet.getInt("byMonth");
                String dateStr = byYear + RptConstant.DATE_SPLIT + byMonth;
                if (period.equals(RptConstant.PERIOD_BYDAY)) {
                    int byDay = rowSet.getInt("byDay");
                    dateStr = dateStr + RptConstant.DATE_SPLIT + byDay;
                }
                dateStr = FormatUtil.getNumberDateStr(dateStr);
                String timelong = StringUtils.cnulls((String)rowSet.getString("timelong"), (String)"0");
                String tasksum = StringUtils.cnulls((String)rowSet.getString("tasksum"), (String)"0");
                BigDecimal _timelong = new BigDecimal(timelong).setScale(6, 5);
                BigDecimal _tasksum = new BigDecimal(tasksum);
                Object last_timelong = map.get("timelong");
                if (last_timelong != null) {
                    _timelong = _timelong.add(new BigDecimal(last_timelong.toString()));
                }
                if ((last_taskCount = map.get("taskCount")) != null) {
                    _tasksum = _tasksum.add(new BigDecimal(last_taskCount.toString()));
                }
                map.put("timelong", _timelong);
                map.put(dateStr, (BigDecimal)((Object)tasksum));
                map.put("taskCount", _tasksum);
                dimMap.put(dim_key, map);
            }
            for (Map.Entry rec : dimMap.entrySet()) {
                Map recmap = (Map)rec.getValue();
                BigDecimal _timelong = (BigDecimal)recmap.get("timelong");
                BigDecimal _tasksum = (BigDecimal)recmap.get("taskCount");
                String avg_eff = df.format(_tasksum.setScale(8, 5).divide(_timelong.doubleValue() == 0.0 ? new BigDecimal("0.01") : _timelong, 4, 5));
                String avg_task = df.format(_tasksum.setScale(8, 5).divide(new BigDecimal(datediff), 4, 5));
                recmap.put("avg_eff", avg_eff);
                recmap.put("avg_task", avg_task);
                for (String dateStr : dateSet) {
                    if (recmap.containsKey(dateStr)) continue;
                    recmap.put(dateStr, 0);
                }
                bizList.add(recmap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bizList;
    }

    @Override
    protected String _getPersonalDetailData(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String startDate = (String)solutionMap.get("startDate");
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        Object _isAll = solutionMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = null;
        try {
            sql = TaskReportUtil.getPersonalDetailSql(solutionMap, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        } else {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql));
        }
        ArrayList bizList = new ArrayList();
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (period.equals(RptConstant.PERIOD_BYDAY)) {
                    map.put("completeDate", startDate.substring(0, 10));
                } else {
                    map.put("completeDate", startDate.substring(0, 7));
                }
                map.put("username", rowSet.getString("username"));
                map.put("userno", rowSet.getString("userno"));
                map.put("bizType", rowSet.getString("bizType"));
                map.put("orgname", rowSet.getString("orgname"));
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("timely", StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0"));
                map.put("tasksum", rowSet.getString("tasksum"));
                bizList.add(map);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected String _getTaskAnalyzeByPeriod(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String sql = null;
        try {
            sql = TaskReportUtil.getTaskAnalyzeByPeriod(solutionMap, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            DecimalFormat df = new DecimalFormat("#0.0000");
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(RptConstant.PERIOD_BYYEAR, rowSet.getString(RptConstant.PERIOD_BYYEAR));
                map.put(RptConstant.PERIOD_BYMONTH, rowSet.getString(RptConstant.PERIOD_BYMONTH));
                if (period.equals(RptConstant.PERIOD_BYDAY)) {
                    map.put(RptConstant.PERIOD_BYDAY, rowSet.getString(RptConstant.PERIOD_BYDAY));
                }
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("timely", StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0"));
                String timelong = StringUtils.cnulls((String)rowSet.getString("timelong"), (String)"0");
                String tasksum = StringUtils.cnulls((String)rowSet.getString("tasksum"), (String)"0");
                BigDecimal _timelong = new BigDecimal(timelong).setScale(6, 5);
                BigDecimal _tasksum = new BigDecimal(tasksum);
                String avg_eff = df.format(_tasksum.setScale(8, 5).divide(_timelong.doubleValue() == 0.0 ? new BigDecimal(1).setScale(10, 5).divide(new BigDecimal(3600), 10, 5) : _timelong, 4, 5));
                map.put("avg_eff", avg_eff);
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getOrgBizChart(Context ctx, String solutionInfo) throws BOSException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String sql = null;
        try {
            sql = TaskReportUtil.getOrgBizChartSql(solutionMap, ctx);
        }
        catch (SSCException e) {
            throw new BOSException((Throwable)((Object)e));
        }
        IRowSet rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bizType", rowSet.getString("bizType"));
                map.put("orgname", rowSet.getString("orgname"));
                map.put("expired", StringUtils.cnulls((String)rowSet.getString("expired"), (String)"0"));
                map.put("timely", StringUtils.cnulls((String)rowSet.getString("timely"), (String)"0"));
                map.put("tasksum", rowSet.getString("tasksum"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    @Override
    protected String _getBizOrgFilter(Context ctx, String userId, String roleType) throws BOSException {
        if (!StringUtils.isEmpty((String)userId) && !StringUtils.isEmpty((String)roleType)) {
            return TaskReportUtil.getBizOrgFilterSql(userId, roleType);
        }
        return null;
    }

    @Override
    protected String _getUnpassReport(Context ctx, String filter) throws BOSException, EASBizException {
        HashMap filterMap = JSONUtils.convertJsonToObject((Context)ctx, (String)filter);
        filterMap.put("isOnlyAuditJob", false);
        return this.getUnpassData(ctx, filterMap);
    }

    private String getUnpassCountStr(Context ctx, Map filterMap) throws BOSException, SSCException {
        String dynamicfilter = (String)filterMap.get("dynamicfilter");
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildUnpassReaSelector(dynamicfilter));
        sb.append(this.buildUnpassTable());
        sb.append(this.buildUnpasFilter(filterMap, ctx));
        sb.append(this.buildUnpassGroupBy(dynamicfilter));
        return sb.toString();
    }

    private String getTotalJobCountStr(Context ctx, Map filterMap) throws BOSException, SSCException {
        String dynamicfilter = (String)filterMap.get("dynamicfilter");
        StringBuffer totalJobCountSb = new StringBuffer();
        totalJobCountSb.append(this.buildUnpassSelector(dynamicfilter));
        totalJobCountSb.append(this.buildTable());
        totalJobCountSb.append(" left join  t_ssc_unpassReason unpassRea on u.fid = unpassRea.fid");
        totalJobCountSb.append(this.buildTotalTableFilter(filterMap, ctx));
        String quickValue = (String)filterMap.get("totalQuickValue");
        if (!StringUtils.isEmpty((String)quickValue)) {
            totalJobCountSb.append("and ( " + quickValue + " ) ");
        }
        totalJobCountSb.append(this.buildGroupBy(dynamicfilter));
        return totalJobCountSb.toString();
    }

    private String buildSelector(String dynamicfilter) {
        StringBuffer sb = new StringBuffer("select ");
        String bussId = null;
        String orgId = null;
        String userId = null;
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            bussId = "buss.fid ";
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            orgId = "org.fid ";
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            userId = "u.fid ";
        }
        sb.append(bussId + " fbussId,");
        sb.append(orgId + " forgId,");
        sb.append(userId + " fuserId,");
        sb.append("count(1) fjobTotal");
        return sb.toString();
    }

    private String buildUnpassReaSelector(String dynmaicfilter) {
        return this.buildSelector(dynmaicfilter) + ",unpassRea.fid funpasReaId,jobhis.FJobState";
    }

    private String buildUnpassSelector(String dynmaicfilter) {
        return this.buildSelector(dynmaicfilter) + ",sum(case when jobhis.fjobstate in ('3','4','6','10','11','13') then 1 else 0 end) foperation, case when jobhis.FJobState='3' then '\u5ba1\u6838\u901a\u8fc7' when jobhis.FJobState='4' then '\u5ba1\u6838\u4e0d\u901a\u8fc7' when jobhis.FJobState='6' then '\u6253\u56de' when jobhis.FJobState='10' then '\u5df2\u5904\u7406' when jobhis.FJobState='11' then '\u8f6c\u4ea4' when jobhis.FJobState = '13' then '\u6253\u56de\u5e76\u9000\u626b' else '' end foperationType,jobhis.fjobstate";
    }

    private String buildGroupBy(String dynamicfilter) {
        String groupByStr;
        StringBuffer sb = new StringBuffer(" group by ");
        sb.append(" jobhis.FJobState, ");
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            sb.append(" buss.fid ").append(",");
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            sb.append(" org.fid ").append(",");
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            sb.append(" u.fid ");
        }
        if ((groupByStr = sb.toString()).endsWith(",")) {
            return groupByStr.substring(0, groupByStr.length() - 1);
        }
        return groupByStr;
    }

    private String buildUnpassGroupBy(String dynamicfilter) {
        return this.buildGroupBy(dynamicfilter) + ",unpassRea.fid";
    }

    private String buildTable() {
        StringBuffer sb = new StringBuffer();
        sb.append(" from t_ssc_jobhis jobhis ");
        sb.append(" inner join t_ssc_bussinessAttribute buss on jobhis.fbussattrIDID = buss.FID ");
        sb.append(" inner join t_ssc_org org on jobhis.forgidid = org.fid ");
        sb.append(" inner join t_ssc_user u on jobhis.fpersonnelIDID = u.fid ");
        return sb.toString();
    }

    private String buildUnpassTable() {
        return this.buildTable() + " inner join (SELECT distinct upr.fjobid,upr.funpassReaId funpassReaId FROM t_ssc_jobUnpassRea upr) jobunpassrea on jobhis.fid = jobunpassrea.fjobid  inner join t_ssc_unpassReason unpassRea on jobunpassrea.funpassReaId = unpassRea.fid ";
    }

    private String buildTotalTableFilter(Map filterMap, Context ctx) throws BOSException, SSCException {
        Map<String, String> filterSqlMap = this.getBizAttrOrgUser(filterMap, ctx);
        String bizAttrIdFiler = filterSqlMap.get("bizAttrIds");
        String userIdFilter = filterSqlMap.get("userIds");
        String extendErpIdFilter = filterSqlMap.get("extendErpIds");
        String userId = (String)filterMap.get("userId");
        String startDate = (String)filterMap.get("startDate");
        String endDate = (String)filterMap.get("endDate");
        String orgId = (String)filterMap.get("orgId");
        String bussId = (String)filterMap.get("bussId");
        String jobstate = (String)filterMap.get("jobstate");
        StringBuffer sb = new StringBuffer();
        sb.append(" where jobhis.fcompletetme >=").append(DateUtil.dateToTsDate(startDate));
        sb.append(" and jobhis.fcompletetme <=").append(DateUtil.dateToTsDate(endDate));
        if (!StringUtils.isEmpty((String)userId)) {
            userId = "'" + userId.replaceAll(",", "','") + "'";
            sb.append(" and jobhis.fpersonnelIDID in (").append(userId).append(") ");
        } else {
            sb.append(" and jobhis.fpersonnelIDID in (" + userIdFilter + ")");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sb.append(" and jobhis.forgidid in (").append(orgId).append(") ");
        } else {
            sb.append(" and exists ( select forgid from T_SSC_SysAttrOrgSCMap ta where jobhis.forgidid = ta.forgid and  ta.FShareCenterID IN (" + this.getShareCenter(ctx, filterMap) + " ))");
        }
        if (!StringUtils.isEmpty((String)bussId)) {
            bussId = "'" + bussId.replaceAll(",", "','") + "'";
            sb.append(" and jobhis.fbussattrIDID in (").append(bussId).append(") ");
        } else {
            sb.append(" and jobhis.fbussattrIDID in (" + bizAttrIdFiler + ")");
        }
        if (!StringUtils.isEmpty((String)jobstate)) {
            jobstate = "'" + jobstate.replaceAll(",", "','") + "'";
            sb.append(" and jobhis.fjobstate in (").append(jobstate).append(") ");
        } else {
            sb.append(" and jobhis.fjobstate in ('3','4','6','10','11','13') ");
        }
        String extendErpId = (String)filterMap.get("extendErpId");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            sb.append(extendErpIdFilter);
        }
        return sb.toString();
    }

    private String buildTotalUnpasFilter(Map filterMap, Context ctx) throws BOSException, SSCException {
        return this.buildTotalTableFilter(filterMap, ctx);
    }

    private String buildUnpasFilter(Map filterMap, Context ctx) throws BOSException, SSCException {
        String unpasReaId;
        String filter = this.buildTotalUnpasFilter(filterMap, ctx);
        String quickValue = (String)filterMap.get("quickValue");
        if (!StringUtils.isEmpty((String)quickValue)) {
            filter = filter + "and ( " + quickValue + " ) ";
        }
        if (!StringUtils.isEmpty((String)(unpasReaId = (String)filterMap.get("unpassReaId")))) {
            unpasReaId = "'" + unpasReaId.replaceAll(",", "','") + "'";
            filter = filter + " and unpassRea.fid in (" + unpasReaId + ") ";
        }
        return filter;
    }

    private String getUnpassData(Context ctx, Map filterMap) throws BOSException, SSCException {
        String dynamicfilter = (String)filterMap.get("dynamicfilter");
        String startIndex = (String)filterMap.get("startIndex");
        String rowCount = (String)filterMap.get("rowCount");
        StringBuffer sb = new StringBuffer();
        sb.append(this.buildUnpassDataSelector(ctx, dynamicfilter));
        sb.append(this.buildUnpassDataTable(ctx, filterMap));
        sb.append(" order by totalJob.fbussId,totalJob.forgId,totalJob.fuserId");
        try {
            IRowSet rs = null;
            boolean isAll = false;
            if (filterMap.get("isAll") != null) {
                isAll = (Boolean)filterMap.get("isAll");
            }
            rs = isAll ? SSCDbUtil.executeQuery((Context)ctx, (String)sb.toString()) : SSCDbUtil.executeQuery((Context)ctx, (String)sb.toString(), (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            logger.error((Object)("\u6279\u9000\u539f\u56e0\u62a5\u8868sql\uff1a" + sb.toString()));
            IRowSet rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sb.toString()));
            int totalCount = 0;
            if (rowSetCount.next()) {
                totalCount = rowSetCount.getInt(1);
            }
            ArrayList dataList = new ArrayList();
            DecimalFormat df = new DecimalFormat("#0.00");
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bussName", rs.getString("bussName"));
                map.put("orgName", rs.getString("orgName"));
                map.put("userName", rs.getString("userName"));
                map.put("unpassReaName", rs.getString("unpassReaName"));
                map.put("foperation", rs.getString("foperation"));
                map.put("foperationType", rs.getString("foperationType"));
                map.put("unpassCount", rs.getInt("unpassCount") + "");
                map.put("unpassPerc", df.format(rs.getBigDecimal("unpassPerc").multiply(new BigDecimal(100))) + "%");
                dataList.add(map);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("records", String.valueOf(totalCount));
            result.put("rows", dataList);
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSCException(SSCException.UNKNOW, e, new Object[]{e.getMessage()});
        }
    }

    private String buildUnpassDataSelector(Context ctx, String dynamicfilter) {
        StringBuffer sb = new StringBuffer();
        String bussName = null;
        String orgName = null;
        String userName = null;
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            bussName = "buss.fname_" + ctx.getLocale().toString();
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            orgName = "org.fname_" + ctx.getLocale().toString();
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            userName = "u.fname_" + ctx.getLocale().toString();
        }
        sb.append("select ");
        sb.append(bussName + " bussName,");
        sb.append(orgName + " orgName,");
        sb.append(userName + " userName,");
        sb.append("totalJob.foperation foperation, ");
        sb.append("totalJob.foperationType foperationType, ");
        sb.append("unpasRea.fname_" + ctx.getLocale().toString() + " unpassReaName,");
        sb.append("unpass.fjobTotal unpassCount,");
        sb.append("unpass.fjobTotal*1.0/totalJob.foperation unpassPerc ");
        return sb.toString();
    }

    private String buildUnpassDataTable(Context ctx, Map filterMap) throws BOSException, SSCException {
        String dynamicfilter = (String)filterMap.get("dynamicfilter");
        StringBuffer sb = new StringBuffer();
        sb.append(" from (");
        sb.append(this.getTotalJobCountStr(ctx, filterMap));
        sb.append(" ) totalJob ");
        sb.append(" inner join (");
        sb.append(this.getUnpassCountStr(ctx, filterMap));
        sb.append(") unpass on totalJob.fjobstate = unpass.FJobState ");
        StringBuffer unpassOnsb = new StringBuffer();
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            unpassOnsb.append(" and totalJob.fbussId = unpass.fbussId ");
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            unpassOnsb.append(" and totalJob.forgId = unpass.forgId ");
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            unpassOnsb.append(" and totalJob.fuserId = unpass.fuserId ");
        }
        sb.append(unpassOnsb);
        String bussTable = "";
        String orgTable = "";
        String uTable = "";
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_BIZTYPE) > -1) {
            bussTable = " left outer join t_ssc_bussinessAttribute buss on totalJob.fbussId = buss.fid ";
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_ORGNAME) > -1) {
            orgTable = " left outer join t_ssc_org org on totalJob.forgId = org.fid ";
        }
        if (dynamicfilter.indexOf(RptConstant.STAT_DIMENSION_DEALER) > -1) {
            uTable = " left outer join t_ssc_user u on totalJob.fuserId = u.fid ";
        }
        sb.append(bussTable);
        sb.append(orgTable);
        sb.append(uTable);
        sb.append(" left outer join t_ssc_unpassReason unpasRea on unpass.funpasReaId = unpasRea.fid ");
        return sb.toString();
    }

    @Override
    protected String _getTaskQualityData(Context ctx, String param) throws BOSException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getTaskQualityData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected Map _getTaskQualityDetailData(Context ctx, Map param) throws BOSException, EASBizException {
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        int iStartIndex = 0;
        int iRowCount = 0;
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList bizList = new ArrayList();
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        Map<String, Object> sqlMap = TaskReportUtil.getTaskQualityDetailSql(param, ctx);
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        String sql = sqlMap.get("sql").toString();
        int totalCount = 0;
        rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql), (Object[])((Object[])sqlMap.get("params")));
        try {
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (totalCount == 0) {
            result.put("records", String.valueOf(totalCount));
            result.put("rows", bizList);
            return result;
        }
        rowSet = isAll ? SSCDbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])sqlMap.get("params"))) : SSCDbUtil.executeQuery(ctx, sql, (Object[])sqlMap.get("params"), iStartIndex, iRowCount);
        String jobState = (String)param.get("jobState");
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (rowSet.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                rec.put("userId", rowSet.getString("userId"));
                rec.put("username", rowSet.getString("username"));
                rec.put("orgname", rowSet.getString("orgname"));
                rec.put("orgId", rowSet.getString("orgId"));
                rec.put("bizType", rowSet.getString("bizType"));
                rec.put("bizTypeId", rowSet.getString("bizTypeId"));
                rec.put("subject", rowSet.getString("subject"));
                rec.put("messages", rowSet.getString("messages"));
                Date receiveTime = rowSet.getDate("receiveTime");
                Date dealTime = rowSet.getDate("dealTime");
                rec.put("receiveTime", df.format(receiveTime));
                rec.put("dealTime", df.format(dealTime));
                long time = rowSet.getBigDecimal("costTime") == null ? 0L : rowSet.getBigDecimal("costTime").multiply(new BigDecimal(3600)).longValue();
                rec.put("cost", DateUtil.formatDisplay(time));
                rec.put("priority", rowSet.getString("priority"));
                if (TaskReportUtil.taskQualityDetailIsShowRea(jobState)) {
                    rec.put("unpassRea", rowSet.getString("unpassRea"));
                }
                bizList.add(rec);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    @Override
    protected String _getTaskQualityDetailData(Context ctx, String param) throws BOSException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getTaskQualityDetailData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected Map _getMutiTaskEfficientData(Context ctx, Map param) throws BOSException, EASBizException {
        param.put("isOnlyAuditJob", true);
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        int iStartIndex = 0;
        int iRowCount = 0;
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String shareCenterID = (String)param.get("shareCenter.id");
        BOSUuid.read((String)shareCenterID);
        int iDataCount = 1;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            iDataCount = WorkDateUtil.getInstance(ctx, shareCenterID, false).getCalWorkAndHalfDays(format.parse(startDate), format.parse(endDate));
            if (iDataCount == 0) {
                iDataCount = 1;
            }
        }
        catch (Exception e1) {
            logger.error((Object)"[\u4efb\u52a1\u62a5\u8868-\u591a\u7ea7\u5ba1\u6279\u6548\u7387\u8868]\u8c03\u7528\u5de5\u4f5c\u65e5\u5386\u8ba1\u7b97\u5de5\u4f5c\u65f6\u95f4\u51fa\u9519");
            throw new BOSException((Throwable)e1);
        }
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String maxLvlSql = TaskReportUtil.getMutiTaskEfficientMaxLvlSql(param, ctx);
        int iMaxLvl = 0;
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        int totalCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList recList = new ArrayList();
        try {
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)maxLvlSql);
            if (rowSet != null) {
                while (rowSet.next()) {
                    iMaxLvl = rowSet.getInt("maxLvl");
                    if (iMaxLvl > 0) {
                        param.put("iMaxLvl", iMaxLvl);
                        continue;
                    }
                    return result;
                }
            } else {
                return result;
            }
            rowSet = null;
            String billtypeListSql = TaskReportUtil.getMutiTaskEfficientBillListSql(param, ctx);
            if (isAll) {
                iStartIndex = 0;
                iRowCount = 1000;
            }
            if ((rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(billtypeListSql))) != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
            if (totalCount <= 0) {
                return result;
            }
            DecimalFormat decimalFormat = new DecimalFormat("#0.0000");
            LinkedHashMap lm = new LinkedHashMap();
            do {
                rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)billtypeListSql, (int)iStartIndex, (int)iRowCount);
                StringBuffer billTypeIds = new StringBuffer(500);
                billTypeIds.append("('");
                while (rowSet.next()) {
                    billTypeIds.append(rowSet.getString("fid")).append("','");
                }
                if (billTypeIds.length() <= 2) {
                    return result;
                }
                billTypeIds.delete(billTypeIds.length() - 2, billTypeIds.length()).append(")");
                String gridDataSql = TaskReportUtil.getMutiTaskEfficientGridDataSql(billTypeIds.toString(), param, ctx);
                rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)gridDataSql);
                while (rowSet.next()) {
                    String billTypeId = rowSet.getString("fid");
                    String billTypeName = rowSet.getString("fname_l2");
                    int lvl = rowSet.getInt("flevel");
                    long timeLvl = rowSet.getBigDecimal("costTime") == null ? 0L : rowSet.getBigDecimal("costTime").multiply(new BigDecimal(3600)).longValue();
                    HashMap<String, Object> rec = (HashMap<String, Object>)lm.get(billTypeId);
                    if (rec == null) {
                        rec = new HashMap<String, Object>();
                        rec.put("billTypeId", billTypeId);
                        rec.put("billType", billTypeName);
                        lm.put(billTypeId, rec);
                    }
                    if (rec.get("timeLvl" + lvl) == null) {
                        rec.put("timeLvl" + lvl, new Long(timeLvl));
                        rec.put("count" + lvl, 1);
                        continue;
                    }
                    Long sumTimeLvl = (Long)rec.get("timeLvl" + lvl);
                    Integer countLvl = (Integer)rec.get("count" + lvl);
                    rec.put("timeLvl" + lvl, sumTimeLvl + timeLvl);
                    rec.put("count" + lvl, countLvl + 1);
                }
                this._formatMutiEffiGridData(lm.values(), iDataCount, decimalFormat);
                recList.addAll(lm.values());
            } while (isAll && (iStartIndex += iRowCount) < totalCount);
        }
        catch (Exception e) {
            logger.error((Object)("[\u4efb\u52a1\u62a5\u8868-\u591a\u7ea7\u5ba1\u6279\u6548\u7387\u8868]-\u8868\u683c\u540e\u53f0\u53d6\u6570\u51fa\u73b0\u5f02\u5e38" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", recList);
        result.put("maxLvl", iMaxLvl);
        return result;
    }

    private void _formatMutiEffiGridData(Collection<Map> recs, int iDataCount, DecimalFormat df) {
        for (Map rec : recs) {
            Long t;
            int i = 1;
            int count = 0;
            long att = 0L;
            while ((t = (Long)rec.get("timeLvl" + i)) != null) {
                Integer c = (Integer)rec.get("count" + i);
                rec.put("avgTime" + i, DateUtil.secend2Min(t / (long)c.intValue()));
                rec.put("avgDayDeal" + i, df.format((double)c.intValue() / (double)iDataCount));
                att += t.longValue();
                count += c.intValue();
                ++i;
            }
            count = count == 0 ? 1 : count;
            rec.put("avgDayDealTotal", df.format((double)count / (double)iDataCount));
            rec.put("avgTimeTotal", DateUtil.formatDisplay(att / (long)count));
        }
    }

    @Override
    protected String _getMutiTaskEfficientData(Context ctx, String param) throws BOSException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getMutiTaskEfficientData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected Map _getMutiTaskDetailData(Context ctx, Map param) throws BOSException, EASBizException {
        logger.error((Object)("\u591a\u7ea7\u4efb\u52a1\u5ba1\u6279\u7edf\u8ba1\u8868\uff1aparam:" + param.toString()));
        param.put("isOnlyAuditJob", false);
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        String sord = (String)param.get("sord");
        String sidx = (String)param.get("sidx");
        int iStartIndex = 0;
        int iRowCount = 0;
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        int iMaxLvl = 0;
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        int totalCount = 0;
        ArrayList<Map<String, Object>> recList = new ArrayList<Map<String, Object>>();
        try {
            String billTypeListSql = TaskReportUtil.getMutiTaskDetailBillTypeListSql(param, ctx);
            String billType = (String)param.get("billType");
            String orgId = (String)param.get("orgId");
            String userId = (String)param.get("userId");
            String jobState = (String)param.get("jobState");
            String subject = (String)param.get("subject");
            int objLen = 0;
            ArrayList<String> para = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)billType)) {
                objLen += SSCUtil.objectLength(billType);
                para.addAll(Arrays.asList(billType.split(",")));
            }
            if (!StringUtils.isEmpty((String)orgId)) {
                objLen += SSCUtil.objectLength(orgId);
                para.addAll(Arrays.asList(orgId.split(",")));
            }
            if (!StringUtils.isEmpty((String)userId)) {
                objLen += SSCUtil.objectLength(SSCUtil.objectLength(userId));
                para.addAll(Arrays.asList(userId.split(",")));
            }
            if (!("10000".equals(jobState) || "30".equals(jobState) || "20".equals(jobState) || "40".equals(jobState) || "1".equals(jobState))) {
                para.add(jobState);
            }
            if (!StringUtils.isEmpty((String)subject)) {
                para.add("%" + subject + "%");
            }
            Object[] obj = new Object[para.size()];
            for (int i = 0; i < para.size(); ++i) {
                obj[i] = para.get(i);
            }
            String timeStr = null;
            if (isAll) {
                String clearTmpTableDataSql = "delete from T_SSC_ForMTDReport where FCreateTime < ADD_HOURS(NOW(),-1);";
                SSCDbUtil.execute((Context)ctx, (String)clearTmpTableDataSql);
                String ctxUserId = ctx.getCaller().toString();
                timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date());
                String insertSql = "INSERT INTO T_SSC_ForMTDReport(FProclnstId,FUserId,FCreateTime) SELECT fproclnstid,'" + ctxUserId + "',{ts'" + timeStr + "'} FROM (" + billTypeListSql + ") tmp";
                SSCDbUtil.execute((Context)ctx, (String)insertSql, (Object[])obj);
                obj = new Object[]{};
                billTypeListSql = "select fproclnstid from T_SSC_ForMTDReport where FUserId = '" + ctxUserId + "' and FCreateTime = {ts'" + timeStr + "'}";
            }
            String sql = TaskReportUtil.getCountSql(billTypeListSql);
            rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            logger.error((Object)("sql:" + sql));
            logger.error((Object)("obj:" + obj.toString()));
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt(1);
                }
            }
            if (totalCount == 0) {
                return result;
            }
            DecimalFormat decimalFormat = new DecimalFormat("#0.00");
            TreeMap<String, Map<String, Object>> tm = new TreeMap<String, Map<String, Object>>();
            if (!isAll) {
                if (!StringUtils.isEmpty((String)sidx)) {
                    billTypeListSql = billTypeListSql + " order by billtype ";
                    if (!StringUtils.isEmpty((String)sord)) {
                        billTypeListSql = billTypeListSql + sord;
                    }
                }
                rowSet = SSCDbUtil.executeQuery(ctx, billTypeListSql, obj, iStartIndex, iRowCount);
                StringBuffer sbu = new StringBuffer(iRowCount * 44);
                while (rowSet.next()) {
                    sbu.append(",'").append(rowSet.getString(1)).append("'");
                }
                billTypeListSql = sbu.length() > 0 ? sbu.substring(1) : "";
            }
            String dataSql = TaskReportUtil.getMutiTaskDataSql(billTypeListSql, sord, sidx);
            rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)dataSql);
            logger.error((Object)("dataSql:" + dataSql));
            while (rowSet.next()) {
                billType = rowSet.getString("billType");
                subject = rowSet.getString("fsubject");
                jobState = rowSet.getString("fjobstate");
                String dealPerson = rowSet.getString("username");
                Time lastUpdateTime = rowSet.getTime("flastupdatetime");
                int lvl = rowSet.getInt("flevel");
                if (lvl > iMaxLvl) {
                    iMaxLvl = lvl;
                }
                long consumingTime = 0L;
                String proclnstid = rowSet.getString("fproclnstid");
                Map<String, Object> rec = tm.get(proclnstid);
                if (rec == null) {
                    rec = new HashMap<String, Object>();
                    rec.put("billType", billType);
                    rec.put("subject", subject);
                    rec.put("totalTimeConsuming", 0L);
                    tm.put(proclnstid, rec);
                }
                long l = consumingTime = rowSet.getBigDecimal("costTime") == null ? 0L : rowSet.getBigDecimal("costTime").multiply(new BigDecimal(3600)).longValue();
                if (rec.get("jobState" + lvl) == null) {
                    rec.put("jobState" + lvl, this.getJobStateDisplayAlias(jobState));
                    rec.put("dealPerson" + lvl, dealPerson);
                    rec.put("timeConsuming" + lvl, consumingTime);
                    rec.put("lastUpdateTime" + lvl, lastUpdateTime);
                } else {
                    java.util.Date lut = (java.util.Date)rec.get("lastUpdateTime" + lvl);
                    if (lastUpdateTime.after(lut)) {
                        rec.put("jobState" + lvl, this.getJobStateDisplayAlias(jobState));
                        rec.put("dealPerson" + lvl, dealPerson);
                        rec.put("lastUpdateTime" + lvl, lastUpdateTime);
                    }
                    long ct = (Long)rec.get("timeConsuming" + lvl);
                    rec.put("timeConsuming" + lvl, ct + consumingTime);
                }
                Long tt = (Long)rec.get("totalTimeConsuming");
                rec.put("totalTimeConsuming", consumingTime + tt);
            }
            this._formatNumber(tm, decimalFormat);
            recList.addAll(tm.values());
            tm = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SSCException(SSCException.UNKNOW, e, new Object[]{e.getMessage()});
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", recList);
        result.put("maxLvl", iMaxLvl);
        logger.error((Object)("recList:" + ((Object)recList).toString()));
        return result;
    }

    private void _formatNumber(TreeMap<String, Map<String, Object>> tm, DecimalFormat decimalFormat) {
        for (Map<String, Object> m : tm.values()) {
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                if (!entry.getKey().startsWith("timeConsuming") && !entry.getKey().equals("totalTimeConsuming")) continue;
                m.put(entry.getKey(), DateUtil.formatDisplay((Long)entry.getValue()));
            }
        }
    }

    private String getJobStateDisplayAlias(String jsValue) {
        return JobState.getEnum(jsValue).getAlias();
    }

    @Override
    protected String _getMutiTaskDetailData(Context ctx, String param) throws BOSException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getMutiTaskDetailData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    private Map<String, String> getBizAttrOrgUser(Map solutionMap, Context ctx) throws BOSException, SSCException {
        HashMap<String, String> whereSqlMap = new HashMap<String, String>();
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        Boolean isOnlyAuditJob = (Boolean)solutionMap.get("isOnlyAuditJob");
        String extendErpId = (String)solutionMap.get("extendErpId");
        String extendErpIdSql = "";
        if (!StringUtils.isEmpty((String)extendErpId)) {
            extendErpId = SSCStringUtils.getSQLStrBySplitStr(extendErpId);
            extendErpIdSql = " AND SYSATTR.FEXTENDERPID IN (" + extendErpId + ")";
        }
        String topShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        String bizAttrIdSql = "SELECT FID FROM T_SSC_BUSSINESSATTRIBUTE";
        bizAttrIdSql = bizAttrIdSql + " WHERE (FSHARECENTERID IN (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")) or (FSHARECENTERID IN ('" + topShareCenterId + "')";
        if (isOnlyAuditJob != null && isOnlyAuditJob.booleanValue()) {
            bizAttrIdSql = bizAttrIdSql + " AND FJobClassification = 1 ";
        }
        bizAttrIdSql = bizAttrIdSql + ")";
        bizAttrIdSql = "SELECT DISTINCT t4.FID bizAttrId FROM T_SSC_SysAttrOrgSCMap t1 LEFT JOIN T_SSC_SystemAttribute t2 ON t1.FSystemAttributeID = t2.FID LEFT JOIN T_SSC_BILLTYPE t3 ON t3.FSYSATTRID = t2.FID LEFT JOIN T_SSC_BUSSINESSATTRIBUTE t4 ON t4.FBILLTYPEID = t3.FID WHERE t1.FShareCenterID IN (" + this.getShareCenter(ctx, solutionMap) + ") AND t4.FID IN (" + bizAttrIdSql + ")";
        String orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN (" + this.getShareCenter(ctx, solutionMap) + ")";
        String userIdSql = "SELECT FID FROM T_SSC_USER WHERE FShareCenterId in (" + this.getShareCenter(ctx, solutionMap) + ")";
        whereSqlMap.put("bizAttrIds", bizAttrIdSql);
        whereSqlMap.put("orgIds", orgIdSql);
        whereSqlMap.put("userIds", userIdSql);
        whereSqlMap.put("extendErpIds", extendErpIdSql);
        return whereSqlMap;
    }

    private String getShareCenter(Context ctx, Map solutionMap) throws BOSException {
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        if (StringUtils.isEmpty((String)shareCenterId)) {
            return ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId);
        }
        return "'" + shareCenterId + "'";
    }

    private String getTaskPro(Context ctx, Map solutionMap) throws BOSException {
        String newEndDate;
        String newStartDate;
        String userId;
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        Boolean isOnlyAuditJob = (Boolean)solutionMap.get("isOnlyAuditJob");
        String bizTypeId = (String)solutionMap.get("bizTypeId");
        String extendErpId = (String)solutionMap.get("extendErpId");
        String orgId = (String)solutionMap.get("orgId");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            extendErpId = SSCStringUtils.getSQLStrBySplitStr(extendErpId);
        }
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            bizTypeId = "'" + bizTypeId.replaceAll(",", "','") + "'";
        }
        if (!StringUtils.isEmpty((String)(userId = (String)solutionMap.get("userid")))) {
            userId = "'" + userId.replaceAll(",", "','") + "'";
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
        }
        if (isOnlyAuditJob == null) {
            isOnlyAuditJob = false;
        }
        String topShareCenterId = "";
        try {
            topShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        StringBuffer buffer = new StringBuffer(1500);
        StringBuffer startBuffer = new StringBuffer("select sum(TT.finish) finish, sum(TT.untreated) untreated, sum(TT.deal) deal ");
        String stat_dimension = (String)solutionMap.get(RptConstant.STAT_DIMENSION);
        buffer.append("select t1.finish,t2.untreated,t3.deal ");
        StringBuilder sql_on = new StringBuilder();
        StringBuilder sql_on2 = new StringBuilder();
        StringBuilder orderStr = new StringBuilder("order by");
        StringBuilder groupStr = new StringBuilder(" AS TT group by");
        if (stat_dimension.indexOf("showBizType") > -1) {
            buffer.append(",case when t1.bizType is not null  then t1.bizType  when t2.bizType is not null  then t2.bizType else t3.bizType end bizType");
            buffer.append(",case when t1.bizTypeId is not null then t1.bizTypeId  when t2.bizTypeId is not null then t2.bizTypeId else t3.bizTypeId end bizTypeId");
            sql_on.append(" and t1.bizTypeId = t2.bizTypeId");
            sql_on2.append(" and t1.bizTypeId = t3.bizTypeId");
            orderStr.append(" bizType,");
            startBuffer.append(", TT.bizType bizType, TT.bizTypeId bizTypeId");
            groupStr.append(" TT.bizType, TT.bizTypeId,");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            buffer.append(",case when t1.orgname is not null then t1.orgname  when t2.orgname is not null then t2.orgname else t3.orgname end orgname");
            buffer.append(",case when t1.orgId is not null then t1.orgId  when t2.orgId is not null then t2.orgId  else t3.orgId end orgId");
            sql_on.append(" and t1.orgId = t2.orgId");
            sql_on2.append(" and t1.orgId = t3.orgId");
            orderStr.append(" orgname,");
            startBuffer.append(", TT.orgname orgname,TT.orgId orgId");
            groupStr.append(" TT.orgId,TT.orgname,");
        }
        if (stat_dimension.indexOf("showDealPerson") > -1) {
            buffer.append(",case when t1.username is not null then t1.username  when t2.username is not null then t2.username else t3.username end username");
            buffer.append(",case when t1.userno is not null then t1.userno when t2.userno is not null then t2.userno else t3.userno end userno");
            sql_on.append(" and t1.userno = t2.userno");
            sql_on2.append(" and t1.userno = t3.userno ");
            orderStr.append(" username,");
            startBuffer.append(", TT.username username,TT.userno userno");
            groupStr.append(" TT.username ,TT.userno,");
        }
        startBuffer.append(" from ");
        buffer = startBuffer.append(buffer);
        orderStr = new StringBuilder(orderStr.subSequence(0, orderStr.length() - 1));
        groupStr = new StringBuilder(groupStr.subSequence(0, groupStr.length() - 1));
        groupStr.append(" ");
        buffer.append(" from (select * from (select count(1) finish,");
        buffer.append("              tb.fname_l2 bizType, ");
        buffer.append("              tb.fid bizTypeId, ");
        buffer.append("              tg.fname_l2 orgname, ");
        buffer.append("              tg.fid orgId, ");
        buffer.append("              tu.fname_l2 username, ");
        buffer.append("              tu.fnumber userno, ");
        buffer.append("              tu.fid userId ");
        buffer.append("         from t_ssc_jobhis tj ");
        buffer.append("         inner join t_ssc_bussinessAttribute tb ");
        buffer.append("           on tj.fbussattridid = tb.fid ");
        buffer.append("         inner join t_ssc_org tg ");
        buffer.append("           on tj.forgidid = tg.fid ");
        buffer.append("         left join t_ssc_user tu ");
        buffer.append("           on tj.fpersonnelidid = tu.fid ");
        buffer.append("        where 1 = 1 ");
        buffer.append("          and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("          and exists ");
        buffer.append("              (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                 FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                 inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                   ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                 inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                   ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                 inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                   ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                WHERE t1.FShareCenterID IN ");
        buffer.append("                      (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                  AND t4.FID IN ");
        buffer.append("                      (SELECT DISTINCT FID ");
        buffer.append("                         FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                        WHERE FSHARECENTERID IN ");
        buffer.append("                              (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       UNION ");
        buffer.append("                       SELECT DISTINCT FID ");
        buffer.append("                         FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                        WHERE FSHARECENTERID IN ");
        buffer.append("                              ('" + topShareCenterId + "')) ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                              and tb.fid = t4.FID ");
        buffer.append("                              and tg.fid = t1.FOrgid ");
        buffer.append("                              and tu.FShareCenterId = t1.FShareCenterId ");
        buffer.append("                              ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.fcompletetme >=").append(newStartDate);
            buffer.append(" and tj.fcompletetme <=").append(newEndDate);
        }
        buffer.append("        group by tb.fname_l2, ");
        buffer.append("                 tb.fid, ");
        buffer.append("                 tg.fname_l2, ");
        buffer.append("                 tg.fid, ");
        buffer.append("                 tu.fname_l2, ");
        buffer.append("                 tu.fnumber, ");
        buffer.append("                 tu.fid) t ) t1 ");
        buffer.append(" full join (select * from ( select sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '1' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) untreated, ");
        buffer.append("                   sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '2' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) deal, ");
        buffer.append("                   tb.fname_l2 bizType, ");
        buffer.append("                   tb.fid bizTypeId, ");
        buffer.append("                   tg.fname_l2 orgname, ");
        buffer.append("                   tg.fid orgId, ");
        buffer.append("                   tu.fname_l2 username, ");
        buffer.append("                   tu.fnumber userno, ");
        buffer.append("                   tu.fid userId ");
        buffer.append("              from t_ssc_job tj ");
        buffer.append("              inner join t_ssc_bussinessAttribute tb ");
        buffer.append("                on tj.fbussattridid = tb.fid ");
        buffer.append("              inner join t_ssc_org tg ");
        buffer.append("                on tj.forgidid = tg.fid ");
        buffer.append("              left join t_ssc_user tu ");
        buffer.append("                on tj.fpersonnelidid = tu.fid ");
        buffer.append("             where 1 = 1 ");
        buffer.append("               and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("               and  ");
        buffer.append("               exists ");
        buffer.append("                   (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                      FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                      inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                        ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                        ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                        ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                     WHERE t1.FShareCenterID IN ");
        buffer.append("                           (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       AND t4.FID IN ");
        buffer.append("                           (SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                            UNION ");
        buffer.append("                            SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   ('" + topShareCenterId + "')) ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                                  and tb.fid = t4.FID ");
        buffer.append("                                   and tg.fid = t1.FOrgid ");
        buffer.append("                                   ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.fcreatetime >=").append(newStartDate);
            buffer.append(" and tj.fcreatetime <=").append(newEndDate);
        }
        buffer.append("               and tj.FJOBPOOLINGTYPE = '1' ");
        buffer.append("             group by tb.fname_l2, ");
        buffer.append("                      tb.fid, ");
        buffer.append("                      tg.fname_l2, ");
        buffer.append("                      tg.fid, ");
        buffer.append("                      tu.fname_l2, ");
        buffer.append("                      tu.fnumber, ");
        buffer.append("                      tu.fid) t ) t2 ");
        buffer.append("   on 1 = 1 ");
        buffer.append("  and t1.bizTypeId = t2.bizTypeId ");
        buffer.append("  and t1.orgId = t2.orgId ");
        buffer.append("  and t1.userno = t2.userno ");
        buffer.append(" full join (select * from ( select sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '1' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) untreated, ");
        buffer.append("                   sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '2' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) deal, ");
        buffer.append("                   tb.fname_l2 bizType, ");
        buffer.append("                   tb.fid bizTypeId, ");
        buffer.append("                   tg.fname_l2 orgname, ");
        buffer.append("                   tg.fid orgId, ");
        buffer.append("                   tu.fname_l2 username, ");
        buffer.append("                  tu.fnumber userno, ");
        buffer.append("                   tu.fid userId ");
        buffer.append("              from t_ssc_job tj ");
        buffer.append("              inner join t_ssc_bussinessAttribute tb ");
        buffer.append("                on tj.fbussattridid = tb.fid ");
        buffer.append("              inner join t_ssc_org tg ");
        buffer.append("               on tj.forgidid = tg.fid ");
        buffer.append("              left join t_ssc_user tu ");
        buffer.append("                on tj.fpersonnelidid = tu.fid ");
        buffer.append("             where 1 = 1 ");
        buffer.append("               and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("               and  ");
        buffer.append("               exists ");
        buffer.append("                   (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                      FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                      inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                        ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                        ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                        ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                     WHERE t1.FShareCenterID IN ");
        buffer.append("                           (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       AND t4.FID IN ");
        buffer.append("                           (SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                            UNION ");
        buffer.append("                            SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   ('" + topShareCenterId + "')) ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                                   and tb.fid = t4.FID ");
        buffer.append("                                   and tu.fsharecenterid = t1.FShareCenterID ");
        buffer.append("                                   and tg.fid = t1.FOrgid ");
        buffer.append("                                   ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.FRECEIVETIME >=").append(newStartDate);
            buffer.append(" and tj.FRECEIVETIME <=").append(newEndDate);
        }
        buffer.append("               and tj.FJOBPOOLINGTYPE = '2' ");
        buffer.append("             group by tb.fname_l2, ");
        buffer.append("                     tb.fid, ");
        buffer.append("                      tg.fname_l2, ");
        buffer.append("                      tg.fid, ");
        buffer.append("                      tu.fname_l2, ");
        buffer.append("                      tu.fnumber, ");
        buffer.append("                      tu.fid) t ) t3 ");
        buffer.append("   on 1 = 1 ");
        buffer.append("  and t1.bizTypeId = t3.bizTypeId ");
        buffer.append("  and t1.orgId = t3.orgId ");
        buffer.append("  and t1.userno = t3.userno ");
        buffer.append((CharSequence)groupStr);
        buffer.append((CharSequence)orderStr);
        logger.error((Object)("\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1\u8868\u4f18\u5316\u540e\u7684sql:" + buffer.toString()));
        return buffer.toString();
    }

    private String getTaskProChar(Context ctx, Map solutionMap) throws BOSException {
        String newEndDate;
        String newStartDate;
        String userId;
        String EASUserId = (String)solutionMap.get("EASUserId");
        String permissionId = (String)solutionMap.get("permissionId");
        String shareCenterId = (String)solutionMap.get("shareCenter.id");
        Boolean isOnlyAuditJob = (Boolean)solutionMap.get("isOnlyAuditJob");
        String bizTypeId = (String)solutionMap.get("bizTypeId");
        String extendErpId = (String)solutionMap.get("extendErpId");
        String orgId = (String)solutionMap.get("orgId");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            extendErpId = SSCStringUtils.getSQLStrBySplitStr(extendErpId);
        }
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            bizTypeId = "'" + bizTypeId.replaceAll(",", "','") + "'";
        }
        if (!StringUtils.isEmpty((String)(userId = (String)solutionMap.get("userid")))) {
            userId = "'" + userId.replaceAll(",", "','") + "'";
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
        }
        if (isOnlyAuditJob == null) {
            isOnlyAuditJob = false;
        }
        String topShareCenterId = "";
        try {
            topShareCenterId = ShareCenterUtils.getTopShareCenter(ctx).getId().toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(" select t1.finish,t2.untreated,t3.deal ");
        buffer.append(" from (select count(1) finish");
        buffer.append("         from t_ssc_jobhis tj ");
        buffer.append("         inner join t_ssc_bussinessAttribute tb ");
        buffer.append("           on tj.fbussattridid = tb.fid ");
        buffer.append("         inner join t_ssc_org tg ");
        buffer.append("           on tj.forgidid = tg.fid ");
        buffer.append("         left join t_ssc_user tu ");
        buffer.append("           on tj.fpersonnelidid = tu.fid ");
        buffer.append("        where 1 = 1 ");
        buffer.append("          and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("          and exists ");
        buffer.append("              (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                 FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                 inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                   ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                 inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                   ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                 inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                   ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                WHERE t1.FShareCenterID IN ");
        buffer.append("                      (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                  AND t4.FID IN ");
        buffer.append("                      (SELECT DISTINCT FID ");
        buffer.append("                         FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                        WHERE FSHARECENTERID IN ");
        buffer.append("                              (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       UNION ");
        buffer.append("                       SELECT DISTINCT FID ");
        buffer.append("                         FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                        WHERE FSHARECENTERID IN ");
        buffer.append("                              ('" + topShareCenterId + "')) ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                              and tb.fid = t4.FID ");
        buffer.append("                              and tg.fid = t1.FOrgid ");
        buffer.append("                              and tu.FShareCenterId = t1.FShareCenterId ");
        buffer.append("                              ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        String startDate = (String)solutionMap.get("startDate");
        String endDate = (String)solutionMap.get("endDate");
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.fcompletetme >=").append(newStartDate);
            buffer.append(" and tj.fcompletetme <=").append(newEndDate);
        }
        buffer.append("                 ) t1 ");
        buffer.append(" full join (select sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '1' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) untreated, ");
        buffer.append("                   sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '2' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) deal");
        buffer.append("              from t_ssc_job tj ");
        buffer.append("              inner join t_ssc_bussinessAttribute tb ");
        buffer.append("                on tj.fbussattridid = tb.fid ");
        buffer.append("              inner join t_ssc_org tg ");
        buffer.append("                on tj.forgidid = tg.fid ");
        buffer.append("              left join t_ssc_user tu ");
        buffer.append("                on tj.fpersonnelidid = tu.fid ");
        buffer.append("             where 1 = 1 ");
        buffer.append("               and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("               and  ");
        buffer.append("               exists ");
        buffer.append("                   (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                      FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                      inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                        ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                        ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                        ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                     WHERE t1.FShareCenterID IN ");
        buffer.append("                           (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       AND t4.FID IN ");
        buffer.append("                           (SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                            UNION ");
        buffer.append("                            SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   ('" + topShareCenterId + "')) ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                                  and tb.fid = t4.FID ");
        buffer.append("                                   and tg.fid = t1.FOrgid ");
        buffer.append("                                   ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.fcreatetime >=").append(newStartDate);
            buffer.append(" and tj.fcreatetime <=").append(newEndDate);
        }
        buffer.append("               and tj.FJOBPOOLINGTYPE = '1' ");
        buffer.append("                      ) t2 ");
        buffer.append("   on 1 = 1 ");
        buffer.append(" full join (select sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '1' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) untreated, ");
        buffer.append("                   sum(case ");
        buffer.append("                         when tj.fjobpoolingtype = '2' then ");
        buffer.append("                          1 ");
        buffer.append("                       end) deal ");
        buffer.append("              from t_ssc_job tj ");
        buffer.append("              inner join t_ssc_bussinessAttribute tb ");
        buffer.append("                on tj.fbussattridid = tb.fid ");
        buffer.append("              inner join t_ssc_org tg ");
        buffer.append("               on tj.forgidid = tg.fid ");
        buffer.append("              left join t_ssc_user tu ");
        buffer.append("                on tj.fpersonnelidid = tu.fid ");
        buffer.append("             where 1 = 1 ");
        buffer.append("               and tj.fjobstate <> '5' ");
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            buffer.append("          and tj.fshareCenterId in ('" + shareCenterId + "') ");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            buffer.append("          and tj.forgIdId in (" + orgId + ") ");
        }
        buffer.append("               and  ");
        buffer.append("               exists ");
        buffer.append("                   (SELECT DISTINCT t4.FID bizAttrId ");
        buffer.append("                      FROM T_SSC_SysAttrOrgSCMap t1 ");
        buffer.append("                      inner JOIN T_SSC_SystemAttribute t2 ");
        buffer.append("                        ON t1.FSystemAttributeID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BILLTYPE t3 ");
        buffer.append("                        ON t3.FSYSATTRID = t2.FID ");
        buffer.append("                      inner JOIN T_SSC_BUSSINESSATTRIBUTE t4 ");
        buffer.append("                        ON t4.FBILLTYPEID = t3.FID ");
        buffer.append("                     WHERE t1.FShareCenterID IN ");
        buffer.append("                           (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                       AND t4.FID IN ");
        buffer.append("                           (SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ") ");
        buffer.append("                            UNION ");
        buffer.append("                            SELECT DISTINCT FID ");
        buffer.append("                              FROM T_SSC_BUSSINESSATTRIBUTE ");
        buffer.append("                             WHERE FSHARECENTERID IN ");
        buffer.append("                                   ('" + topShareCenterId + "')) ");
        buffer.append("                                   and tb.fid = t4.FID ");
        if (!StringUtils.isEmpty((String)extendErpId)) {
            buffer.append(" and t2.FEXTENDERPID in (" + extendErpId + ")");
        }
        buffer.append("                                   and tu.fsharecenterid = t1.FShareCenterID ");
        buffer.append("                                   and tg.fid = t1.FOrgid ");
        buffer.append("                                   ) ");
        if (!StringUtils.isEmpty((String)bizTypeId)) {
            buffer.append(" and tb.fid in(").append(bizTypeId).append(")");
        }
        if (!StringUtils.isEmpty((String)userId)) {
            buffer.append(" and tu.fid in(").append(userId).append(")");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            newStartDate = DateUtil.dateToTsDate(startDate);
            newEndDate = DateUtil.dateToTsDate(endDate);
            buffer.append(" and tj.FRECEIVETIME >=").append(newStartDate);
            buffer.append(" and tj.FRECEIVETIME <=").append(newEndDate);
        }
        buffer.append("               and tj.FJOBPOOLINGTYPE = '2' ");
        buffer.append("                      ) t3 ");
        buffer.append("   on 1 = 1 ");
        logger.error((Object)("\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1\u8868char\u4f18\u5316\u540e\u7684sql:" + buffer.toString()));
        return buffer.toString();
    }

    @Override
    protected String _getSummaryOfWork(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        String CheckUnQuantitySql;
        String JobRollBackSelectSql;
        String sampleLibrarySelectSql;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Map> records = new ArrayList<Map>();
        HashMap<String, Map<String, String>> userInfo = new HashMap<String, Map<String, String>>();
        Map<String, String> row = new HashMap();
        IRowSet rowSet = null;
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String dateFrom = (String)solutionMap.get("dateFrom");
        String dateTo = (String)solutionMap.get("dateTo");
        String groupUserId = (String)solutionMap.get("groupUserId");
        String userId = (String)solutionMap.get("userId");
        String selectShareCenterId = (String)solutionMap.get("selectShareCenterId");
        String extendErpId = (String)solutionMap.get("extendErpId");
        if (StringUtils.isEmpty((String)userId) || "''".equals(userId)) {
            return JSONUtils.convertObjectToJson((Context)ctx, result);
        }
        if (!StringUtils.isEmpty((String)extendErpId)) {
            extendErpId = SSCStringUtils.getSQLStrBySplitStr(extendErpId);
        }
        if (StringUtils.isEmpty((String)selectShareCenterId)) {
            String EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
            selectShareCenterId = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, "58cc63c7-a447-443a-9bab-e64d06975853PERMITEM");
        } else {
            selectShareCenterId = SSCStringUtils.getSQLStrBySplitStr(selectShareCenterId);
        }
        String queryUuid = (String)solutionMap.get("queryUuid");
        Uuid uuid = null;
        if (queryUuid != null) {
            uuid = Uuid.read((String)queryUuid);
        }
        int page = Integer.parseInt(new DecimalFormat("0").format(Double.parseDouble(solutionMap.get("page").toString())));
        String jobHIsSelectSql = TaskReportUtil.getJobHisSelectWorkSql(dateFrom, dateTo, groupUserId, userId, selectShareCenterId, extendErpId);
        rowSet = DbUtil.executeQuery((Context)ctx, (String)jobHIsSelectSql);
        double sscJobQuantity = 0.0;
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    String preGroupName;
                    String userSscJobQuantity;
                    String userID = rowSet.getString("userid");
                    String groupID = rowSet.getString("groupid");
                    String attrId = rowSet.getString("attrid");
                    double standardNum = rowSet.getDouble("standardNum");
                    String userName = rowSet.getString("username");
                    String groupName = rowSet.getString("groupname");
                    if (row.get("sscJobQuantity") != null && (userSscJobQuantity = row.get("sscJobQuantity").toString()) != null) {
                        sscJobQuantity = Double.parseDouble(userSscJobQuantity);
                    }
                    if (row.get("userid") == null || row.get("userid") != null && !row.get("userid").toString().equals(userID)) {
                        row = this.initUserMap(userID, userName, groupID, groupName);
                        sscJobQuantity = 0.0;
                    }
                    if (!StringUtils.isEmpty((String)(preGroupName = (String)row.get("groupUser"))) && !preGroupName.contains(groupName)) {
                        row.put("groupUser", preGroupName + "/" + groupName);
                    }
                    if (row.get("attrId").toString().equals(attrId)) continue;
                    row.put("attrId", attrId);
                    row.put("sscJobQuantity", (String)((Object)new BigDecimal(sscJobQuantity + standardNum)));
                    userInfo.put(userID, row);
                }
                Set userIdSet = userInfo.keySet();
                for (String userID : userIdSet) {
                    String userSscJobQuantity;
                    Map rowIt = (Map)userInfo.get(userID);
                    if (rowIt.get("sscJobQuantity") == null || (userSscJobQuantity = rowIt.get("sscJobQuantity").toString()) == null) continue;
                    sscJobQuantity = Double.parseDouble(userSscJobQuantity);
                    rowIt.put("sscJobQuantity", new BigDecimal(sscJobQuantity).setScale(2, 4));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sampleLibrarySelectSql = TaskReportUtil.getSampleLibraryQualityTaskSelectWorkSql(dateFrom, dateTo, groupUserId, userId, selectShareCenterId, extendErpId)))) != null) {
            try {
                while (rowSet.next()) {
                    row = new HashMap();
                    String userID = rowSet.getString("userid");
                    String groupID = rowSet.getString("groupid");
                    String billType = rowSet.getString("billType");
                    int choujianNum = rowSet.getInt("choujian");
                    int zhijianNum = rowSet.getInt("zhijian");
                    double standardCoe = rowSet.getDouble("standardcoe");
                    String userName = rowSet.getString("username");
                    String groupName = rowSet.getString("groupname");
                    double choujianallSum = (double)choujianNum * standardCoe;
                    double zhijianallSum = (double)zhijianNum * standardCoe;
                    row = userInfo.get(userID) != null ? (Map)userInfo.get(userID) : this.initUserMap(userID, userName, groupID, groupName);
                    if (row.get("userid") == null || row.get("userid") != null && row.get("userid").toString().equals(userID)) {
                        choujianallSum += Double.parseDouble(row.get("sscCheckQuantity").toString());
                        zhijianallSum += Double.parseDouble(row.get("sscQualityQuantity").toString());
                    }
                    if (row.get("billType").toString().equals(billType)) continue;
                    row.put("billType", billType);
                    row.put("sscCheckQuantity", (String)((Object)new BigDecimal(choujianallSum).setScale(2, 4)));
                    row.put("sscQualityQuantity", (String)((Object)new BigDecimal(zhijianallSum).setScale(2, 4)));
                    userInfo.put(userID, row);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(JobRollBackSelectSql = TaskReportUtil.getJobRollBackSelectSql(dateFrom, dateTo, groupUserId, userId, selectShareCenterId, extendErpId)))) != null) {
            try {
                while (rowSet.next()) {
                    String userID;
                    row = new HashMap();
                    userID = rowSet.getString("userid");
                    String groupID = rowSet.getString("groupid");
                    String billid = rowSet.getString("billid");
                    int billNum = 1;
                    String userName = rowSet.getString("username");
                    String groupName = rowSet.getString("groupname");
                    row = userInfo.get(userID) != null ? (Map)userInfo.get(userID) : this.initUserMap(userID, userName, groupID, groupName);
                    if (row.get("userid") == null || row.get("userid") != null && row.get("userid").toString().equals(userID)) {
                        String sumCheckUnQuantity = row.get("sumCallBack").toString();
                        if (sumCheckUnQuantity != null && sumCheckUnQuantity.indexOf(".") > 0) {
                            sumCheckUnQuantity = sumCheckUnQuantity.substring(0, 1);
                        }
                        billNum += Integer.parseInt(sumCheckUnQuantity);
                    }
                    if (row.get("rollBackBill").toString().equals(billid)) continue;
                    row.put("rollBackBill", billid);
                    row.put("sumCallBack", (String)((Object)Integer.valueOf(billNum)));
                    userInfo.put(userID, row);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if ((rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)(CheckUnQuantitySql = TaskReportUtil.getCheckschemeUnpassSql(dateFrom, dateTo, groupUserId, userId, selectShareCenterId, extendErpId)))) != null) {
            try {
                while (rowSet.next()) {
                    row = new HashMap();
                    String userID = rowSet.getString("userid");
                    String groupID = rowSet.getString("groupid");
                    String billid = rowSet.getString("billid");
                    int billNum = rowSet.getInt("billNum");
                    String userName = rowSet.getString("username");
                    String groupName = rowSet.getString("groupname");
                    row = userInfo.get(userID) != null ? (Map)userInfo.get(userID) : this.initUserMap(userID, userName, groupID, groupName);
                    if (row.get("userid") == null || row.get("userid") != null && row.get("userid").toString().equals(userID)) {
                        String sumCheckUnQuantity = row.get("sumCheckUnQuantity").toString();
                        if (sumCheckUnQuantity != null && sumCheckUnQuantity.indexOf(".") > 0) {
                            sumCheckUnQuantity = sumCheckUnQuantity.substring(0, 1);
                        }
                        billNum += Integer.parseInt(sumCheckUnQuantity);
                    }
                    if (row.get("billid").toString().equals(billid)) continue;
                    row.put("billid", billid);
                    row.put("sumCheckUnQuantity", (String)((Object)Integer.valueOf(billNum)));
                    userInfo.put(userID, row);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HashMap<String, Object> sumM = new HashMap<String, Object>();
        Set key = userInfo.keySet();
        String sscJobQuantitystr = null;
        String sscCheckQuantitystr = null;
        String sscQualityQuantitystr = null;
        String groupSumCheckUnQuantitystr = null;
        String groupSumCallBackstr = null;
        for (String s : key) {
            Map info = (Map)userInfo.get(s);
            sscJobQuantitystr = info.get("sscJobQuantity").toString();
            sscCheckQuantitystr = info.get("sscCheckQuantity").toString();
            sscQualityQuantitystr = info.get("sscQualityQuantity").toString();
            groupSumCheckUnQuantitystr = info.get("sumCheckUnQuantity").toString();
            groupSumCallBackstr = info.get("sumCallBack").toString();
            info.put("totalSum", new BigDecimal(Double.parseDouble(sscJobQuantitystr) + Double.parseDouble(sscCheckQuantitystr) + Double.parseDouble(sscQualityQuantitystr)).setScale(2, 4));
            records.add(info);
            String sscJobQuantityValue = null;
            if (sumM.get("sscJobQuantity") != null) {
                sscJobQuantityValue = sumM.get("sscJobQuantity").toString();
            }
            if (sscJobQuantityValue != null) {
                sumM.put("sscJobQuantity", new BigDecimal(Double.parseDouble(sscJobQuantityValue) + Double.parseDouble(sscJobQuantitystr)).setScale(2, 4));
            } else {
                sumM.put("sscJobQuantity", new BigDecimal(sscJobQuantitystr).setScale(2, 4));
            }
            String sscCheckQuantityValue = null;
            if (sumM.get("sscCheckQuantity") != null) {
                sscCheckQuantityValue = sumM.get("sscCheckQuantity").toString();
            }
            if (sscCheckQuantityValue != null) {
                sumM.put("sscCheckQuantity", new BigDecimal(Double.parseDouble(sscCheckQuantityValue) + Double.parseDouble(sscCheckQuantitystr)).setScale(2, 4));
            } else {
                sumM.put("sscCheckQuantity", new BigDecimal(sscCheckQuantitystr).setScale(2, 4));
            }
            String sscQualityQuantityValue = null;
            if (sumM.get("sscQualityQuantity") != null) {
                sscQualityQuantityValue = sumM.get("sscQualityQuantity").toString();
            }
            if (sscQualityQuantityValue != null) {
                sumM.put("sscQualityQuantity", new BigDecimal(Double.parseDouble(sscQualityQuantityValue) + Double.parseDouble(sscQualityQuantitystr)).setScale(2, 4));
            } else {
                sumM.put("sscQualityQuantity", new BigDecimal(sscQualityQuantitystr).setScale(2, 4));
            }
            String SumCheckUnQuantityValue = null;
            if (sumM.get("sumCheckUnQuantity") != null) {
                SumCheckUnQuantityValue = sumM.get("sumCheckUnQuantity").toString();
            }
            if (SumCheckUnQuantityValue != null) {
                sumM.put("sumCheckUnQuantity", new BigDecimal(Double.parseDouble(SumCheckUnQuantityValue) + Double.parseDouble(groupSumCheckUnQuantitystr)).setScale(2, 4));
            } else {
                sumM.put("sumCheckUnQuantity", new BigDecimal(groupSumCheckUnQuantitystr).setScale(2, 4));
            }
            String groupSumCallBackValue = null;
            if (sumM.get("sumCallBack") != null) {
                groupSumCallBackValue = sumM.get("sumCallBack").toString();
            }
            if (groupSumCallBackValue != null) {
                sumM.put("sumCallBack", new BigDecimal(Double.parseDouble(groupSumCallBackValue) + Double.parseDouble(groupSumCallBackstr)).setScale(2, 4));
            } else {
                sumM.put("sumCallBack", new BigDecimal(groupSumCallBackstr).setScale(2, 4));
            }
            String sumstrValue = null;
            if (sumM.get("totalSum") != null) {
                sumstrValue = sumM.get("totalSum").toString();
            }
            if (sumstrValue != null) {
                sumM.put("totalSum", new BigDecimal(Double.parseDouble(sumstrValue) + Double.parseDouble(sscJobQuantitystr) + Double.parseDouble(sscCheckQuantitystr) + Double.parseDouble(sscQualityQuantitystr)).setScale(2, 4));
                continue;
            }
            sumM.put("totalSum", new BigDecimal(Double.parseDouble(sscJobQuantitystr) + Double.parseDouble(sscCheckQuantitystr) + Double.parseDouble(sscQualityQuantitystr)).setScale(2, 4));
        }
        if (records.size() > 0) {
            sumM.put("userName", "\u5168\u90e8\u5408\u8ba1\uff1a");
            HashMap<String, Object> userdata = null;
            userdata = sumM;
            result.put("userdata", userdata);
        }
        if (uuid != null) {
            result.put("uuid", uuid.toString());
        }
        result.put("page", page);
        result.put("rows", records);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected Map _getOverdueTaskReport(Context ctx, Map param) throws BOSException, EASBizException {
        String shareCenterId = (String)param.get("shareCenter.id");
        if (!shareCenterId.contains("'")) {
            shareCenterId = "'" + shareCenterId + "'";
        }
        UserGroupCollection useGroupCollection = UserGroupFactory.getLocalInstance(ctx).getUserGroupCollection("select *,user.*,group.* where user.shareCenterId in (" + shareCenterId + ") order by user.id,isdefaultgroup desc,group.name");
        StringBuffer groups = new StringBuffer();
        HashMap<String, String> usergroup = new HashMap<String, String>();
        if (useGroupCollection != null && useGroupCollection.size() > 0) {
            for (int i = 0; i < useGroupCollection.size(); ++i) {
                UserGroupInfo userGroupInfo = useGroupCollection.get(i);
                if (usergroup.containsKey(userGroupInfo.getUser().getId().toString())) continue;
                usergroup.put(userGroupInfo.getUser().getId().toString(), userGroupInfo.getGroup().getId().toString() + ";" + userGroupInfo.getGroup().getName());
            }
            for (Map.Entry entry : usergroup.entrySet()) {
                groups.append(" select '" + (String)entry.getKey() + "' fuserid,'" + ((String)entry.getValue()).split(";")[0] + "' fid,'" + ((String)entry.getValue()).split(";")[1] + "' FNAME_L2 union all");
            }
            String groupTable = groups.substring(0, groups.length() - 10);
            param.put("groupTable", groupTable);
        } else {
            param.put("groupTable", "");
        }
        String strStartIndex = (String)param.get("startIndex");
        String strRowCount = (String)param.get("rowCount");
        int iStartIndex = 0;
        int iRowCount = 0;
        if (!StringUtils.isEmpty((String)strStartIndex) && !StringUtils.isEmpty((String)strRowCount)) {
            iStartIndex = Integer.parseInt(strStartIndex);
            iRowCount = Integer.parseInt(strRowCount);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList bizList = new ArrayList();
        Object _isAll = param.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        if (isAll) {
            iStartIndex = 0;
            iRowCount = Integer.MAX_VALUE;
        }
        Map<String, Object> sqlMap = TaskReportUtil.getOverdueTaskSql(param);
        String sql = sqlMap.get("sql").toString();
        IRowSet rowSet = SSCDbUtil.executeQuery(ctx, sql, (Object[])sqlMap.get("params"), iStartIndex, iRowCount);
        IRowSet rowSetCount = SSCDbUtil.executeQuery((Context)ctx, (String)TaskReportUtil.getCountSql(sql), (Object[])((Object[])sqlMap.get("params")));
        int totalCount = 0;
        try {
            DecimalFormat df = new DecimalFormat("##.00");
            while (rowSet.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                rec.put("userGroupName", rowSet.getString("userGroupName"));
                rec.put("userName", rowSet.getString("userName"));
                rec.put("handCount", rowSet.getString("handCount"));
                rec.put("overdueCount", null == rowSet.getString("overdueCount") ? "0" : rowSet.getString("overdueCount"));
                rec.put("overduePercent", (null == rowSet.getString("overdueCount") ? "0" : df.format(rowSet.getDouble("overduePercent"))) + "%");
                bizList.add(rec);
            }
            if (rowSetCount != null) {
                while (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt("count");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    @Override
    protected String _getOverdueTaskReport(Context ctx, String param) throws BOSException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getOverdueTaskReport(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected String _getJobRollBackData(Context ctx, String solution) throws BOSException, EASBizException {
        String EASUserId;
        String shareCenterId;
        String JobRollBackSelectSql;
        IRowSet rowSet;
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solution);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList records = new ArrayList();
        String dataType = (String)solutionMap.get("dataType");
        if (dataType == null || dataType.equals("")) {
            dataType = "MAP";
        }
        int page = Integer.parseInt(new DecimalFormat("0").format(Double.parseDouble(solutionMap.get("page").toString())));
        String queryUuid = (String)solutionMap.get("queryUuid");
        Uuid uuid = null;
        if (queryUuid != null) {
            uuid = Uuid.read((String)queryUuid);
        }
        String dateFrom = (String)solutionMap.get("dateFrom");
        String dateTo = (String)solutionMap.get("dateTo");
        String beCallBackUserId = (String)solutionMap.get("beCallBackUserId");
        String callBackUserId = (String)solutionMap.get("callBackUserId");
        if (uuid != null) {
            result.put("uuid", uuid.toString());
        }
        if ((rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)(JobRollBackSelectSql = this.getJobRollBackSelectSql(dateFrom, dateTo, beCallBackUserId, callBackUserId, shareCenterId = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx), "58cc63c7-a447-443a-9bab-e64d06975853PERMITEM"))))) != null) {
            HashMap<String, String> row = new HashMap<String, String>();
            try {
                while (rowSet.next()) {
                    row = new HashMap();
                    row.put("beCallBackPerson", rowSet.getString("beCallBackPerson"));
                    row.put("subject", rowSet.getString("subject"));
                    row.put("callBackPerson", rowSet.getString("callBackPerson"));
                    row.put("callBackReason", rowSet.getString("callBackReason"));
                    row.put("callBackTime", rowSet.getString("callBackTime"));
                    try {
                        ObjectUuidPK uuidPK = new ObjectUuidPK(rowSet.getString("billId"));
                        String bosType = uuidPK.getObjectType().toString();
                        BOSObjectType type = BOSObjectType.create((String)bosType);
                        IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)uuidPK);
                        if (billValue != null && billValue.get("number") != null) {
                            row.put("billNumber", billValue.get("number").toString());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    records.add(row);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        result.put("page", page);
        result.put("rows", records);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private String getJobRollBackSelectSql(String dateFrom, String dateTo, String beCallBackUserId, String callBackUserId, String shareCenterId) {
        String sql = "select jobhis.FSubject     subject, jobhis.FBillID     billId, tmp.FChangeTime     callBackTime, tmp.FMessages       callBackReason, callBack.fname_l2   callBackPerson, beCallBack.fname_l2 beCallBackPerson from t_ssc_jobhis jobhis inner join t_ssc_user beCallBack  on beCallBack.fid = jobhis.fpersonnelidid inner join (select DISTINCT jh.fbillid,  jh.fcompletetme,  jh.flevel,  jh.FIsLastLevel,   jh.FAutoApprove,  jsh.fid,                        jsh.FOperatorIDID,                         jsh.FChangeTime,                      jsh.FMessages       from T_SSC_jobstatimhis jsh     inner join t_ssc_jobhis jh       on jh.fid = jsh.fjobidid   inner join t_ssc_user u    on u.fid = jsh.foperatoridid  where jsh.foperation = '10'";
        if (callBackUserId != null && callBackUserId != "") {
            sql = sql + "   and u.fid in (" + callBackUserId + ")";
        }
        if (shareCenterId != null && shareCenterId != "") {
            sql = sql + " and jh.fshareCenterId in (" + shareCenterId + ") ";
        }
        sql = sql + "   and jh.fbillid in       (select fbillId          from T_SSC_JOBHIS        where (FIsLastLevel = '1' and FAutoApprove = '0' and             fcompletetme >= {ts '" + dateFrom + "'            } and fcompletetme <= {ts '" + dateTo + "' })     and (fjobstate = '3' or fjobstate = '4' or fjobstate = '10'))) tmp on tmp.fbillid = jobhis.fbillid and jobhis.flevel = tmp.flevel - 1 and jobhis.fcompletetme < tmp.fcompletetme inner join t_ssc_user callBack on callBack.fid = tmp.FOperatorIDID";
        if (beCallBackUserId != null && beCallBackUserId != "") {
            sql = sql + " where beCallBack.fid in (" + beCallBackUserId + ")";
        }
        if (shareCenterId != null && shareCenterId != "") {
            sql = sql + " and jobhis.fshareCenterId in (" + shareCenterId + ") ";
        }
        sql = sql + " order by jobhis.FBillID, beCallBack.fid, tmp.FChangeTime";
        return sql;
    }

    private String dateToTsDate(String dateStr) {
        try {
            String dateTxt = dateStr.contains("-") ? "yyyy-MM-dd HH:mm:ss" : "yyyy/MM/dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(dateTxt);
            java.util.Date d2 = format.parse(dateStr);
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "{ts'" + format2.format(d2) + "'}";
        }
        catch (Exception e) {
            throw new IllegalArgumentException("id is not valid:" + dateStr, e);
        }
    }

    @Override
    protected String _getCheckUnQuantityData(Context ctx, String parma) throws BOSException, EASBizException {
        String EASUserId;
        String shareCenterId;
        String JobRollBackSelectSql;
        IRowSet rowSet;
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)parma);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList records = new ArrayList();
        String dataType = (String)solutionMap.get("dataType");
        if (dataType == null || dataType.equals("")) {
            dataType = "MAP";
        }
        int page = Integer.parseInt(new DecimalFormat("0").format(Double.parseDouble(solutionMap.get("page").toString())));
        String queryUuid = (String)solutionMap.get("queryUuid");
        Uuid uuid = null;
        if (queryUuid != null) {
            uuid = Uuid.read((String)queryUuid);
        }
        String dateFrom = (String)solutionMap.get("dateFrom");
        String dateTo = (String)solutionMap.get("dateTo");
        String beCallBackUserId = (String)solutionMap.get("beCallBackUserId");
        String callBackUserId = (String)solutionMap.get("callBackUserId");
        if (uuid != null) {
            result.put("uuid", uuid.toString());
        }
        if ((rowSet = SSCDbUtil.executeQuery((Context)ctx, (String)(JobRollBackSelectSql = this.getCheckUnQuantitySql(dateFrom, dateTo, beCallBackUserId, callBackUserId, shareCenterId = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx), "58cc63c7-a447-443a-9bab-e64d06975853PERMITEM"))))) != null) {
            HashMap<String, String> row = new HashMap<String, String>();
            try {
                while (rowSet.next()) {
                    row = new HashMap();
                    row.put("sscuser", rowSet.getString("sscuser"));
                    row.put("checkuser", rowSet.getString("checkuser"));
                    row.put("reason", rowSet.getString("reason"));
                    row.put("checkdate", rowSet.getString("checkdate"));
                    try {
                        ObjectUuidPK uuidPK = new ObjectUuidPK(rowSet.getString("fbillid"));
                        String bosType = uuidPK.getObjectType().toString();
                        BOSObjectType type = BOSObjectType.create((String)bosType);
                        IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)uuidPK);
                        if (billValue != null && billValue.get("number") != null) {
                            row.put("billnumber", billValue.get("number").toString());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    records.add(row);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        result.put("page", page);
        result.put("rows", records);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private String getCheckUnQuantitySql(String dateFrom, String dateTo, String beCallBackUserId, String callBackUserId, String shareCenterId) {
        String sql = "select b.fname_l2 sscuser,a.fbillid,b.fname_l2 checkuser,a.FUnqualifyText reason,a.fexaminedate checkdate from T_SSC_SampleLibraryQualityTask a inner join t_ssc_user b on a.FEXAMINERID = b.fid left join t_ssc_jobhis c on a.fbillid = c.fbillid where c.FISLASTLEVEL =1 and a.FCheckResult = '0'  and c.fautoapprove = 0 and a.fexaminedate>=" + this.dateToTsDate(dateFrom) + " and a.fexaminedate<=" + this.dateToTsDate(dateTo) + " ";
        if (beCallBackUserId != null && beCallBackUserId != "") {
            sql = sql + " and c.fpersonnelidid in (" + beCallBackUserId + ")";
        }
        if (callBackUserId != null && callBackUserId != "") {
            sql = sql + " and a.FEXAMINERID in (" + callBackUserId + ")";
        }
        if (shareCenterId != null && shareCenterId != "") {
            sql = sql + " and c.fshareCenterId in (" + shareCenterId + ") ";
        }
        return sql;
    }

    private Map initUserMap(String userID, String userName, String groupID, String groupName) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("attrId", "");
        row.put("billid", "");
        row.put("userid", userID);
        row.put("userName", userName);
        row.put("groupid", groupID);
        row.put("groupUser", groupName);
        row.put("sscJobQuantity", 0);
        row.put("sscCheckQuantity", 0);
        row.put("sscQualityQuantity", 0);
        row.put("sumCallBack", 0);
        row.put("sumCheckUnQuantity", 0);
        row.put("billType", "");
        row.put("rollBackBill", "");
        row.put("totalSum", 0);
        return row;
    }

    @Override
    protected String _getQuaUnpassReport(Context ctx, String filter) throws BOSException, EASBizException {
        HashMap filterMap = JSONUtils.convertJsonToObject((Context)ctx, (String)filter);
        boolean isAll = false;
        if (filterMap.get("isAll") != null) {
            isAll = (Boolean)filterMap.get("isAll");
        }
        IRowSet rowSet = null;
        int totalCount = 0;
        String sql = this.getQuaUnpassSql(ctx, filterMap);
        ArrayList bizList = new ArrayList();
        try {
            if (isAll) {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                totalCount = rowSet.size();
            } else {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt((String)filterMap.get("startIndex")), (int)Integer.parseInt((String)filterMap.get("rowCount")));
                IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)this.getCountSql(sql));
                if (rowSetCount.next()) {
                    totalCount = rowSetCount.getInt(1);
                }
            }
            String stat_dimension = (String)filterMap.get(RptConstant.STAT_DIMENSION);
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (stat_dimension.indexOf("showBillType") > -1) {
                    map.put("billTypeName", rowSet.getString("billTypeName"));
                }
                if (stat_dimension.indexOf("showOrgName") > -1) {
                    map.put("orgName", rowSet.getString("orgName"));
                }
                map.put("reason", rowSet.getString("reason"));
                map.put("unpassNum", rowSet.getString("unpassNum"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSCException(SSCException.UNKNOW, e, new Object[]{e.getMessage()});
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private String getQuaUnpassSql(Context ctx, Map filterMap) throws BOSException {
        String startDate = (String)filterMap.get("startDate");
        String endDate = (String)filterMap.get("endDate");
        String billTypeId = (String)filterMap.get("billType");
        String shareCenterId = (String)filterMap.get("shareCenter.id");
        String orgId = (String)filterMap.get("orgId");
        String unQualTex = (String)filterMap.get("unpassReaId");
        StringBuilder startBuffer = new StringBuilder("");
        String stat_dimension = (String)filterMap.get(RptConstant.STAT_DIMENSION);
        StringBuffer whereBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)startDate)) {
            String newStartDate = this.dateToTsDate(startDate);
            String newEndDate = this.dateToTsDate(endDate);
            whereBuffer.append(" and T.FEXAMINEDATE >=").append(newStartDate);
            whereBuffer.append(" and T.FEXAMINEDATE <=").append(newEndDate);
        }
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            ParamCheckUtil.checkBOSUuids(shareCenterId);
            shareCenterId = "'" + shareCenterId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T3.FSHARECENTERID in (" + shareCenterId + ")");
        } else {
            String EASUserId = (String)filterMap.get("EASUserId");
            String permissionId = (String)filterMap.get("permissionId");
            whereBuffer.append(" and T3.FSHARECENTERID in (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")");
        }
        if (!StringUtils.isEmpty((String)billTypeId)) {
            ParamCheckUtil.checkBOSUuids(billTypeId);
            billTypeId = "'" + billTypeId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T.FBILLTYPEID in (" + billTypeId + ")");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            ParamCheckUtil.checkBOSUuids(orgId);
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T.FORGID in (" + orgId + ")");
        }
        startBuffer.append("SELECT T5.FName_L2 reason,");
        if (stat_dimension.indexOf("showBillType") > -1) {
            startBuffer.append("T1.FNAME_L2 billTypeName, ");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            startBuffer.append("T4.FNAME_L2 orgName, ");
        }
        startBuffer.append("sum(CASE WHEN T.FCHECKRESULT = '0' THEN 1 END) unpassNum ");
        startBuffer.append("FROM T_SSC_SAMPLELIBRARYQUALITYTASK T ");
        startBuffer.append("JOIN t_ssc_BillType T1 ON T.FBILLTYPEID = T1.FID ");
        startBuffer.append("JOIN t_ssc_systemattribute T2 ON T1.FSYSATTRID = T2.FID ");
        startBuffer.append("JOIN T_SSC_SysAttrOrgSCMap T3 ON T2.FID = T3.FSYSTEMATTRIBUTEID ");
        startBuffer.append("JOIN T_SSC_SAMPLELIBRARY TS ON T.FPARENTID = TS.FID ");
        startBuffer.append("JOIN T_SSC_CheckScheme TC ON TS.FCHECKSCHEMEID = TC.FID ");
        startBuffer.append("JOIN T_SSC_Org T4 ON T.FORGID = T4.FID ");
        startBuffer.append("JOIN T_SSC_TASKUNPASSREASON TT ON T.FID = TT.FTaskId ");
        startBuffer.append("JOIN T_SSC_UnqualifyReason T5 ON TT.FUPQUALIFYREASONID = T5.FID ");
        startBuffer.append("WHERE T.FTASKSTATE = '4' AND T.FORGID = T3.FORGID AND TC.FCheckType = 20 ");
        startBuffer.append(whereBuffer);
        if (!StringUtils.isEmpty((String)unQualTex)) {
            ParamCheckUtil.checkBOSUuids(unQualTex);
            unQualTex = "'" + unQualTex.replaceAll(",", "','") + "'";
            startBuffer.append("and T5.FID in (" + unQualTex + ")");
        }
        startBuffer.append("GROUP BY ");
        startBuffer.append("T5.FName_L2,");
        if (stat_dimension.indexOf("showBillType") > -1) {
            startBuffer.append("T1.FNAME_L2, ");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            startBuffer.append("T4.FNAME_L2, ");
        }
        startBuffer = new StringBuilder(startBuffer.subSequence(0, startBuffer.length() - 2));
        return startBuffer.toString();
    }

    private String getQuaUnpassSql(Context ctx, Map filterMap, String sql) throws BOSException {
        String startDate = (String)filterMap.get("startDate");
        String endDate = (String)filterMap.get("endDate");
        String billTypeId = (String)filterMap.get("billType");
        String shareCenterId = (String)filterMap.get("shareCenter.id");
        String orgId = (String)filterMap.get("orgId");
        String unQualTex = (String)filterMap.get("unpassReaId");
        StringBuilder startBuffer = new StringBuilder("");
        String stat_dimension = (String)filterMap.get(RptConstant.STAT_DIMENSION);
        StringBuffer whereBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)startDate)) {
            String newStartDate = this.dateToTsDate(startDate);
            String newEndDate = this.dateToTsDate(endDate);
            whereBuffer.append(" and T.FEXAMINEDATE >=").append(newStartDate);
            whereBuffer.append(" and T.FEXAMINEDATE <=").append(newEndDate);
        }
        if (!StringUtils.isEmpty((String)shareCenterId)) {
            shareCenterId = "'" + shareCenterId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T3.FSHARECENTERID in (" + shareCenterId + ")");
        } else {
            String EASUserId = (String)filterMap.get("EASUserId");
            String permissionId = (String)filterMap.get("permissionId");
            whereBuffer.append(" and T3.FSHARECENTERID in (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")");
        }
        if (!StringUtils.isEmpty((String)billTypeId)) {
            billTypeId = "'" + billTypeId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T.FBILLTYPEID in (" + billTypeId + ")");
        }
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            whereBuffer.append("and T.FORGID in (" + orgId + ")");
        }
        startBuffer.append("SELECT T5.FName_L2 reason,");
        if (stat_dimension.indexOf("showBillType") > -1) {
            startBuffer.append("T1.FNAME_L2 billTypeName, ");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            startBuffer.append("T4.FNAME_L2 orgName, ");
        }
        startBuffer.append("sum(CASE WHEN T.FCHECKRESULT = '0' THEN 1 END) unpassNum ");
        startBuffer.append("FROM T_SSC_SAMPLELIBRARYQUALITYTASK T ");
        startBuffer.append("JOIN t_ssc_BillType T1 ON T.FBILLTYPEID = T1.FID ");
        startBuffer.append("JOIN t_ssc_systemattribute T2 ON T1.FSYSATTRID = T2.FID ");
        startBuffer.append("JOIN T_SSC_SysAttrOrgSCMap T3 ON T2.FID = T3.FSYSTEMATTRIBUTEID ");
        startBuffer.append("JOIN T_SSC_SAMPLELIBRARY TS ON T.FPARENTID = TS.FID ");
        startBuffer.append("JOIN T_SSC_CheckScheme TC ON TS.FCHECKSCHEMEID = TC.FID ");
        startBuffer.append("JOIN T_SSC_Org T4 ON T.FORGID = T4.FID ");
        startBuffer.append("JOIN T_SSC_TASKUNPASSREASON TT ON T.FID = TT.FTaskId ");
        startBuffer.append("JOIN T_SSC_UnqualifyReason T5 ON TT.FUPQUALIFYREASONID = T5.FID ");
        startBuffer.append("WHERE T.FTASKSTATE = '4' AND T.FORGID = T3.FORGID AND TC.FCheckType = 20 ");
        startBuffer.append(whereBuffer);
        if (!StringUtils.isEmpty((String)unQualTex)) {
            unQualTex = "'" + unQualTex.replaceAll(",", "','") + "'";
            startBuffer.append("and T5.FID in (" + unQualTex + ")");
        }
        startBuffer.append("GROUP BY ");
        startBuffer.append("T5.FName_L2,");
        if (stat_dimension.indexOf("showBillType") > -1) {
            startBuffer.append("T1.FNAME_L2, ");
        }
        if (stat_dimension.indexOf("showOrgName") > -1) {
            startBuffer.append("T4.FNAME_L2, ");
        }
        startBuffer = new StringBuilder(startBuffer.subSequence(0, startBuffer.length() - 2));
        return startBuffer.toString();
    }

    private String getCountSql(String sql) {
        if (sql.indexOf("order by") > -1) {
            sql = sql.substring(0, sql.indexOf("order"));
        }
        String countSql = "select count(1) count from (" + sql + ")t";
        return countSql;
    }

    @Override
    protected String _getQualityCheckData(Context ctx, String param) throws BOSException, SSCException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getQualityCheckData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected Map _getQualityCheckData(Context ctx, Map param) throws BOSException, SSCException, EASBizException {
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        String startIndex = (String)param.get("startIndex");
        String rowCount = (String)param.get("rowCount");
        IRowSet rowSet = null;
        Object rowSetCount = null;
        ArrayList bizList = new ArrayList();
        String sharecenterId = "''";
        String orgIdSql = "''";
        String billtyIdSql = "''";
        if (!StringUtil.isEmpty((String)((String)param.get("shareCenter.id")))) {
            sharecenterId = "('" + (String)param.get("shareCenter.id") + "')";
            billtyIdSql = "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN" + sharecenterId;
            orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN " + sharecenterId;
        } else {
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            sharecenterId = "(" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")";
            billtyIdSql = "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN" + sharecenterId;
            orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN " + sharecenterId;
        }
        StringBuffer sb = new StringBuffer("select t.orgId orgId,ORG.fname_" + ctx.getLocale().toString() + " orgname,t.billTypeId billTypeId,bi.fname_" + ctx.getLocale().toString() + " billTypeName,t.checkbillCount checkbillCount,t.unqualifiedbillCount unqualifiedbillCount,t.unqualifiedbillPercent unqualifiedbillPercent from ");
        sb.append("(SELECT sq.FORGID orgId ,sq.FBILLTYPEID billTypeId ,count(sq.FBILLID ) checkbillCount,sum(case when sq.FCheckResult='0' then 1 end) unqualifiedbillCount, ");
        sb.append("sum(case when sq.FCheckResult='0' then 1 end)*1.0/count(sq.FBILLID ) unqualifiedbillPercent FROM T_SSC_SAMPLELIBRARYQUALITYTASK sq ");
        sb.append("inner join (SELECT sb.FID ,cs.FSHARECENTERID   FROM t_ssc_SAMPLELIBRARY sb INNER JOIN T_SSC_CHECKSCHEME cs ON SB.FCHECKSCHEMEID = CS.FID and cs.FCHECKTYPE ='20' ) sc ON sc.fid=sq.FPARENTID where sq.FTASKSTATE = '4' ");
        if (!StringUtils.isEmpty((String)startDate)) {
            sb.append(" and sq.FCOMPLETEDATE >=").append(this.dateToTsDate(startDate));
            sb.append(" and sq.FCOMPLETEDATE <=").append(this.dateToTsDate(endDate));
        }
        if (!StringUtil.isEmpty((String)((String)param.get("shareCenter.id")))) {
            sb.append(" and sc.FSHARECENTERID in ('" + (String)param.get("shareCenter.id") + "')");
        } else {
            String EASUserId = (String)param.get("EASUserId");
            String permissionId = (String)param.get("permissionId");
            sb.append(" and sc.FSHARECENTERID in (" + ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId) + ")");
        }
        String orgId = (String)param.get("orgId");
        String billType = (String)param.get("billType");
        if (StringUtils.isEmpty((String)orgId)) {
            sb.append(" and sq.forgid in(" + orgIdSql + ")");
        } else {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sb.append(" and sq.forgid in(" + orgId + ")");
        }
        if (StringUtils.isEmpty((String)billType)) {
            sb.append(" and sq.FBILLTYPEID in (" + billtyIdSql + ")");
        } else {
            billType = "'" + billType.replaceAll(",", "','") + "'";
            sb.append("and sq.FBILLTYPEID in (" + billType + ")");
        }
        sb.append("group by sq.FORGID ,sq.FBILLTYPEID) t inner join T_SSC_BILLTYPE bi on t.billTypeId = bi.FID inner join T_SSC_ORG org ON t.orgId= ORG.FID ");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        DecimalFormat df = new DecimalFormat("#0.00");
        try {
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String unqualifiedbillPercent = rowSet.getString("unqualifiedbillPercent");
                unqualifiedbillPercent = unqualifiedbillPercent == null || "".equals(unqualifiedbillPercent) ? "0.00%" : df.format(new BigDecimal(unqualifiedbillPercent).multiply(new BigDecimal(100))) + "%";
                String _orgId = rowSet.getString("orgId");
                String _billTypeId = rowSet.getString("billTypeId");
                String _checkbillCount = rowSet.getString("checkbillCount");
                String _billCount = this.getTotalBillCount(ctx, _billTypeId, _orgId, sharecenterId, startDate, endDate);
                if ("".equals(_checkbillCount) || "0".equals(_checkbillCount) || _checkbillCount == null || "".equals(_billCount) || _billCount == null || "0".equals(_billCount)) continue;
                Double _checkpercent = Double.parseDouble(_checkbillCount) / (double)Integer.parseInt(_billCount);
                String checkpercent = df.format(new BigDecimal(_checkpercent).multiply(new BigDecimal(100))) + "%";
                map.put("orgId", _orgId);
                map.put("orgname", rowSet.getString("orgname"));
                map.put("billTypeName", rowSet.getString("billTypeName"));
                map.put("billTypeId", rowSet.getString("billTypeId"));
                map.put("billCount", _billCount);
                map.put("checkbillCount", _checkbillCount);
                map.put("checkpercent", checkpercent);
                map.put("unqualifiedbillCount", rowSet.getString("unqualifiedbillCount") == null ? Integer.valueOf(0) : rowSet.getString("unqualifiedbillCount"));
                map.put("unqualifiedbillPercent", unqualifiedbillPercent);
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"558_TaskReportFacadeControllerBean", (Locale)ctx.getLocale()) + sb.toString()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        int totalCount = 0;
        if (bizList != null) {
            totalCount = bizList.size();
        }
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    private String getTotalBillCount(Context ctx, String billTypeId, String orgId, String sharecenterId, String startDate, String endDate) throws BOSException {
        StringBuffer sql = new StringBuffer("SELECT sq.FCOMPLETEDATE ftime ,cs.FCHECKSCHEMETIMETYPE timetype,sq.FBILLID   FROM T_SSC_SAMPLELIBRARY sb  INNER JOIN ");
        sql.append("T_SSC_SAMPLELIBRARYQUALITYTASK sq  ON SQ.FPARENTID = SB.FID INNER JOIN T_SSC_CHECKSCHEME cs ON SB.FCHECKSCHEMEID = CS.FID where ");
        sql.append("cs.FSHARECENTERID in " + sharecenterId + " and sq.FBILLTYPEID ='" + billTypeId + "' and sq.FORGID ='" + orgId + "' and sq.FTASKSTATE = '4' ");
        sql.append(" and sq.FCOMPLETEDATE >=").append(this.dateToTsDate(startDate));
        sql.append(" and sq.FCOMPLETEDATE <=").append(this.dateToTsDate(endDate));
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList list = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            while (rowSet.next()) {
                Map map = new HashMap();
                String datetime = rowSet.getString("ftime");
                String timetype = rowSet.getString("timetype");
                map = this.getTimeRunk(sdf.parse(datetime), timetype);
                list.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"558_TaskReportFacadeControllerBean", (Locale)ctx.getLocale()) + sql.toString()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (list.size() == 0) {
            return null;
        }
        ArrayList<Timestamp> beginlist = new ArrayList<Timestamp>();
        ArrayList<Timestamp> endlist = new ArrayList<Timestamp>();
        for (int i = 0; i < list.size(); ++i) {
            Timestamp begin = (Timestamp)((Map)list.get(i)).get("beginDate");
            Timestamp end = (Timestamp)((Map)list.get(i)).get("endDate");
            beginlist.add(begin);
            endlist.add(end);
        }
        Timestamp starttime = (Timestamp)Collections.min(beginlist);
        Timestamp endtime = (Timestamp)Collections.max(endlist);
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        df.format(starttime);
        String sqlcount = "SELECT count(distinct jh.fbillid) totalBillCount FROM t_ssc_jobhis jh INNER JOIN T_SSC_BUSSINESSATTRIBUTE BA ON JH.FBUSSATTRIDID = BA.FID where jh.FISLASTLEVEL = 1 and jh.FJOBSTATE in ('3','10') and (jh.FCHECKTYPE = '2' or jh.FCHECKTYPE = '3') and ( (jh.FAUTOAPPROVE = 1 and jh.FPhotoCopyFlag = 1 AND jh.FImageUploadTime >= " + this.dateToTsDate(df.format(starttime)) + " AND jh.FImageUploadTime <=" + this.dateToTsDate(df.format(endtime)) + ") or (jh.FAUTOAPPROVE <> 1 AND jh.FCompleteTme >=" + this.dateToTsDate(df.format(starttime)) + " and jh.FCompleteTme<=" + this.dateToTsDate(df.format(endtime)) + "))  and jh.FORGIDID = '" + orgId + "' and BA.FBILLTYPEID = '" + billTypeId + "' and jh.FSHARECENTERID IN" + sharecenterId;
        countRowSet = DbUtil.executeQuery((Context)ctx, (String)sqlcount);
        String totalBillCount = "";
        try {
            while (countRowSet.next()) {
                totalBillCount = countRowSet.getString("totalBillCount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.base.ssc.SSCAutoGenerateResource", (String)"558_TaskReportFacadeControllerBean", (Locale)ctx.getLocale()) + sqlcount.toString()));
        }
        return totalBillCount;
    }

    private Map getTimeRunk(java.util.Date date, String timeType) throws BOSException {
        Timestamp beginDate = null;
        Timestamp endDate = null;
        HashMap<String, Timestamp> timemap = new HashMap<String, Timestamp>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if ("yesterDay".equals(timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            beginDate = this.getFirstTime(calendar);
        } else if ("beforeYesterDay2".equals(timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -2);
            beginDate = this.getFirstTime(calendar);
        } else if ("beforeYesterDay3".equals(timeType)) {
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -3);
            beginDate = this.getFirstTime(calendar);
        } else if ("week".equals(timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            beginDate = this.getFirstTime(calendar);
        } else if ("beforeWeek".equals(timeType)) {
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(5, -6);
            beginDate = this.getFirstTime(calendar);
        } else if ("month".equals(timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.set(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if ("beforeMonth".equals(timeType)) {
            calendar.set(5, 1);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(2, -1);
            calendar.add(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if ("years".equals(timeType)) {
            endDate = this.getFirstTime(calendar);
            calendar.set(6, 1);
            beginDate = this.getFirstTime(calendar);
        } else if ("lastYear".equals(timeType)) {
            calendar.set(6, 1);
            calendar.add(5, -1);
            endDate = this.getLastTime(calendar);
            calendar.add(1, -1);
            calendar.add(5, 1);
            beginDate = this.getFirstTime(calendar);
        } else if ("between".equals(timeType)) {
            beginDate = this.getFirstTime(calendar);
            endDate = this.getLastTime(calendar);
        }
        timemap.put("beginDate", beginDate);
        timemap.put("endDate", endDate);
        return timemap;
    }

    private Timestamp getLastTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private Timestamp getFirstTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    protected String _getQualityChecktDetailData(Context ctx, String param) throws BOSException, SSCException, EASBizException {
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        Map retMap = this._getQualityChecktDetailData(ctx, paramMap);
        return JSONUtils.convertObjectToJson((Context)ctx, (Object)retMap);
    }

    @Override
    protected Map _getQualityChecktDetailData(Context ctx, Map paramMap) throws BOSException, SSCException, EASBizException {
        String startIndex = (String)paramMap.get("startIndex");
        String rowCount = (String)paramMap.get("rowCount");
        Object _isAll = paramMap.get("isAll");
        boolean isAll = false;
        if (_isAll != null) {
            isAll = (Boolean)_isAll;
        }
        String sql = this.QualityChecktDetail(paramMap, ctx);
        IRowSet rowSet = null;
        IRowSet rowSetCount = null;
        if (isAll) {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        } else {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (int)Integer.parseInt(startIndex), (int)Integer.parseInt(rowCount));
            rowSetCount = DbUtil.executeQuery((Context)ctx, (String)this.getCountSql(sql));
        }
        ArrayList bizList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("subject", rowSet.getString("subject"));
                map.put("billTypeName", rowSet.getString("billTypeName"));
                map.put("exminer", rowSet.getString("exminer"));
                map.put("message", rowSet.getString("messages"));
                map.put("unqualifytext", rowSet.getString("unqualifytext"));
                bizList.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int totalCount = 0;
        if (bizList != null) {
            totalCount = bizList.size();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", bizList);
        return result;
    }

    private String QualityChecktDetail(Map paramMap, Context ctx) {
        String startDate = (String)paramMap.get("startDate");
        String endDate = (String)paramMap.get("endDate");
        StringBuffer sql = new StringBuffer("select t1.subject,t1.billTypeName,t1.exminer,t1.unqualifytext,t1.messages from ");
        sql.append("(SELECT sq.FSUBJECT subject,bt.FNAME_l2 billTypeName,tu.FNAME_l2 exminer,sq.FUNQUALIFYTEXT  unqualifytext ,sq.FResultInstruction messages, sq.fbillid bill FROM ");
        sql.append("T_SSC_SAMPLELIBRARYQUALITYTASK sq INNER JOIN T_SSC_ORG org on sq.FORGID = org.FID  inner join ");
        sql.append("T_SSC_BILLTYPE bt on sq.FBILLTYPEID = bt.fid inner join t_ssc_user tu on tu.fid = sq.FEXAMINERID ");
        sql.append("inner join  T_SSC_SAMPLELIBRARY sb on sb.fid = sq.fparentid where sb.FSTATE = '4' and sb.FCHECKTYPE = 20 ");
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and sq.FCOMPLETEDATE >=").append(this.dateToTsDate(startDate));
            sql.append(" and sq.FCOMPLETEDATE <=").append(this.dateToTsDate(endDate));
        }
        String orgId = (String)paramMap.get("orgId");
        String billType = (String)paramMap.get("billType");
        if (!StringUtils.isEmpty((String)orgId)) {
            orgId = "'" + orgId.replaceAll(",", "','") + "'";
            sql.append(" and sq.FORGID in(").append(orgId).append(")");
        }
        if (!StringUtils.isEmpty((String)billType)) {
            billType = "'" + billType.replaceAll(",", "','") + "'";
            sql.append(" and sq.fbilltypeid in (" + billType + ") ");
        }
        sql.append(") t1,(select p.billid,p.jobid,jst.fmessages messages from ");
        sql.append("T_SSC_JOBSTATIMHIS jst inner join (select jh.fid jobid,jh.fbillid billid from ");
        sql.append("T_SSC_SAMPLELIBRARYQUALITYTASK sq inner join t_ssc_jobhis jh on jh.fbillid = sq.fbillid ");
        sql.append("inner join  T_SSC_SAMPLELIBRARY sb on sb.fid = sq.fparentid  where jh.fislastlevel = 1 ");
        sql.append("and sb.FSTATE = '4' and sb.FCHECKTYPE = 20 and sq.FCheckResult='0' ");
        if (!StringUtils.isEmpty((String)orgId)) {
            sql.append(" and sq.FORGID in(").append(orgId).append(")");
        }
        if (!StringUtils.isEmpty((String)billType)) {
            sql.append(" and sq.fbilltypeid in (" + billType + ") ");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            sql.append(" and sq.FCOMPLETEDATE >=").append(this.dateToTsDate(startDate));
            sql.append(" and sq.FCOMPLETEDATE <=").append(this.dateToTsDate(endDate));
        }
        sql.append(") p on p.jobid = jst.fjobidid where jst.fnewjobstate in ('3','10')) t2 ");
        sql.append("where t1.bill = t2.billid order by billTypeName");
        return sql.toString();
    }

    @Override
    protected String _getQualityInspectionChart(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String period = (String)solutionMap.get(RptConstant.PERIOD);
        String startDate = (String)solutionMap.get("startDate");
        String sql = this.getQualityInspectionSql(solutionMap, ctx);
        int col1 = 0;
        int col2 = 100;
        Double col3 = 0.0;
        Boolean isFirst = true;
        int startYear = Integer.parseInt(startDate.substring(0, 4));
        int startMonth = Integer.parseInt(startDate.substring(5, 7));
        int realYear = 0;
        int realMonth = 0;
        int realQuarter = 0;
        String key = "";
        if (period.equals(RptConstant.PERIOD_BYMONTH)) {
            if (startMonth == 1) {
                realYear = startYear - 1;
                realMonth = 12;
            } else {
                realYear = startYear;
                realMonth = startMonth - 1;
            }
            key = RptConstant.PERIOD_BYMONTH;
        } else if (period.equals(RptConstant.PERIOD_BYQUARTER)) {
            if (startMonth <= 3) {
                realYear = startYear - 1;
                realQuarter = 4;
            } else if (4 <= startMonth && startMonth <= 6) {
                realYear = startYear;
                realQuarter = 1;
            } else if (7 <= startMonth && startMonth <= 9) {
                realYear = startYear;
                realQuarter = 2;
            } else {
                realYear = startYear;
                realQuarter = 3;
            }
            key = RptConstant.PERIOD_BYQUARTER;
        } else {
            key = RptConstant.PERIOD_BYYEAR;
            realYear = startYear - 1;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList bizList = new ArrayList();
        try {
            DecimalFormat df = new DecimalFormat("#0.00");
            while (rowSet.next()) {
                int _col1 = rowSet.getInt("byYear");
                int _col2 = rowSet.getInt(key);
                Double _col3 = rowSet.getDouble("qualifyedPercent");
                if (isFirst.booleanValue() && ("byYear".equals(key) && realYear == _col1 || "byQuarter".equals(key) && realYear == _col1 && realQuarter == _col2 || "byMonth".equals(key) && realYear == _col1 && realMonth == _col2)) {
                    col1 = _col1;
                    col2 = _col2;
                    col3 = _col3;
                    isFirst = false;
                    continue;
                }
                Double upPercent = 0.0;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (!period.equals(RptConstant.PERIOD_BYYEAR)) {
                    if (period.equals(RptConstant.PERIOD_BYMONTH)) {
                        if (_col1 == col1) {
                            if (_col2 == col2 + 1 && col3 != 0.0) {
                                upPercent = (_col3 - col3) / col3;
                            }
                        } else if (_col1 == col1 + 1 && _col2 == col2 - 11 && col3 != 0.0) {
                            upPercent = (_col3 - col3) / col3;
                        }
                    } else if (period.equals(RptConstant.PERIOD_BYQUARTER)) {
                        if (_col1 == col1) {
                            if (_col2 == col2 + 1 && col3 != 0.0) {
                                upPercent = (_col3 - col3) / col3;
                            }
                        } else if (_col1 == col1 + 1 && _col2 == col2 - 3 && col3 != 0.0) {
                            upPercent = (_col3 - col3) / col3;
                        }
                    }
                    map.put(RptConstant.PERIOD_BYYEAR, rowSet.getString(RptConstant.PERIOD_BYYEAR));
                    map.put(key, rowSet.getString(key));
                    map.put("qualifyedPercent", df.format(rowSet.getBigDecimal("qualifyedPercent").multiply(new BigDecimal(100))));
                    map.put("upPercent", upPercent == 0.0 ? Integer.valueOf(0) : df.format(new BigDecimal(upPercent).multiply(new BigDecimal(100))));
                    map.put("unqualifyedsum", rowSet.getString("unqualifyedsum"));
                } else {
                    if (_col1 == col1 + 1 && col3 != 0.0) {
                        upPercent = (_col3 - col3) / col3;
                    }
                    map.put(RptConstant.PERIOD_BYYEAR, rowSet.getString(RptConstant.PERIOD_BYYEAR));
                    map.put("qualifyedPercent", df.format(rowSet.getBigDecimal("qualifyedPercent").multiply(new BigDecimal(100))));
                    map.put("upPercent", upPercent == 0.0 ? Integer.valueOf(0) : df.format(upPercent * 100.0));
                    map.put("unqualifyedsum", rowSet.getString("unqualifyedsum"));
                }
                bizList.add(map);
                col1 = _col1;
                col2 = _col2;
                col3 = _col3;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, bizList);
    }

    private String getQualityInspectionSql(Map solutionMap, Context ctx) throws BOSException {
        String orderBy;
        String groupBy;
        StringBuilder sql;
        block23: {
            sql = new StringBuilder("select ");
            String period = (String)solutionMap.get(RptConstant.PERIOD);
            String startDate = (String)solutionMap.get("startDate");
            String endDate = (String)solutionMap.get("endDate");
            String billTypeId = (String)solutionMap.get("billTypeId");
            String shareCenterId = (String)solutionMap.get("shareCenter.id");
            String orgId = (String)solutionMap.get("orgId");
            String EASUserId = (String)solutionMap.get("EASUserId");
            String permissionId = (String)solutionMap.get("permissionId");
            groupBy = "";
            orderBy = "";
            String orgIdSql = "''";
            String billtyIdSql = "''";
            if (StringUtils.isEmpty((String)shareCenterId)) {
                shareCenterId = ShareCenterPermissionOrgUtil.getPermissionOrg(ctx, EASUserId, permissionId);
                billtyIdSql = "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN(" + shareCenterId + ")";
                orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN (" + shareCenterId + ")";
            } else {
                ParamCheckUtil.checkBOSUuid(shareCenterId);
                shareCenterId = "'" + shareCenterId + "'";
                billtyIdSql = "SELECT DISTINCT T3.FID BILLTYPEID FROM T_SSC_SysAttrOrgSCMap T1 LEFT JOIN T_SSC_SystemAttribute T2 ON T1.FSystemAttributeID = T2.FID LEFT JOIN T_SSC_BILLTYPE T3 ON T3.FSYSATTRID = T2.FID WHERE T1.FSHARECENTERID IN(" + shareCenterId + ")";
                orgIdSql = "SELECT DISTINCT FOrgid FROM T_SSC_SysAttrOrgSCMap WHERE FShareCenterID IN (" + shareCenterId + ")";
            }
            if (period.equals(RptConstant.PERIOD_BYMONTH)) {
                sql.append("YEAR(sq.FCOMPLETEDATE) byYear,MONTH(sq.FCOMPLETEDATE) byMonth ");
                groupBy = " YEAR(sq.FCOMPLETEDATE),MONTH(sq.FCOMPLETEDATE) ";
                orderBy = " YEAR(sq.FCOMPLETEDATE),MONTH(sq.FCOMPLETEDATE)";
            } else if (period.equals(RptConstant.PERIOD_BYQUARTER)) {
                sql.append("YEAR(sq.FCOMPLETEDATE) byYear,QUARTER(sq.FCOMPLETEDATE) byQUARTER ");
                groupBy = "YEAR(sq.FCOMPLETEDATE) ,QUARTER(sq.FCOMPLETEDATE ) ";
                orderBy = "YEAR(sq.FCOMPLETEDATE) ,QUARTER(sq.FCOMPLETEDATE)";
            } else {
                sql.append("YEAR(sq.FCOMPLETEDATE) byYear ");
                groupBy = " YEAR(sq.FCOMPLETEDATE) ";
                orderBy = " YEAR(sq.FCOMPLETEDATE)";
            }
            sql.append(",count(1) tasksum ");
            sql.append(",sum(case when (FCHECKRESULT ='1' ) then 1 else 0 end) qualifyedsum ");
            sql.append(",sum(case when (FCHECKRESULT ='0' ) then 1 else 0 end) unqualifyedsum ");
            sql.append(",sum(case when (FCHECKRESULT ='1' ) then 1 else 0 end)*1.0/count(1) qualifyedPercent ");
            sql.append("FROM T_SSC_SAMPLELIBRARYQUALITYTASK sq INNER JOIN T_SSC_SAMPLELIBRARY sb ON SQ.FPARENTID = SB.FID left join T_SSC_CHECKSCHEME sc on sb.FCHECKSCHEMEID = sc.fid where sb.FCHECKTYPE = 20 and sb.FSTATE = '4' ");
            if (StringUtils.isEmpty((String)orgId)) {
                sql.append(" and sq.FORGID in (" + orgIdSql + ")");
            } else {
                ParamCheckUtil.checkBOSUuids(orgId);
                orgId = "'" + orgId.replaceAll(",", "','") + "'";
                sql.append("and sq.FORGID in (" + orgId + ")");
            }
            if (StringUtils.isEmpty((String)billTypeId)) {
                sql.append(" and sq.FBILLTYPEID in (" + billtyIdSql + ")");
            } else {
                ParamCheckUtil.checkBOSUuids(billTypeId);
                billTypeId = "'" + billTypeId.replaceAll(",", "','") + "'";
                sql.append("and sq.FBILLTYPEID in (" + billTypeId + ")");
            }
            sql.append(" and sc.FSHARECENTERID in (" + shareCenterId + ")");
            SimpleDateFormat longSdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy/MM/dd");
            try {
                if (!StringUtils.isEmpty((String)startDate)) {
                    Calendar c = Calendar.getInstance();
                    String newStartDate = "";
                    if (period.equals(RptConstant.PERIOD_BYMONTH)) {
                        c.setTime(longSdf.parse(startDate));
                        c.add(2, -1);
                        c.set(5, 1);
                        newStartDate = longSdf.format(longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00")).toString();
                    } else if (period.equals(RptConstant.PERIOD_BYQUARTER)) {
                        c.setTime(this.getCurrentQuarterStartTime(longSdf.parse(startDate)));
                        c.add(2, -3);
                        c.set(5, 1);
                        newStartDate = longSdf.format(c.getTime()).toString();
                    } else {
                        try {
                            c.setTime(this.getCurrentQuarterStartTime(longSdf.parse(startDate)));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        c.add(2, -12);
                        c.set(6, 1);
                        newStartDate = longSdf.format(longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00")).toString();
                    }
                    newStartDate = this.dateToTsDate(newStartDate);
                    String newEndDate = this.dateToTsDate(endDate);
                    sql.append(" and sq.FCOMPLETEDATE >=").append(newStartDate);
                    sql.append(" and sq.FCOMPLETEDATE <=").append(newEndDate);
                    break block23;
                }
                Calendar c = Calendar.getInstance();
                String start = "";
                if (period.equals(RptConstant.PERIOD_BYMONTH)) {
                    c.setTime(new java.util.Date());
                    c.add(2, -12);
                    c.set(5, 1);
                    start = longSdf.format(longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00")).toString();
                } else if (period.equals(RptConstant.PERIOD_BYQUARTER)) {
                    c.setTime(this.getCurrentQuarterStartTime(new java.util.Date()));
                    c.add(2, -12);
                    c.set(5, 1);
                    start = longSdf.format(c.getTime()).toString();
                } else {
                    c.setTime(new java.util.Date());
                    c.add(2, -24);
                    c.set(6, 1);
                    start = longSdf.format(longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00")).toString();
                }
                String end = longSdf.format(Calendar.getInstance().getTime()).toString();
                sql.append(" and sq.FCOMPLETEDATE >=").append(this.dateToTsDate(start));
                sql.append(" and sq.FCOMPLETEDATE <=").append(this.dateToTsDate(end));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        sql.append(" group by ").append(groupBy);
        sql.append(" order by ").append(orderBy);
        return sql.toString();
    }

    private java.util.Date getCurrentQuarterStartTime(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        int currentMonth = c.get(2) + 1;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 1);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            date = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }
}

