/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BussinessAttributeExtFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.WorkPressureInfo;
import com.kingdee.eas.base.ssc.app.AbstractWorkPressureControllerBean;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkPressureControllerBean
extends AbstractWorkPressureControllerBean {
    private static final long serialVersionUID = 7588058048749431912L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.WorkPressureControllerBean");

    @Override
    protected void _init(Context ctx) throws BOSException, EASBizException {
        double minPressure = 0.0;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("select 1 from t_ssc_workpressure where FCREATETIME >= CURDATE()");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs.next()) {
                sb = new StringBuffer();
                sb.append(" SELECT distinct ru.FUSERIDID FROM T_SSC_ROLEUSER ru,T_SSC_ROLE r");
                sb.append(" where ru.FROLEIDID = r.FID");
                sb.append(" and r.FROLETYPEIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
                sb.append(" and ru.FUSERIDID not in (select fuserid from T_ssc_workpressure)");
                CoreBaseCollection colls = new CoreBaseCollection();
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                boolean initMinPressure = false;
                while (rs.next()) {
                    if (!initMinPressure) {
                        String sql = "select min(fworkpressure) from t_ssc_workpressure";
                        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (rowSet.next()) {
                            minPressure = rowSet.getDouble(1);
                        }
                        initMinPressure = true;
                    }
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)rs.getString(1)));
                    WorkPressureInfo info = new WorkPressureInfo();
                    info.setUser(userInfo);
                    info.setWorkPressure(new BigDecimal(minPressure));
                    FillDataUtils.fillAuditData(ctx, info);
                    colls.add((CoreBaseInfo)info);
                }
                if (colls.size() > 0) {
                    WorkPressureFactory.getLocalInstance(ctx).saveBatchData(colls);
                }
            } else {
                sb = new StringBuffer("insert into t_ssc_workpressurehis SELECT * FROM t_ssc_workpressure");
                DbUtil.execute((Context)ctx, (String)sb.toString());
                sb = new StringBuffer("delete FROM t_ssc_workpressure");
                DbUtil.execute((Context)ctx, (String)sb.toString());
                sb = new StringBuffer();
                sb.append(" SELECT distinct ru.FUSERIDID FROM T_SSC_ROLEUSER ru,T_SSC_ROLE r");
                sb.append(" where ru.FROLEIDID = r.FID");
                sb.append(" and r.FROLETYPEIDID = 'F68lZzqpRWC1K1nV8ZYPgS0WZ4A='");
                this.init(ctx, sb.toString());
            }
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void init(Context ctx, String sql) {
        try {
            CoreBaseCollection colls = new CoreBaseCollection();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString(1)));
                WorkPressureInfo info = new WorkPressureInfo();
                info.setUser(userInfo);
                info.setWorkPressure(new BigDecimal(0));
                FillDataUtils.fillAuditData(ctx, info);
                colls.add((CoreBaseInfo)info);
            }
            if (colls.size() > 0) {
                WorkPressureFactory.getLocalInstance(ctx).saveBatchData(colls);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected List _workPressureSort(Context ctx, List userIds) throws BOSException, EASBizException {
        ArrayList<String> uIds = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(" select fuserid from t_ssc_workpressure");
            sb.append(" where fuserid in " + FormatUtils.list2Sql(userIds));
            sb.append(" order by fworkPressure asc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                uIds.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return uIds;
    }

    @Override
    protected void _add(Context ctx, String userId, BigDecimal standardBills) throws BOSException, EASBizException {
        Object[] params = null;
        StringBuffer sb = new StringBuffer();
        try {
            sb = new StringBuffer("update T_SSC_WorkPressure set fWorkPressure = fWorkPressure + ? , flastUpdateTime = now() where fuserId=?");
            params = new Object[]{standardBills, userId};
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)("ctx:" + ctx.toString()));
            logger.error((Object)("param:" + standardBills + ";" + userId));
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _addMulitJob(Context ctx, String userId, String bussAttrId, int count) throws BOSException, EASBizException {
        BigDecimal standardcoe = new BigDecimal("1.00");
        BigDecimal approvecoe = null;
        BigDecimal workPressure = null;
        Object[] params = null;
        StringBuffer sb = new StringBuffer();
        IRowSet rs = null;
        try {
            String shareCenterId = ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userId);
            approvecoe = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId)).getApproveCoe();
            standardcoe = BussinessAttributeExtFactory.getLocalInstance(ctx).exists("where bussId='" + bussAttrId + "' and shareCenterId='" + shareCenterId + "'") ? BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtInfo("where bussId='" + bussAttrId + "' and shareCenterId='" + shareCenterId + "'").getStandardCoe() : BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectUuidPK(bussAttrId)).getStandardCoe();
            sb = new StringBuffer("SELECT fWorkPressure FROM T_SSC_WorkPressure where fuserId=?");
            params = new Object[]{userId};
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (!rs.next()) {
                return;
            }
            workPressure = rs.getBigDecimal(1);
            workPressure = standardcoe.multiply(new BigDecimal(count)).divide(approvecoe, 4, 4);
            sb = new StringBuffer("update T_SSC_WorkPressure set fWorkPressure=fWorkPressure+? where fuserId=?");
            params = new Object[]{workPressure, userId};
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)("ctx:" + ctx.toString()));
            logger.error((Object)("param:" + params.toString()));
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _addSingleJob(Context ctx, String userId, String bussAttrId) throws BOSException, EASBizException {
        this.addMulitJob(ctx, userId, bussAttrId, 1);
    }

    @Override
    protected void _subtract(Context ctx, String userId, BigDecimal standardBills) throws BOSException, EASBizException {
        Object[] params = null;
        StringBuffer sb = new StringBuffer();
        try {
            sb = new StringBuffer("update T_SSC_WorkPressure set fWorkPressure = case when fWorkPressure - ? < 0 then 0 else fWorkPressure - ? end where fuserId=?");
            params = new Object[]{standardBills, standardBills, userId};
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)("ctx:" + ctx.toString()));
            logger.error((Object)("param:" + params.toString()));
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _subtractMulitJob(Context ctx, String userId, String bussAttrId, int count) throws BOSException, EASBizException {
        BigDecimal standardcoe = new BigDecimal("1.00");
        BigDecimal approvecoe = null;
        BigDecimal workPressure = null;
        Object[] params = null;
        StringBuffer sb = new StringBuffer();
        IRowSet rs = null;
        try {
            String shareCenterId = ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userId);
            approvecoe = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId)).getApproveCoe();
            standardcoe = BussinessAttributeExtFactory.getLocalInstance(ctx).exists("where bussId='" + bussAttrId + "' and shareCenterId='" + shareCenterId + "'") ? BussinessAttributeExtFactory.getLocalInstance(ctx).getBussinessAttributeExtInfo("where bussId='" + bussAttrId + "' and shareCenterId='" + shareCenterId + "'").getStandardCoe() : BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectUuidPK(bussAttrId)).getStandardCoe();
            sb = new StringBuffer("SELECT fWorkPressure FROM T_SSC_WorkPressure where fuserId=?");
            params = new Object[]{userId};
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (!rs.next()) {
                return;
            }
            workPressure = rs.getBigDecimal(1);
            workPressure = standardcoe.multiply(new BigDecimal(count)).divide(approvecoe, 4, 4);
            sb = new StringBuffer("update T_SSC_WorkPressure set fWorkPressure = case when fWorkPressure - ? < 0 then 0 else fWorkPressure - ? end where fuserId=?");
            params = new Object[]{workPressure, workPressure, userId};
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)("ctx:" + ctx.toString()));
            logger.error((Object)("param:" + params.toString()));
            logger.error((Object)("SQL:" + sb.toString()));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _subtractSingleJob(Context ctx, String userId, String bussAttrId) throws BOSException, EASBizException {
        this.subtractMulitJob(ctx, userId, bussAttrId, 1);
    }
}

