/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.assign.node.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AssignException;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.assign.node.impl.AbstractSscAssignController;
import com.kingdee.eas.base.ssc.app.assign.node.pojo.PersonTrackPojo;
import com.kingdee.eas.base.ssc.app.assign.util.AssignJobUtils;
import com.kingdee.eas.base.ssc.assign.AssignFlowNodeInfo;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class EndAssignFlowController
extends AbstractSscAssignController {
    private static Logger logger = Logger.getLogger(EndAssignFlowController.class);

    @Override
    public boolean isMatch(Context ctx, AssignFlowNodeInfo assignFlowNode, AssignModelInfo modelInfo) throws AssignException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAssignee4MatchSuccess(Context ctx, AssignFlowNodeInfo assignFlowNode, AssignModelInfo modelInfo) throws AssignException {
        List<String> prvEngineeList = assignFlowNode.getPrevEngineeList();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(prvEngineeList);
        prvEngineeList = new ArrayList<String>(set);
        Map userInfoMap = (Map)modelInfo.getDynamicAttributes("userMap");
        PersonTrackPojo personTrack = new PersonTrackPojo("\u7ed3\u675f\u5206\u914d\uff0c\u786e\u8ba4\u7528\u6237");
        personTrack.setInparam(AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, prvEngineeList));
        try {
            if (CollectionUtils.isEmpty(prvEngineeList)) {
                personTrack.setDesc("\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u7528\u6237\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5206\u914d\u4efb\u52a1");
                throw new AssignException(AssignException.NOPOWER);
            }
            boolean isIgnoreMaxOver = false;
            JobInfo jobinfo = (JobInfo)modelInfo.getDynamicAttributes("jobInfo");
            Map map = modelInfo.getExtendPropertiesForMap();
            ArrayList<String> resultList = new ArrayList<String>();
            Map assigneeMap = (Map)modelInfo.getDynamicAttributes("assigneeMap");
            if (map.get("isIgnoreMaxOver") != null) {
                isIgnoreMaxOver = Boolean.valueOf(map.get("isIgnoreMaxOver").toString());
            }
            boolean isOverMax = false;
            double count = 0.0;
            Iterator<String> iterator = prvEngineeList.iterator();
            if (iterator.hasNext()) {
                String userId = iterator.next();
                try {
                    isOverMax = JobUtils.isOverMax(ctx, jobinfo.getBussAttrID().getId().toString(), userId);
                    count = AssignJobUtils.getUserJobOrPressureNumber(ctx, jobinfo.getBussAttrID().getId().toString(), userId);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (!isIgnoreMaxOver && jobinfo.getJoblevel().getValue() > 10 && isOverMax) {
                    personTrack.setDesc(AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, userId) + "\u4efb\u52a1\u8d85\u51fa\u6700\u5927\u5206\u914d\u6570\uff0c\u7528\u6237\u7684\u5f53\u524d\u5206\u914d\u6570\u4e3a\uff1a'" + count + "'\uff0c\u5206\u914d\u4e2d\u65ad");
                    throw new AssignException(AssignException.OVERMAX);
                }
                String consignerId = "";
                if (assigneeMap != null) {
                    consignerId = (String)assigneeMap.get(userId);
                }
                if (StringUtils.isNotBlank((CharSequence)consignerId)) {
                    try {
                        map.put("consigner", consignerId);
                        modelInfo.setExtendPropertiesForMap(map);
                    }
                    catch (Exception e) {
                        throw new AssignException(AssignException.FAILEUPDATECONSIGNER, e);
                    }
                    boolean hasPermission = false;
                    try {
                        hasPermission = AssignJobUtils.checkPermission(ctx, userId, jobinfo);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (!hasPermission) {
                        try {
                            SSCUtil.genAndAllotCompelRole(ctx, jobinfo.getBussAttrID().getId().toString(), userId, jobinfo.getShareCenterID().getId().toString(), true);
                        }
                        catch (Exception e) {
                            throw new AssignException(AssignException.FAILEASSIGNPOWER, e);
                        }
                    }
                }
                modelInfo.setAssignee(BOSUuid.read((String)userId));
                resultList.add(userId);
            }
            StringBuilder sb = new StringBuilder("\u9ed8\u8ba4\u5206\u914d\u7ed9\u7b2c\u4e00\u987a\u5e8f\u4f4d\u7528\u6237\uff1a" + AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, resultList) + "\uff0c\u7528\u6237\u5f53\u524d\u4efb\u52a1\u5206\u914d\u6570\u4e3a\uff1a" + count);
            if (map.get("pullPerson") != null) {
                if (modelInfo.getAssignee().toString().equals(map.get("pullPerson"))) {
                    sb.append("\uff0c\u3010").append(AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, map.get("pullPerson").toString()) + "\u3011\u7528\u6237\u5728\u5206\u914d\u4eba\u5217\u8868\u4e2d\uff0c\u62c9\u53d6\u4efb\u52a1\u6210\u529f");
                } else {
                    sb.append("\uff0c\u3010").append(AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, map.get("pullPerson").toString()) + "\u3011\u7528\u6237\u4e0d\u5728\u5206\u914d\u4eba\u5217\u8868\u4e2d\uff0c\u62c9\u53d6\u4efb\u52a1\u5931\u8d25");
                }
            }
            personTrack.setOutparam(AssignJobUtils.idTransferName((Map<String, UserInfo>)userInfoMap, resultList)).setDesc(sb.toString());
            ArrayList<String> arrayList = resultList;
            return arrayList;
        }
        finally {
            try {
                this.saveAssignPerson(ctx, modelInfo, personTrack.getValues());
            }
            catch (Exception e) {
                logger.error((Object)("\u4fdd\u5b58\u5206\u914d\u4eba\u5458\u8ddf\u8e2a\u8bb0\u5f55\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

