/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.assign.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.ssc.AbstractWorkPressureInfo;
import com.kingdee.eas.base.ssc.AssignRuleCollection;
import com.kingdee.eas.base.ssc.AssignRuleFactory;
import com.kingdee.eas.base.ssc.AssignRuleInfo;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.IUser;
import com.kingdee.eas.base.ssc.JobCollection;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobStateTimeFactory;
import com.kingdee.eas.base.ssc.JobStateTimeInfo;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.SystemAttributeCollection;
import com.kingdee.eas.base.ssc.SystemAttributeFactory;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkPressureCollection;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.app.assign.util.DataTransferUtils;
import com.kingdee.eas.base.ssc.assign.AssignFlowInstCollection;
import com.kingdee.eas.base.ssc.assign.AssignFlowInstEntryCollection;
import com.kingdee.eas.base.ssc.assign.AssignFlowInstEntryFactory;
import com.kingdee.eas.base.ssc.assign.AssignFlowInstFactory;
import com.kingdee.eas.base.ssc.assign.AssignFlowTrackHisCollection;
import com.kingdee.eas.base.ssc.assign.AssignFlowTrackHisFactory;
import com.kingdee.eas.base.ssc.assign.AssignPersonTrackCollection;
import com.kingdee.eas.base.ssc.assign.AssignPersonTrackFactory;
import com.kingdee.eas.base.ssc.bussiness.bean.JobBean;
import com.kingdee.eas.base.ssc.external.TransferFlowSend;
import com.kingdee.eas.base.ssc.tool.EqualDivisionUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.wssc.ImmediateSubmitFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.util.JSONUtils;
import org.apache.log4j.Logger;

public class AssignJobUtils {
    private static Logger logger = Logger.getLogger(AssignJobUtils.class);

    public static boolean checkUserState(Context ctx, UserInfo user) {
        return JobUtils.isEnabledForUser(ctx, user) && StopAssignEnum.normal == user.getIsStopAssign();
    }

    public static boolean checkUserState(Context ctx, UserInfo user, boolean ignoreStopAssign) {
        if (ignoreStopAssign) {
            return JobUtils.isEnabledForUser(ctx, user);
        }
        return AssignJobUtils.checkUserState(ctx, user);
    }

    public static String idTransferName(Map<String, UserInfo> userMap, String userIds) {
        String result = "";
        if (!StringUtils.isEmpty((String)userIds)) {
            result = userMap.get(userIds) == null ? "" : userMap.get(userIds).getName();
        }
        return result;
    }

    public static boolean checkPermission(Context ctx, String userId, String billTypeId, ConsignationTaskTypeEnum taskType) throws BOSException {
        boolean ret = false;
        StringBuffer permSQL = new StringBuffer("select top 1 tem.fid ");
        permSQL.append("from t_ssc_billtype bt ");
        permSQL.append("inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid,rb.fbillnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid) tem ");
        permSQL.append("on bt.fid=tem.fbillnameid ");
        permSQL.append("left join t_ssc_roletype rt on rt.fid=tem.FRoleTypeIDID ");
        permSQL.append("left join t_ssc_roleuser ru on tem.fid = ru.FRoleIDID ");
        permSQL.append("where bt.fid='").append(billTypeId).append("' and ru.fuseridid='").append(userId);
        if (ConsignationTaskTypeEnum.qualityJob.equals((Object)taskType)) {
            permSQL.append("' and rt.FNUMBER ='ROLE_AUDIT'");
        } else if (ConsignationTaskTypeEnum.spotCheckJob.equals((Object)taskType)) {
            permSQL.append("' and rt.FNUMBER ='ROLE_LATER'");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSQL.toString());
            ret = rs.next();
        }
        catch (Exception e) {
            logger.error((Object)("param: userId = " + userId + "\uff1bbillTypeID = " + billTypeId));
        }
        return ret;
    }

    public static void checkPermissionIfNoteExistCreate(Context ctx, String userId, String billTypeId, String shareCenterId, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        boolean isPermission = AssignJobUtils.checkPermission(ctx, userId, billTypeId, taskType);
        if (!isPermission) {
            SSCUtil.genAndAllotCompelRole(ctx, billTypeId, userId, shareCenterId, true, taskType);
        }
    }

    public static String idTransferName(Map<String, UserInfo> userMap, List<String> userIds) {
        StringBuilder sb = new StringBuilder();
        if (userMap != null && userIds != null) {
            for (int i = 0; i < userIds.size(); ++i) {
                sb.append((userMap.get(userIds.get(i)) == null ? "" : userMap.get(userIds.get(i)).getName()) + ",");
            }
            if (sb.length() > 0) {
                sb.setCharAt(sb.length() - 1, ' ');
            }
        }
        return sb.toString();
    }

    public static void jobStateTime(Context ctx, List<JobBean> jobBeanList, UserInfo userInfo, Operation op) throws EASBizException, BOSException {
        try {
            if (jobBeanList != null && jobBeanList.size() > 0) {
                JobBean jobBean = null;
                CoreBaseCollection jobstatetimeList = new CoreBaseCollection();
                for (int i = 0; i < jobBeanList.size(); ++i) {
                    jobBean = jobBeanList.get(i);
                    if (jobBean == null) continue;
                    JobStateTimeInfo jobstatetime = new JobStateTimeInfo();
                    jobstatetime.setJobID(jobBean.getJobInfo());
                    jobstatetime.setNewJobState(jobBean.getJobState());
                    jobstatetime.setOldJobState(jobBean.getJobState());
                    jobstatetime.setChangeTime(new Timestamp(new Date().getTime()));
                    if (userInfo != null) {
                        jobstatetime.setOperatorID(userInfo);
                    }
                    jobstatetime.setOperation(op == null ? Operation.AutoAssign : op);
                    jobstatetime.setBussAttr(jobBean.getJobInfo().getBussAttrID());
                    jobstatetimeList.add((CoreBaseInfo)jobstatetime);
                }
                JobStateTimeFactory.getLocalInstance(ctx).addnew(jobstatetimeList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static void sendTask(Context ctx, List<JobBean> jobBeanList) throws EASBizException, BOSException {
        if (jobBeanList != null && jobBeanList.size() > 0) {
            TransferFlowSend transferFlowSend = new TransferFlowSend();
            JobBean job = null;
            JobInfo jobInfo = null;
            for (int i = 0; i < jobBeanList.size(); ++i) {
                job = jobBeanList.get(i);
                if (job == null || (jobInfo = job.getJobInfo()) == null) continue;
                String FassignId = jobInfo.getAssignId();
                String solution = jobInfo.getSolution();
                String dataCenter = jobInfo.getDataCenter();
                String useID = job.getUserId();
                logger.debug((Object)("transfer interface send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                boolean sendOk = true;
                try {
                    sendOk = transferFlowSend.sendTask(ctx, jobInfo, solution, dataCenter, FassignId, useID);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    try {
                        LogUtil.beginLog((Context)ctx, (String)"AssignJobUtils.sendTask", (BOSObjectType)jobInfo.getId().getType(), (IObjectPK)new ObjectUuidPK(jobInfo.getId()), (String)(jobInfo.getId() + ";" + DataTransferUtils.getExceptionDetail(ex)));
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                if (!sendOk) {
                    logger.error((Object)("transfer interface not send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                }
                logger.debug((Object)"transfer interface end-----------");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistConsignerRelation(Context ctx, String bussAttrId, List<String> userIds, Map<String, List<String>> consignerMap, Map<String, String> assigneeMap) {
        StringBuilder sb = new StringBuilder();
        boolean isExistConsignerRelation = false;
        IRowSet rs = null;
        Object[] param = new Object[]{bussAttrId, "30"};
        try {
            if (EqualDivisionUtils.isEqualDivision(ctx, ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userIds.get(0)))) {
                sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
                sb.append(" FROM T_ssc_consignation c ");
                sb.append(" INNER JOIN t_ssc_consignationentry ce on ce.fparentid = c.FID ");
                sb.append(" inner join t_ssc_user u on c.FCONSIGNERID = u.fid ");
                sb.append(" LEFT JOIN t_ssc_workpressure d on c.FCONSIGNERID = d.fuserid ");
                sb.append(" where c.FCONSIGNERID in " + FormatUtils.list2Sql(userIds));
                sb.append(" and ce.fbusstypeid = ?");
                sb.append(" and c.FSTATUS = ?");
                sb.append(" and u.fisStopAssign = 0");
                sb.append(" and u.FIsEnabled = 1");
                sb.append(" order by d.fworkpressure asc ");
            } else {
                sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
                sb.append(" FROM T_ssc_consignation c ");
                sb.append(" INNER JOIN t_ssc_consignationentry ce on ce.fparentid = c.FID ");
                sb.append(" inner join t_ssc_user u on c.FCONSIGNERID = u.fid ");
                sb.append(" inner join ( ");
                sb.append(" select u.fid,");
                sb.append(" (select count(1) from t_ssc_job j");
                sb.append(" where (j.FPersonnelIDID = u.fid");
                sb.append(" or j.fconsignerid = u.fid)");
                sb.append(" and j.FJobPoolingType = '2'");
                sb.append(" and j.FBussAttrIDID in");
                sb.append(" (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid =");
                sb.append(" (select sy.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where ba.fid = '" + bussAttrId + "')");
                sb.append(" )");
                sb.append(" ) as operatingCount");
                sb.append(" from t_ssc_user u");
                sb.append(" where u.FID in " + FormatUtils.list2Sql(userIds));
                sb.append(" ) tmp on c.FCONSIGNERID = tmp.fid ");
                sb.append(" where c.FCONSIGNERID in " + FormatUtils.list2Sql(userIds));
                sb.append(" and ce.fbusstypeid = ?");
                sb.append(" and c.FSTATUS = ?");
                sb.append(" and u.fisStopAssign = 0");
                sb.append(" and u.FIsEnabled = 1");
                sb.append(" order by tmp.operatingCount asc ");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                isExistConsignerRelation = true;
                String consignerId = rs.getString(1);
                String assigneeId = rs.getString(2);
                List<String> assigneeList = consignerMap.get(consignerId);
                if (null == assigneeList) {
                    assigneeList = new ArrayList<String>();
                }
                assigneeList.add(assigneeId);
                consignerMap.put(consignerId, assigneeList);
                if (null != assigneeMap.get(assigneeId)) continue;
                assigneeMap.put(assigneeId, consignerId);
            }
            JobUtils.closeRS(rs);
        }
        catch (Exception e) {
            logger.error((Object)("Query consigner relation error! sql:" + sb.toString() + ";param:" + JSONUtils.valueToString((Object)param)), (Throwable)e);
        }
        finally {
            JobUtils.closeRS(rs);
        }
        return isExistConsignerRelation;
    }

    public static boolean isEffectConsignByBussAttrId(Context ctx, String bussAttrId, List<String> userIds) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT 1 FROM T_ssc_Consignation c,T_SSC_CONSIGNATIONENTRY ce");
        sb.append(" where ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = '30'");
        sb.append(" and c.FCONSIGNERID in " + FormatUtils.list2Sql(userIds));
        sb.append(" and c.fid = ce.fparentid");
        Object[] params = new Object[]{bussAttrId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("sql:" + sb.toString()));
        }
        return false;
    }

    public static boolean isEffectConsign(Context ctx, String consignerId, String assigneeId, String bussAttrId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT 1 FROM T_ssc_Consignation c,T_SSC_CONSIGNATIONENTRY ce");
        sb.append(" where c.FCONSIGNERID = ?");
        sb.append(" and c.FASSIGNEEID = ?");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = '30'");
        sb.append(" and c.fid = ce.fparentid");
        Object[] params = new Object[]{consignerId, assigneeId, bussAttrId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("sql:" + sb.toString()));
        }
        return false;
    }

    public static double getUserPressureNumber(Context ctx, String userId) throws BOSException {
        AbstractWorkPressureInfo info = null;
        try {
            try {
                info = WorkPressureFactory.getLocalInstance(ctx).getWorkPressureInfo("where user.id = '" + userId + "'");
            }
            catch (InvalidEntityViewException e) {
                WorkPressureCollection colls = WorkPressureFactory.getLocalInstance(ctx).getWorkPressureCollection("where user.id = '" + userId + "'");
                info = colls.get(0);
                WorkPressureFactory.getLocalInstance(ctx).delete("where user.id = '" + userId + "' and id !='" + info.getId().toString() + "'");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info.getWorkPressure().doubleValue();
    }

    public static double getUserJobOrPressureNumber(Context ctx, String bussAttrId, String userId) throws BOSException, EASBizException {
        if (EqualDivisionUtils.isEqualDivision(ctx, ShareCenterUtils.getShareCenterIdBySSCUserId(ctx, userId))) {
            return AssignJobUtils.getUserPressureNumber(ctx, userId);
        }
        return AssignJobUtils.getUserJobNumber(ctx, bussAttrId, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUserJobNumber(Context ctx, String bussAttrId, String userId) throws BOSException {
        IRowSet rs;
        block4: {
            int n;
            SystemAttributeInfo sysAttr = AssignJobUtils.getSystemAttribute(ctx, bussAttrId);
            StringBuffer sql = new StringBuffer();
            sql.append(" select count(1) from t_ssc_job j");
            sql.append(" where j.FPersonnelIDID = ? and j.FJobPoolingType = '2'");
            sql.append(" and j.FBussAttrIDID in (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid = ? )");
            Object[] param = new Object[]{userId, sysAttr.getId().toString()};
            rs = null;
            try {
                int count;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (!rs.next()) break block4;
                n = count = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sql.toString()));
                    logger.error((Object)"Query max task count error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    JobUtils.closeRS(rs);
                    throw throwable;
                }
                JobUtils.closeRS(rs);
            }
            JobUtils.closeRS(rs);
            return n;
        }
        JobUtils.closeRS(rs);
        return 0;
    }

    public static SystemAttributeInfo getSystemAttribute(Context ctx, String bussAttrId) {
        SystemAttributeInfo systemAttributeInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select sy.FID ");
        sql.append(" from T_SSC_BussinessAttribute ba");
        sql.append(" inner join T_SSC_BillType bt on ba.fbilltypeid=bt.fid ");
        sql.append(" inner join t_ssc_systemattribute sy on bt.fsysattrid = sy.fid ");
        sql.append(" where ba.fid = '" + bussAttrId + "'");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        try {
            SystemAttributeCollection systemAttributeCollection = SystemAttributeFactory.getLocalInstance(ctx).getSystemAttributeCollection(view);
            if (systemAttributeCollection != null && systemAttributeCollection.size() > 0) {
                systemAttributeInfo = systemAttributeCollection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("sql:" + sql.toString()));
            logger.error((Object)"Query lv1 systemAttr error!", (Throwable)e);
        }
        return systemAttributeInfo;
    }

    public static UserInfo handleRejectedJob(Context ctx, JobInfo job) throws BOSException {
        UserInfo assignUser = null;
        IUser iUser = UserFactory.getLocalInstance(ctx);
        String sql = "select FPERSONNELIDID from t_ssc_jobhis where FBUSSATTRIDID = ? and FBillID = ? order by fcreatetime desc";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{job.getBussAttrID().getId().toString(), job.getBillID()});
            if (rs != null && rs.next()) {
                assignUser = new UserInfo();
                assignUser.setId(BOSUuid.read((String)rs.getString("FPERSONNELIDID")));
                assignUser = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(assignUser.getId()));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
        }
        JobUtils.closeRS(rs);
        return assignUser;
    }

    public static boolean isExistsCustomerAssignRule(Context ctx, JobInfo job) {
        EntityViewInfo entityViewInfo = AssignJobUtils.getEntityViewInfo(ctx, job.getBussAttrID().getId().toString(), job.getShareCenterID().getId().toString());
        try {
            return AssignRuleFactory.getLocalInstance(ctx).exists(entityViewInfo.getFilter());
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
    }

    public static AssignRuleCollection getCustomerAssignRule(Context ctx, JobInfo job) {
        String busID = job.getBussAttrID().getId().toString();
        EntityViewInfo entityViewInfo = AssignJobUtils.getEntityViewInfo(ctx, busID, job.getShareCenterID().getId().toString());
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("priority"));
        entityViewInfo.setSorter(sorterItemCollection);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("user.*");
        selector.add("role.*");
        selector.add("bussAttr.*");
        selector.add("entry.*");
        entityViewInfo.setSelector(selector);
        try {
            return AssignRuleFactory.getLocalInstance(ctx).getAssignRuleCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static EntityViewInfo getEntityViewInfo(Context ctx, String busID, String shareCenterId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussAttr", (Object)busID));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)shareCenterId));
        String topShareCenterID = "";
        try {
            topShareCenterID = ShareCenterUtils.getTopShareCenter(ctx).get("id") + "";
        }
        catch (Exception e1) {
            logger.error((Object)("find top shareCenterInfo exception!" + e1));
        }
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)topShareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)true));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        return entityViewInfo;
    }

    public static boolean checkPermission(Context ctx, String userId, JobInfo jobInfo) throws BOSException {
        boolean ret = false;
        String bussAttrId = jobInfo.getBussAttrID().getId().toString();
        StringBuffer permSQL = new StringBuffer("select distinct tem.fid ");
        permSQL.append("from t_ssc_bussinessAttribute ba ");
        permSQL.append("inner join (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb left join  t_ssc_role role on role.fid= rb.fparentid) tem ");
        permSQL.append("on ba.fid=tem.fbussnameid ");
        permSQL.append("left join t_ssc_roletype rt on rt.fid=tem.FRoleTypeIDID ");
        permSQL.append("left join t_ssc_roleuser ru on tem.fid = ru.FRoleIDID ");
        permSQL.append("where ba.fid='").append(bussAttrId).append("' and ru.fuseridid='").append(userId).append("' and rt.FNUMBER ='ROLE_BIZ'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)permSQL.toString());
            ret = rs.next();
        }
        catch (Exception e) {
            logger.error((Object)("param: userId = " + userId + "\uff1bbussAttrId = " + bussAttrId));
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public static List<String> getUserMatchOrg(Context ctx, JobInfo job, AssignRuleInfo assignRuleInfo) {
        List<String> resultList = new ArrayList<String>();
        String bussAttrId = job.getBussAttrID().getId().toString();
        String orgId = job.getOrgID().getId().toString();
        ArrayList<String> userIds = new ArrayList<String>();
        UserInfo assignUser = assignRuleInfo.getUser();
        if (assignUser != null) {
            userIds.add(assignUser.getId().toString());
            resultList = JobUtils.getPermissionUserIds(ctx, bussAttrId, null, userIds, orgId);
        }
        if (assignRuleInfo.getRoles() != null) {
            ArrayList<String> roleIdList = new ArrayList<String>();
            String[] roles = assignRuleInfo.getRoles().split(",");
            for (int i = 0; i < roles.length; ++i) {
                roleIdList.add(roles[i]);
            }
            resultList = JobUtils.getPermissionUserIds(ctx, bussAttrId, roleIdList, null, orgId);
        }
        return resultList;
    }

    public static void deleteAssignModelExceptionInfo(Context ctx, List<String> AssignModelExIds) throws BOSException {
        if (null == AssignModelExIds || AssignModelExIds.size() == 0) {
            return;
        }
        String list2Sql = FormatUtils.list2Sql(AssignModelExIds);
        AssignFlowInstCollection flowInstCollection = AssignFlowInstFactory.getLocalInstance(ctx).getAssignFlowInstCollection("select id where assignModel.id in " + list2Sql + " ");
        String flowInstId = FormatUtils.coreBaseCollection2Sql((IObjectCollection)flowInstCollection, "id");
        AssignFlowInstEntryCollection flowInstEntryCollection = AssignFlowInstEntryFactory.getLocalInstance(ctx).getAssignFlowInstEntryCollection("select id where assignFlowInst.id in " + flowInstId + "");
        AssignFlowTrackHisCollection flowTrackHisCollection = AssignFlowTrackHisFactory.getLocalInstance(ctx).getAssignFlowTrackHisCollection("select id where assignModelId in " + list2Sql + " ");
        AssignPersonTrackCollection personTrackCollection = AssignPersonTrackFactory.getLocalInstance(ctx).getAssignPersonTrackCollection("select id where assignModel.id in " + list2Sql + " ");
        ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("delete from t_ssc_AssignFlowInstEntry where fid in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)flowInstEntryCollection, "id"));
        ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("delete from t_ssc_AssignFlowInst where fid in " + flowInstId + " ");
        ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("delete from t_ssc_AssignFlowTrackHis where fid in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)flowTrackHisCollection, "id"));
        ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("delete from t_ssc_AssignPersonTrack where fid in " + FormatUtils.coreBaseCollection2Sql((IObjectCollection)personTrackCollection, "id"));
        ImmediateSubmitFacadeFactory.getLocalInstance((Context)ctx).executeSql("delete from T_SSC_AssignModelException where fid in " + list2Sql + " ");
    }

    public static JobCollection filterNoPersonJobFromJobs(Context ctx, Set<String> jobIds) throws BOSException {
        if (null == jobIds || jobIds.size() == 0) {
            return new JobCollection();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entityViewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", jobIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("personnelID", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personnelID", (Object)"", CompareType.INCLUDE));
        filter.setMaskString("#0 and (#1 or #2)");
        return JobFactory.getLocalInstance(ctx).getJobCollection(entityViewInfo);
    }
}

