/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckPointManager;
import com.kingdee.eas.base.ssc.app.checkpointext.ExecutionRuleConditionEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.comparetype.AbstractCompareType;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.comparetype.CompareTypeFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.handler.AbstractExprHandler;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.handler.CommonExprHandler;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.handler.FunctionExprHandler;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.WrongDataInfo;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointLogUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CompareManager {
    private static Logger logger = Logger.getLogger(CompareManager.class);
    public static final Pattern pattern1 = Pattern.compile("\\{\\$(.*?)}");
    public static final Pattern pattern2 = Pattern.compile("\\{@(.*?)}");
    public static final Pattern pattern3 = Pattern.compile("([a-z|A-Z]*)(?=\\.\\{\\$)");
    public static final Pattern pattern4 = Pattern.compile(".*[+|\\-|*|/].*");
    public static final Pattern pattern5 = Pattern.compile("^-[1-9]\\d*$");
    public static final Map<String, List<WrongDataInfo>> wrongData = new HashMap<String, List<WrongDataInfo>>();
    private static volatile CompareManager compareManger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompareManager getCompareManager() {
        if (compareManger != null) return compareManger;
        Class<CompareManager> clazz = CompareManager.class;
        synchronized (CompareManager.class) {
            if (compareManger != null) return compareManger;
            compareManger = new CompareManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return compareManger;
        }
    }

    public RuleEntryInfo executeRule(Context ctx, RuleEntryInfo ruleEntryInfo, DataInfo filedValue, DataInfo valueValue) throws BOSException, EASBizException {
        IntelligentAuditExecuteRuleEntryInfo entryInfo = ruleEntryInfo.getEntryInfo();
        String jobId = ruleEntryInfo.getJobInfo().getId().toString();
        String compareCharType = entryInfo.getCompare();
        ExecutionRuleConditionEnum conditionEnum = entryInfo.getEntryExecuteRule() == null ? ExecutionRuleConditionEnum.allPass : entryInfo.getEntryExecuteRule();
        boolean result = this.compareS(compareCharType, filedValue, valueValue, conditionEnum);
        CheckPointLogUtils.executeLogRecord(ctx, jobId, "\u68c0\u67e5\u70b9\u89c4\u5219\u5206\u5f55ID:" + entryInfo.getId() + ",\u6bd4\u8f83\u7b26:" + compareCharType + ",\u6bd4\u8f83\u7ed3\u679c:" + result, "CompareManager.executeRule");
        ruleEntryInfo.setResult(result);
        if (!result) {
            if (!wrongData.containsKey(jobId)) {
                wrongData.put(jobId, new ArrayList());
            }
            WrongDataInfo wrongDataInfo = new WrongDataInfo();
            wrongDataInfo.setCheckId(ruleEntryInfo.getCheckpointInfo().getId().toString());
            List<TableModelInfo> file_tableModels = filedValue.getTableModels();
            if (ModelTypeEnum.Table.equals((Object)filedValue.getType())) {
                if (file_tableModels != null && file_tableModels.size() > 0) {
                    for (TableModelInfo tableModel : file_tableModels) {
                        if (!tableModel.isW()) continue;
                        wrongDataInfo.getwIdSet().add(tableModel.getId());
                        if (ruleEntryInfo.getSqlInfo() == null) continue;
                        wrongDataInfo.getwIdSet().addAll(tableModel.getCv().keySet());
                    }
                } else {
                    wrongDataInfo.getwIdSet().add(filedValue.getExpr());
                }
            } else {
                wrongDataInfo.getwIdSet().add(filedValue.getExpr());
                if (file_tableModels != null) {
                    for (TableModelInfo tableModel : file_tableModels) {
                        wrongDataInfo.getwIdSet().add(tableModel.getId());
                    }
                }
            }
            wrongData.get(jobId).add(wrongDataInfo);
        }
        return ruleEntryInfo;
    }

    public DataInfo getExprRealValue(Context ctx, RuleEntryInfo ruleEntryInfo, String columnExpr) throws EASBizException, BOSException {
        DataInfo exprRealValue = null;
        columnExpr = columnExpr.trim();
        AbstractExprHandler handler = null;
        if (!pattern5.matcher(columnExpr).matches() && pattern4.matcher(columnExpr).find()) {
            exprRealValue = this.parseFormulaExpr(ctx, ruleEntryInfo, columnExpr);
        } else {
            handler = CheckPointUtils.hasFunction(columnExpr) ? new FunctionExprHandler(ruleEntryInfo) : new CommonExprHandler(ruleEntryInfo);
            exprRealValue = handler.getExprRealValue(ctx, columnExpr);
        }
        this.verify(exprRealValue, "expr\uff1a" + columnExpr);
        exprRealValue.setExpr(columnExpr);
        if (ModelTypeEnum.Field.equals((Object)exprRealValue.getType())) {
            List<FieldModelInfo> fieldModels = exprRealValue.getFieldModels();
            for (int i = 0; i < fieldModels.size(); ++i) {
                fieldModels.get(i).setF(columnExpr);
            }
        }
        return exprRealValue;
    }

    private DataInfo parseFormulaExpr(Context ctx, RuleEntryInfo ruleEntryInfo, String columnExpr) throws EASBizException, BOSException {
        logger.error((Object)("beforeParse,columnExpr:" + columnExpr));
        AbstractExprHandler handler = null;
        Map<Integer, String> exprFormula = CheckPointUtils.dealExprFormula(columnExpr);
        ModelTypeEnum typeEnum = null;
        List<Object> tableModelInfos = new ArrayList();
        ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
        StringBuilder newColumnExpr = new StringBuilder();
        for (Map.Entry<Integer, String> m : exprFormula.entrySet()) {
            String value = m.getValue().trim();
            if (CheckPointUtils.isNumeric(value) || pattern4.matcher(value).find()) {
                newColumnExpr.append(" " + value + " ");
                continue;
            }
            newColumnExpr.append(" " + value.replace(".", "").replace("{$", "").replace("}", "").replace("(", "").replace(")", "") + " ");
            handler = CheckPointUtils.hasFunction(value) ? new FunctionExprHandler(ruleEntryInfo) : new CommonExprHandler(ruleEntryInfo);
            DataInfo exprRealValue = handler.getExprRealValue(ctx, value);
            typeEnum = exprRealValue.getType();
            if (typeEnum.equals((Object)ModelTypeEnum.Table)) {
                tableModelInfos.addAll(exprRealValue.getTableModels());
            } else {
                fieldModelInfos.addAll(exprRealValue.getFieldModels());
            }
            this.verify(exprRealValue, "expr\uff1a" + value);
        }
        if (typeEnum == null) {
            throw new EASBizException(new NumericExceptionSubItem("001", "\u4e0d\u592a\u53ef\u80fd\u53d1\u751f\u7684\u9519\u8bef"));
        }
        if (!tableModelInfos.isEmpty() && !fieldModelInfos.isEmpty()) {
            typeEnum = ModelTypeEnum.Table;
            FieldModelInfo fieldModelInfo = (FieldModelInfo)fieldModelInfos.get(0);
            for (int i = 0; i < tableModelInfos.size(); ++i) {
                ((TableModelInfo)tableModelInfos.get(i)).getCv().put(fieldModelInfo.getF(), fieldModelInfo.getV());
            }
        }
        DataInfo info = new DataInfo();
        String newExpr = newColumnExpr.toString();
        logger.error((Object)("afterParse,columnExpr:" + newExpr));
        Expression compile = AviatorEvaluator.compile((String)newExpr);
        HashMap<String, Object> newCv = new HashMap<String, Object>();
        if (typeEnum.equals((Object)ModelTypeEnum.Table)) {
            info.setTableModels(new ArrayList<TableModelInfo>());
            CheckPointManager manager = CheckPointManager.getCheckPointManager();
            HashMap<String, List<TableModelInfo>> map = new HashMap<String, List<TableModelInfo>>();
            map.put("temp", tableModelInfos);
            Map<String, List<TableModelInfo>> sameTableData = manager.mergeSameTableData(map);
            tableModelInfos = sameTableData.get("temp");
            int len = tableModelInfos.size();
            for (int j = 0; j < len; ++j) {
                TableModelInfo modelInfo = (TableModelInfo)tableModelInfos.get(j);
                Map<String, Object> cv = modelInfo.getCv();
                newCv = new HashMap();
                for (Map.Entry<String, Object> entry : cv.entrySet()) {
                    if (entry.getValue() != null) {
                        entry.setValue(StringUtils.isEmpty((String)entry.getValue().toString()) ? BigDecimal.ZERO : new BigDecimal(entry.getValue().toString()));
                    } else {
                        entry.setValue(BigDecimal.ZERO);
                    }
                    newCv.put(entry.getKey().replace(".", "").replace("{$", "").replace("}", "").replace("(", "").replace(")", ""), entry.getValue());
                }
                Object o = compile.execute(newCv);
                cv.put(columnExpr, o);
                info.getTableModels().add(modelInfo);
            }
            info.setType(ModelTypeEnum.Table);
            info.setExpr(columnExpr);
        } else {
            int len = fieldModelInfos.size();
            for (int j = 0; j < len; ++j) {
                FieldModelInfo fieldModelInfo = (FieldModelInfo)fieldModelInfos.get(j);
                if (fieldModelInfo.getV() != null) {
                    fieldModelInfo.setV(StringUtils.isEmpty((String)fieldModelInfo.getV().toString()) ? BigDecimal.ZERO : new BigDecimal(fieldModelInfo.getV().toString()));
                } else {
                    fieldModelInfo.setV(BigDecimal.ZERO);
                }
                newCv.put(fieldModelInfo.getF().replace(".", "").replace("{$", "").replace("}", "").replace("(", "").replace(")", ""), fieldModelInfo.getV());
            }
            Object o = compile.execute(newCv);
            info = CheckPointUtils.genFieldModelDataInfo(columnExpr, o);
        }
        return info;
    }

    private boolean compareS(String compareType, DataInfo compareField, DataInfo value, ExecutionRuleConditionEnum conditionEnum) throws EASBizException {
        if (!this.verifyValue(compareType, compareField, value)) {
            if (compareField != null) {
                List<FieldModelInfo> fieldModels = compareField.getFieldModels();
                List<TableModelInfo> tableModels = compareField.getTableModels();
                if (fieldModels != null) {
                    for (FieldModelInfo fieldModel : fieldModels) {
                        fieldModel.setW(true);
                    }
                }
                if (tableModels != null && tableModels.size() > 0) {
                    for (TableModelInfo tableModel : tableModels) {
                        tableModel.setW(true);
                    }
                }
            }
            return false;
        }
        AbstractCompareType handler = CompareTypeFactory.getObjectCompareTypeHandler(compareType);
        if (handler == null) {
            logger.error((Object)("\u627e\u4e0d\u5230\u6bd4\u8f83\u7b26\u7684\u5b9e\u4f8b\u5316\u7c7b\uff1a" + compareType));
            return false;
        }
        return handler.compare(compareType, compareField, value, conditionEnum);
    }

    private boolean verify(DataInfo info, String param) {
        String msg;
        String string = msg = !StringUtils.isEmpty((String)param) ? param.replaceAll("\\{", "").replaceAll("\\}", "") : "";
        if (ModelTypeEnum.Table.equals((Object)info.getType())) {
            if (info.getTableModels().isEmpty()) {
                logger.error((Object)("TableModels's size must be 1 or more\uff0cbut now list is 0\uff01" + msg));
                return false;
            }
        } else if (ModelTypeEnum.Field.equals((Object)info.getType()) && (info.getFieldModels() == null || info.getFieldModels().size() == 0)) {
            logger.error((Object)("FieldModels is null\uff01" + msg));
            return false;
        }
        return true;
    }

    private boolean verifyValue(String compareType, DataInfo compareField, DataInfo compareValue) {
        if (compareField == null || compareValue == null) {
            logger.error((Object)"list's size must be 1 at last\uff0cbut now list is null\uff01");
            return false;
        }
        if (!"is_null".equals(compareType)) {
            return this.verify(compareValue, null);
        }
        if (!this.verify(compareField, null)) {
            return false;
        }
        return this.verify(compareValue, null);
    }
}

