/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.IData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointLogUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class EntityData
implements IData {
    protected Logger logger = Logger.getLogger(this.getClass());
    private String column;

    public EntityData(String column) {
        this.column = column;
    }

    @Override
    public DataInfo getData(Context ctx, RuleEntryInfo ruleEntryInfo) throws EASBizException {
        String[] column_split = this.column.split(",");
        String[] columns = new String[column_split.length];
        if (column_split != null && column_split.length > 0) {
            for (int i = 0; i < column_split.length; ++i) {
                try {
                    Matcher matcher = CompareManager.pattern1.matcher(column_split[i]);
                    if (!matcher.find()) continue;
                    columns[i] = matcher.group(1);
                    continue;
                }
                catch (Exception e) {
                    throw new EASBizException(new NumericExceptionSubItem("XX", "get expr's column failed\uff01column:" + column_split[i]), (Throwable)e);
                }
            }
        }
        IObjectValue billValue = ruleEntryInfo.getBillValue();
        CheckpointEntryFilterCollection entryFilters = ruleEntryInfo.getCheckpointInfo().getEntryFilters();
        IObjectValue filterBillValue = CheckPointUtils.filterObjectValueEntry(ctx, billValue, entryFilters);
        HashMap tableValueMap = new HashMap();
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
        boolean isTableModel = false;
        int len = column_split.length;
        for (int i = 0; i < len; ++i) {
            String s = columns[i];
            if (s == null) continue;
            Object object = CheckPointUtils.getValue(ctx, filterBillValue, s.split("\\."));
            if (object != null) {
                if (object instanceof Map) {
                    HashMap map = (HashMap)object;
                    for (Map.Entry m : map.entrySet()) {
                        if (!tableValueMap.containsKey(m.getKey())) {
                            HashMap mapValue = new HashMap();
                            tableValueMap.put(m.getKey(), mapValue);
                        }
                        ((Map)tableValueMap.get(m.getKey())).put(column_split[i], m.getValue());
                    }
                    isTableModel = true;
                    continue;
                }
                fieldValueMap.put(column_split[i], object);
                continue;
            }
            this.logger.error((Object)("\u6839\u636e\u5b57\u6bb5:" + (String)s + "\u627e\u4e0d\u5230\u6570\u636e! jobId:" + ruleEntryInfo.getJobInfo().getId().toString() + "\uff1b\u9ed8\u8ba4\u4e3a\u7a7a"));
            CheckPointLogUtils.executeLogRecord(ctx, ruleEntryInfo.getJobInfo().getId().toString(), "\u6839\u636e\u5b57\u6bb5:" + (String)s + "\u627e\u4e0d\u5230\u6570\u636e!\uff0c\u9ed8\u8ba4\u4e3a\u7a7a", "EntityData.getData");
        }
        DataInfo info = new DataInfo();
        ArrayList<TableModelInfo> tableModelInfos = new ArrayList<TableModelInfo>();
        info.setTableModels(tableModelInfos);
        if (isTableModel) {
            for (Map.Entry entry : tableValueMap.entrySet()) {
                TableModelInfo modelInfo = new TableModelInfo();
                modelInfo.setId((String)entry.getKey());
                Map value = (Map)entry.getValue();
                if (!fieldValueMap.isEmpty()) {
                    for (Map.Entry entryHead : fieldValueMap.entrySet()) {
                        value.put(entryHead.getKey(), entryHead.getValue());
                    }
                }
                modelInfo.getCv().putAll(value);
                tableModelInfos.add(modelInfo);
            }
            info.setType(ModelTypeEnum.Table);
        } else {
            ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
            info.setFieldModels(fieldModelInfos);
            for (Map.Entry entry : fieldValueMap.entrySet()) {
                FieldModelInfo modelInfo = new FieldModelInfo();
                modelInfo.setF((String)entry.getKey());
                modelInfo.setV(entry.getValue());
                fieldModelInfos.add(modelInfo);
            }
            info.setType(ModelTypeEnum.Field);
        }
        return info;
    }
}

