/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.function;

import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.AvgFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.DateTimeDifFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.MaxFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.MinFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.SumFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.SumGroupByFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class CustomerFunction {
    protected Logger logger = Logger.getLogger(this.getClass());
    public static final Pattern avgReg = Pattern.compile("avg\\((.*?)\\)");
    public static final Pattern maxReg = Pattern.compile("max\\((.*?)\\)");
    public static final Pattern minReg = Pattern.compile("min\\((.*?)\\)");
    public static final Pattern sumReg = Pattern.compile("sum\\((.*?)\\)");
    public static final Pattern sumGroupByReg = Pattern.compile("sumGroupBy\\((.*?)\\)");
    public static final Pattern dateTimeDifReg = Pattern.compile("dateTimeDif\\((.*?)\\)");
    public static final Map<String, CustomerFunction> functions;
    public static final Map<String, Pattern> funtionReg;

    public abstract String getFunctionClassify();

    public abstract String getFunctionName();

    public abstract String getFunctionAlias();

    public abstract String getFunctionDesc();

    public abstract DataInfo execute(DataInfo var1, String var2) throws EASBizException;

    public abstract String getFuncParamType();

    static {
        HashMap<String, CustomerFunction> tempFunction = new HashMap<String, CustomerFunction>(6);
        tempFunction.put("avg", new AvgFunction());
        tempFunction.put("max", new MaxFunction());
        tempFunction.put("min", new MinFunction());
        tempFunction.put("sum", new SumFunction());
        tempFunction.put("sumGroupBy", new SumGroupByFunction());
        tempFunction.put("dateTimeDif", new DateTimeDifFunction());
        functions = Collections.unmodifiableMap(tempFunction);
        HashMap<String, Pattern> tempReg = new HashMap<String, Pattern>(tempFunction.size());
        tempReg.put("avg", avgReg);
        tempReg.put("max", maxReg);
        tempReg.put("min", minReg);
        tempReg.put("sum", sumReg);
        tempReg.put("sumGroupBy", sumGroupByReg);
        tempReg.put("dateTimeDif", dateTimeDifReg);
        funtionReg = Collections.unmodifiableMap(tempReg);
    }
}

