/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.function;

import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.ComplexFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class DateTimeDifFunction
extends ComplexFunction {
    @Override
    public String getFunctionClassify() {
        return "\u65e5\u671f\u51fd\u6570,DateFuncGroup";
    }

    @Override
    public String getFunctionName() {
        return "dateTimeDif";
    }

    @Override
    public String getFunctionAlias() {
        return "";
    }

    @Override
    public String getFunctionDesc() {
        return "\u529f\u80fd\uff1a\u8ba1\u7b97\u65e5\u671f\u5dee\u3002\n\u4f7f\u7528\u65b9\u6cd5\uff1adateTimeDif (beginTimeField,endTimeField,model)\nbeginTimeField\uff1a\u5f00\u59cb\u65f6\u95f4\u3002\nendTimeField\uff1a\u7ed3\u675f\u65f6\u95f4\u3002\nmodel\uff1a\u6a21\u5f0f\u3002\u201cMIN\u201d\u8ba1\u7b97\u5206\u949f\u5dee\uff0c\u201cH\u201d\u8ba1\u7b97\u5c0f\u65f6\u5dee\uff0c\u201cD\u201d\u8ba1\u7b97\u5929\u6570\u5dee\uff0c\u201cM\u201d\u8ba1\u7b97\u6708\u4efd\u5dee\uff0c\u201cY\u201d\u8ba1\u7b97\u5e74\u4efd\u5dee\n";
    }

    @Override
    public DataInfo execute(DataInfo args, String columnNames) throws EASBizException {
        String[] split = columnNames.split(",");
        String model = split[2];
        String beginField = split[0];
        String endField = split[1];
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (ModelTypeEnum.Field.equals((Object)args.getType())) {
                List<FieldModelInfo> fieldModels = args.getFieldModels();
                if (fieldModels.size() == 2) {
                    String beginTime = null;
                    String endTime = null;
                    for (FieldModelInfo fieldModelInfo : fieldModels) {
                        if (fieldModelInfo.getF().equals(beginField)) {
                            beginTime = (String)fieldModelInfo.getV();
                            continue;
                        }
                        if (!fieldModelInfo.getF().equals(endField)) continue;
                        endTime = (String)fieldModelInfo.getV();
                    }
                    if (beginField.equals(endField)) {
                        beginTime = endTime;
                    }
                    FieldModelInfo fieldModelInfo = new FieldModelInfo();
                    fieldModelInfo.setF(columnNames);
                    if (beginTime != null && endTime != null) {
                        double datedif = this.getDatedifByModel(format.parse(beginTime), format.parse(endTime), model);
                        args.setType(ModelTypeEnum.Field);
                        fieldModelInfo.setV(datedif);
                    } else {
                        this.logger.error((Object)("search data no data , expr = " + args.getExpr()));
                        fieldModelInfo.setV(0);
                    }
                    ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
                    fieldModelInfos.add(fieldModelInfo);
                    args.setFieldModels(fieldModelInfos);
                } else {
                    this.logger.error((Object)("wrong data size = " + fieldModels.size()));
                }
            } else {
                List<TableModelInfo> tableModels = args.getTableModels();
                ArrayList<TableModelInfo> tableModels_new = new ArrayList<TableModelInfo>();
                if (tableModels.size() > 0) {
                    for (TableModelInfo tableModelInfo : tableModels) {
                        Set<Map.Entry<String, Object>> entries = tableModelInfo.getCv().entrySet();
                        String beginTime = null;
                        String endTime = null;
                        for (Map.Entry<String, Object> entry : entries) {
                            if (entry.getKey().equals(beginField)) {
                                beginTime = (String)entry.getValue();
                                continue;
                            }
                            if (!entry.getKey().equals(endField)) continue;
                            endTime = (String)entry.getValue();
                        }
                        if (beginField.equals(endField)) {
                            beginTime = endTime;
                        }
                        TableModelInfo modelInfo = new TableModelInfo();
                        modelInfo.setId(tableModelInfo.getId());
                        HashMap<String, Object> cv = new HashMap<String, Object>();
                        if (beginTime != null && endTime != null) {
                            double datedif = this.getDatedifByModel(format.parse(beginTime), format.parse(endTime), model);
                            cv.put(columnNames, datedif);
                        } else {
                            this.logger.error((Object)("search data no data , expr = " + args.getExpr() + "entryId = " + tableModelInfo.getId()));
                            cv.put(columnNames, 0);
                        }
                        modelInfo.setCv(cv);
                        tableModels_new.add(modelInfo);
                    }
                } else {
                    TableModelInfo modelInfo = new TableModelInfo();
                    modelInfo.setId("datetimeDif" + new Random().nextInt(1000));
                    HashMap<String, Object> cv = new HashMap<String, Object>();
                    cv.put(columnNames, 0);
                    modelInfo.setCv(cv);
                    tableModels_new.add(modelInfo);
                }
                args.setTableModels(tableModels_new);
            }
        }
        catch (ParseException e) {
            this.logger.error((Object)"time transfer fail;");
        }
        return args;
    }

    private double getDatedifByModel(Date beginTime, Date endTime, String model) {
        if ("MIN".equalsIgnoreCase(model)) {
            double result = (double)Math.round((endTime.getTime() - beginTime.getTime()) * 100L / 60000L) / 100.0;
            return result;
        }
        if ("H".equalsIgnoreCase(model)) {
            double result = (double)Math.round((endTime.getTime() - beginTime.getTime()) * 100L / 3600000L) / 100.0;
            return result;
        }
        if ("D".equalsIgnoreCase(model)) {
            double result = (double)Math.round((endTime.getTime() - beginTime.getTime()) * 100L / 86400000L) / 100.0;
            return result;
        }
        if ("M".equalsIgnoreCase(model)) {
            Calendar end = Calendar.getInstance();
            Calendar begin = Calendar.getInstance();
            end.setTime(endTime);
            begin.setTime(beginTime);
            int day = end.get(5) - begin.get(5);
            int month = end.get(2) - begin.get(2);
            int year = end.get(1) - begin.get(1);
            return new BigDecimal(12 * year).add(new BigDecimal(month)).add(new BigDecimal(day).divide(new BigDecimal("30"), 2, 0)).doubleValue();
        }
        if ("Y".equalsIgnoreCase(model)) {
            Calendar end = Calendar.getInstance();
            Calendar begin = Calendar.getInstance();
            end.setTime(endTime);
            begin.setTime(beginTime);
            int month = end.get(2) - begin.get(2);
            int year = end.get(1) - begin.get(1);
            int day = end.get(5) - begin.get(5);
            return new BigDecimal(year).add(new BigDecimal(month).add(new BigDecimal(day).divide(new BigDecimal("30"), 3, 0)).divide(new BigDecimal("12"), 2, 0)).doubleValue();
        }
        return 0.0;
    }
}

