/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.function;

import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.ComplexFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SumGroupByFunction
extends ComplexFunction {
    @Override
    public DataInfo execute(DataInfo args, String columnNames) throws EASBizException {
        List<TableModelInfo> tableModels;
        if (args == null) {
            return null;
        }
        String[] columnArr = columnNames.split(",", 2);
        List<TableModelInfo> tableModels_New = tableModels = args.getTableModels();
        if (ModelTypeEnum.Table.equals((Object)args.getType())) {
            tableModels_New = this.getSumdataByTableModel(args, tableModels, columnArr);
        }
        args.getTableModels().clear();
        args.setTableModels(tableModels_New);
        args.getAttrs().put("comparebyid", true);
        return args;
    }

    private List<TableModelInfo> getSumdataByTableModel(DataInfo args, List<TableModelInfo> tableModels, String[] columnArr) {
        ArrayList<TableModelInfo> tableModels_new = new ArrayList<TableModelInfo>();
        String sumColumn = columnArr[0];
        String[] groupColumn = columnArr[1].split(",");
        HashMap<String, BigDecimal> temp_sumColumn = new HashMap<String, BigDecimal>(tableModels.size());
        int len = tableModels.size();
        for (int i = 0; i < len; ++i) {
            TableModelInfo tableModelInfo = tableModels.get(i);
            Map<String, Object> cv = tableModelInfo.getCv();
            StringBuilder keys = new StringBuilder();
            for (String c : groupColumn) {
                keys.append(cv.get(c) + ",");
            }
            keys.setCharAt(keys.length() - 1, ' ');
            String key = keys.toString().trim();
            if (!temp_sumColumn.containsKey(key)) {
                temp_sumColumn.put(key, BigDecimal.ZERO);
            }
            BigDecimal sum = ((BigDecimal)temp_sumColumn.get(key)).add(new BigDecimal(cv.get(sumColumn).toString()));
            temp_sumColumn.put(key, sum);
        }
        String pinyin = "";
        for (Map.Entry m : temp_sumColumn.entrySet()) {
            TableModelInfo info = new TableModelInfo();
            pinyin = (String)m.getKey();
            if (CheckPointUtils.isContainChinese(pinyin)) {
                pinyin = CheckPointUtils.getAllFirstLetter(pinyin);
            }
            info.setId(args.getExpr() + "sumgroupby" + "g" + pinyin);
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put(sumColumn, ((BigDecimal)m.getValue()).stripTrailingZeros().toPlainString());
            int len2 = groupColumn.length;
            for (int i = 0; i < len2; ++i) {
                map.put(groupColumn[i], ((String)m.getKey()).split(",")[i]);
            }
            info.setCv(map);
            tableModels_new.add(info);
        }
        return tableModels_new;
    }

    @Override
    public String getFunctionClassify() {
        return "\u5206\u7ec4\u805a\u5408\u51fd\u6570,AggregateFuncGroup";
    }

    @Override
    public String getFunctionName() {
        return "sumGroupBy";
    }

    @Override
    public String getFunctionAlias() {
        return "";
    }

    @Override
    public String getFunctionDesc() {
        return "\u529f\u80fd\uff1a\u6309\u7167\u6307\u5b9a\u5b57\u6bb5\u5206\u7c7b\u6c47\u603b\u3002\n\u4f7f\u7528\u65b9\u6cd5\uff1asumGroupBy (exp,group1,group2,\u2026groupn)\nexp\uff1a\u6570\u503c\u5b57\u6bb5\u3002\u6c47\u603b\u5bf9\u8c61\u3002\ngroup1~n\uff1a\u5206\u7c7b\u6c47\u603b\u4f9d\u636e,\u53ef\u4ee5\u6709\u591a\u4e2a\u4f9d\u636e\uff0c\u5212\u5206\u66f4\u7ec6\u81f4\u7684\u5206\u7c7b\u3002\n\u793a\u4f8b1\uff1a\nsumGroupBy (table1.fAmount,table1.fType)<= sumGroupBy (table2.Amount,table2.Type)\n\u5728\u89c4\u5219\u4e2d\u505a\u5982\u4e0a\u8bbe\u7f6e\uff0c\u6267\u884c\u65f6\u5206\u7c7b\u4f9d\u636e\u76f8\u540ctable1.fType\u7b49\u4e8etable2.Type\u7684\u5206\u7c7b\u6c47\u603b\u503c\u8fdb\u884c\u6bd4\u8f83\u3002\n\u5982\u679c\u6709\u591a\u4e2a\u5206\u7c7b\u4f9d\u636e\uff0c\u5219\u591a\u4e2a\u5206\u7c7b\u4f9d\u636e\u90fd\u76f8\u540c\u7684\u6c47\u603b\u503c\u8fdb\u884c\u6bd4\u8f83\u3002\n\n\u793a\u4f8b2\uff1a\nsumGroupBy (table1.fAmount,table1.fType)<= table2.Amount\n\u5728\u89c4\u5219\u4e2d\u8bbe\u7f6e\u5982\u4e0a\u89c4\u5219\uff0c\u5219\u5206\u7c7b\u6c47\u603b\u7684\u6bcf\u4e2a\u503c\u90fdtable2. Amount\u7684\u503c\u8fdb\u884c\u6bd4\u8f83\u3002\n\n\u793a\u4f8b3\uff1a\nsumGroupBy (table1.fAmount,table1.fType,table1.fTypeName)\n\u5728\u5c55\u793a\u5b57\u6bb5\u4e2d\u505a\u5982\u4e0a\u8bbe\u7f6e\uff0c\u5219\u5728\u68c0\u67e5\u70b9\u4e2d\u4ee5\u8868\u683c\u5f62\u5f0f\u5c55\u793a\u6570\u636e\uff0c\u5c55\u793a\u7684\u5217\u5206\u522b\u4e3a\uff1atable1.fType table1.fTypeName  \u5206\u7c7b\u6c47\u603b\u503c\u3002\n";
    }

    @Override
    public String getFuncParamType() {
        return "0:false,1:true";
    }
}

