/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.transfer.rule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.rule.AbstractColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.rule.EntryColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.rule.HeadColumn;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.DataSetUtils;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RuleTransfer {
    private static Logger logger = Logger.getLogger(RuleTransfer.class);
    static Pattern pattern1 = Pattern.compile("[\\+\\-\\*\\/]");

    public RuleEntryInfo transferExecuteRule(Context ctx, IntelligentAuditCheckpointInfo info) throws EASBizException, BOSException {
        RuleEntryInfo ruleEntryInfo = new RuleEntryInfo();
        IntelligentAuditExecuteRuleEntryCollection executeRuleEntryCollection = info.getExecuteRule();
        CheckpointDataSetInfo dataSet = info.getDataSet();
        IntelligentDataShowCfgCollection showCfgCollection = info.getShowCfgEntrys();
        CheckpointEntryFilterCollection entryFilters = info.getEntryFilters();
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        if (dataSet != null && dataSet.getEntrys() != null) {
            Map<String, Map<String, String>> allTableNameAndEntityName = DataSetUtils.getAllTableNameAndEntityName(ctx, dataSet, executeRuleEntryCollection, showCfgCollection, entryFilters);
            ruleEntryInfo.getAliasEntityName().putAll(allTableNameAndEntityName.get("entityname-app"));
            ruleEntryInfo.getAliasTableName().putAll(allTableNameAndEntityName.get("tablename-app"));
            Map<String, String> tableColumnFromDataSet = this.getTableColumnFromDataSet(ctx, dataSet, ruleEntryInfo);
            formulaColumn.putAll(tableColumnFromDataSet);
        }
        if (executeRuleEntryCollection != null && executeRuleEntryCollection.size() > 0) {
            Map<String, String> tableColumnFromExecuteRuleEntry = this.getTableColumnFromExecuteRuleEntry(ctx, executeRuleEntryCollection, ruleEntryInfo);
            formulaColumn.putAll(tableColumnFromExecuteRuleEntry);
        }
        if (showCfgCollection != null && showCfgCollection.size() > 0) {
            Map<String, String> tableColumnFromShowCfg = this.getTableColumnFromShowCfg(ctx, showCfgCollection, ruleEntryInfo);
            formulaColumn.putAll(tableColumnFromShowCfg);
        }
        if (entryFilters != null && entryFilters.size() > 0) {
            Map<String, String> tableColumnFromEntryFilter = this.getTableColumnFromEntryFilter(ctx, entryFilters, ruleEntryInfo);
            formulaColumn.putAll(tableColumnFromEntryFilter);
        }
        ruleEntryInfo.setFormulaColumn(formulaColumn);
        return ruleEntryInfo;
    }

    public Map<String, String> getTableColumnFromDataSet(Context ctx, CheckpointDataSetInfo dataSetInfo, RuleEntryInfo ruleEntryInfo) throws EASBizException {
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        if (dataSetInfo.getEntrys() != null) {
            int len = dataSetInfo.getEntrys().size();
            for (int i = 0; i < len; ++i) {
                CheckpointDataSetEntryInfo entryInfo = dataSetInfo.getEntrys().get(i);
                formulaColumn.putAll(this.getTableColumn1(ctx, ruleEntryInfo, entryInfo.getCompareFieldAlias() + "." + entryInfo.getCompareField()));
                formulaColumn.putAll(this.getTableColumn1(ctx, ruleEntryInfo, entryInfo.getCompareValueAlias() + "." + entryInfo.getCompareValue()));
            }
        }
        return formulaColumn;
    }

    private Map<String, String> getTableColumnFromShowCfg(Context ctx, IntelligentDataShowCfgCollection showCfgCollection, RuleEntryInfo ruleEntryInfo) throws EASBizException, BOSException {
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        int len = showCfgCollection.size();
        for (int i = 0; i < len; ++i) {
            IntelligentDataShowCfgInfo intelligentShowCfgInfo = showCfgCollection.get(i);
            IntelligentDataShowCfgFieldEntryCollection showCfgFieldEntry = (IntelligentDataShowCfgFieldEntryCollection)((Object)intelligentShowCfgInfo.get("filedentry-app"));
            int len1 = showCfgFieldEntry.size();
            for (int j = 0; j < len1; ++j) {
                IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = showCfgFieldEntry.get(j);
                formulaColumn.putAll(this.getTableColumn(ctx, ruleEntryInfo, fieldEntryInfo.getFieldAlias()));
            }
        }
        return formulaColumn;
    }

    private Map<String, String> getTableColumnFromEntryFilter(Context ctx, CheckpointEntryFilterCollection entryFilters, RuleEntryInfo ruleEntryInfo) throws EASBizException, BOSException {
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        int len = entryFilters.size();
        for (int i = 0; i < len; ++i) {
            CheckpointEntryFilterInfo intelligentShowCfgInfo = entryFilters.get(i);
            formulaColumn.putAll(this.getTableColumn(ctx, ruleEntryInfo, intelligentShowCfgInfo.getCompareFieldAlias()));
            formulaColumn.putAll(this.getTableColumn(ctx, ruleEntryInfo, intelligentShowCfgInfo.getCompareValueAlias()));
        }
        return formulaColumn;
    }

    private Map<String, String> getTableColumnFromExecuteRuleEntry(Context ctx, IntelligentAuditExecuteRuleEntryCollection executeRuleEntryCollection, RuleEntryInfo ruleEntryInfo) throws EASBizException {
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        int len = executeRuleEntryCollection.size();
        for (int i = 0; i < len; ++i) {
            String value;
            IntelligentAuditExecuteRuleEntryInfo executeRuleEntryInfo = executeRuleEntryCollection.get(i);
            String field = executeRuleEntryInfo.getCompareFieldEntity();
            if (StringUtils.isNotEmpty((CharSequence)field) && field.contains("{$")) {
                formulaColumn.putAll(this.getTableColumn(ctx, ruleEntryInfo, field));
            }
            if (!StringUtils.isNotEmpty((CharSequence)(value = executeRuleEntryInfo.getCompareValueEntity())) || !value.contains("{$")) continue;
            formulaColumn.putAll(this.getTableColumn(ctx, ruleEntryInfo, value));
        }
        return formulaColumn;
    }

    private Map<String, String> getTableColumn(Context ctx, RuleEntryInfo ruleEntryInfo, String sourceEntity) throws EASBizException {
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)sourceEntity)) {
            return formulaColumn;
        }
        if (!sourceEntity.contains("{$")) {
            return formulaColumn;
        }
        if (pattern1.matcher(sourceEntity).find()) {
            Map<Integer, String> formula = CheckPointUtils.dealExprFormula(sourceEntity);
            for (String value : formula.values()) {
                formulaColumn.putAll(this.getTableColumn1(ctx, ruleEntryInfo, value));
            }
        } else {
            formulaColumn.putAll(this.getTableColumn1(ctx, ruleEntryInfo, sourceEntity));
        }
        return formulaColumn;
    }

    private Map<String, String> getTableColumn1(Context ctx, RuleEntryInfo ruleEntryInfo, String entityField) throws EASBizException {
        Map<String, String> aliasEntityName;
        HashMap<String, String> formulaColumn = new HashMap<String, String>();
        List<Object> entityFieldList = new ArrayList();
        if (CheckPointUtils.hasFunction(entityField)) {
            entityFieldList = CheckPointUtils.dealFunction(entityField);
        }
        if (entityFieldList.isEmpty()) {
            entityFieldList.add(entityField);
        }
        if ((aliasEntityName = ruleEntryInfo.getAliasEntityName()).isEmpty()) {
            return formulaColumn;
        }
        for (String string : entityFieldList) {
            String s1 = string.trim();
            if (formulaColumn.containsKey(s1) || !s1.contains("{$")) continue;
            String alias = s1.substring(0, s1.indexOf(".{"));
            String sourceEntity = aliasEntityName.get(alias);
            String realEntity = "";
            if (CompareManager.pattern1.matcher(s1).find()) {
                realEntity = CheckPointUtils.spiltString(s1);
            }
            String column = "";
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(sourceEntity.substring(0, sourceEntity.lastIndexOf("."))));
            if (sourceEntity.contains(".entity")) {
                AbstractColumn entityColumn = null;
                entityColumn = realEntity.contains(".") ? new EntryColumn(ruleEntryInfo) : new HeadColumn(ruleEntryInfo);
                column = entityColumn.getTableColumn(ctx, entityObjectInfo, alias, realEntity);
            }
            formulaColumn.put(s1, column);
        }
        return formulaColumn;
    }
}

