/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.CheckTypeEnum;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskCollection;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFactory;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.app.checkscheme.AbstractCheckRiskFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.checkscheme.IRiskResult;
import com.kingdee.eas.base.ssc.app.checkscheme.RiskResultCollection;
import com.kingdee.eas.base.ssc.app.checkscheme.RiskResultFactory;
import com.kingdee.eas.base.ssc.app.checkscheme.RiskResultInfo;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.wssc.SSCTaskCenterBaseSeviceFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CheckRiskFacadeControllerBean
extends AbstractCheckRiskFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.checkscheme.CheckRiskFacadeControllerBean");

    @Override
    protected String _getCheckBillRisk(Context ctx, String checkJobId) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("taskId", (Object)checkJobId));
        ev.setFilter(filterInfo);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItemInfo);
        ev.setSorter(sorterItemCollection);
        RiskResultCollection coll = RiskResultFactory.getLocalInstance(ctx).getRiskResultCollection(ev);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getResult();
        }
        return "";
    }

    protected String getBillRiskUIPK(Context ctx, SampleLibraryQualityTaskInfo taskInfo) throws BOSException, EASBizException {
        String viewBill;
        CheckSchemeInfo checkScheme = taskInfo.getParent().getCheckScheme();
        String processID = this.getUipkByParamSet(ctx, checkScheme, taskInfo);
        SSCJob sscJob = null;
        if (StringUtils.isNotEmpty((CharSequence)processID)) {
            if (BOSUuid.isValidLength((String)processID)) {
                sscJob = this.getJobId(ctx, new Object[]{taskInfo.getBillId(), processID});
            } else {
                return processID;
            }
        }
        if (sscJob == null) {
            sscJob = this.getJobId(ctx, new Object[]{taskInfo.getBillId()});
        }
        if (StringUtils.isEmpty((CharSequence)(viewBill = SSCTaskCenterBaseSeviceFacadeFactory.getLocalInstance((Context)ctx).viewBill(sscJob.getFSOLUTION(), sscJob.getFDATACENTER(), taskInfo.getBillId(), sscJob.getFASSIGNID())))) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5de5\u4f5c\u6d41\u8282\u70b9\u83b7\u53d6\u5355\u636eUIPK\u5931\u8d25"));
        }
        String UIPK = this.getUIPK(ctx, viewBill);
        if (StringUtils.isEmpty((CharSequence)UIPK)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u4e0d\u5230\u5355\u636eUIPK"));
        }
        return UIPK;
    }

    private SSCJob getJobId(Context ctx, Object[] param) throws EASBizException {
        String jobId = "";
        String solution = null;
        String assignId = null;
        String dataCenter = null;
        boolean isHis = true;
        try {
            IRowSet jobRow;
            IRowSet hisRow = this.getJobHisRowSet(ctx, param);
            if (hisRow.next()) {
                jobId = hisRow.getString(1);
                solution = hisRow.getString(2);
                dataCenter = hisRow.getString(3);
                assignId = hisRow.getString(4);
            }
            if (StringUtils.isEmpty((CharSequence)jobId) && (jobRow = this.getJobRowSet(ctx, param)).next()) {
                jobId = jobRow.getString(1);
                solution = hisRow.getString(2);
                dataCenter = hisRow.getString(3);
                assignId = hisRow.getString(4);
                isHis = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)jobId)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u4e0d\u5230Job/JobHis\u6570\u636e"));
        }
        return SSCJob.builder(jobId, solution, dataCenter, assignId, isHis);
    }

    private IRowSet getJobHisRowSet(Context ctx, Object[] param) throws BOSException {
        if (param.length == 1) {
            String sqlHis = "SELECT FID ,FSOLUTION ,FDATACENTER ,FASSIGNID  FROM t_ssc_jobhis WHERE FBILLID = ? order by fcompleteTme desc";
            return DbUtil.executeQuery((Context)ctx, (String)sqlHis, (Object[])param);
        }
        String sqlHis = "SELECT FID ,FSOLUTION ,FDATACENTER ,FASSIGNID  FROM t_ssc_jobhis WHERE FBILLID = ? AND FBUSSATTRIDID = ?  order by fcompleteTme desc";
        return DbUtil.executeQuery((Context)ctx, (String)sqlHis, (Object[])param);
    }

    private IRowSet getJobRowSet(Context ctx, Object[] param) throws BOSException {
        if (param.length == 1) {
            String sqlHis = "SELECT FID ,FSOLUTION ,FDATACENTER ,FASSIGNID  FROM t_ssc_job WHERE FBILLID = ? ";
            return DbUtil.executeQuery((Context)ctx, (String)sqlHis, (Object[])param);
        }
        String sqlHis = "SELECT FID ,FSOLUTION ,FDATACENTER ,FASSIGNID  FROM t_ssc_job WHERE FBILLID = ? AND FBUSSATTRIDID = ?  ";
        return DbUtil.executeQuery((Context)ctx, (String)sqlHis, (Object[])param);
    }

    private String getUipkByParamSet(Context ctx, CheckSchemeInfo checkScheme, SampleLibraryQualityTaskInfo taskInfo) throws BOSException {
        HashMap<String, String> paramCache = new HashMap<String, String>();
        String shareCenterId = checkScheme.getShareCenterId();
        CheckTypeEnum checkType = checkScheme.getCheckType();
        String dySQL = "";
        dySQL = CheckTypeEnum.afterAudit.equals((Object)checkType) ? " IN ('check','checkIsClose')" : " = 'spotCheck'";
        String sql = " SELECT FBillTypeId,FprocessUIPK from t_ssc_checkBTParam where fshareCenterId = ? and fcheck ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + dySQL), (Object[])new Object[]{shareCenterId});
        try {
            while (rs.next()) {
                paramCache.put(rs.getString(1), rs.getString(2));
            }
            return (String)paramCache.get(checkScheme.getBilltype().getId());
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private String getUIPK(Context ctx, String viewBill) {
        int indexUIPK = viewBill.indexOf("uipk=");
        viewBill = viewBill.substring(indexUIPK);
        int indexY = viewBill.indexOf("&");
        viewBill = viewBill.substring(5, indexY);
        return viewBill;
    }

    protected List<String> getRiskOrgList(Context ctx, String checkJobId) throws BOSException, EASBizException {
        StringBuilder builder = new StringBuilder(100);
        builder.append(" select cr.FRiskOrgId,st.fbillid  from T_SSC_CHECKSCHEME cc ");
        builder.append(" inner join T_SSC_SAMPLELIBRARY sb   on cc.FID = sb.FCHECKSCHEMEID ");
        builder.append(" inner join T_SSC_SAMPLELIBRARYQUALITYTASK st on st.FPARENTID =sb.FID ");
        builder.append(" inner join t_ssc_checkrisk cr on cc.FID =cr.fparentid ");
        builder.append(" where st.FID =? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{checkJobId});
        ArrayList<String> riskOrgList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String riskorg = rowSet.getString(1);
                if (!StringUtils.isNotEmpty((CharSequence)riskorg)) continue;
                riskOrgList.add(riskorg);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u98ce\u63a7\u6a21\u578b\u7ec4\u7ec7\u6267\u884cSQL\u5f02\u5e38"));
        }
        return riskOrgList;
    }

    protected SampleLibraryQualityTaskInfo getTaskInfo(Context ctx, String checkJobId) throws BOSException, EASBizException {
        SelectorItemCollection selector = this.getTaskSelector(ctx, new SelectorItemCollection());
        return SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo(H.PK(checkJobId), selector);
    }

    protected SelectorItemCollection getTaskSelector(Context ctx, SelectorItemCollection selector) {
        selector.add("*");
        selector.add("parent.*");
        selector.add("parent.checkScheme.*");
        selector.add("parent.checkScheme.riskEntry.*");
        selector.add("parent.checkScheme.billtype.*");
        return selector;
    }

    @Override
    protected String _executeCheckRisk(Context ctx, String sampleLibId) throws BOSException, EASBizException {
        logger.error((Object)("********_executeCheckRisk in begin**************" + System.currentTimeMillis() + ";sampleLibId=" + sampleLibId));
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("parent", (Object)sampleLibId));
        ev.setFilter(filter);
        SampleLibraryQualityTaskCollection coll = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskCollection(ev);
        JSONObject json = null;
        CoreBaseCollection baseColl = new CoreBaseCollection();
        IRiskResult instance = RiskResultFactory.getLocalInstance(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            RiskResultInfo result = new RiskResultInfo();
            SampleLibraryQualityTaskInfo taskInfo = coll.get(i);
            String taskJobId = taskInfo.getId().toString();
            String risk = this.doRisk(ctx, taskJobId);
            if (StringUtils.isEmpty((CharSequence)risk)) continue;
            json = JSONObject.parseObject((String)risk);
            boolean allExecSuccess = json.getBoolean("allExecSuccess");
            String billNumber = json.getString("billNumber");
            result.setAllExecSuccess(allExecSuccess);
            result.setBillId(taskInfo.getBillId());
            result.setTaskId(taskJobId);
            result.setBillNumber(billNumber);
            result.setResult(json.toJSONString());
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            result.setCreateTime(timestamp);
            result.setLastUpdateTime(timestamp);
            baseColl.add((CoreBaseInfo)result);
            if (i % 500 != 0 || i <= 0) continue;
            instance.addnewBatchData(baseColl);
            baseColl.clear();
        }
        RiskResultFactory.getLocalInstance(ctx).addnewBatchData(baseColl);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", "true");
        map.put("message", "true");
        return JSON.toJSONString(map);
    }

    protected String doRisk(Context ctx, String checkJobId) throws BOSException, EASBizException {
        SampleLibraryQualityTaskInfo taskInfo = this.getTaskInfo(ctx, checkJobId);
        List<String> riskOrgList = this.getRiskOrgList(ctx, checkJobId);
        if (riskOrgList == null || riskOrgList.size() == 0) {
            return "";
        }
        String uipk = this.getBillRiskUIPK(ctx, taskInfo);
        if (StringUtils.isEmpty((CharSequence)uipk)) {
            return "";
        }
        String json = null;
        try {
            Class<?> managerClass = Class.forName("com.kingdee.eas.base.risk.service.riskManage.RiskBizManager");
            Method service = managerClass.getMethod("getService", Context.class);
            Object object = service.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getModelRiskByRiskOrg", Context.class, String.class, String.class, List.class);
            Object invoke = tMethodService.invoke(object, ctx, taskInfo.getBillId(), uipk, riskOrgList);
            json = JSONObject.toJSONString((Object)invoke);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return json;
    }

    public static class SSCJob {
        private String FID;
        private String FSOLUTION;
        private String FDATACENTER;
        private String FASSIGNID;
        private boolean isHis;

        public String getFID() {
            return this.FID;
        }

        public String getFSOLUTION() {
            return this.FSOLUTION;
        }

        public String getFDATACENTER() {
            return this.FDATACENTER;
        }

        public String getFASSIGNID() {
            return this.FASSIGNID;
        }

        public boolean isHis() {
            return this.isHis;
        }

        private SSCJob(String FID, String FSOLUTION, String FDATACENTER, String FASSIGNID, boolean isHis) {
            this.FID = FID;
            this.FSOLUTION = FSOLUTION;
            this.FDATACENTER = FDATACENTER;
            this.FASSIGNID = FASSIGNID;
            this.isHis = isHis;
        }

        public static SSCJob builder(String FID, String FSOLUTION, String FDATACENTER, String FASSIGNID, boolean isHis) {
            return new SSCJob(FID, FSOLUTION, FDATACENTER, FASSIGNID, isHis);
        }
    }
}

