/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl.plane;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.app.erp.check.impl.BaseCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlaneInvoiceNameInspection
extends BaseCheckService {
    @Override
    public Map<String, String> check(Map map) {
        String billId = this.getBillId(map);
        Context ctx = (Context)map.get("ctx");
        try {
            List<Map<String, String>> planeInvoiceList = InvoiceUtil.getPlaneInvoicesAndCheck(ctx, billId, "customerName");
            if (planeInvoiceList.isEmpty()) {
                return this.printLogAndReturnMap("true", null, null);
            }
            String ladingBiller = InvoiceUtil.getLadingBiller(map);
            ArrayList<String> exceptionInvoiceList = new ArrayList<String>();
            for (Map<String, String> planeInvoice : planeInvoiceList) {
                if (ladingBiller.equals(planeInvoice.get("customerName"))) continue;
                exceptionInvoiceList.add(planeInvoice.get("airNum"));
            }
            if (!exceptionInvoiceList.isEmpty()) {
                String msg = "\u673a\u7968" + ((Object)exceptionInvoiceList).toString() + "\u4e58\u5ba2\u59d3\u540d\u548c\u76ee\u6807\u4eba\u540d\u4e0d\u7b26!";
                return this.printLogAndReturnMap("false", msg, null);
            }
        }
        catch (CheckException e) {
            String msg = "\u98de\u673a\u7968\u4e58\u5ba2\u5b9e\u540d\u68c0\u67e5-" + e.getMessage();
            String errorCode = "ctx:" + ctx.toString() + ",billId:" + billId + "," + e.getCause().getMessage();
            return this.printLogAndReturnMap("false", msg, errorCode);
        }
        return this.printLogAndReturnMap("true", null, null);
    }
}

