/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl.vat;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.app.erp.check.impl.BaseCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InvoiceSalerTaxNoInspection
extends BaseCheckService {
    @Override
    public Map<String, String> check(Map map) {
        String billId = this.getBillId(map);
        Context ctx = (Context)map.get("ctx");
        try {
            List<Map<String, String>> invoiceList = InvoiceUtil.getInvoicesAndCheck(ctx, billId, "salerTaxNo");
            if (invoiceList.isEmpty()) {
                return this.printLogAndReturnMap("true", null, null);
            }
            List<String> taxNumberList = InvoiceUtil.getTaxNumberList(map);
            ArrayList<String> exceptionInvoiceList = new ArrayList<String>();
            for (Map<String, String> invoice : invoiceList) {
                if (taxNumberList.contains(invoice.get("salerTaxNo"))) continue;
                exceptionInvoiceList.add(invoice.get("invoiceNo"));
            }
            if (!exceptionInvoiceList.isEmpty()) {
                String msg = "\u516c\u53f8\u7eb3\u7a0e\u8bc6\u522b\u53f7\u4e3a\uff1a" + this.cutFirstAndEnd(taxNumberList.toString()) + " \n\u68c0\u67e5\u6709\u95ee\u9898\u7684\u53d1\u7968\u53f7\uff1a" + this.cutFirstAndEnd(((Object)exceptionInvoiceList).toString());
                return this.printLogAndReturnMap("false", msg, null);
            }
        }
        catch (CheckException e) {
            String msg = "\u53d1\u7968\u9500\u65b9\u7a0e\u53f7\u68c0\u67e5-" + e.getMessage();
            String errorCode = "ctx:" + ctx.toString() + ",billId:" + billId + "," + e.getCause().getMessage();
            return this.printLogAndReturnMap("false", msg, errorCode);
        }
        return this.printLogAndReturnMap("true", null, null);
    }
}

