/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.app.erp.check.constant.InvoiceConstant;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class InvoiceUtil
implements InvoiceConstant {
    protected static Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.erp.check.BaseInvoiceCheckService");

    public static List<Map<String, String>> getPlaneInvoices(Context ctx, String billId) {
        String cacheKey = "SSC_PLANEINVOICE_BILLID_" + billId;
        ArrayList<Map<String, String>> invoiceList = new ArrayList<Map<String, String>>();
        if (cache.getIfPresent((Object)cacheKey) != null) {
            return (List)cache.getIfPresent((Object)cacheKey);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select p.FId,p.FAirNum,p.FCustomerName,pe.FInvoiceDate,pe.FTakePlaneTime");
            sb.append(" from T_TM_PlaneInvoice p");
            sb.append(" left join T_TM_PlaneInvoiceEntry pe on p.fid = pe.fparentId");
            sb.append(" where p.FBizBillID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billId});
            while (rs.next()) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>();
                invoiceMap.put("id", rs.getString("FID"));
                invoiceMap.put("airNum", rs.getString("FAirNum"));
                invoiceMap.put("customerName", rs.getString("FCustomerName"));
                invoiceMap.put("invoiceDate", rs.getString("FInvoiceDate"));
                invoiceMap.put("takePlaneTime", rs.getString("FTakePlaneTime"));
                invoiceList.add(invoiceMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("billId:" + billId));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        cache.put((Object)cacheKey, invoiceList);
        return invoiceList;
    }

    public static List<Map<String, String>> getPlaneInvoicesAndCheck(Context ctx, String billId, String invoiceFiled) throws CheckException {
        List<Map<String, String>> planeInvoiceList = InvoiceUtil.getPlaneInvoices(ctx, billId);
        for (Map<String, String> planeInvoice : planeInvoiceList) {
            if (StringUtils.isBlank((CharSequence)planeInvoice.get(invoiceFiled))) {
                throw new CheckException(invoiceFiled + "\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + planeInvoice.get("id").toString());
            }
            if (!StringUtils.isBlank((CharSequence)planeInvoice.get("airNum"))) continue;
            throw new CheckException("\u673a\u7968\u53f7\u4e3a\u7a7a\uff01", "param:" + planeInvoice.get("id").toString());
        }
        return planeInvoiceList;
    }

    public static List<Map<String, String>> getTrainInvoices(Context ctx, String billId) {
        String cacheKey = "SSC_TRAININVOICE_BILLID_" + billId;
        ArrayList<Map<String, String>> invoiceList = new ArrayList<Map<String, String>>();
        if (cache.getIfPresent((Object)cacheKey) != null) {
            return (List)cache.getIfPresent((Object)cacheKey);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select FId,FTrainNum,FPassengerName,FInvoiceDate,FTrainTime");
            sb.append(" from T_TM_TrainInvoice");
            sb.append(" where FBizBillID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billId});
            while (rs.next()) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>();
                invoiceMap.put("id", rs.getString("FID"));
                invoiceMap.put("trainNum", rs.getString("FTrainNum"));
                invoiceMap.put("passengerName", rs.getString("FPassengerName"));
                invoiceMap.put("invoiceDate", rs.getString("FInvoiceDate"));
                invoiceMap.put("trainTime", rs.getString("FTrainTime"));
                invoiceList.add(invoiceMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("billId:" + billId));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        cache.put((Object)cacheKey, invoiceList);
        return invoiceList;
    }

    public static List<Map<String, String>> getTrainInvoicesAndCheck(Context ctx, String billId, String invoiceFiled) throws CheckException {
        List<Map<String, String>> invoiceList = InvoiceUtil.getTrainInvoices(ctx, billId);
        for (Map<String, String> invoice : invoiceList) {
            if (StringUtils.isBlank((CharSequence)invoice.get(invoiceFiled))) {
                throw new CheckException(invoiceFiled + "\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
            }
            if (!StringUtils.isBlank((CharSequence)invoice.get("trainNum"))) continue;
            throw new CheckException("\u706b\u8f66\u8f66\u6b21\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
        }
        return invoiceList;
    }

    public static List<Map<String, String>> getTaixInvoices(Context ctx, String billId) {
        String cacheKey = "SSC_TAXIINVOICE_BILLID_" + billId;
        ArrayList<Map<String, String>> invoiceList = new ArrayList<Map<String, String>>();
        if (cache.getIfPresent((Object)cacheKey) != null) {
            return (List)cache.getIfPresent((Object)cacheKey);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select FId,FInvoiceCode,FInvoiceNo,FInvoiceDate,FTimeGetOn");
            sb.append(" from T_TM_TaxiInvoice");
            sb.append(" where FBizBillID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billId});
            while (rs.next()) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>();
                invoiceMap.put("id", rs.getString("FID"));
                invoiceMap.put("InvoiceCode", rs.getString("FInvoiceCode"));
                invoiceMap.put("invoiceNo", rs.getString("FInvoiceNo"));
                invoiceMap.put("invoiceDate", rs.getString("FInvoiceDate"));
                invoiceMap.put("TimeGetOn", rs.getString("FTimeGetOn"));
                invoiceList.add(invoiceMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("billId:" + billId));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        cache.put((Object)cacheKey, invoiceList);
        return invoiceList;
    }

    public static List<Map<String, String>> getTaixInvoicesAndCheck(Context ctx, String billId, String invoiceFiled) throws CheckException {
        List<Map<String, String>> invoiceList = InvoiceUtil.getTrainInvoices(ctx, billId);
        for (Map<String, String> invoice : invoiceList) {
            if (StringUtils.isBlank((CharSequence)invoice.get(invoiceFiled))) {
                throw new CheckException(invoiceFiled + "\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
            }
            if (!StringUtils.isBlank((CharSequence)invoice.get("trainNum"))) continue;
            throw new CheckException("\u706b\u8f66\u8f66\u6b21\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
        }
        return invoiceList;
    }

    private static List<Map<String, String>> getInvoices(Context ctx, String billId) {
        String cacheKey = "SSC_INCOMEINVOICE_BILLID_" + billId;
        ArrayList<Map<String, String>> invoiceList = new ArrayList<Map<String, String>>();
        if (cache.getIfPresent((Object)cacheKey) != null) {
            return (List)cache.getIfPresent((Object)cacheKey);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select FID,FInvoiceNo,FBuyerName,FBuyerTaxNo,FSalerName,FSalerTaxNo");
            sb.append(" from T_TM_CommonSpecialInvoice");
            sb.append(" where FBizBillID = ? union all");
            sb.append(" select FID,FInvoiceNumber as FInvoiceNo,FBuyerName,FBuyerTaxNo,FBillingCompany as FSalerName,FTaxNumber as FSalerTaxNo");
            sb.append(" from T_IM_IncomeInvoice");
            sb.append(" where FBizBillID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{billId, billId});
            while (rs.next()) {
                HashMap<String, String> invoiceMap = new HashMap<String, String>();
                invoiceMap.put("id", rs.getString("FID"));
                invoiceMap.put("invoiceNo", rs.getString("FInvoiceNo"));
                invoiceMap.put("buyerName", rs.getString("FBuyerName"));
                invoiceMap.put("buyerTaxNo", rs.getString("FBuyerTaxNo"));
                invoiceMap.put("salerName", rs.getString("FSalerName"));
                invoiceMap.put("salerTaxNo", rs.getString("FSalerTaxNo"));
                invoiceList.add(invoiceMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("billId:" + billId));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        cache.put((Object)cacheKey, invoiceList);
        return invoiceList;
    }

    public static List<Map<String, String>> getInvoicesAndCheck(Context ctx, String billId, String invoiceFiled) throws CheckException {
        List<Map<String, String>> invoiceList = InvoiceUtil.getInvoices(ctx, billId);
        for (Map<String, String> invoice : invoiceList) {
            if (StringUtils.isBlank((CharSequence)invoice.get(invoiceFiled))) {
                throw new CheckException(invoiceFiled + "\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
            }
            if (!StringUtils.isBlank((CharSequence)invoice.get("invoiceNo"))) continue;
            throw new CheckException("\u53d1\u7968\u53f7\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
        }
        return invoiceList;
    }

    public static List<String> getTaxpayerList(Map map) throws CheckException {
        Context ctx = (Context)map.get("ctx");
        Map param = (Map)map.get("param");
        if (null == param || param.isEmpty()) {
            throw new CheckException("\u83b7\u53d6\u53c2\u6570\u5217\u8868\u5931\u8d25\uff01");
        }
        Object costBearingCompany = param.get(0);
        ArrayList<String> taxpayerList = new ArrayList<String>();
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        if (costBearingCompany instanceof String) {
            try {
                sb.append(" SELECT CASE WHEN LENGTH(FREGISTEREDCODE) = 0 THEN FNAME_L2 ELSE FREGISTEREDCODE END");
                sb.append(" FROM T_ORG_Company");
                try {
                    Map costBearingCompanyMap = JSONUtil.jsonToMap(param.get(0).toString());
                    if (null == costBearingCompanyMap || costBearingCompanyMap.isEmpty()) {
                        throw new CheckException("\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
                    }
                    ArrayList<String> costBearingCompanyList = new ArrayList<String>(costBearingCompanyMap.values());
                    if (BOSUuid.isValid((String)((String)costBearingCompanyList.get(0)), (boolean)true)) {
                        sb.append(" where fid in " + FormatUtils.collection2Sql(costBearingCompanyList));
                    } else {
                        sb.append(" where FNAME_L2 in " + FormatUtils.collection2Sql(costBearingCompanyList));
                    }
                }
                catch (Exception e) {
                    if (BOSUuid.isValid((String)((String)costBearingCompany), (boolean)true)) {
                        sb.append(" where fid = '" + costBearingCompany + "'");
                    }
                    sb.append(" where FNAME_L2 = '" + costBearingCompany + "'");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    taxpayerList.add(rs.getString(1));
                }
            }
            catch (Exception e) {
                throw new CheckException("\u67e5\u8be2\u516c\u53f8\u7eb3\u7a0e\u4eba\u540d\u79f0\u5931\u8d25\uff01", "param:" + param.get(0).toString());
            }
        }
        throw new CheckException("\u67e5\u8be2\u516c\u53f8\u7eb3\u7a0e\u4eba\u540d\u79f0\u5931\u8d25\uff01", "param:" + costBearingCompany.getClass().getName());
        if (taxpayerList.isEmpty()) {
            throw new CheckException("\u516c\u53f8\u7eb3\u7a0e\u4eba\u540d\u79f0\u5217\u8868\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
        }
        return taxpayerList;
    }

    public static List<String> getTaxNumberList(Map map) throws CheckException {
        Context ctx = (Context)map.get("ctx");
        Map param = (Map)map.get("param");
        if (null == param || param.isEmpty()) {
            throw new CheckException("\u83b7\u53d6\u53c2\u6570\u5217\u8868\u5931\u8d25\uff01");
        }
        Object costBearingCompany = param.get(0);
        ArrayList<String> taxNumberList = new ArrayList<String>();
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        if (costBearingCompany instanceof String) {
            try {
                sb.append(" SELECT FTaxNumber");
                sb.append(" FROM T_ORG_Company");
                try {
                    Map costBearingCompanyMap = JSONUtil.jsonToMap(param.get(0).toString());
                    if (null == costBearingCompanyMap || costBearingCompanyMap.isEmpty()) {
                        throw new CheckException("\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
                    }
                    ArrayList<String> costBearingCompanyList = new ArrayList<String>(costBearingCompanyMap.values());
                    if (BOSUuid.isValid((String)((String)costBearingCompanyList.get(0)), (boolean)true)) {
                        sb.append(" where fid in " + FormatUtils.collection2Sql(costBearingCompanyList));
                    } else {
                        sb.append(" where FNAME_L2 in " + FormatUtils.collection2Sql(costBearingCompanyList));
                    }
                }
                catch (Exception e) {
                    if (BOSUuid.isValid((String)((String)costBearingCompany), (boolean)true)) {
                        sb.append(" where fid = '" + costBearingCompany + "'");
                    }
                    sb.append(" where FNAME_L2 = '" + costBearingCompany + "'");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    taxNumberList.add(rs.getString(1));
                }
            }
            catch (Exception e) {
                throw new CheckException("\u67e5\u8be2\u516c\u53f8\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5931\u8d25\uff01", "param:" + param.get(0).toString());
            }
        }
        throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + costBearingCompany.getClass().getName());
        if (taxNumberList.isEmpty()) {
            throw new CheckException("\u516c\u53f8\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5217\u8868\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
        }
        for (String taxNumber : taxNumberList) {
            if (!StringUtils.isBlank((CharSequence)taxNumber)) continue;
            throw new CheckException("\u516c\u53f8\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
        }
        return taxNumberList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLadingBiller(Map map) throws CheckException {
        Context ctx = (Context)map.get("ctx");
        Map param = (Map)map.get("param");
        if (null == param || param.isEmpty()) {
            throw new CheckException("\u83b7\u53d6\u53c2\u6570\u5217\u8868\u5931\u8d25\uff01");
        }
        Object ladingBillerObj = param.get(0);
        String ladingBiller = "";
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        if (!(ladingBillerObj instanceof String)) throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + ladingBillerObj.getClass().getName());
        try {
            if (BOSUuid.isValid((String)((String)ladingBillerObj), (boolean)true)) {
                sb.append(" SELECT FNAME_L2");
                sb.append(" FROM T_PM_USER");
                sb.append(" where fid = ?");
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{ladingBillerObj});
                if (rs.next()) {
                    ladingBiller = rs.getString(1);
                }
            } else {
                ladingBiller = (String)ladingBillerObj;
            }
        }
        catch (Exception e) {
            throw new CheckException("\u67e5\u8be2\u5ba2\u6237\u5b9e\u540d\u5931\u8d25\uff01", "param:" + param.get(0).toString());
        }
        if (!StringUtils.isBlank((CharSequence)ladingBiller)) return ladingBiller;
        throw new CheckException("\u5ba2\u6237\u5b9e\u540d\u4e3a\u7a7a\uff01", "param:" + param.get(0).toString());
    }

    public static Map<String, Date> getStartAndEndDate(Map map) throws CheckException {
        Map param = (Map)map.get("param");
        if (null == param || param.isEmpty()) {
            throw new CheckException("\u83b7\u53d6\u53c2\u6570\u5217\u8868\u5931\u8d25\uff01");
        }
        Object startDateObj = param.get(0);
        Object endDateObj = param.get(1);
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        Date startDate = InvoiceUtil.getStartDate(InvoiceUtil.getDateList(startDateObj));
        Date endDate = InvoiceUtil.getEndDate(InvoiceUtil.getDateList(endDateObj));
        dateMap.put("startDate", startDate);
        dateMap.put("endDate", endDate);
        return dateMap;
    }

    private static Date getStartDate(List<Object> dateList) {
        Date startDate = (Date)dateList.get(0);
        for (int i = 1; i < dateList.size(); ++i) {
            Date tempDate = (Date)dateList.get(i);
            if (!startDate.after(tempDate)) continue;
            startDate = tempDate;
        }
        return startDate;
    }

    private static Date getEndDate(List<Object> dateList) {
        Date endDate = (Date)dateList.get(0);
        for (int i = 1; i < dateList.size(); ++i) {
            Date tempDate = (Date)dateList.get(i);
            if (!endDate.before(tempDate)) continue;
            endDate = tempDate;
        }
        return endDate;
    }

    private static Date dateParse(String dateStr) throws CheckException {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = sdf.parse(dateStr);
                return date;
            }
            catch (ParseException e1) {
                throw new CheckException("\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff01", "param:" + dateStr);
            }
        }
    }

    private static List<Object> getDateList(Object dateObjStr) throws CheckException {
        ArrayList<Object> dateList;
        block8: {
            dateList = new ArrayList<Object>();
            if (dateObjStr instanceof String) {
                try {
                    Map dateMap = JSONUtil.jsonToMap((String)dateObjStr);
                    if (null == dateMap || dateMap.isEmpty()) {
                        throw new CheckException("\u65e5\u671f\u4e3a\u7a7a\uff01", "param:" + dateObjStr.toString());
                    }
                    ArrayList dateObjList = new ArrayList(dateMap.values());
                    if (dateObjList.get(0) instanceof String) {
                        for (Object dateObj : dateObjList) {
                            Date date = InvoiceUtil.dateParse((String)dateObj);
                            dateList.add(date);
                        }
                        break block8;
                    }
                    if (dateObjList.get(0) instanceof Date) {
                        dateList.addAll(dateObjList);
                        break block8;
                    }
                    throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + dateObjList.get(0).getClass().getName());
                }
                catch (Exception e) {
                    Date date = InvoiceUtil.dateParse((String)dateObjStr);
                    dateList.add(date);
                }
            } else {
                throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + dateObjStr.getClass().getName());
            }
        }
        return dateList;
    }

    public static BigDecimal getTotalAmount(Map map) throws CheckException {
        BigDecimal totalAmount;
        block11: {
            Map param = (Map)map.get("param");
            if (null == param || param.isEmpty()) {
                throw new CheckException("\u83b7\u53d6\u53c2\u6570\u5217\u8868\u5931\u8d25\uff01");
            }
            Object amount = param.get(0);
            totalAmount = new BigDecimal(0);
            if (amount instanceof String) {
                try {
                    Map dateMap = JSONUtil.jsonToMap((String)amount);
                    ArrayList dateObjList = new ArrayList(dateMap.values());
                    if (dateObjList.get(0) instanceof String) {
                        for (Object dateObj : dateObjList) {
                            totalAmount = totalAmount.add(new BigDecimal((String)dateObj));
                        }
                        break block11;
                    }
                    if (dateObjList.get(0) instanceof BigDecimal) {
                        for (Object dateObj : dateObjList) {
                            totalAmount = totalAmount.add((BigDecimal)dateObj);
                        }
                        break block11;
                    }
                    throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + dateObjList.get(0).getClass().getName());
                }
                catch (Exception e) {
                    totalAmount = totalAmount.add(new BigDecimal((String)amount));
                }
            } else if (amount instanceof BigDecimal) {
                totalAmount = totalAmount.add((BigDecimal)amount);
            } else {
                throw new CheckException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01", "param:" + amount.getClass().getName());
            }
        }
        return totalAmount;
    }
}

