/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.eas;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.easLogin.EASLoginProxy;
import com.kingdee.eas.base.ssc.app.easLogin.EASLoginProxyServiceLocator;
import com.kingdee.eas.base.ssc.app.easLogin.WSContext;
import com.kingdee.eas.base.ssc.app.erp.eas.EASCfgUtil;
import com.kingdee.eas.base.ssc.erp.eas.EASLoginBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.util.StringUtils;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;

public class CommonUtil {
    private static Logger logger = Logger.getLogger(CommonUtil.class);
    public static String CONFIG_DIR;
    public static String EASLOGIN_PATH;
    public static String REMOTE_PATH;
    public static String LTPATOKEN_PATH;

    public static boolean loginEAS(EASLoginBean easLoginBean, String easLoginWsdl) {
        EASLoginProxyServiceLocator locator = new EASLoginProxyServiceLocator();
        String loginURL = easLoginWsdl;
        logger.info((Object)("eas Login wsdl URL:" + loginURL));
        locator.setEASLoginEndpointAddress(loginURL);
        locator.setMaintainSession(true);
        try {
            String dbType;
            String language;
            String dcName;
            String slnName;
            WSContext ctx;
            String sessionID;
            EASLoginProxy loginProxy = locator.getEASLogin();
            String userName = easLoginBean.getUserName();
            String password = easLoginBean.getPassword();
            if (null == password) {
                password = "";
            }
            if (StringUtils.isEmpty((String)(sessionID = (ctx = loginProxy.login(userName, password, slnName = easLoginBean.getSlnName(), dcName = easLoginBean.getDcName(), language = easLoginBean.getLanguage(), Integer.parseInt(dbType = easLoginBean.getDbType()))).getSessionId()))) {
                logger.error((Object)"login EAS Fail!");
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)"login EAS Fail!");
            return false;
        }
        return true;
    }

    public static WSContext loginEASAndGetReturn(EASLoginBean easLoginBean, String easLoginWsdl) throws EASBizException {
        WSContext result = null;
        try {
            Service s = new Service();
            Call call = (Call)s.createCall();
            call.setOperationName("login");
            call.setTargetEndpointAddress(easLoginWsdl);
            call.setReturnType(new QName("urn:client", "WSContext"));
            call.setReturnClass(WSContext.class);
            call.setReturnQName(new QName("", "loginReturn"));
            call.setTimeout(Integer.valueOf(60000));
            call.setMaintainSession(true);
            result = (WSContext)call.invoke(new Object[]{easLoginBean.getUserName(), easLoginBean.getPassword(), easLoginBean.getSlnName(), easLoginBean.getDcName(), easLoginBean.getLanguage(), Integer.valueOf(easLoginBean.getDbType()), "BaseDB"});
            result.setCall(call);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SSCException(SSCException.WEBSERVICEERROR, new Object[]{"\u767b\u9646\u5931\u8d25!\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684\u767b\u9646\u4fe1\u606f!"});
        }
        return result;
    }

    public static String getPassword(String userNumber) {
        LtpaToken token = LtpaTokenManager.generate((String)userNumber, (String)(CONFIG_DIR + LTPATOKEN_PATH));
        return token.toString();
    }

    public static void main(String[] args) {
    }

    public static String getAbsoluteEASLOGIN_PATH() {
        String cfgFolder = "eas";
        return CommonUtil.getAbsoluteEASLOGIN_PATH(cfgFolder);
    }

    public static String getAbsoluteREMOTE_PATH() {
        String cfgFolder = "eas";
        return CommonUtil.getAbsoluteREMOTE_PATH(cfgFolder);
    }

    public static void setConfigDir() {
        try {
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
                return;
            }
            int i = tmp.lastIndexOf("/");
            if (i < 0) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
                return;
            }
            CONFIG_DIR = tmp.substring(0, i) + "/ssc/";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String getAbsoluteEASLOGIN_PATH(String cfgFolder) {
        return CONFIG_DIR + cfgFolder + "/" + EASLOGIN_PATH;
    }

    public static String getAbsoluteREMOTE_PATH(String cfgFolder) {
        return CONFIG_DIR + cfgFolder + "/" + REMOTE_PATH;
    }

    public static WSContext loginEAS(Context ctx, ExtendERPInfo extendERPInfo) {
        EASLoginBean loginBean = CommonUtil.getEASLoginBean(ctx, extendERPInfo);
        WSContext result = null;
        try {
            Service s = new Service();
            Call call = (Call)s.createCall();
            call.setOperationName("login");
            call.setTargetEndpointAddress(loginBean.getLoginURL());
            call.setReturnType(new QName("urn:client", "WSContext"));
            call.setReturnClass(WSContext.class);
            call.setReturnQName(new QName("", "loginReturn"));
            call.setTimeout(Integer.valueOf(60000));
            call.setMaintainSession(true);
            result = (WSContext)call.invoke(new Object[]{loginBean.getUserName(), loginBean.getPassword(), loginBean.getSlnName(), loginBean.getDcName(), loginBean.getLanguage(), Integer.valueOf(loginBean.getDbType()), "BaseDB"});
            result.setCall(call);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static EASLoginBean getEASLoginBean(Context ctx, ExtendERPInfo extendERPInfo) {
        String loginURL = EASCfgUtil.getValue(ctx, extendERPInfo, "eas.login.wsdl");
        String userName = EASCfgUtil.getValue(ctx, extendERPInfo, "userName");
        String password = EASCfgUtil.getValue(ctx, extendERPInfo, "password");
        String slnName = EASCfgUtil.getValue(ctx, extendERPInfo, "slnName");
        String dcName = EASCfgUtil.getValue(ctx, extendERPInfo, "dcName");
        String language = EASCfgUtil.getValue(ctx, extendERPInfo, "language");
        String dbType = EASCfgUtil.getValue(ctx, extendERPInfo, "dbType");
        EASLoginBean loginBean = new EASLoginBean(userName, password, dcName, slnName, language, dbType, loginURL);
        return loginBean;
    }

    static {
        EASLOGIN_PATH = "EASLogin.properties";
        REMOTE_PATH = "remote.properties";
        LTPATOKEN_PATH = "LtpaToken.properties";
        CommonUtil.setConfigDir();
    }
}

