/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.webserviceproxy;

import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.ERPWebServiceLogin;
import com.kingdee.eas.base.ssc.app.erp.webserviceproxy.ErpInfo;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public enum ERPWebserviceChecker {
    INSTANCE;

    public static final long timeout_millisecond = 60000L;
    private static Logger logger;
    private static volatile ConcurrentHashMap<String, ErpInfo> erpStateMap;

    public ConcurrentHashMap<String, ErpInfo> getErpStateMap() {
        return erpStateMap;
    }

    private static void checkErpState() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Set entrys = erpStateMap.entrySet();
                    ERPWebService service = null;
                    for (Map.Entry entry : entrys) {
                        ErpInfo erpStateInfo = (ErpInfo)entry.getValue();
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - Long.parseLong(erpStateInfo.getLastInvokingTime()) <= 60000L) continue;
                        ExtendERPInfo erpInfo = erpStateInfo.getErpInfo();
                        try {
                            Class<?> clazz = Class.forName(erpInfo.getImpleClass());
                            service = (ERPWebService)clazz.newInstance();
                            if (service instanceof ERPWebServiceLogin) {
                                boolean result = ((ERPWebServiceLogin)((Object)service)).login(erpStateInfo.getLoginBean(), erpStateInfo.getOtherParam());
                                erpStateInfo.setLastInvokingTime(System.currentTimeMillis() + "");
                                erpStateInfo.setState(result);
                                continue;
                            }
                            logger.error((Object)(erpInfo.getImpleClass() + " is not a instanceof ERPWebServiceLogin!"));
                        }
                        catch (Exception e) {
                            logger.error((Object)(erpInfo.getImpleClass() + "\uff1b" + e.getMessage()), (Throwable)e);
                        }
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    static {
        logger = Logger.getLogger(ERPWebserviceChecker.class);
        erpStateMap = new ConcurrentHashMap();
        ERPWebserviceChecker.checkErpState();
    }
}

