/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common.script;

import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.common.script.Word;
import com.kingdee.eas.base.ssc.common.script.WordGenerator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;

public class ScriptEngine {
    private static String[] col = new String[]{"leftParenthesis", "dynamicAtt", "compare", "dynamicAttrValue", "rightParenthesis", "logic"};
    private static Pattern pattern = Pattern.compile("[0-9]{1,}(.[0-9]{1,})?");

    public List<Map<String, String>> parseScript(WordGenerator wg) throws EASBizException {
        ArrayList<Map<String, String>> retList = new ArrayList<Map<String, String>>();
        Stack<StringBuffer> parenthesisStack = new Stack<StringBuffer>();
        Word wd = wg.nextWord();
        int index = Integer.MAX_VALUE;
        HashMap<String, String> row = new HashMap<String, String>();
        while (wd != null) {
            String rv;
            if (wd.isSpace()) {
                wd = wg.nextWord();
                continue;
            }
            if (index > wd.getType()) {
                row = new HashMap();
                retList.add(row);
            }
            index = wd.getType();
            if (wd.isLeftParenthesis()) {
                parenthesisStack.push(wd.getWord());
                rv = (String)row.get(col[wd.getType()]);
                if (StringUtils.isEmpty((String)rv)) {
                    row.put(col[wd.getType()], wd.getWord().toString());
                } else {
                    row.put(col[wd.getType()], rv + wd.getWord().toString());
                }
            } else if (wd.isRightParenthesis()) {
                parenthesisStack.pop();
                rv = (String)row.get(col[wd.getType()]);
                if (StringUtils.isEmpty((String)rv)) {
                    row.put(col[wd.getType()], wd.getWord().toString());
                } else {
                    row.put(col[wd.getType()], rv + wd.getWord().toString());
                }
            } else {
                row.put(col[wd.getType()], wd.getWord().toString());
            }
            wd = wg.nextWord();
        }
        if (!parenthesisStack.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("", "parenthesis is not match!"));
        }
        this._checkLogic(retList);
        return retList;
    }

    public String parseScript(List<Map<String, Object>> attrnumlist, List<Map<String, String>> scriptEnties) throws EASBizException {
        HashMap<String, String> types = new HashMap<String, String>();
        for (int j = 0; j < attrnumlist.size(); ++j) {
            double type = Double.parseDouble(attrnumlist.get(j).get("type").toString());
            int i = (int)type;
            types.put((String)attrnumlist.get(j).get("number"), i + "");
        }
        scriptEnties = this._filterSpaceRow(scriptEnties);
        this._checkLogic(scriptEnties);
        StringBuffer sb = new StringBuffer(100);
        int j = 0;
        for (int i = 0; i < scriptEnties.size(); ++i) {
            boolean flagWithString = false;
            while (j < col.length) {
                String val = (String)((Map)scriptEnties.get(i)).get(col[j]);
                if (col[j].equals("compare") && ("is_null".equals(org.apache.commons.lang3.StringUtils.trim((String)val)) || "is_not_null".equals(org.apache.commons.lang3.StringUtils.trim((String)val)))) {
                    flagWithString = true;
                }
                if (!StringUtils.isEmpty((String)val)) {
                    if (j == 3 && (!this._isNumeric((String)types.get(((Map)scriptEnties.get(i)).get(col[1])), val) || flagWithString)) {
                        sb.append("'" + val + "'");
                    } else {
                        sb.append(val);
                    }
                }
                ++j;
            }
            j = 0;
        }
        return sb.toString();
    }

    private boolean _isNumeric(String type, String dynamicAttrValue) {
        return FieldType.NUMBER.equals((Object)FieldType.getEnum(type));
    }

    private List _filterSpaceRow(List scriptEntry) {
        Map row;
        ArrayList retList = new ArrayList();
        for (int i = 0; !(i >= scriptEntry.size() || StringUtils.isEmpty((String)((String)(row = (Map)scriptEntry.get(i)).get("leftParenthesis"))) && StringUtils.isEmpty((String)((String)row.get("dynamicAtt"))) && StringUtils.isEmpty((String)((String)row.get("compare"))) && StringUtils.isEmpty((String)((String)row.get("dynamicAttrValue"))) && StringUtils.isEmpty((String)((String)row.get("rightParenthesis"))) && StringUtils.isEmpty((String)((String)row.get("logic")))); ++i) {
            retList.add(scriptEntry.get(i));
        }
        return retList;
    }

    private void _checkLogic(List<Map<String, String>> l) throws EASBizException {
        if (l == null || l.size() == 0) {
            throw new EASBizException(new NumericExceptionSubItem("", "script is empty!"));
        }
        for (int i = 0; i < l.size(); ++i) {
            Map<String, String> m = l.get(i);
            if (m == null) {
                throw new EASBizException(new NumericExceptionSubItem("", "missing logic at line " + (i + 1)));
            }
            if (i != l.size() - 1) {
                if (StringUtils.isEmpty((String)m.get(col[5]))) {
                    throw new EASBizException(new NumericExceptionSubItem("", "missing logic operator at line " + (i + 1)));
                }
            } else if (!StringUtils.isEmpty((String)m.get(col[5]))) {
                throw new EASBizException(new NumericExceptionSubItem("", "illegal logic operator at line " + (i + 1)));
            }
            if (StringUtils.isEmpty((String)m.get(col[1]))) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u7b2c" + (i + 1) + "\u884c " + "\u89c4\u5219\u5b57\u6bb5" + " \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (StringUtils.isEmpty((String)m.get(col[2]))) {
                throw new EASBizException(new NumericExceptionSubItem("", "\u7b2c" + (i + 1) + "\u884c " + "\u6bd4\u8f83\u7b26" + " \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!StringUtils.isEmpty((String)m.get(col[3]))) continue;
            throw new EASBizException(new NumericExceptionSubItem("", "\u7b2c" + (i + 1) + "\u884c " + "\u6bd4\u8f83\u503c" + " \u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }
}

