/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.mail;

import com.kingdee.eas.base.wssc.util.SSCBASE64Decoder;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SendMail {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.mail.SendMail");
    private static boolean conMailSuccess = false;

    public static boolean sendMessage(String smtpHost, String smtpPort, String senderInternetAddress, String senderInternetNICK, String senderEmailAccount, String senderEmailPassword, String receiveEmailAddres, String ccEmailAddres, String subject, String content, String[] attachFileNames, Map otherParams) {
        boolean result = true;
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", smtpHost);
            props.put("mail.smtp.port", smtpPort);
            props.put("mail.smtp.auth", (Object)true);
            Session mailConnection = Session.getInstance((Properties)props, null);
            MimeMessage mailMessage = new MimeMessage(mailConnection);
            InternetAddress sender = new InternetAddress(senderInternetAddress, senderInternetNICK);
            mailMessage.setFrom((Address)sender);
            if (StringUtils.isNotEmpty((String)receiveEmailAddres)) {
                mailMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)receiveEmailAddres));
            }
            if (StringUtils.isNotEmpty((String)ccEmailAddres)) {
                mailMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccEmailAddres));
            }
            mailMessage.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)content, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)contentPart);
            mailMessage.setContent((Multipart)multipart);
            mailMessage.setSentDate(new Date());
            Transport trans = mailConnection.getTransport("smtp");
            trans.connect(smtpHost, senderEmailAccount, senderEmailPassword);
            trans.sendMessage((Message)mailMessage, mailMessage.getAllRecipients());
            trans.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = false;
        }
        return result;
    }

    public static boolean sendMessageCon(String smtpHost, String smtpPort, String senderInternetAddress, String senderInternetNICK, String senderEmailAccount, String senderEmailPassword, String subject, String content) {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", smtpHost);
            props.put("mail.smtp.port", smtpPort);
            props.put("mail.smtp.auth", (Object)true);
            Session mailConnection = Session.getInstance((Properties)props, null);
            MimeMessage mailMessage = new MimeMessage(mailConnection);
            InternetAddress sender = new InternetAddress(senderInternetAddress, senderInternetNICK);
            mailMessage.setFrom((Address)sender);
            mailMessage.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Object)content, "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)contentPart);
            mailMessage.setContent((Multipart)multipart);
            mailMessage.setSentDate(new Date());
            Transport trans = mailConnection.getTransport("smtp");
            SSCBASE64Decoder base64Decoder = new SSCBASE64Decoder();
            if (!StringUtils.isEmpty((String)senderEmailPassword)) {
                senderEmailPassword = new String(base64Decoder.decodeBuffer(senderEmailPassword));
            }
            new SendMailEnable(smtpHost, senderEmailAccount, senderEmailPassword, trans).start();
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            conMailSuccess = false;
        }
        logger.error((Object)("*******return******conMailSuccess***********" + conMailSuccess));
        return conMailSuccess;
    }

    static class SendMailEnable
    extends Thread {
        private String smtpHost;
        private String senderEmailAccount;
        private String senderEmailPassword;
        private Transport trans;

        public SendMailEnable(String smtpHost, String senderEmailAccount, String senderEmailPassword, Transport trans) {
            this.smtpHost = smtpHost;
            this.senderEmailAccount = senderEmailAccount;
            this.senderEmailPassword = senderEmailPassword;
            this.trans = trans;
        }

        @Override
        public void run() {
            try {
                conMailSuccess = false;
                this.trans.connect(this.smtpHost, this.senderEmailAccount, this.senderEmailPassword);
                this.trans.close();
                conMailSuccess = true;
                logger.error((Object)("*******run***success***conMailSuccess***********" + conMailSuccess + "**smtpHost***" + this.smtpHost + "**senderEmailAccount**" + this.senderEmailAccount));
            }
            catch (Exception e) {
                conMailSuccess = false;
                logger.error((Object)("*******run***Exception***conMailSuccess***********" + conMailSuccess));
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

