/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.monitor.core.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.DataBaseCfgInfo;
import com.kingdee.eas.base.ssc.MonitorExecuteRuleEntryFactory;
import com.kingdee.eas.base.ssc.MonitorExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.MonitorInnerJoinEntryFactory;
import com.kingdee.eas.base.ssc.MonitorInnerJoinEntryInfo;
import com.kingdee.eas.base.ssc.MonitorMultiSqlLogFactory;
import com.kingdee.eas.base.ssc.MonitorMultiSqlLogInfo;
import com.kingdee.eas.base.ssc.SqlEntryCollection;
import com.kingdee.eas.base.ssc.SqlEntryFactory;
import com.kingdee.eas.base.ssc.SqlEntryInfo;
import com.kingdee.eas.base.ssc.monitor.core.Enum.InnerEnum;
import com.kingdee.eas.base.ssc.monitor.core.entry.InnerErrorModel;
import com.kingdee.eas.base.ssc.monitor.core.factory.CompareFactory;
import com.kingdee.eas.base.ssc.monitor.core.model.CheckErrorModel;
import com.kingdee.eas.base.ssc.monitor.core.model.Field;
import com.kingdee.eas.base.ssc.monitor.core.model.InnerResult;
import com.kingdee.eas.base.ssc.monitor.core.model.MatchRuleModel;
import com.kingdee.eas.base.ssc.monitor.core.model.RowModel;
import com.kingdee.eas.base.ssc.monitor.core.model.RuleCalculationlModel;
import com.kingdee.eas.base.ssc.monitor.core.model.SqlModel;
import com.kingdee.eas.base.ssc.monitor.core.model.SqlResultModel;
import com.kingdee.eas.base.ssc.monitor.core.model.TableModel;
import com.kingdee.eas.base.ssc.monitor.core.result.MontiorSqlResult;
import com.kingdee.eas.base.ssc.monitor.core.utils.AvitorUtil;
import com.kingdee.eas.base.ssc.monitor.core.utils.MonitorUtils;
import com.kingdee.eas.base.ssc.monitor.database.AbstractDataBase;
import com.kingdee.eas.base.ssc.monitor.database.DataBaseFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class MontiorSqlCore {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.monitor.core.service.MontiorSqlCore");
    private SqlModel sqlModel = new SqlModel();
    private Context ctx;

    public MontiorSqlCore(Context ctx) {
        this.ctx = ctx;
    }

    public MontiorSqlResult execute(Context ctx, String monitor, BOSUuid downloadId) throws EASBizException, BOSException {
        MontiorSqlResult montiorSqlResult = new MontiorSqlResult();
        this.sqlModel = this.bulidSqlTask(ctx, monitor);
        try {
            this.createTempTable();
            this.constructFromSql();
            this.constructWhereSql();
            this.executeInnerJoin();
            this.fillInnerResultRows();
            this.getNoInner();
            this.executeRule();
            this.persistentDB(monitor, downloadId);
            this.releaseTable(ctx, this.sqlModel.getTableModel());
            this.buildMonitorSqlResult(montiorSqlResult, this.sqlModel);
        }
        catch (Exception e) {
            logger.error((Object)("\u76d1\u63a7\u673a\u5668\u4eba\u6267\u884c\u5931\u8d25  " + e.getMessage()), (Throwable)e);
        }
        return montiorSqlResult;
    }

    private void releaseTable(Context ctx, TableModel tableModel) {
        for (String sqlId : tableModel.getTableMap().keySet()) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableModel.getTableMap().get(sqlId));
        }
    }

    private void persistentDB(String monitorId, BOSUuid downloadId) throws Exception {
        this.persistentInnnerSuccessDB(this.ctx, this.sqlModel.getCheckErrorModel(), monitorId, downloadId);
        this.persistentInnnerErrorDB(this.ctx, this.sqlModel.getInnerErrorModel(), monitorId, downloadId);
    }

    private void persistentInnnerSuccessDB(Context ctx, CheckErrorModel checkErrorModel, String monitorId, BOSUuid downloadId) throws Exception {
        CoreBaseCollection coll = new CoreBaseCollection();
        HashMap<String, List<RowModel>> map = checkErrorModel.getRowModels();
        for (String sqlId : map.keySet()) {
            List<RowModel> rowList = map.get(sqlId);
            ArrayList<String> fieldList = new ArrayList<String>();
            for (RowModel rowModel : rowList) {
                MonitorMultiSqlLogInfo info = new MonitorMultiSqlLogInfo();
                fieldList.clear();
                for (int i = 0; i < rowModel.getFields().size(); ++i) {
                    Field field = rowModel.getFields().get(i);
                    fieldList.add(field.getFieldName().toUpperCase() + "," + field.getFieldValue());
                }
                this.initMonitorMutilSql(info, fieldList, sqlId, monitorId, true, downloadId);
                coll.add((CoreBaseInfo)info);
            }
        }
        try {
            MonitorMultiSqlLogFactory.getLocalInstance(ctx).addnew(coll);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void persistentInnnerErrorDB(Context ctx, InnerErrorModel innerErrorModel, String monitorId, BOSUuid downloadId) throws Exception {
        CoreBaseCollection coll = new CoreBaseCollection();
        HashMap<String, List<RowModel>> map = innerErrorModel.getRowModels();
        for (String sqlId : map.keySet()) {
            List<RowModel> rowList = map.get(sqlId);
            ArrayList<String> fieldList = new ArrayList<String>();
            for (RowModel rowModel : rowList) {
                MonitorMultiSqlLogInfo info = new MonitorMultiSqlLogInfo();
                fieldList.clear();
                for (int i = 0; i < rowModel.getFields().size(); ++i) {
                    Field field = rowModel.getFields().get(i);
                    if (field.getFieldName().contains("FFMONITORUUID")) continue;
                    fieldList.add(field.getFieldName().toUpperCase().substring(1) + "," + field.getFieldValue());
                }
                this.initMonitorMutilSql(info, fieldList, sqlId, monitorId, false, downloadId);
                coll.add((CoreBaseInfo)info);
            }
        }
        try {
            MonitorMultiSqlLogFactory.getLocalInstance(ctx).addnew(coll);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void initMonitorMutilSql(MonitorMultiSqlLogInfo info, ArrayList<String> fieldList, String sqlId, String monitorId, boolean inner, BOSUuid downloadId) {
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setMonitorId(monitorId);
        info.setSqlId(sqlId);
        info.setField1(this.isNull(fieldList, 0));
        info.setField2(this.isNull(fieldList, 1));
        info.setField3(this.isNull(fieldList, 2));
        info.setField4(this.isNull(fieldList, 3));
        info.setField5(this.isNull(fieldList, 4));
        info.setField6(this.isNull(fieldList, 5));
        info.setField7(this.isNull(fieldList, 6));
        info.setField8(this.isNull(fieldList, 7));
        info.setField9(this.isNull(fieldList, 8));
        info.setField10(this.isNull(fieldList, 9));
        info.setField11(this.isNull(fieldList, 10));
        info.setField12(this.isNull(fieldList, 11));
        info.setInner(inner);
        info.setDownloadId(downloadId);
    }

    private String isNull(ArrayList<String> list, int n) {
        if (list.size() <= n) {
            return "";
        }
        return list.get(n);
    }

    private void getNoInner() throws Exception {
        HashMap<String, StringBuffer> map = this.sqlModel.getSelectSqlMap();
        TableModel tableModel = this.sqlModel.getTableModel();
        HashMap<String, String> tableMap = tableModel.getTableMap();
        String sql = "";
        Iterator<Map.Entry<String, StringBuffer>> selectSqlIter = map.entrySet().iterator();
        InnerErrorModel innerErrorModel = this.sqlModel.getInnerErrorModel();
        HashMap<String, List<RowModel>> rowsMap = innerErrorModel.getRowModels();
        Connection conn = EJBFactory.getConnection((Context)this.ctx);
        PreparedStatement stmt = null;
        while (selectSqlIter.hasNext()) {
            ArrayList<RowModel> rows = new ArrayList<RowModel>();
            Map.Entry<String, StringBuffer> entry = selectSqlIter.next();
            sql = this.transferSql(entry, this.sqlModel);
            try {
                stmt = conn.prepareStatement(sql);
                long t1 = System.currentTimeMillis();
                ResultSet rs = stmt.executeQuery();
                ResultSetMetaData dm = rs.getMetaData();
                int columnCount = dm.getColumnCount();
                String[] columnNames = new String[columnCount];
                Integer[] alias = new Integer[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    alias[i - 1] = Integer.valueOf(dm.getColumnName(i).split("\\.")[0]);
                    columnNames[i - 1] = dm.getColumnName(i).split("\\.")[1];
                }
                while (rs.next()) {
                    RowModel row = new RowModel();
                    for (int i = 1; i <= columnCount; ++i) {
                        Field field = new Field();
                        field.setSqlId(this.sqlModel.getAlias().get(alias[i - 1]));
                        field.setFieldName(columnNames[i - 1]);
                        field.setFieldValue(rs.getString(dm.getColumnName(i)));
                        row.addField(field);
                    }
                    rows.add(row);
                }
                rowsMap.put(entry.getKey(), rows);
                logger.error((Object)("***query over***" + (System.currentTimeMillis() - t1) / 1000L));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        SQLUtils.cleanup(stmt, (Connection)conn);
    }

    private void executeInnerJoin() throws Exception {
        logger.error((Object)"***query begin***");
        InnerResult innerResult = this.sqlModel.getInnerResult();
        ArrayList<RowModel> rowModelList = new ArrayList<RowModel>();
        Connection conn = EJBFactory.getConnection((Context)this.ctx);
        PreparedStatement stmt = null;
        try {
            TableModel tableModel = this.sqlModel.getTableModel();
            StringBuffer querySql = new StringBuffer("");
            String whereSql = tableModel.getWhereSql();
            String fromSql = tableModel.getFromSql();
            stmt = conn.prepareStatement(querySql.append(fromSql).append(whereSql).toString());
            long t1 = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData dm = rs.getMetaData();
            int columnCount = dm.getColumnCount();
            String[] columnNames = new String[columnCount];
            Integer[] sqlId = new Integer[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                sqlId[i - 1] = Integer.valueOf(dm.getColumnName(i).split("\\.")[0]);
                columnNames[i - 1] = dm.getColumnName(i).split("\\.")[1];
            }
            while (rs.next()) {
                RowModel rowModel = new RowModel();
                ArrayList<Field> fields = new ArrayList<Field>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    Field field = new Field();
                    field.setFieldName(columnNames[i - 1]).setFieldValue(rs.getString(dm.getColumnName(i))).setSqlId(this.sqlModel.getAlias().get(sqlId[i - 1]));
                    fields.add(field);
                }
                rowModel.setFields(fields);
                rowModelList.add(rowModel);
            }
            innerResult.setInnerResultRow(rowModelList);
            logger.error((Object)("***query over***" + (System.currentTimeMillis() - t1) / 1000L));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String transferSql(Map.Entry<String, StringBuffer> entry, SqlModel sqlModel) {
        TableModel map = sqlModel.getTableModel();
        String field = entry.getValue().toString();
        String sqlId = entry.getKey();
        String fromSql = map.getFromSql();
        String whereSql = map.getWhereSql();
        HashMap<String, String> tableMap = map.getTableMap();
        fromSql = fromSql.substring(1).replaceFirst("\\*", "\"" + sqlModel.getAlia().get(sqlId) + "." + "FFMONITORUUID" + "\"");
        String tableName = tableMap.get(sqlId);
        StringBuffer sql = new StringBuffer("");
        sql.append(" select ").append(field).append(" from ").append(tableName).append(" where ").append("\"").append(this.sqlModel.getAlia().get(sqlId)).append(".").append("FFMONITORUUID").append("\"").append(" NOT IN ").append("(").append(fromSql).append(whereSql).append(")");
        return sql.toString();
    }

    private void constructWhereSql() {
        TableModel tableModel = this.sqlModel.getTableModel();
        HashMap<String, Integer> alias = this.sqlModel.getAlia();
        StringBuffer sb = new StringBuffer(" where ");
        List<MatchRuleModel> matchRules = this.sqlModel.getInnerMatchRule();
        for (int i = 0; i < matchRules.size(); ++i) {
            MatchRuleModel matchRule = matchRules.get(i);
            Field left = matchRule.getField1();
            Field right = matchRule.getField2();
            int leftAlia = alias.get(left.getSqlId());
            int rightAlia = alias.get(right.getSqlId());
            if (i == matchRules.size() - 1) {
                sb.append(MonitorUtils.appendFields(left, right, leftAlia, rightAlia));
                continue;
            }
            sb.append(MonitorUtils.appendFieldsAnd(left, right, leftAlia, rightAlia));
        }
        tableModel.setWhereSql(sb.toString());
    }

    private void constructFromSql() {
        TableModel tableModel = this.sqlModel.getTableModel();
        HashMap<String, String> tableMap = tableModel.getTableMap();
        StringBuffer sb = new StringBuffer(" select ").append(" * ").append(" from ");
        for (Map.Entry<String, String> entry : tableMap.entrySet()) {
            sb.append(" ").append(entry.getValue()).append(" ").append("\"").append(entry.getKey()).append("\"").append(" , ");
        }
        sb.deleteCharAt(sb.toString().lastIndexOf(","));
        tableModel.setFromSql(sb.toString());
    }

    private void createTempTable() throws Exception {
        TableModel tableModel = this.sqlModel.getTableModel();
        HashMap<Integer, String> alias = this.sqlModel.getAlias();
        HashMap<String, Integer> alia = this.sqlModel.getAlia();
        HashMap<String, String> tableMap = tableModel.getTableMap();
        try {
            Iterator<Map.Entry<String, SqlResultModel>> it = this.sqlModel.getSqlResultModels().entrySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                Map.Entry<String, SqlResultModel> entry = it.next();
                SqlResultModel sqlResult = entry.getValue();
                String sql = sqlResult.getSql();
                String sqlId = sqlResult.getSqlId();
                List<Field> fieldList = sqlResult.getRows().get(0).getFields();
                String tempTable = this.createTable(this.ctx, fieldList, index);
                alias.put(index, sqlId);
                alia.put(sqlId, index);
                for (Field field : fieldList) {
                    this.initSqlFiledMap(field);
                }
                tableMap.put(sqlId, tempTable);
                this.insertSql(this.ctx, tempTable, sql, fieldList, index);
                ++index;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private String createTable(Context ctx, List<Field> field, int index) throws BOSException {
        String tableName = null;
        int n = field.size();
        StringBuffer createTableSql = new StringBuffer();
        StringBuffer fieldStr = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            fieldStr.append("\"").append(index).append(".").append("f").append(field.get(i).getFieldName()).append("\"").append(" ").append(field.get(i).getFieldStruct()).append(",");
        }
        fieldStr.deleteCharAt(fieldStr.toString().lastIndexOf(","));
        createTableSql.append(" create table " + this.getRandomString(12));
        createTableSql.append(" (" + fieldStr + ") ");
        try {
            tableName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSql.toString().toUpperCase());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(52);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    private void insertSql(Context ctx, String tableName, String fromSql, List<Field> field, int alia) throws BOSException, SQLException {
        Connection conn = EJBFactory.getConnection((Context)ctx);
        fromSql = this.toUpperSql(fromSql);
        PreparedStatement stmt = null;
        StringBuffer fieldSql = new StringBuffer("");
        fieldSql.append("(");
        for (int i = 0; i < field.size(); ++i) {
            fieldSql.append("\"").append(alia).append(".").append("F").append(field.get(i).getFieldName()).append("\"").append(" , ");
        }
        fieldSql.deleteCharAt(fieldSql.toString().lastIndexOf(","));
        fieldSql.append(")");
        StringBuffer insertSql = new StringBuffer("");
        insertSql.append("insert into ").append(tableName).append(fieldSql.toString()).append(fromSql);
        long t1 = System.currentTimeMillis();
        try {
            stmt = conn.prepareStatement(insertSql.toString().toUpperCase());
            stmt.executeUpdate();
            logger.error((Object)("***insertSql over***" + (System.currentTimeMillis() - t1) / 1000L));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException("Monitor sql innsert sql Error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String toUpperSql(String fromSql) {
        String sql = fromSql.toUpperCase();
        sql = sql.replaceFirst("SELECT", "SELECT NEWBOSID('32E218AA'),");
        return sql;
    }

    private void buildMonitorSqlResult(MontiorSqlResult montiorSqlResult, SqlModel sqlModel) {
        montiorSqlResult.setCheckErrorModel(sqlModel.getCheckErrorModel());
        montiorSqlResult.setUnInnerResult(sqlModel.getInnerErrorModel());
    }

    private void executeRule() {
        int n = this.sqlModel.getKeyRuleMap().keySet().size();
        if (0 == n) {
            return;
        }
        CheckErrorModel checkErrorModel = this.sqlModel.getCheckErrorModel();
        InnerResult innerSuccessResult = this.sqlModel.getInnerResult();
        if (1 == n) {
            for (RowModel rowModel : innerSuccessResult.getInnerResultRow()) {
                Map<Integer, RuleCalculationlModel> ruleCache = rowModel.getKeyRuleMap();
                if (ruleCache.get(1).getMatch().booleanValue()) continue;
                checkErrorModel.addErrorModel(rowModel, ruleCache.get(1).getMatchRuleLit());
            }
        } else {
            for (RowModel rowModel : innerSuccessResult.getInnerResultRow()) {
                Map<Integer, RuleCalculationlModel> rowCache = rowModel.getKeyRuleMap();
                AvitorUtil avitorUtil = new AvitorUtil();
                String expression = rowModel.getCompareExpression();
                RuleCalculationlModel calculation = avitorUtil.caculate(expression, rowCache);
                if (calculation.getMatch().booleanValue()) continue;
                checkErrorModel.addErrorModel(rowModel, calculation.getMatchRuleLit());
            }
        }
        this.sqlModel.setCheckErrorModel(checkErrorModel);
    }

    private void fillInnerResultRows() {
        for (RowModel rowModel : this.sqlModel.getInnerResult().getInnerResultRow()) {
            HashMap<Integer, RuleCalculationlModel> rowCompareResultMap = new HashMap();
            rowModel.setCompareExpression(this.sqlModel.getCompareExpression());
            Set<Integer> set = this.sqlModel.getKeyRuleMap().keySet();
            for (Integer num : set) {
                RuleCalculationlModel value = this.sqlModel.getKeyRuleMap().get(num);
                String left = MonitorUtils.openExpression(value.getExpression()).get(0)[0];
                String leftSqlId = left.split("\\.")[0];
                String leftValue = left.split("\\.")[1];
                String right = MonitorUtils.openExpression(value.getExpression()).get(0)[1];
                String rightSqlId = right.split("\\.")[0];
                String rightValue = right.split("\\.")[1];
                String oper = MonitorUtils.openExpression(value.getExpression()).get(1)[0];
                String leftRelValue = "";
                String rightRelValue = "";
                for (Field field : rowModel.getFields()) {
                    if (field.getFieldName().equalsIgnoreCase(leftValue) && field.getSqlId().equals(leftSqlId)) {
                        leftRelValue = (String)field.getFieldValue();
                    }
                    if (!field.getFieldName().equalsIgnoreCase(rightValue) || !field.getSqlId().equals(rightSqlId)) continue;
                    rightRelValue = (String)field.getFieldValue();
                }
                value.setMatch(CompareFactory.getMonitorCompareResult(oper, leftRelValue, rightRelValue));
            }
            try {
                rowCompareResultMap = (Map)MonitorUtils.deeplyCopy(this.sqlModel.getKeyRuleMap());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            rowModel.setKeyRuleMap(rowCompareResultMap);
        }
    }

    private SqlModel bulidSqlTask(Context ctx, String monitorId) throws EASBizException, BOSException {
        SqlModel sqlModel = new SqlModel();
        sqlModel.setMonitorId(monitorId).setSqlResultModels(this.executeQuery(ctx, monitorId));
        this.initMatchRuleModel(ctx, sqlModel);
        this.initCompareRuleModel(ctx, sqlModel);
        return sqlModel;
    }

    public void initCompareRuleModel(Context ctx, SqlModel sqlTaskMode) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)sqlTaskMode.getMonitorId(), CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sortter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("seq");
        sorterItem.setSortType(SortType.ASCEND);
        sortter.add(sorterItem);
        view.setSorter(sortter);
        CoreBaseCollection colls = MonitorExecuteRuleEntryFactory.getLocalInstance(ctx).getCollection(view);
        MonitorExecuteRuleEntryInfo info = null;
        StringBuffer compareRule = new StringBuffer("");
        HashMap<Integer, RuleCalculationlModel> cacheMap = new HashMap<Integer, RuleCalculationlModel>();
        int n = 1;
        for (int i = 1; i <= colls.size(); ++i) {
            RuleCalculationlModel ruleCalculationlModel = new RuleCalculationlModel();
            info = (MonitorExecuteRuleEntryInfo)colls.get(i - 1);
            if (info.getLeftBracket() == null) {
                info.setLeftBracket("");
            }
            if (info.getRightBracket() == null) {
                info.setRightBracket("");
            }
            MatchRuleModel matchRule = new MatchRuleModel();
            Field[] fields = this.initField(info);
            matchRule.setAction(MonitorUtils.getEnum(info.getCompare())).setField1(fields[0]).setField2(fields[1]);
            ArrayList<MatchRuleModel> list = new ArrayList<MatchRuleModel>();
            list.add(matchRule);
            String temp = this.logic(info.getLogic());
            ruleCalculationlModel.setExpression(info.getCompareFieldSrcSqlId() + "." + "F" + info.getCompareFieldSrc() + info.getCompare() + info.getCompareFieldToSqlId() + "." + "F" + info.getCompareFieldTo());
            ruleCalculationlModel.setMatch(false);
            ruleCalculationlModel.setNum(n);
            ruleCalculationlModel.setMatchRuleLit(list);
            cacheMap.put(n, ruleCalculationlModel);
            compareRule.append(info.getLeftBracket() + n + info.getRightBracket() + temp);
            ++n;
        }
        sqlTaskMode.setCompareExpression(compareRule.toString());
        sqlTaskMode.setKeyRuleMap(cacheMap);
    }

    private String logic(String logic) {
        if (!"".equals(logic) && "&&".equals(logic)) {
            return "+";
        }
        if (!"".equals(logic) && "||".equals(logic)) {
            return "-";
        }
        return "";
    }

    private Field[] initField(MonitorExecuteRuleEntryInfo info) {
        Field[] fields = new Field[2];
        Field fieldLeft = new Field();
        Field fieldRight = new Field();
        fields[0] = fieldLeft;
        fields[1] = fieldRight;
        info.setCompareFieldSrc(info.getCompareFieldSrc().replace("{", "").replace("}", "").replace("$", ""));
        info.setCompareFieldTo(info.getCompareFieldTo().replace("{", "").replace("}", "").replace("$", ""));
        fieldLeft.setSqlId(info.getCompareFieldSrcSqlId()).setFieldName(info.getCompareFieldSrc());
        fieldRight.setSqlId(info.getCompareFieldToSqlId()).setFieldName(info.getCompareFieldTo());
        return fields;
    }

    public void initMatchRuleModel(Context ctx, SqlModel sqlModel) throws BOSException {
        CoreBaseCollection colls = MonitorInnerJoinEntryFactory.getLocalInstance(ctx).getCollection("select * where parent = '" + sqlModel.getMonitorId() + "'");
        MonitorInnerJoinEntryInfo info = null;
        List<MatchRuleModel> list = sqlModel.getInnerMatchRule();
        for (int i = 0; i < colls.size(); ++i) {
            info = (MonitorInnerJoinEntryInfo)colls.get(i);
            MatchRuleModel matchRuleModel = new MatchRuleModel();
            Field fieldFrom = new Field();
            Field fieldTo = new Field();
            String fromSqlId = info.getRelationFieldFromSqlId();
            String toSqlId = info.getRelationFieldToSqlId();
            String from = info.getRelationFieldFrom();
            String to = info.getRelationFieldTo();
            fieldFrom.setSqlId(fromSqlId).setFieldName(from);
            fieldTo.setSqlId(toSqlId).setFieldName(to);
            matchRuleModel.setAction(InnerEnum.INNER).setField1(fieldFrom).setField2(fieldTo);
            list.add(matchRuleModel);
        }
    }

    private void initSqlFiledMap(Field field) {
        HashMap<String, StringBuffer> map = this.sqlModel.getSelectSqlMap();
        String fieldName = field.getFieldName();
        String fieldSqlId = field.getSqlId();
        fieldName = new StringBuffer("F").append(fieldName).toString();
        StringBuffer sb = new StringBuffer("");
        sb.append("(").append("\"").append(this.sqlModel.getAlia().get(fieldSqlId)).append(".").append(fieldName).append("\"").append(")");
        if (map.containsKey(fieldSqlId)) {
            map.get(fieldSqlId).append(" , ").append(sb);
        } else {
            map.put(fieldSqlId, sb);
        }
    }

    private Map<String, SqlResultModel> executeQuery(Context ctx, String monitorId) throws EASBizException {
        HashMap<String, SqlResultModel> sqlResultModelList = new HashMap<String, SqlResultModel>();
        try {
            SqlEntryCollection colls = SqlEntryFactory.getLocalInstance(ctx).getSqlEntryCollection("select *,databaseCfg.* where monitor = '" + monitorId + "'");
            if (null != colls && !colls.isEmpty()) {
                for (int j = 0; j < colls.size(); ++j) {
                    SqlResultModel sqlResultModel = new SqlResultModel();
                    SqlEntryInfo info = colls.get(j);
                    String sql = info.getSql();
                    String id = info.getId().toString();
                    DataBaseCfgInfo dataBaseCfgInfo = info.getDatabaseCfg();
                    String databaseName = dataBaseCfgInfo.getDataBaseType().getValue();
                    if (!databaseName.equals("Datacenter")) {
                        int targetDbType = DbType.getValue((String)databaseName);
                        sql = TransUtil.Translate((String)sql, (int)targetDbType);
                    }
                    AbstractDataBase abstractDataBase = DataBaseFactory.getInstance(ctx, dataBaseCfgInfo);
                    sqlResultModel = abstractDataBase.executeQuerySqlResultModel(sql, id, null);
                    sqlResultModel.setSqlId(id);
                    sqlResultModel.setSql(sql);
                    sqlResultModelList.put(id, sqlResultModel);
                }
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("SQLEXCEPTION", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sqlResultModelList;
    }
}

