/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.monitor.database;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.DataBaseCfgInfo;
import com.kingdee.eas.base.ssc.DataBaseType;
import com.kingdee.eas.base.ssc.monitor.database.AbstractDataBase;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_DB2;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_DM;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_DataCenter;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_MySql;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_Oracle;
import com.kingdee.eas.base.ssc.monitor.database.DataBase_SqlServer;

public class DataBaseFactory {
    public static AbstractDataBase getInstance(Context ctx, DataBaseType dataBaseType, String host, int port, String user, String password, String dataBaseName) throws Exception {
        AbstractDataBase abstractDataBase = null;
        if (dataBaseType.getValue().startsWith("Oracle")) {
            abstractDataBase = new DataBase_Oracle(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseType == DataBaseType.SQLSERVER) {
            abstractDataBase = new DataBase_SqlServer(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseType == DataBaseType.MYSQL) {
            abstractDataBase = new DataBase_MySql(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseType == DataBaseType.DB2) {
            abstractDataBase = new DataBase_DB2(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseType == DataBaseType.DATACENTER) {
            abstractDataBase = new DataBase_DataCenter(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseType == DataBaseType.DM) {
            abstractDataBase = new DataBase_DM(ctx, host, port, user, password, dataBaseName);
        } else {
            throw new Exception("\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
        }
        return abstractDataBase;
    }

    public static AbstractDataBase getInstance(Context ctx, DataBaseCfgInfo dataBaseCfgInfo) throws Exception {
        String dataBaseName;
        AbstractDataBase abstractDataBase = null;
        String host = dataBaseCfgInfo.getServerIp();
        int port = dataBaseCfgInfo.getPort();
        String user = dataBaseCfgInfo.getGrantUser();
        String password = dataBaseCfgInfo.getPassword();
        String string = dataBaseName = dataBaseCfgInfo.getDataBaseType().getValue().startsWith("Oracle") ? dataBaseCfgInfo.getServerName() : dataBaseCfgInfo.getDatabaseName();
        if (dataBaseCfgInfo.isCurrentShareCenter()) {
            abstractDataBase = new DataBase_DataCenter(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType().getValue().startsWith("Oracle")) {
            abstractDataBase = new DataBase_Oracle(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType() == DataBaseType.SQLSERVER) {
            abstractDataBase = new DataBase_SqlServer(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType() == DataBaseType.MYSQL) {
            abstractDataBase = new DataBase_MySql(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType() == DataBaseType.DB2) {
            abstractDataBase = new DataBase_DB2(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType() == DataBaseType.DATACENTER) {
            abstractDataBase = new DataBase_DataCenter(ctx, host, port, user, password, dataBaseName);
        } else if (dataBaseCfgInfo.getDataBaseType() == DataBaseType.DM) {
            abstractDataBase = new DataBase_DM(ctx, host, port, user, password, dataBaseName);
        } else {
            throw new Exception("\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
        }
        return abstractDataBase;
    }
}

