/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.ssc.SendMessageInfo;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SendMessageThread
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.thread.SendMessageThread");
    private Context ctx;
    private String title;
    private String content;
    private String[] receiverIds;

    public SendMessageThread(SendMessageInfo info) {
        this.ctx = info.getCtx();
        this.title = info.getTitle();
        this.content = info.getContent();
        this.receiverIds = info.getReceiverIds();
    }

    @Override
    public void run() {
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            for (String receiverId : this.receiverIds) {
                if (!BOSUuid.isValid((String)receiverId, (boolean)true)) continue;
                if ("80EF7DED".equals(new ObjectUuidPK(receiverId).getObjectType().toString())) {
                    Person[] persons = svc.getPersonByPersonID(receiverId);
                    for (int j = 0; j < persons.length; ++j) {
                        Person person = persons[j];
                        if (person == null) continue;
                        this.sendMessage(person.getUserId());
                    }
                    continue;
                }
                this.sendMessage(receiverId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void sendMessage(String receiverId) {
        Message message = this.createMessage(receiverId);
        try {
            Class<?> factoryClz = Class.forName("com.kingdee.eas.base.message.WsMessageCenterFacadeFactory");
            Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
            Object facadeObj = getInsMethod.invoke(null, this.ctx);
            Method addBMCMessageMethod = facadeObj.getClass().getMethod("addBMCMessage", Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, Timestamp.class, Timestamp.class, String.class, String.class, Integer.TYPE, String.class, String.class);
            addBMCMessageMethod.invoke(facadeObj, message.getIntHeader("type"), message.getIntHeader("bizType"), message.getStringHeader("sender"), message.getIntHeader("priority"), Integer.parseInt("0"), Integer.parseInt("0"), message.getStringHeader("title"), message.getStringHeader("body"), new Timestamp(new Date().getTime()), new Timestamp(new Date().getTime()), "", message.getStringHeader("receiver"), Integer.parseInt("-1"), "11111111-1111-1111-1111-111111111111CCE7AED4", "");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Message createMessage(String receiverId) {
        Message message = MessageFactory.newMessage((String)"kingdee.ssc");
        if (this.ctx != null) {
            message.setStringHeader("databaseCenter", this.ctx.getAIS());
            message.setStringHeader("solution", this.ctx.getSolution());
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        message.setStringHeader("title", this.title);
        message.setLocaleStringHeader("title", this.title, new Locale("L2"));
        message.setStringHeader("body", this.content);
        message.setLocaleStringHeader("body", this.content, new Locale("L2"));
        message.setStringHeader("sender", "administrator");
        message.setLocaleStringHeader("sender", "administrator", new Locale("L2"));
        message.setStringHeader("receiver", receiverId);
        message.setLocaleStringHeader("receiver", receiverId, new Locale("L2"));
        return message;
    }
}

