/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.eas.base.ssc.app.CheckSchemeTimeType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static long calWorkDays(Date d1, Date d2) throws Exception {
        if (d1 == null || d2 == null) {
            throw new Exception("date can not be null");
        }
        if (d1.after(d2)) {
            Date tmp = d1;
            d1 = d2;
            d2 = tmp;
        }
        if ((d1 = DateUtil.jumpWeekend(d1)).after(d2 = DateUtil.jumpWeekendBackward(d2))) {
            return 0L;
        }
        long totalMillSeconds = d2.getTime() - d1.getTime();
        long ret = 0L;
        long weekCount = 0L;
        long milsecPerWeek = 604800000L;
        if (totalMillSeconds > milsecPerWeek) {
            weekCount = totalMillSeconds / milsecPerWeek;
            ret = 5L * weekCount;
        }
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTimeInMillis(d1.getTime() + weekCount * milsecPerWeek);
        calendar2.setTime(d2);
        int dow1 = calendar1.get(7);
        int dow2 = calendar2.get(7);
        if (dow1 > dow2) {
            return ret + (long)dow2 - (long)dow1 + 6L;
        }
        return ret + (long)dow2 - (long)dow1 + 1L;
    }

    public static boolean isSameDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getTime() / 86400000L == d2.getTime() / 86400000L;
    }

    public static boolean isWeekDay(Date d) {
        boolean ret = false;
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        int day = c.get(7);
        if (day == 1 || day == 7) {
            ret = true;
        }
        return ret;
    }

    public static Date getDateBegin(Date d) {
        Calendar c = Calendar.getInstance();
        long t = d.getTime();
        t = t / 86400L * 86400L;
        c.setTimeInMillis(t);
        return c.getTime();
    }

    public static long calSecendBetween(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return 0L;
        }
        long ret = 0L;
        long m = d2.getTime() - d1.getTime();
        ret = m / 1000L;
        return ret;
    }

    public static double calMinutesBetween(Date d1, Date d2) {
        double ret = 0.0;
        long sec = DateUtil.calSecendBetween(d1, d2);
        ret = (double)sec / 60.0;
        return ret;
    }

    public static long calSecendBetweenWithoutWeekend(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return 0L;
        }
        if ((d1 = DateUtil.jumpWeekend(d1)).after(d2 = DateUtil.jumpWeekendBackward(d2))) {
            return 0L;
        }
        long ret = 0L;
        long m = d2.getTime() - d1.getTime();
        long wc = m / 604800000L;
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTimeInMillis(d1.getTime() + wc * 604800000L);
        calendar2.setTimeInMillis(d2.getTime());
        int d1Day = calendar1.get(7);
        int d2Day = calendar2.get(7);
        if (d1Day > d2Day) {
            ++wc;
        }
        ret = DateUtil.calSecendBetween(d1, d2) - wc * 172800L;
        return ret;
    }

    public static Date jumpWeekend(Date d) {
        if (d == null) {
            return null;
        }
        if (!DateUtil.isWeekDay(d)) {
            return d;
        }
        long ct = d.getTime();
        ct = ct / 86400000L * 86400000L + 86400000L;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ct);
        if (DateUtil.isWeekDay(c.getTime())) {
            c.setTimeInMillis(ct + 86400000L);
            return c.getTime();
        }
        return c.getTime();
    }

    public static Date jumpWeekendBackward(Date d) {
        if (d == null) {
            return null;
        }
        if (!DateUtil.isWeekDay(d)) {
            return d;
        }
        long ct = d.getTime();
        ct = ct / 86400000L * 86400000L - 1L;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ct);
        if (DateUtil.isWeekDay(c.getTime())) {
            c.setTimeInMillis(ct - 86400000L);
            return c.getTime();
        }
        return c.getTime();
    }

    public static String formatDisplay(long secend) {
        long h = secend / 3600L;
        long m = (secend %= 3600L) / 60L;
        return h + ":" + m + ":" + (secend %= 60L);
    }

    public static String secend2Hours(long secend, DecimalFormat df) {
        double h = (double)secend / 3600.0;
        return df.format(h);
    }

    public static String secend2Min(long secend) {
        try {
            BigDecimal sixTy = new BigDecimal(60).setScale(2);
            BigDecimal secendBigD = new BigDecimal(secend).setScale(2);
            BigDecimal hour = secendBigD.divide(sixTy.multiply(sixTy), 0, RoundingMode.DOWN);
            BigDecimal min = secendBigD.subtract(hour.multiply(sixTy).multiply(sixTy)).divide(sixTy, 0, RoundingMode.HALF_UP);
            String ret = hour.toString() + ":";
            if (min.abs().intValue() < 10) {
                ret = ret + "0";
            }
            ret = ret + min.abs();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0:00";
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date d1 = format.parse("2015/2/2 0:0:0");
        Date d2 = format.parse("2015/2/6 23:59:59");
        System.out.println(DateUtil.calWorkDays(d1, d2));
    }

    public static String getCurDay() {
        Date temp = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(temp);
    }

    public static String getCurDayDate() {
        Date temp = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(temp);
    }

    public static String getYesterdayDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        Date temp = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(temp);
    }

    public static String getPrevYearCurDay() {
        Calendar c = Calendar.getInstance();
        int curYear = c.get(1);
        c.set(1, curYear - 1);
        Date temp = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(temp);
    }

    public static String getPrevMonthCurDay() {
        Calendar c = Calendar.getInstance();
        int curYear = c.get(2);
        c.set(2, curYear - 1);
        Date temp = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(temp);
    }

    public static String getPrevYearFirstDay() {
        Calendar c = Calendar.getInstance();
        int curYear = c.get(1);
        c.clear();
        c.set(1, curYear - 1);
        Date temp = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(temp);
    }

    public static String getCurYearFirstDay() {
        Calendar c = Calendar.getInstance();
        int curYear = c.get(1);
        c.clear();
        c.set(1, curYear);
        Date temp = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(temp);
    }

    public static Date parseDateTime(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(dateStr);
    }

    public static Date parseDate(String dateStr) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(dateStr);
    }

    public static String dateToTsDate(Date date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "{ts'" + sdf.format(date) + "'}";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dateToTsDate(String dateStr) {
        try {
            String dateTxt = dateStr.contains("-") ? "yyyy-MM-dd HH:mm:ss" : "yyyy/MM/dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(dateTxt);
            Date d2 = format.parse(dateStr);
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "{ts'" + format2.format(d2) + "'}";
        }
        catch (Exception e) {
            throw new IllegalArgumentException("id is not valid:" + dateStr, e);
        }
    }

    public static Timestamp[] getDatesByTimeType(CheckSchemeTimeType timeType) {
        Timestamp beginDate = null;
        Timestamp endDate = null;
        Calendar calendar = Calendar.getInstance();
        if (CheckSchemeTimeType.yesterDay.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeYesterDay2.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            calendar.add(5, -2);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeYesterDay3.equals((Object)timeType)) {
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            calendar.add(5, -3);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.week.equals((Object)timeType)) {
            endDate = DateUtil.getFirstTime(calendar);
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeWeek.equals((Object)timeType)) {
            calendar.setFirstDayOfWeek(2);
            calendar.set(7, 2);
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            calendar.add(5, -6);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.month.equals((Object)timeType)) {
            endDate = DateUtil.getFirstTime(calendar);
            calendar.set(5, 1);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.beforeMonth.equals((Object)timeType)) {
            calendar.set(5, 1);
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            calendar.add(2, -1);
            calendar.add(5, 1);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.years.equals((Object)timeType)) {
            endDate = DateUtil.getFirstTime(calendar);
            calendar.set(6, 1);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.lastYear.equals((Object)timeType)) {
            calendar.set(6, 1);
            calendar.add(5, -1);
            endDate = DateUtil.getLastTime(calendar);
            calendar.add(1, -1);
            calendar.add(5, 1);
            beginDate = DateUtil.getFirstTime(calendar);
        } else if (CheckSchemeTimeType.between.equals((Object)timeType)) {
            // empty if block
        }
        Timestamp[] timeParams = new Timestamp[2];
        for (int i = 0; i < 2; ++i) {
            timeParams[i] = i % 2 == 0 ? beginDate : endDate;
        }
        return timeParams;
    }

    private static Timestamp getFirstTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private static Timestamp getLastTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getCurrentQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
        int currentMonth = c.get(2) + 1;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 1);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            date = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }
}

