/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AssignRuleCollection;
import com.kingdee.eas.base.ssc.AssignRuleFactory;
import com.kingdee.eas.base.ssc.AssignRuleInfo;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueCollection;
import com.kingdee.eas.base.ssc.DynamicValueFactory;
import com.kingdee.eas.base.ssc.DynamicValueInfo;
import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.IUser;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.PackageConfigEntryCollection;
import com.kingdee.eas.base.ssc.PackageConfigEntryFactory;
import com.kingdee.eas.base.ssc.PackageConfigEntryInfo;
import com.kingdee.eas.base.ssc.PackageConfigFactory;
import com.kingdee.eas.base.ssc.ParamSetFacadeFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SysParamMgerCollection;
import com.kingdee.eas.base.ssc.SysParamMgerFactory;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.common.script.custom.ScriptEngineUtil;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.OrgRoleUserUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PreditJobUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.PreditJobUtils");

    public static void closeRS(IRowSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                rs = null;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPermissionUserIdsExcludeRule(Context ctx, JobInfo job, List<String> ruleRoleIds, List<String> ruleUserIds) throws Exception {
        String orgId = job.getOrgID().getId().toString();
        String bussAttrId = job.getBussAttrID().getId().toString();
        String shareCenterId = job.getShareCenterID().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_org o,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
        sb.append(" where r.FROLETYPEIDID <> 'hEw8bwRNR8qPRPajcUdX4C0WZ4A='");
        sb.append(" and r.FNUMBER not like 'addForCompel%'");
        sb.append(" and ru.FROLEIDID = r.FID");
        sb.append(" and ru.FUSERIDID = u.FID");
        sb.append(" and ro.FROLEIDID = r.FID");
        sb.append(" and ro.FORGIDID  = o.FID");
        sb.append(" and rb.FParentID = r.fid");
        sb.append(" and rb.FBUSSNAMEID = ?");
        sb.append(" and o.FID = ?");
        if (StringUtils.isNotBlank((String)shareCenterId)) {
            sb.append(" and u.fsharecenterid = '" + shareCenterId + "'");
        }
        if (null != ruleRoleIds && 0 < ruleRoleIds.size()) {
            List<String> roleUserIds = OrgRoleUserUtils.getUsersByRole(ctx, ruleRoleIds);
            HashSet<String> temp = new HashSet<String>(ruleUserIds);
            temp.addAll(roleUserIds);
            ruleUserIds = new ArrayList<String>(temp);
        }
        if (ruleUserIds != null && !ruleUserIds.isEmpty()) {
            String userStr = FormatUtils.list2Sql(ruleUserIds);
            sb.append(" and u.FID not in " + userStr);
        }
        Object[] param = new Object[]{bussAttrId, orgId};
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query user permission exclude rule error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
        }
        PreditJobUtils.closeRS(rs);
        return userIds;
    }

    public static List<UserInfo> defAssignJob(Context ctx, JobInfo job) throws Exception {
        ArrayList<String> ruleUserIds = new ArrayList<String>();
        ArrayList<String> ruleRoleIds = new ArrayList<String>();
        AssignRuleCollection assignRuleCollection = PreditJobUtils.getCustomerAssignRule(ctx, job);
        if (assignRuleCollection != null && assignRuleCollection.size() > 0) {
            for (int j = 0; j < assignRuleCollection.size(); ++j) {
                AssignRuleInfo assignRuleInfo = assignRuleCollection.get(j);
                if (assignRuleInfo.isIsExclusive() && null != assignRuleInfo.getUser()) {
                    ruleUserIds.add(assignRuleInfo.getUser().getId().toString());
                    continue;
                }
                if (!assignRuleInfo.isIsExclusive() || null == assignRuleInfo.getRoles()) continue;
                String[] roles = assignRuleInfo.getRoles().split(",");
                for (int i = 0; i < roles.length; ++i) {
                    ruleRoleIds.add(roles[i]);
                }
            }
        }
        List<String> defaultUserIds = PreditJobUtils.getPermissionUserIdsExcludeRule(ctx, job, ruleRoleIds, ruleUserIds);
        ArrayList userIds = new ArrayList();
        logger.error((Object)(job.getSubject() + ",\u9ed8\u8ba4\u5206\u914d\u7684\u4eba\u5458ID\uff1a" + defaultUserIds));
        return PreditJobUtils.getPackageAssignUser(ctx, job, defaultUserIds, null, null);
    }

    public static AssignRuleCollection getCustomerAssignRule(Context ctx, JobInfo job) throws SSCException {
        String busID = job.getBussAttrID().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bussAttr", (Object)busID));
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)job.getShareCenterID().getId().toString()));
        String topShareCenterID = "";
        try {
            topShareCenterID = ShareCenterUtils.getTopShareCenter(ctx).get("id") + "";
        }
        catch (BOSException e1) {
            logger.error((Object)("find top shareCenterInfo exception!" + (Object)((Object)e1)));
        }
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)topShareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)new Boolean(true)));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("user.*");
        selector.add("role.*");
        selector.add("bussAttr.*");
        entityViewInfo.setSelector(selector);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("priority"));
        entityViewInfo.setSorter(sorterItemCollection);
        try {
            return AssignRuleFactory.getLocalInstance(ctx).getAssignRuleCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllConsignerIDs(Context ctx, String bussAttrId, String userId) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
        sb.append(" FROM T_ssc_consignation c,t_ssc_consignationentry ce");
        sb.append(" where ce.fparentid = c.FID");
        sb.append(" and c.FASSIGNEEID = ? ");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = ?");
        Object[] param = new Object[]{userId, bussAttrId, "30"};
        ArrayList<String> consignerIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                consignerIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query getAllConsignerIDs error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
        }
        PreditJobUtils.closeRS(rs);
        return consignerIds;
    }

    public static List<UserInfo> getUserMatchOrg(Context ctx, JobInfo job, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) throws Exception {
        String bussAttrId = job.getBussAttrID().getId().toString();
        String orgId = job.getOrgID().getId().toString();
        ArrayList<String> userIds = new ArrayList<String>();
        List<String> consignerIds = null;
        UserInfo assignUser = assignRuleInfo.getUser();
        if (assignUser != null) {
            userIds.add(assignUser.getId().toString());
        }
        if (!userIds.isEmpty()) {
            return PreditJobUtils.getLeastTaskPermissionUser(ctx, job, bussAttrId, null, userIds, orgId, assignRuleInfo, assignRuleCollection);
        }
        if (assignRuleInfo.getRoles() != null) {
            String[] roles = assignRuleInfo.getRoles().split(",");
            ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
            ArrayList<String> roleIdList = new ArrayList<String>();
            for (int i = 0; i < roles.length; ++i) {
                roleIdList.add(roles[i]);
            }
            List<UserInfo> list = PreditJobUtils.getLeastTaskPermissionUser(ctx, job, bussAttrId, roleIdList, consignerIds, orgId, assignRuleInfo, assignRuleCollection);
            if (null == list && PreditJobUtils.isExistsOrgPermission(ctx, bussAttrId, roleIdList, orgId)) {
                list = new ArrayList<UserInfo>();
            }
            userInfoList.addAll(list);
            return userInfoList;
        }
        return new ArrayList<UserInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistsOrgPermission(Context ctx, String bussAttrId, List<String> roleIdList, String orgId) throws BOSException {
        IRowSet rs;
        block4: {
            boolean bl;
            StringBuffer sql = new StringBuffer();
            sql.append(" select 1");
            sql.append(" from t_ssc_role r,t_ssc_org o,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
            sql.append(" where ro.FROLEIDID = r.FID");
            sql.append(" and ro.FORGIDID  = o.FID");
            sql.append(" and rb.FParentID = r.fid");
            sql.append(" and o.FID = ?");
            sql.append(" and rb.FBUSSNAMEID = ?");
            sql.append(" and r.FID in " + FormatUtils.list2Sql(roleIdList));
            Object[] param = new Object[]{orgId, bussAttrId};
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sql.toString()));
                    logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                    logger.error((Object)"Query role permission error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    PreditJobUtils.closeRS(rs);
                    throw throwable;
                }
                PreditJobUtils.closeRS(rs);
            }
            PreditJobUtils.closeRS(rs);
            return bl;
        }
        PreditJobUtils.closeRS(rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPermissionUserIds(Context ctx, String bussAttrId, List<String> roleIdList, List<String> userIdList, String orgID) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct u.fid");
        sb.append(" from t_ssc_user u,t_ssc_role r,t_ssc_org o,t_ssc_roleuser ru,t_ssc_roleorg ro,t_ssc_rolebussattr rb");
        sb.append(" where r.FROLETYPEIDID <> 'hEw8bwRNR8qPRPajcUdX4C0WZ4A='");
        sb.append(" and r.FNUMBER not like 'addForCompel%'");
        sb.append(" and ru.FROLEIDID = r.FID");
        sb.append(" and ru.FUSERIDID = u.FID");
        sb.append(" and ro.FROLEIDID = r.FID");
        sb.append(" and ro.FORGIDID  = o.FID");
        sb.append(" and rb.FParentID = r.fid");
        sb.append(" and rb.FBUSSNAMEID = ?");
        sb.append(" and o.FID = ?");
        if (null != roleIdList && !roleIdList.isEmpty()) {
            sb.append(" and r.FID in " + FormatUtils.list2Sql(roleIdList));
        }
        if (null != userIdList && !userIdList.isEmpty()) {
            sb.append(" and u.FID in " + FormatUtils.list2Sql(userIdList));
        }
        Object[] param = new Object[]{bussAttrId, orgID};
        ArrayList<String> userIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                userIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query user permission error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
        }
        PreditJobUtils.closeRS(rs);
        return userIds;
    }

    public static List<UserInfo> getLeastTaskPermissionUser(Context ctx, JobInfo job, String bussAttrId, List<String> roleIdList, List<String> userIdList, String orgID, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) throws Exception {
        List<String> userIds = PreditJobUtils.getPermissionUserIds(ctx, bussAttrId, roleIdList, userIdList, orgID);
        logger.error((Object)(job.getSubject() + "\uff0c\u80fd\u5206\u914d\u7684\u6709\u6743\u9650\u7684\u4eba\u5458ID\u4e3a:" + userIds.toString()));
        return PreditJobUtils.getPackageAssignUser(ctx, job, userIds, assignRuleInfo, assignRuleCollection);
    }

    public static Map<String, Object> getCustomerAssignUser(Context ctx, JobInfo job) throws BOSException, Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> userInfoList = new ArrayList();
        map.put("matchRule", false);
        map.put("assignUser", null);
        AssignRuleCollection assignRuleCollection = PreditJobUtils.getCustomerAssignRule(ctx, job);
        if (assignRuleCollection != null && assignRuleCollection.size() > 0) {
            DynamicValueCollection dynamicValueCollection = PreditJobUtils.getCustomerAssignRuleColumn(ctx, job.getId().toString());
            for (int j = 0; j < assignRuleCollection.size(); ++j) {
                AssignRuleInfo assignRuleInfo = assignRuleCollection.get(j);
                if (!PreditJobUtils.isAssignRuleMatch(assignRuleInfo.getScript(), dynamicValueCollection)) continue;
                map.put("matchRule", true);
                userInfoList = PreditJobUtils.getUserMatchOrg(ctx, job, assignRuleInfo, assignRuleCollection);
                if (userInfoList != null && !userInfoList.isEmpty()) {
                    map.put("assignUser", userInfoList);
                    return map;
                }
                return map;
            }
        }
        return map;
    }

    public static DynamicValueCollection getCustomerAssignRuleColumn(Context ctx, String jobId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("jobID.id", (Object)jobId));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("dynamicID.*");
        entityViewInfo.setSelector(selectorItemCollection);
        try {
            int i;
            DynamicValueCollection coll = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueCollection(entityViewInfo);
            int j = coll.size();
            DynamicValueCollection coll2 = new DynamicValueCollection();
            ArrayList<DynamicValueInfo> list = new ArrayList<DynamicValueInfo>(j);
            for (i = 0; i < j; ++i) {
                list.add(coll.get(i));
            }
            Collections.sort(list, new Comparator<DynamicValueInfo>(){

                @Override
                public int compare(DynamicValueInfo paramT1, DynamicValueInfo paramT2) {
                    if (paramT1.getDynamicID().getNumber().length() > paramT2.getDynamicID().getNumber().length()) {
                        return -1;
                    }
                    if (paramT1.getDynamicID().getNumber().length() < paramT2.getDynamicID().getNumber().length()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (i = 0; i < j; ++i) {
                coll2.add((DynamicValueInfo)list.get(i));
            }
            return coll2;
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5206\u914d\u89c4\u5219\u5b57\u6bb5\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public static boolean isAssignRuleMatch(String script, DynamicValueCollection dynamicValueCollection) {
        Boolean assignResult = ScriptEngineUtil.isRuleMatch(script, dynamicValueCollection);
        return assignResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserInfo handleRejectedJob(Context ctx, JobInfo job) throws BOSException, EASBizException {
        String position = "**jobInfo :{" + job.getId() + "@@" + job.getSubject() + "},\u5904\u7406\u6253\u56de\u903b\u8f91**";
        UserInfo assignUser = null;
        UserInfo consignUser = null;
        IUser iUser = UserFactory.getLocalInstance(ctx);
        String sql = "select FPERSONNELIDID, FCONSIGNERID from t_ssc_jobhis where FBUSSATTRIDID = ? and FBillID = ? order by fcreatetime desc";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{job.getBussAttrID().getId().toString(), job.getBillID()});
            if (rs.next()) {
                assignUser = new UserInfo();
                assignUser.setId(BOSUuid.read((String)rs.getString("FPERSONNELIDID")));
                assignUser = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(assignUser.getId()));
                String consignerId = rs.getString("FCONSIGNERID");
                if (!StringUtils.isBlank((String)consignerId)) {
                    consignUser = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(consignerId));
                }
            }
            PreditJobUtils.closeRS(rs);
        }
        catch (Exception e) {
            logger.error((Object)(position + e.getMessage()), (Throwable)e);
        }
        finally {
            PreditJobUtils.closeRS(rs);
        }
        logger.error((Object)(position + "\u67e5\u8be2\u7ed3\u679c.assignUser:" + (assignUser == null ? "null" : assignUser.getNumber()) + "**consignUser:" + (consignUser == null ? "null" : consignUser.getNumber())));
        String isReturnToOriginalPerson = ParamSetFacadeFactory.getLocalInstance(ctx).getSSCParam(job.getShareCenterID().getId().toString()).getIsReturnToOriginalPerson();
        if (Boolean.parseBoolean(isReturnToOriginalPerson) && consignUser != null && assignUser != null && !PreditJobUtils.isEffectConsign(ctx, consignUser.getId().toString(), assignUser.getId().toString(), job.getBussAttrID().toString())) {
            assignUser = consignUser;
        }
        if (assignUser != null && PreditJobUtils.isEnabledForUser(ctx, assignUser) && StopAssignEnum.normal == assignUser.getIsStopAssign()) {
            return assignUser;
        }
        return null;
    }

    public static boolean isEffectConsign(Context ctx, String consignerId, String assigneeId, String bussAttrId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT 1 FROM T_ssc_Consignation c,T_SSC_CONSIGNATIONENTRY ce");
        sb.append(" where c.FCONSIGNERID = ?");
        sb.append(" and c.FASSIGNEEID = ?");
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = '30'");
        sb.append(" and c.fid = ce.fparentid");
        Object[] params = new Object[]{consignerId, assigneeId, bussAttrId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("sql:" + sb.toString()));
        }
        return false;
    }

    public static boolean isEnabledForUser(Context ctx, UserInfo userInfo) {
        return userInfo.isIsEnabled() && PreditJobUtils.isEnabledForEasUser(ctx, userInfo);
    }

    public static boolean isEnabledForEasUser(Context ctx, UserInfo userInfo) {
        com.kingdee.eas.base.permission.UserInfo easUser = null;
        try {
            easUser = com.kingdee.eas.base.permission.UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userInfo.getEasUserId()));
            if (!easUser.isIsForbidden()) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static PackageConfigEntryCollection getPackageAssignRule(Context ctx, JobInfo job) throws BOSException, EASBizException {
        String oql = "where shareCenterId='" + job.getShareCenterID().getId().toString() + "' and bussAttr.id='" + job.getBussAttrID().getId().toString() + "'";
        IObjectPK[] pk = PackageConfigFactory.getLocalInstance(ctx).getPKList(oql);
        if (pk != null && 1 == pk.length) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk[0].toString()));
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            sorterItemCollection.add(new SorterItemInfo("priority"));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            view.setSorter(sorterItemCollection);
            return PackageConfigEntryFactory.getLocalInstance(ctx).getPackageConfigEntryCollection(view);
        }
        return null;
    }

    public static boolean isDynamicValueNumber(Context ctx, String dynamicId) {
        try {
            DynamicAttributeInfo dynamicAttributeInfo = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeInfo(H.PK(dynamicId));
            return FieldType.NUMBER.equals((Object)dynamicAttributeInfo.getType());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static List<UserInfo> getPackageAssignUser(Context ctx, JobInfo job, List<String> userIds, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) throws Exception {
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        ArrayList<String> prUserIds = new ArrayList();
        boolean isPackageRule = false;
        PackageConfigEntryCollection prColl = PreditJobUtils.getPackageAssignRule(ctx, job);
        if (prColl != null && !prColl.isEmpty()) {
            int len = prColl.size();
            for (int i = 0; i < len; ++i) {
                PackageConfigEntryInfo prInfo = prColl.get(i);
                String attrNumber = prInfo.getAttrNumber();
                if (!StringUtils.isNotBlank((String)attrNumber)) continue;
                List mapList = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)attrNumber, List.class);
                int ruleSize = mapList.size();
                StringBuffer sb = new StringBuffer();
                sb.append("where jobId = '" + job.getId().toString() + "' and (");
                for (Map map : mapList) {
                    if (ruleSize > 1) {
                        sb.append(" dynamicID = '" + map.get("id") + "' or");
                    } else {
                        sb.append(" dynamicID = '" + map.get("id") + "'");
                    }
                    --ruleSize;
                }
                sb.append(")");
                DynamicValueCollection dvColl = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueCollection(sb.toString());
                if (dvColl == null || dvColl.isEmpty()) continue;
                HashMap<String, String> rule = new HashMap<String, String>();
                int len2 = dvColl.size();
                for (int j = 0; j < len2; ++j) {
                    DynamicValueInfo dvInfo = dvColl.get(j);
                    if (PreditJobUtils.isDynamicValueNumber(ctx, dvInfo.getDynamicID().getId().toString())) {
                        rule.put(dvInfo.getDynamicID().getId().toString(), dvInfo.getDigiValue().toString());
                        continue;
                    }
                    rule.put(dvInfo.getDynamicID().getId().toString(), dvInfo.getDinamicValue());
                }
                List<String> strList = PreditJobUtils.getPackageAssignUser(ctx, rule, 3, userIds, job.getShareCenterID().getId().toString(), assignRuleInfo, assignRuleCollection);
                if (strList == null || strList.isEmpty()) continue;
                prUserIds.addAll(strList);
                isPackageRule = true;
                break;
            }
        }
        if (prUserIds.isEmpty()) {
            prUserIds = userIds;
        }
        logger.error((Object)(job.getSubject() + ",\u6253\u5305\u5206\u914d\u540e\u7684\u4eba\u5458ID\uff1a" + prUserIds));
        return PreditJobUtils.getPreBussAttrUser(ctx, job, job.getBussAttrID().getId().toString(), prUserIds, isPackageRule);
    }

    private static String getDate(int day) {
        Date temp = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(temp);
        calendar.add(5, -day);
        temp = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getJobIdsByPackageRule(Context ctx, Map<String, String> rule, String jobTable, String dynTable, int daysAgo, String shareCenterId) {
        ArrayList<String> arrayList;
        if (null == rule || rule.isEmpty()) {
            return null;
        }
        int len = rule.size();
        StringBuffer selectSql = new StringBuffer(" select j.FID");
        StringBuffer fromSql = new StringBuffer(" from " + jobTable + " j");
        for (int i = 0; i < len; ++i) {
            fromSql.append("," + dynTable + " dv" + i);
        }
        StringBuffer whereSql = new StringBuffer(" where dv0.FJOBIDID=j.FID");
        int i = 0;
        Object[] params = new Object[2 * len];
        for (String key : rule.keySet()) {
            whereSql.append(" and dv" + i + ".FDYNAMICIDID = ?");
            whereSql.append(" and dv" + i + ".FDINAMICVALUE = ?");
            if (i != 0) {
                whereSql.append(" and dv" + (i - 1) + ".FJOBIDID = dv" + i + ".FJOBIDID");
            }
            params[2 * i] = key;
            params[2 * i + 1] = rule.get(key);
            ++i;
        }
        if (daysAgo != 0) {
            String dateStr = "";
            try {
                dateStr = WorkDateUtil.getInstance(ctx, shareCenterId, false).getDate(new Date(), -daysAgo);
                logger.error((Object)("\u83b7\u53d63\u5929\u524d\u7684\u5de5\u4f5c\u65e5\u5386\u65f6\u95f4\u4e3a:" + dateStr));
            }
            catch (SSCException e1) {
                dateStr = PreditJobUtils.getDate(daysAgo);
                logger.error((Object)("\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u65f6\u95f4\u5931\u8d25\uff0c\u83b7\u53d63\u5929\u524d\u81ea\u7136\u65e5:" + dateStr));
            }
            whereSql.append(" and j.FRECEIVETIME > {ts'" + dateStr + "'}");
        }
        StringBuffer orderSql = new StringBuffer(" order by j.FRECEIVETIME desc");
        String sql = selectSql.toString() + fromSql.toString() + whereSql.toString() + orderSql.toString();
        ArrayList<String> jobIds = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                jobIds.add(rs.getString(1));
            }
            arrayList = jobIds;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sql));
                logger.error((Object)("parems:" + params));
                logger.error((Object)"getJobIdsByPackageRule error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
            return null;
        }
        PreditJobUtils.closeRS(rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPackageUserIds(Context ctx, List<String> jobIds, List<String> userIds, String table) {
        String jobIdStr = FormatUtils.list2Sql(jobIds);
        String userIdStr = FormatUtils.list2Sql(userIds);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct fpersonnelidid");
        sb.append(" from " + table);
        sb.append(" where fpersonnelidid in" + userIdStr);
        sb.append(" and fid in" + jobIdStr);
        ArrayList<String> ids = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)"getUserIdsByJobIds error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
        }
        PreditJobUtils.closeRS(rs);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getApprover(Context ctx, String jobId, String table, List<String> userIds) {
        IRowSet rs;
        block4: {
            String string;
            String userIdStr = FormatUtils.list2Sql(userIds);
            StringBuffer sb = new StringBuffer();
            sb.append(" select u.fid from ");
            sb.append(table + " j,t_ssc_user u");
            sb.append(" where j.FPERSONNELIDID = u.fid");
            sb.append(" and u.FISENABLED = '1'");
            sb.append(" and j.fid = '" + jobId + "'");
            sb.append(" and u.fid in " + userIdStr);
            sb.append(" order by j.fcreatetime desc");
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("sql:" + sb.toString()));
                    logger.error((Object)"getApprover error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    PreditJobUtils.closeRS(rs);
                    throw throwable;
                }
                PreditJobUtils.closeRS(rs);
            }
            PreditJobUtils.closeRS(rs);
            return string;
        }
        PreditJobUtils.closeRS(rs);
        return null;
    }

    private static List<String> getPackageAssignUser(Context ctx, Map<String, String> rule, int daysAgo, String jobTable, String dynTable, List<String> userIds, String shareCenterId, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) {
        String userId = null;
        List<String> jobIds = PreditJobUtils.getJobIdsByPackageRule(ctx, rule, jobTable, dynTable, daysAgo, shareCenterId);
        if (null != jobIds && !jobIds.isEmpty()) {
            List<String> tempUserIds = PreditJobUtils.getPackageUserIds(ctx, jobIds, userIds, jobTable);
            if (tempUserIds.isEmpty()) {
                return null;
            }
            if (1 == tempUserIds.size()) {
                return tempUserIds;
            }
            if (assignRuleInfo == null) {
                return tempUserIds;
            }
            ArrayList<String> list = new ArrayList<String>();
            block0: for (String jobId : jobIds) {
                DynamicValueCollection dynamicValueCollection = PreditJobUtils.getCustomerAssignRuleColumn(ctx, jobId);
                for (int j = 0; j < assignRuleCollection.size(); ++j) {
                    AssignRuleInfo temp = assignRuleCollection.get(j);
                    if (!PreditJobUtils.isAssignRuleMatch(temp.getScript(), dynamicValueCollection)) continue;
                    if (!temp.getScript().equals(assignRuleInfo.getScript())) continue block0;
                    userId = PreditJobUtils.getApprover(ctx, jobId, jobTable, tempUserIds);
                    if (!StringUtils.isNotBlank((String)userId)) continue;
                    list.add(userId);
                }
            }
            return list;
        }
        return new ArrayList<String>();
    }

    private static List<String> getPackageAssignUser(Context ctx, Map<String, String> rule, int daysAgo, List<String> userIds, String shareCenterId, AssignRuleInfo assignRuleInfo, AssignRuleCollection assignRuleCollection) {
        List<String> userId = PreditJobUtils.getPackageAssignUser(ctx, rule, daysAgo, "t_ssc_job", "t_ssc_dynamicvalue", userIds, shareCenterId, assignRuleInfo, assignRuleCollection);
        if (userId == null || userId.isEmpty()) {
            userId = PreditJobUtils.getPackageAssignUser(ctx, rule, daysAgo, "t_ssc_jobhis", "t_ssc_dynvaluehis", userIds, shareCenterId, assignRuleInfo, assignRuleCollection);
        }
        return userId;
    }

    private static Boolean isAllowDeal(Context ctx, JobInfo job, String preBussAttrId, String bussAttrId) {
        Object[] params = new Object[]{preBussAttrId, job.getShareCenterID().getId().toString(), bussAttrId};
        String sql = "select FIsNotAllowDeal from T_SSC_BussinessAttributeExt where FPREBUSSATTRID=? and FShareCenterId=? and FBussIdID=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                if (rs.getInt(1) == 0) {
                    return true;
                }
                if (rs.getInt(1) == 1) {
                    return false;
                }
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select FIsNotAllowDeal from T_SSC_BussinessAttribute where FPREBUSSATTRID=? and FShareCenterId=? and fid=? "), (Object[])params)).next()) {
                if (rs.getInt(1) == 0) {
                    return true;
                }
                if (rs.getInt(1) == 1) {
                    return false;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.error((Object)("\u51fa\u9519\u5566,\u524d\u7f6e\u4efb\u52a1\u7c7b\u578b\u6709\u503c\u65f6,FIsAllowPreBusUser \u4e00\u5b9a\u6709\u503c,sql:" + sql));
        return null;
    }

    public static List<String> getPreBussAttrPermissionUser(Context ctx, JobInfo job, String bussAttrId, List<String> userIds) {
        String userStr = FormatUtils.list2Sql(userIds);
        ArrayList<String> preBussAttrUser = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from (");
        sb.append(" select fpersonnelidid,flastupdatetime from t_ssc_job where FBussAttrIDID=? and FBillID=? and fpersonnelidid in" + userStr);
        sb.append(" union all");
        sb.append(" select fpersonnelidid,flastupdatetime from t_ssc_jobhis where FBussAttrIDID=? and FBillID=? and fpersonnelidid in" + userStr);
        sb.append(" ) m ");
        sb.append(" order by m.flastupdatetime desc");
        Object[] params = new Object[]{bussAttrId, job.getBillID(), bussAttrId, job.getBillID()};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                preBussAttrUser.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return preBussAttrUser;
    }

    public static List<UserInfo> getPreBussAttrUser(Context ctx, JobInfo job, String bussAttrId, List<String> userIds, boolean isPackageRule) throws Exception {
        String preBussAttrId = PreditJobUtils.getPreBussAttrId(ctx, job, bussAttrId);
        if (StringUtils.isNotBlank((String)preBussAttrId)) {
            Boolean isPreBussUserDeal = PreditJobUtils.isAllowDeal(ctx, job, preBussAttrId, bussAttrId);
            List<String> preBussAttrUsers = PreditJobUtils.getPreBussAttrPermissionUser(ctx, job, preBussAttrId, userIds);
            if (!preBussAttrUsers.isEmpty()) {
                if (isPreBussUserDeal.booleanValue()) {
                    userIds = preBussAttrUsers;
                    logger.error((Object)(job.getSubject() + ",\u76f8\u540c-----\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u4ebaID\uff1a" + preBussAttrUsers));
                } else {
                    userIds.removeAll(preBussAttrUsers);
                    logger.error((Object)(job.getSubject() + ",\u4e0d\u540c-----\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u4ebaID\uff1a" + preBussAttrUsers));
                }
            }
        }
        logger.error((Object)(job.getSubject() + ",\u8ba1\u7b97\u524d\u7f6e\u4efb\u52a1\u540e\u7684\u4eba\u5458ID\uff1a" + userIds));
        return PreditJobUtils.getLeastTaskUser(ctx, job, job.getBussAttrID().getId().toString(), userIds, isPackageRule);
    }

    public static String getPreBussAttrId(Context ctx, JobInfo job, String bussAttrId) {
        Object[] params = new Object[]{bussAttrId, job.getShareCenterID().getId().toString()};
        try {
            String sql = "select FPreBussAttrID from T_SSC_BussinessAttributeExt where FBussIdID=? and FShareCenterId=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                return rs.getString(1);
            }
            sql = "select FPreBussAttrID from T_SSC_BussinessAttribute where FID=? and FShareCenterId=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistConsignerRelation(Context ctx, String bussAttrId, List<String> userIds, Map<String, List<String>> consignerMap, Map<String, String> assigneeMap) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT c.FCONSIGNERID,c.FASSIGNEEID");
        sb.append(" FROM T_ssc_consignation c,t_ssc_consignationentry ce");
        sb.append(" where ce.fparentid = c.FID");
        sb.append(" and c.FCONSIGNERID in " + FormatUtils.list2Sql(userIds));
        sb.append(" and ce.fbusstypeid = ?");
        sb.append(" and c.FSTATUS = ?");
        Object[] param = new Object[]{bussAttrId, "30"};
        boolean isExistConsignerRelation = false;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                isExistConsignerRelation = true;
                String consignerId = rs.getString(1);
                String assigneeId = rs.getString(2);
                List<String> assigneeList = consignerMap.get(consignerId);
                if (null == assigneeList) {
                    assigneeList = new ArrayList<String>();
                }
                assigneeList.add(assigneeId);
                consignerMap.put(consignerId, assigneeList);
                assigneeMap.put(assigneeId, consignerId);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)net.sf.json.util.JSONUtils.valueToString((Object)param));
                logger.error((Object)"Query consigner relation error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                PreditJobUtils.closeRS(rs);
                throw throwable;
            }
            PreditJobUtils.closeRS(rs);
        }
        PreditJobUtils.closeRS(rs);
        return isExistConsignerRelation;
    }

    public static List<UserInfo> getLeastTaskUser(Context ctx, JobInfo job, String bussAttrId, List<String> userIds, boolean isPackageRule) throws Exception {
        if (null == userIds || 0 == userIds.size()) {
            return null;
        }
        HashMap<String, List<String>> consignerMap = new HashMap<String, List<String>>();
        HashMap<String, String> assigneeMap = new HashMap<String, String>();
        boolean isExistConsignerRelation = PreditJobUtils.isExistConsignerRelation(ctx, bussAttrId, userIds, consignerMap, assigneeMap);
        ArrayList<String> sortResult = new ArrayList<String>();
        if (isExistConsignerRelation) {
            for (String userId : userIds) {
                List temp = (List)consignerMap.get(userId);
                if (null == temp || 0 == temp.size()) {
                    sortResult.add(userId);
                    continue;
                }
                sortResult.add(userId);
                sortResult.addAll(temp);
            }
            userIds = new ArrayList<String>(sortResult);
        }
        logger.error((Object)(job.getSubject() + ",\u8ba1\u7b97\u59d4\u6258\u4efb\u52a1\u540e\u7684\u4eba\u5458ID\uff1a" + userIds));
        return PreditJobUtils.getCanAssignUser(ctx, job, userIds, assigneeMap);
    }

    public static boolean isAudit(Context ctx, JobInfo jobInfo, UserInfo userInfo) throws EASBizException {
        try {
            DynamicValueInfo info = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueInfo("where dynamicID.id ='4VBUlqSUQuO8g8sPkTkXsZvLn80=' and jobID.id ='" + jobInfo.getId().toString() + "'");
            String createId = info.getDinamicValue();
            if (!StringUtils.isBlank((String)createId) && (createId.equals(userInfo.getEasUserId()) || createId.equals(userInfo.getPersonnelID()) || createId.equals(userInfo.getUserID()))) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static List<UserInfo> getCanAssignUser(Context ctx, JobInfo job, List<String> userIds, Map<String, String> assigneeMap) throws Exception {
        ArrayList<UserInfo> list = new ArrayList<UserInfo>();
        boolean onlyOne = true;
        HashSet<String> temp = new HashSet<String>(userIds);
        if (temp.size() > 1) {
            onlyOne = false;
        }
        String isHideDimission = "false";
        SysParamMgerCollection smColl = SysParamMgerFactory.getLocalInstance(ctx).getSysParamMgerCollection("select * where shareCenterId='" + job.getShareCenterID().getId().toString() + "'");
        if (smColl.size() > 0) {
            isHideDimission = String.valueOf(smColl.get(0).isIsHideDimission());
        }
        boolean dimissionState = true;
        if (isHideDimission.equals("true")) {
            dimissionState = false;
        }
        for (String id : userIds) {
            try {
                boolean hasPermission;
                logger.error((Object)("\u6700\u7ec8\u5206\u914d\u4eba\u5458\u7684ID\uff1a" + id));
                UserInfo user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                if (!onlyOne && PreditJobUtils.isAudit(ctx, job, user)) continue;
                boolean flag = true;
                flag = dimissionState ? user.getDimission() != null && 1 == user.getDimission().getValue() : true;
                if (!user.isIsEnabled() || StopAssignEnum.normal != user.getIsStopAssign() || !flag) continue;
                String consignerId = assigneeMap.get(user.getId().toString());
                if (StringUtils.isNotBlank((String)consignerId) && !(hasPermission = SSCUtil.checkPermission(ctx, user, job))) {
                    SSCUtil.genAndAllotCompelRole(ctx, job.getBussAttrID().getId().toString(), user.getId().toString(), job.getShareCenterID().getId().toString(), true);
                    logger.info((Object)"***AssignJobThread.ConsignJob.genAndAllotCompelRole.successful***");
                }
                list.add(user);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static boolean isCallbackToOriginalPerso(Context ctx, String shareCenterId) {
        try {
            return ShareCenterUtils.getSysParamMgerInfo(ctx, shareCenterId).isIsCallbackToOriginalPerso();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

