/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.DynValueHisFactory;
import com.kingdee.eas.base.ssc.DynValueHisInfo;
import com.kingdee.eas.base.ssc.DynamicAttributeCollection;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueFactory;
import com.kingdee.eas.base.ssc.DynamicValueInfo;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.log4j.Logger;

public class SSCBaseBillUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils");

    public static Map<String, String> getSourceBillAttributeBySql(Context ctx, JobInfo jobInfo, List<String> keyList, String sourceBillClass, CheckpointEntryFilterCollection entryFilters) {
        try {
            String billID;
            int i;
            String sourceFactoryClass = sourceBillClass.replace(".app.", ".") + "Factory";
            SelectorItemCollection sic = new SelectorItemCollection();
            if (keyList != null && keyList.size() > 0) {
                for (i = 0; i < keyList.size(); ++i) {
                    sic.add(new SelectorItemInfo(keyList.get(i)));
                }
            }
            if (entryFilters != null && entryFilters.size() > 0) {
                int len = entryFilters.size();
                for (i = 0; i < len; ++i) {
                    CheckpointEntryFilterInfo filterInfo = entryFilters.get(i);
                    Matcher matcher = CompareManager.pattern1.matcher(filterInfo.getCompareField());
                    if (!matcher.find()) continue;
                    String entityColumn = matcher.group(1);
                    sic.add(entityColumn);
                }
            }
            Class<?> bizCollBillFacadeClass = Class.forName(sourceFactoryClass);
            Method bizCollBillMethod = bizCollBillFacadeClass.getMethod("getLocalInstance", Context.class);
            Object object = bizCollBillMethod.invoke(null, ctx);
            Class<?> ICoreBase2 = object.getClass();
            Method existsMethod = ICoreBase2.getMethod("exists", IObjectPK.class);
            String string = billID = jobInfo.getSscBillID() == null ? jobInfo.getBillID() : jobInfo.getSscBillID();
            if (((Boolean)existsMethod.invoke(object, new ObjectUuidPK(BOSUuid.read((String)billID)))).booleanValue()) {
                Method method = ICoreBase2.getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
                IObjectValue dataObj = (IObjectValue)method.invoke(object, new ObjectUuidPK(BOSUuid.read((String)billID)), sic);
                if (entryFilters != null && entryFilters.size() > 0) {
                    dataObj = CheckPointUtils.filterObjectValueEntry(ctx, dataObj, entryFilters);
                }
                return SSCBaseBillUtils.getSourceBillAttribute(ctx, keyList, dataObj);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> getSourceBillAttribute(Context ctx, JobInfo jobInfo, JobHisInfo jobHisInfo, List<String> keyList) {
        String bussAttrId = null;
        bussAttrId = jobInfo != null ? jobInfo.getBussAttrID().getId().toString() : jobHisInfo.getBussAttrID().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append(" select bt.fbindbillentry");
        sb.append(" from T_ssc_bussinessattribute ba,T_ssc_billtype bt");
        sb.append(" where ba.fid=?");
        sb.append(" and ba.FBILLTYPEID = bt.FID ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{bussAttrId});
            if (rs.next()) {
                String sourceBillId;
                String sscBillID;
                String sourceBillClass = rs.getString(1);
                if (StringUtils.isEmpty((String)sourceBillClass)) {
                    return new HashMap<String, String>();
                }
                String sourceFactoryClass = sourceBillClass.replace(".app.", ".") + "Factory";
                SelectorItemCollection sic = new SelectorItemCollection();
                if (keyList != null && keyList.size() > 0) {
                    for (int i = 0; i < keyList.size(); ++i) {
                        sic.add(new SelectorItemInfo(keyList.get(i)));
                    }
                }
                Class<?> bizCollBillFacadeClass = Class.forName(sourceFactoryClass);
                Method bizCollBillMethod = bizCollBillFacadeClass.getMethod("getLocalInstance", Context.class);
                Object object = bizCollBillMethod.invoke(null, ctx);
                Class<?> ICoreBase2 = object.getClass();
                Method existsMethod = ICoreBase2.getMethod("exists", IObjectPK.class);
                String string = sscBillID = jobInfo != null ? jobInfo.getSscBillID() : jobHisInfo.getSscBillID();
                if (!StringUtils.isEmpty((String)sscBillID) && ((Boolean)existsMethod.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sscBillID)))).booleanValue()) {
                    Method method = ICoreBase2.getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
                    IObjectValue dataObj = (IObjectValue)method.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sscBillID)), sic);
                    return SSCBaseBillUtils.getSourceBillAttribute(ctx, keyList, dataObj);
                }
                String string2 = sourceBillId = jobInfo != null ? jobInfo.getBillID() : jobHisInfo.getBillID();
                if (!StringUtils.isEmpty((String)sourceBillId) && ((Boolean)existsMethod.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sourceBillId)))).booleanValue()) {
                    Method method = ICoreBase2.getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
                    IObjectValue dataObj = (IObjectValue)method.invoke(object, new ObjectUuidPK(BOSUuid.read((String)sourceBillId)), sic);
                    return SSCBaseBillUtils.getSourceBillAttribute(ctx, keyList, dataObj);
                }
            } else {
                logger.error((Object)("\u672a\u7ed1\u5b9a\u5355\u636e\u7c7b\u578bbussAttrId:" + bussAttrId));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> getSourceBillAttribute(Context ctx, List<String> keyList, IObjectValue dataObj) {
        HashMap<String, String> fromSC = new HashMap<String, String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String dyKey = keyList.get(i);
            Object dyValue = null;
            if (dataObj instanceof IObjectValue) {
                try {
                    dyValue = dataObj;
                    String[] keys = dyKey.split("\\.");
                    dyValue = SSCBaseBillUtils.getDyValue(ctx, dyValue, keys);
                    if (dyValue instanceof Map) {
                        Map dyValueMap = (Map)dyValue;
                        String retuString = "";
                        retuString = JSONUtil.map2json(dyValueMap);
                        dyValue = retuString;
                    }
                }
                catch (Exception e) {
                    dyValue = null;
                    logger.error((Object)("get params error from bill,dyKey:" + dyKey), (Throwable)e);
                }
            } else if (dataObj instanceof Map) {
                dyValue = ((Map)dataObj).get(dyKey);
            }
            String value = null;
            if (dyValue != null && !dyValue.toString().equals("null")) {
                value = String.valueOf(dyValue);
            }
            logger.info((Object)("dykey is..." + dyKey));
            logger.info((Object)("value is..." + value));
            fromSC.put(dyKey, value);
        }
        return fromSC;
    }

    private static Object getDyValue(Context ctx, Object dyValue, String[] keys) {
        block8: {
            String key = keys[0];
            try {
                Class<?> cls = dyValue.getClass();
                Method method = cls.getMethod("get", String.class);
                dyValue = method.invoke(dyValue, key);
                if (dyValue instanceof Enum) {
                    cls = dyValue.getClass();
                    method = cls.getMethod("getValue", new Class[0]);
                    dyValue = method.invoke(dyValue, new Object[0]);
                    break block8;
                }
                if (dyValue instanceof Timestamp) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return format.format(dyValue);
                }
                if (dyValue instanceof IObjectCollection) {
                    IObjectCollection coll = (IObjectCollection)dyValue;
                    String[] strArr = SSCBaseBillUtils.removeStringArrFrist(keys);
                    HashMap<Object, Object> map = new HashMap<Object, Object>();
                    for (int j = 0; j < coll.size(); ++j) {
                        IObjectValue objValue = coll.getObject(j);
                        dyValue = SSCBaseBillUtils.getDyValue(ctx, objValue, strArr);
                        map.put(null == objValue.get("id") ? Integer.valueOf(j) : objValue.get("id"), dyValue);
                    }
                    return map;
                }
                if (dyValue instanceof IObjectValue) {
                    String[] strArr = SSCBaseBillUtils.removeStringArrFrist(keys);
                    dyValue = SSCBaseBillUtils.getDyValue(ctx, dyValue, strArr);
                    break block8;
                }
                if (dyValue instanceof String) {
                    dyValue = dyValue != null ? ((String)dyValue).trim() : dyValue;
                }
                return dyValue;
            }
            catch (Exception e) {
                dyValue = null;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return dyValue;
    }

    private static String[] removeStringArrFrist(String[] keys) {
        String[] arrNew = new String[keys.length - 1];
        for (int i = 1; i < keys.length; ++i) {
            arrNew[i - 1] = keys[i];
        }
        return arrNew;
    }

    public static String getEntityProperty(Context ctx, JobHisInfo jobHisInfo, String key) {
        String value = SSCBaseBillUtils.getKeyV_value(ctx, jobHisInfo, key);
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if (value.contains("{") || key.contains(".")) {
            try {
                Map map = JSONUtil.jsonToMap(value);
                Iterator iterator = map.values().iterator();
                return (String)iterator.next();
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }

    public static String getKeyV_value(Context ctx, JobHisInfo jobHisInfo, String key) {
        if (key.trim().matches("^\\{@\\S*}$")) {
            key = SSCBaseBillUtils.spiltString(key);
            key = SSCBaseBillUtils.getDynamicAttributeHisValue(ctx, jobHisInfo.getId().toString(), jobHisInfo.getShareCenterID().getId().toString(), jobHisInfo.getBussAttrID().getBillType().getId().toString(), key);
        } else if (key.trim().matches("^\\{\\$\\S*}$")) {
            ArrayList<String> list = new ArrayList<String>();
            key = SSCBaseBillUtils.spiltString(key);
            list.add(key);
            try {
                Map<String, String> map = SSCBaseBillUtils.getSourceBillAttribute(ctx, null, jobHisInfo, list);
                key = map.get(key) == null ? "" : map.get(key);
            }
            catch (Exception e) {
                key = "";
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return key;
    }

    public static String spiltString(String string) {
        string = string.trim();
        return string.substring(2, string.length() - 1);
    }

    private static String getDynamicAttributeHisValue(Context ctx, String jobHisId, String sCOrgId, String billTypeID, String dyKey) {
        String value;
        block3: {
            value = "";
            try {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billType", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)sCOrgId));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", null, CompareType.EQUALS));
                filter.setMaskString("(#0 or #1) and (#2 or #3 or #4) and (#5 or #6 or #7)");
                entityViewInfo.setFilter(filter);
                DynamicAttributeCollection dynamicAttributeCollection = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(entityViewInfo);
                if (dynamicAttributeCollection == null || dynamicAttributeCollection.size() <= 0) break block3;
                for (int j = 0; j < dynamicAttributeCollection.size(); ++j) {
                    DynamicAttributeInfo dynamicAttributeInfo = dynamicAttributeCollection.get(j);
                    if (!dynamicAttributeInfo.getNumber().equals(dyKey)) continue;
                    DynValueHisInfo dynamicValueInfo = DynValueHisFactory.getLocalInstance(ctx).getDynValueHisInfo("select * where jobId='" + jobHisId + "' and dynamicID='" + dynamicAttributeInfo.getId().toString() + "'");
                    value = "1".equals(dynamicAttributeInfo.getType().getValue()) ? dynamicValueInfo.getDigiValue() + "" : (dynamicValueInfo.getDinamicValue() != null ? dynamicValueInfo.getDinamicValue().trim() : dynamicValueInfo.getDinamicValue());
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    @Deprecated
    public static String getRealKey(Context ctx, String key, JobHisInfo jobHisInfo, String billTypeID) {
        Map<Integer, String> keyV = SSCBaseBillUtils.getKeyV_key(key);
        Map<Integer, String> keyRealV = SSCBaseBillUtils.getKeyV_value(ctx, keyV, jobHisInfo, billTypeID);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keyRealV.size(); ++i) {
            String keyRealValue = keyRealV.get(i);
            if (keyRealV.size() > 1 && keyRealValue.startsWith("{") && keyRealValue.endsWith("}")) {
                try {
                    Map map = JSONUtil.jsonToMap(keyRealValue);
                    Iterator iterator = map.values().iterator();
                    keyRealValue = "";
                    while (iterator.hasNext()) {
                        keyRealValue = keyRealValue + iterator.next();
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("*****\u5b57\u7b26\u4e32\u8f6c\u6362map\u51fa\u9519,\u4f7f\u7528\u539f\u503c*****: " + keyRealValue));
                }
                keyRealV.put(i, keyRealValue);
            }
            sb.append(keyRealValue);
        }
        String endStr = sb.toString();
        try {
            if (SSCCompareUtils.isStringDateTime(endStr)) {
                return endStr;
            }
            if (endStr.replaceAll("[\\d+-\\\\*/()]", "").trim().equals("")) {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("JavaScript");
                engine.eval("function t() {return " + endStr + ";}");
                Invocable invocable = (Invocable)((Object)engine);
                Object o = invocable.invokeFunction("t", new Object[0]);
                String str = o.toString();
                BigDecimal big = new BigDecimal(str).setScale(0, 4);
                BigDecimal bigd = new BigDecimal(str);
                if (big.compareTo(bigd) == 0) {
                    return big.toString();
                }
                return bigd.toString();
            }
            sb = new StringBuffer();
            for (int i = 0; i < keyRealV.size(); ++i) {
                String tmp;
                String keyRealValue = keyRealV.get(i);
                if ("+".equals(keyRealValue) || "+".equals(keyRealValue) || "-".equals(keyRealValue) || "*".equals(keyRealValue) || "/".equals(keyRealValue)) continue;
                try {
                    tmp = (String)JSONUtils.convertJsonToObject((Context)ctx, (String)keyRealValue, String.class);
                }
                catch (Exception e) {
                    tmp = keyRealValue;
                    logger.debug((Object)("*****json\u8f6c\u6362\u51fa\u9519,\u4f7f\u7528\u539f\u503c*****: " + tmp));
                }
                tmp = tmp.replace("null", " ");
                sb.append(tmp);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)("IntelligentAuditCfgFacadeControllerBean**getRealKey" + jobHisInfo.getId().toString()));
            return endStr;
        }
    }

    private static Map<Integer, String> getKeyV_value(Context ctx, Map<Integer, String> keyV, JobHisInfo jobHisInfo, String billTypeID) {
        for (int i = 0; i < keyV.size(); ++i) {
            String value = keyV.get(i);
            if (value.trim().matches("^\\{@\\S*}$")) {
                String key = SSCBaseBillUtils.spiltString(keyV.get(i));
                value = SSCBaseBillUtils.getDynamicAttributeHisValue(ctx, jobHisInfo.getId().toString(), jobHisInfo.getShareCenterID().getId().toString(), billTypeID, key);
                keyV.put(i, value);
                continue;
            }
            if (value.trim().matches("^\\{\\$\\S*}$")) {
                ArrayList<String> list = new ArrayList<String>();
                String key = SSCBaseBillUtils.spiltString(keyV.get(i));
                list.add(key);
                try {
                    Map<String, String> map = SSCBaseBillUtils.getSourceBillAttribute(ctx, null, jobHisInfo, list);
                    value = map.get(key);
                }
                catch (Exception e) {
                    value = "";
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                keyV.put(i, value);
                continue;
            }
            keyV.put(i, value);
        }
        return keyV;
    }

    private String getDynamicAttributeValue(Context ctx, JobInfo jobInfo, String billTypeID, String dyKey) {
        String value;
        block3: {
            value = "";
            try {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billType", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("fromBill", (Object)Boolean.TRUE));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)jobInfo.getShareCenterID().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(ctx).getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("shareCenterId", null, CompareType.EQUALS));
                filter.setMaskString("(#0 or #1) and (#2 or #3 or #4) and (#5 or #6 or #7)");
                entityViewInfo.setFilter(filter);
                DynamicAttributeCollection dynamicAttributeCollection = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeCollection(entityViewInfo);
                if (dynamicAttributeCollection == null || dynamicAttributeCollection.size() <= 0) break block3;
                for (int j = 0; j < dynamicAttributeCollection.size(); ++j) {
                    DynamicAttributeInfo dynamicAttributeInfo = dynamicAttributeCollection.get(j);
                    if (!dynamicAttributeInfo.getNumber().equals(dyKey)) continue;
                    DynamicValueInfo dynamicValueInfo = DynamicValueFactory.getLocalInstance(ctx).getDynamicValueInfo("select * where jobId='" + jobInfo.getId().toString() + "' and dynamicID='" + dynamicAttributeInfo.getId().toString() + "'");
                    value = "1".equals(dynamicAttributeInfo.getType().getValue()) ? dynamicValueInfo.getDigiValue() + "" : (dynamicValueInfo.getDinamicValue() != null ? dynamicValueInfo.getDinamicValue().trim() : dynamicValueInfo.getDinamicValue());
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    public static Set<String> getColumns(Map<Integer, String> keyV, String regex) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < keyV.size(); ++i) {
            String value = keyV.get(i).trim();
            if (!value.matches(regex)) continue;
            result.add(SSCBaseBillUtils.spiltString(value));
        }
        return result;
    }

    public static Map<Integer, String> getKeyV_key(String key) {
        String str = key;
        String[] arr1 = str.split("\\+");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < arr1.length; ++i) {
            String[] arr2 = arr1[i].split("\\-");
            for (int j = 0; j < arr2.length; ++j) {
                String[] arr3 = arr2[j].split("\\*");
                for (int k = 0; k < arr3.length; ++k) {
                    String[] arr4 = arr3[k].split("\\/");
                    for (int l = 0; l < arr4.length; ++l) {
                        list.add(arr4[l]);
                        if (l == arr4.length - 1) continue;
                        list.add("/");
                    }
                    if (k == arr3.length - 1) continue;
                    list.add("*");
                }
                if (j == arr2.length - 1) continue;
                list.add("-");
            }
            if (i == arr1.length - 1) continue;
            list.add("+");
        }
        ArrayList<String> endList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            int j;
            if (list.get(i) != null && ((String)list.get(i)).contains("(")) {
                int con = SSCBaseBillUtils.countStr((String)list.get(i), "(");
                for (int j2 = 0; j2 < con; ++j2) {
                    endList.add("(");
                }
                String[] ar1 = ((String)list.get(i)).split("\\(");
                for (j = 0; j < ar1.length; ++j) {
                    if (ar1[j] == null) continue;
                    endList.add(ar1[j]);
                }
                continue;
            }
            if (list.get(i) != null && ((String)list.get(i)).contains(")")) {
                String[] ar1 = ((String)list.get(i)).split("\\)");
                for (int j3 = 0; j3 < ar1.length; ++j3) {
                    if (ar1[j3] == null) continue;
                    endList.add(ar1[j3]);
                }
                int con = SSCBaseBillUtils.countStr((String)list.get(i), ")");
                for (j = 0; j < con; ++j) {
                    endList.add(")");
                }
                continue;
            }
            endList.add((String)list.get(i));
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < endList.size(); ++i) {
            map.put(i, (String)endList.get(i));
            System.out.println((String)endList.get(i));
        }
        return map;
    }

    private static int countStr(String one, String two) {
        int counter = 0;
        if (one.indexOf(two) == -1) {
            return 0;
        }
        while (one.indexOf(two) != -1) {
            ++counter;
            one = one.substring(one.indexOf(two) + two.length());
        }
        return counter;
    }
}

