/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.credit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.CreditFilesCollection;
import com.kingdee.eas.base.ssc.CreditFilesFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewCollection;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogCollection;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.CreditParamsEntryCollection;
import com.kingdee.eas.base.ssc.CreditParamsFacadeFactory;
import com.kingdee.eas.base.ssc.CreditParamsInfo;
import com.kingdee.eas.base.ssc.CreditScoreCollection;
import com.kingdee.eas.base.ssc.CreditScoreFactory;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.ICreditParamsFacade;
import com.kingdee.eas.base.ssc.IUser;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.base.ssc.app.InfluenceCreditTypeEnum;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.credit.CreditCache;
import com.kingdee.eas.base.ssc.tool.credit.CreditCaculateEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreditUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.credit.CreditUtils");
    private static final String UPDATA_CREDITFILES_REDUCE_SQL = "update T_SSC_CreditFilesNew set FCreditRatingID = ?, FCreditScore=?, FUnqualifiedTotalNum=FUnqualifiedTotalNum+1, FThisYearUnqualifiedNum=FThisYearUnqualifiedNum+1, FLASTUPDATETIME=now() where fid=?";
    private static final String UPDATA_CREDITFILES_RISE_SQL = "update T_SSC_CreditFilesNew set FCreditRatingID=?, FCreditScore=?, FLASTUPDATETIME=now() where fid=?";

    public static boolean isJobAuto(Context ctx, String billId) throws BOSException, EASBizException {
        JobHisCollection colls = JobHisFactory.getLocalInstance(ctx).getJobHisCollection("where billID='" + billId + "' and isLastLevel = 1 order by createTime desc");
        if (null != colls && !colls.isEmpty()) {
            return colls.get(0).isAutoApprove();
        }
        return false;
    }

    public static CreditFilesNewInfo getCreditFilesInfo(Context ctx, String userId) throws BOSException, EASBizException {
        CreditFilesNewInfo creditFilesNewInfo = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfoByUserId(userId);
        if (creditFilesNewInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u6839\u636e" + userId + "\u65e0\u6cd5\u83b7\u53d6\u4fe1\u7528\u6863\u6848"));
        }
        return creditFilesNewInfo;
    }

    @Deprecated
    private static String getPMUserId(Context ctx, String userId) throws BOSException, EASBizException {
        if (BOSUuid.isValid((String)userId, (boolean)true)) {
            if ("13B7DE7F".equals(BOSUuid.read((String)userId).getType().toString())) {
                return userId;
            }
            if ("80EF7DED".equals(BOSUuid.read((String)userId).getType().toString())) {
                com.kingdee.eas.base.permission.IUser iUser = com.kingdee.eas.base.permission.UserFactory.getLocalInstance((Context)ctx);
                if (iUser.exists("where person.id='" + userId + "'")) {
                    return iUser.getUserInfo("where person.id='" + userId + "'").getId().toString();
                }
            } else if ("8063D27B".equals(BOSUuid.read((String)userId).getType().toString())) {
                IUser iUser = UserFactory.getLocalInstance(ctx);
                if (iUser.exists("where id='" + userId + "'")) {
                    return iUser.getUserInfo("where id='" + userId + "'").getEasUserId();
                }
            } else {
                throw new EASBizException(new NumericExceptionSubItem("XXXXX", "\u65e0\u6cd5\u6839\u636e" + userId + "\u627e\u5230\u5bf9\u5e94\u7684\u5458\u5de5"));
            }
        }
        throw new EASBizException(new NumericExceptionSubItem("XXXXX", userId + "\u4e0d\u662f\u6709\u6548\u7684ID"));
    }

    public static BigDecimal getAddScore(Context ctx, String billId, ChangeSourceEnum changeSource) {
        BigDecimal addScore = BigDecimal.ZERO;
        try {
            CreditLogCollection colls = CreditLogFactory.getLocalInstance(ctx).getCreditLogCollection("where billId='" + billId + "' and changeSource='" + changeSource.getValue() + "' and creditChangeType=3");
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    addScore = addScore.add(colls.get(i).getChangeScore());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return addScore;
    }

    public static BigDecimal getMinusScore(Context ctx, String billId, ChangeSourceEnum changeSource) {
        BigDecimal minusScore = BigDecimal.ZERO;
        try {
            CreditLogCollection colls = CreditLogFactory.getLocalInstance(ctx).getCreditLogCollection("where billId='" + billId + "' and changeSource='" + changeSource.getValue() + "' and creditChangeType=4");
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    minusScore = minusScore.add(colls.get(i).getChangeScore());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return minusScore;
    }

    public static BigDecimal getJobScoreCreditLog(Context ctx, String billId) {
        BigDecimal minusScore = null;
        try {
            CreditLogCollection colls = CreditLogFactory.getLocalInstance(ctx).getCreditLogCollection("where billId='" + billId + "' and changeSource='1'");
            if (colls != null && !colls.isEmpty()) {
                minusScore = BigDecimal.ZERO;
                for (int i = 0; i < colls.size(); ++i) {
                    CreditLogInfo creditLogInfo = colls.get(i);
                    if (CreditChangeTypeEnum.bonusPoint.equals((Object)creditLogInfo.getCreditChangeType())) {
                        minusScore = minusScore.add(creditLogInfo.getChangeScore());
                        continue;
                    }
                    if (!CreditChangeTypeEnum.deduction.equals((Object)creditLogInfo.getCreditChangeType())) continue;
                    minusScore = minusScore.subtract(creditLogInfo.getChangeScore());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return minusScore;
    }

    public static boolean isCreditByBillTypeId(Context ctx, String scId, String billTypeID) {
        List<String> creditBillType = CreditCache.getCreditBillType(ctx, scId);
        return creditBillType.contains(billTypeID);
    }

    public static CreditScoreInfo getMinCreditScoreInfo(Context ctx) throws EASBizException {
        CreditScoreCollection creditScoreColl = CreditCache.getCreditScoreColl(ctx);
        if (creditScoreColl == null || creditScoreColl.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u4fe1\u7528\u7b49\u7ea7\u672a\u8bbe\u7f6e"));
        }
        return creditScoreColl.get(creditScoreColl.size() - 1);
    }

    public static CreditScoreInfo getMaxCreditScoreInfo(Context ctx) throws EASBizException {
        CreditScoreCollection creditScoreColl = CreditCache.getCreditScoreColl(ctx);
        if (creditScoreColl == null || creditScoreColl.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u4fe1\u7528\u7b49\u7ea7\u672a\u8bbe\u7f6e"));
        }
        return creditScoreColl.get(0);
    }

    public static CreditScoreInfo getCreditScoreInfo(Context ctx, BigDecimal dscore) throws EASBizException {
        CreditScoreCollection creditScoreColl = CreditCache.getCreditScoreColl(ctx);
        if (creditScoreColl == null || creditScoreColl.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u4fe1\u7528\u7b49\u7ea7\u672a\u8bbe\u7f6e"));
        }
        for (int i = 0; i < creditScoreColl.size(); ++i) {
            if (creditScoreColl.get(i).getCreditScopeL().compareTo(dscore) > 0 || creditScoreColl.get(i).getCreditScopeH().add(new BigDecimal("1")).compareTo(dscore) <= 0) continue;
            return creditScoreColl.get(i);
        }
        return null;
    }

    public static BigDecimal getQualityMinusScore(Context ctx, String scId, String sampleLibraryQualityTaskId) {
        BigDecimal minusScore = BigDecimal.ZERO;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ISNULL(sum(e.FREDUCESCORENUM),0)");
        sb.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
        sb.append(" where r.FScOrgID = ? and e.FREASONBYSJZJID in(");
        sb.append(" select FUPQUALIFYREASONID from T_SSC_TaskUnpassReason where FTASKID = ?");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{scId, sampleLibraryQualityTaskId});
            if (rs.next()) {
                minusScore = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getQulityMinusScore error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + sampleLibraryQualityTaskId));
        }
        BigDecimal maxMinusScorePerBill = CreditCache.getMaxMinusScorePerBill(ctx, scId);
        if (maxMinusScorePerBill.compareTo(BigDecimal.ZERO) != 0) {
            minusScore = minusScore.compareTo(maxMinusScorePerBill) == 1 ? maxMinusScorePerBill : minusScore;
        }
        return minusScore;
    }

    public static BigDecimal getSpotMinusScore(Context ctx, String scId, String sampleLibraryQualityTaskId) {
        BigDecimal minusScore = BigDecimal.ZERO;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ISNULL(sum(e.FREDUCESCORENUM),0)");
        sb.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
        sb.append(" where r.FScOrgID = ? and e.FREASONBYGXFHID in(");
        sb.append(" select FUPQUALIFYREASONID from T_SSC_TaskUnpassReason where FTASKID = ?");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{scId, sampleLibraryQualityTaskId});
            if (rs.next()) {
                minusScore = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSpotMinusScore error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + sampleLibraryQualityTaskId));
        }
        BigDecimal maxMinusScorePerBill = CreditCache.getMaxMinusScorePerBill(ctx, scId);
        if (maxMinusScorePerBill.compareTo(BigDecimal.ZERO) != 0) {
            minusScore = minusScore.compareTo(maxMinusScorePerBill) == 1 ? maxMinusScorePerBill : minusScore;
        }
        return minusScore;
    }

    private static BigDecimal getJobMinusScoreWithOutHistoryAudit(Context ctx, String scId, String jobId) {
        BigDecimal minusScore = BigDecimal.ZERO;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ISNULL(sum(e.FREDUCESCORENUM),0)");
        sb.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
        sb.append(" where r.FScOrgID = ? and e.FREASONBYGXSHID in(");
        sb.append(" select FUnpassreaID from T_SSC_JobUnpassRea where FJOBID = ? and FCREATETIME = (select max(FCREATETIME) from T_SSC_JobUnpassRea where FJOBID=?)");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{scId, jobId, jobId});
            if (rs.next()) {
                minusScore = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getJobMinusScore error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + jobId));
        }
        BigDecimal maxMinusScorePerBill = CreditCache.getMaxMinusScorePerBill(ctx, scId);
        if (maxMinusScorePerBill.compareTo(BigDecimal.ZERO) != 0) {
            minusScore = minusScore.compareTo(maxMinusScorePerBill) == 1 ? maxMinusScorePerBill : minusScore;
        }
        return minusScore;
    }

    private static BigDecimal getBillMinusScore(Context ctx, String scId, String billId) {
        BigDecimal minusScore = BigDecimal.ZERO;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ISNULL(sum(e.FREDUCESCORENUM),0)");
        sb.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
        sb.append(" where r.FScOrgID = ? and e.FREASONBYGXSHID in(");
        sb.append(" select FUnpassreaID from T_SSC_JobUnpassRea where FJOBID in (");
        sb.append(" SELECT FID FROM T_ssc_jobhis where FBILLID = ?");
        sb.append(" )");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{scId, billId});
            if (rs.next()) {
                minusScore = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getBillMinusScore error!");
            logger.error((Object)("sql:" + sb.toString() + ",billId:" + billId));
        }
        return minusScore;
    }

    private static BigDecimal getJobNewReasonMinusScore(Context ctx, JobHisInfo jobHisInfo) throws EASBizException, BOSException {
        BigDecimal billMinusScore = CreditUtils.getBillMinusScore(ctx, jobHisInfo.getShareCenterID().getId().toString(), jobHisInfo.getBillID());
        BigDecimal newReasonMinusScore = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT ISNULL(sum(e.FREDUCESCORENUM),0)");
        sb.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
        sb.append(" where r.FScOrgID = ? and e.FREASONBYGXSHID in(");
        sb.append(" select FUnpassreaID from T_SSC_JobUnpassRea where FJOBID = ?");
        sb.append(" and FCREATETIME = (select max(FCREATETIME) from T_SSC_JobUnpassRea where FJOBID=?))");
        sb.append(" and FREASONBYGXSHID not in(");
        sb.append(" select FUnpassreaID from T_SSC_JobUnpassRea where FJOBID in (");
        sb.append(" SELECT FID FROM T_ssc_jobhis where FBILLID = ? and FID != ?");
        sb.append(" )");
        sb.append(" )");
        String jobId = jobHisInfo.getId().toString();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{jobHisInfo.getShareCenterID().getId().toString(), jobId, jobId, jobHisInfo.getBillID(), jobId});
            if (rs.next()) {
                newReasonMinusScore = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getJobMinusScoreCreditLog error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + jobId));
            return BigDecimal.ZERO;
        }
        BigDecimal maxMinusScorePerBill = CreditCache.getMaxMinusScorePerBill(ctx, jobHisInfo.getShareCenterID().getId().toString());
        if (newReasonMinusScore != null && maxMinusScorePerBill.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal remainScore = newReasonMinusScore.subtract(billMinusScore.subtract(maxMinusScorePerBill));
            newReasonMinusScore = remainScore.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : (remainScore.compareTo(newReasonMinusScore) == -1 ? remainScore : newReasonMinusScore);
        }
        return newReasonMinusScore;
    }

    public static String getUnPassReason(Context ctx, ChangeSourceEnum source, String scId, String taskId) throws BOSException {
        String type = "FREASONBYGXSHID";
        String scoreType = "1";
        if (ChangeSourceEnum.auditQuality.equals((Object)source)) {
            type = "FReasonbysjzjID";
            scoreType = "'3'";
        } else if (ChangeSourceEnum.sharedReview.equals((Object)source)) {
            type = "FReasonbygxfhID";
            scoreType = "'2'";
        }
        StringBuffer queryRule = new StringBuffer(500);
        if (ChangeSourceEnum.sharedAudit.equals((Object)source)) {
            queryRule.append("select e.FReduceScoreNum,un.fname_l2 FReducereason from \t").append("T_SSC_CreditScoreLdRule r left join T_SSC_CreditSLRRSE e on r.fid=e.FParentID \t").append(" left join t_ssc_unpassreason un on e.").append(type).append(" = un.fid where  r.FLdRoleType='0'  and r.FScOrgID =? and e.FReduceScoreType='1' \t").append(" and e." + type + " in ( select FUNPASSREAID from T_SSC_JobUnpassRea where fjobid= ? ").append(" and FCREATETIME = (select max(FCREATETIME) from T_SSC_JobUnpassRea where fjobid=? )");
            queryRule.append(" )");
        } else {
            queryRule.append(" SELECT un.fname_l2 FReducereason");
            queryRule.append(" FROM T_SSC_CreditScoreLdRule r inner join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
            queryRule.append(" left join T_ssc_UnqualifyReason un on e." + type + " = un.fid ");
            queryRule.append(" where r.FLdRoleType='0' and r.FScOrgID = ? and e.FReduceScoreType=" + scoreType + " and e." + type);
            queryRule.append(" in( SELECT FUPQUALIFYREASONID  FROM T_ssc_TaskUnpassReason where FTASKID = ?)");
        }
        StringBuffer reason = new StringBuffer();
        try {
            IRowSet rs = null;
            rs = ChangeSourceEnum.sharedAudit.equals((Object)source) ? DbUtil.executeQuery((Context)ctx, (String)queryRule.toString(), (Object[])new Object[]{scId, taskId, taskId}) : DbUtil.executeQuery((Context)ctx, (String)queryRule.toString(), (Object[])new Object[]{scId, taskId});
            if (rs.first()) {
                rs.beforeFirst();
                while (rs.next()) {
                    reason.append(rs.getString("FReducereason"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getUnPassReason error!");
            logger.error((Object)("sql:" + queryRule.toString() + ",taskId:" + taskId));
            return "";
        }
        return reason.toString();
    }

    public static BigDecimal getJobMinusScore(Context ctx, JobHisInfo jobHisInfo) throws EASBizException, BOSException {
        BigDecimal minusScore = CreditUtils.getJobMinusScoreWithOutHistoryAudit(ctx, jobHisInfo.getShareCenterID().getId().toString(), jobHisInfo.getId().toString());
        BigDecimal jobScore = CreditUtils.getJobScoreCreditLog(ctx, jobHisInfo.getBillID());
        if (jobScore != null) {
            if (jobScore.compareTo(BigDecimal.ZERO) == 1) {
                minusScore = minusScore.add(jobScore);
            } else if (jobScore.compareTo(BigDecimal.ZERO) == -1) {
                minusScore = CreditUtils.getJobNewReasonMinusScore(ctx, jobHisInfo);
            }
        }
        return minusScore;
    }

    public static BigDecimal getJobAddScore(Context ctx, JobHisInfo jobHisInfo) throws EASBizException, BOSException {
        BigDecimal minusScore = CreditUtils.getJobMinusScoreWithOutHistoryAudit(ctx, jobHisInfo.getShareCenterID().getId().toString(), jobHisInfo.getId().toString());
        BigDecimal jobScore = CreditUtils.getJobScoreCreditLog(ctx, jobHisInfo.getBillID());
        if (minusScore.compareTo(BigDecimal.ZERO) == 0) {
            if (null == jobScore) {
                return CreditCache.getAddScorePerBill(ctx, jobHisInfo.getShareCenterID().getId().toString());
            }
            return null;
        }
        if (null != jobScore) {
            if (jobScore.compareTo(BigDecimal.ZERO) == 1) {
                minusScore = minusScore.add(jobScore);
            } else if (jobScore.compareTo(BigDecimal.ZERO) == -1) {
                minusScore = CreditUtils.getJobNewReasonMinusScore(ctx, jobHisInfo);
            }
        }
        minusScore = BigDecimal.ZERO.subtract(minusScore);
        return minusScore;
    }

    public static void updateCreditFilesByAddScore(Context ctx, String newCreditRationId, BigDecimal newScore, String creditFileId) {
        try {
            DbUtil.execute((Context)ctx, (String)UPDATA_CREDITFILES_RISE_SQL, (Object[])new Object[]{newCreditRationId, newScore, creditFileId});
        }
        catch (BOSException e) {
            logger.error((Object)"\u4fe1\u7528\u6863\u6848\u52a0\u5206\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void updateCreditFilesByMinusScore(Context ctx, String newCreditRationId, BigDecimal newScore, String creditFileId) {
        try {
            DbUtil.execute((Context)ctx, (String)UPDATA_CREDITFILES_REDUCE_SQL, (Object[])new Object[]{newCreditRationId, newScore, creditFileId});
        }
        catch (BOSException e) {
            logger.error((Object)"\u4fe1\u7528\u6863\u6848\u51cf\u5206\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static boolean isNeedCredit(Context ctx, JobInfo jobInfo) {
        try {
            String isCredit = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(jobInfo.getShareCenterID().getId().toString()), (String)"SSC_CREDIT_MANAGER");
            logger.info((Object)("---isCredit " + (isCredit == null ? "" : isCredit)));
            if (!"true".equals(isCredit)) {
                return false;
            }
            ICreditParamsFacade service = CreditParamsFacadeFactory.getLocalInstance(ctx);
            boolean isShareReview = service.whetherInfluenceCredit(jobInfo.getShareCenterID().getId().toString(), InfluenceCreditTypeEnum.sharedAudit);
            if (!isShareReview) {
                logger.info((Object)("---isShareReview---- " + isShareReview));
                return false;
            }
            BussinessAttributeInfo bInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectStringPK(jobInfo.getBussAttrID().getId().toString()));
            String billTypeID = bInfo.getBillType().getId().toString();
            if (1 != bInfo.getJobClassification().getValue()) {
                return false;
            }
            boolean hasBill = CreditUtils.hasBill(ctx, jobInfo.getShareCenterID().getId().toString(), billTypeID);
            if (!hasBill) {
                return false;
            }
            ArrayList<String> billTypeIds = new ArrayList<String>();
            billTypeIds.add(billTypeID);
            String baseSql = " select j.fid  from t_ssc_jobhis j inner join T_SSC_DynValueHis DV on j.fid=DV.Fjobidid inner join t_ssc_dynamicattribute DT on DV.Fdynamicidid=DT.Fid where j.fid=?";
            Map map = CreditParamsFacadeFactory.getLocalInstance(ctx).getFilteringSql(jobInfo.getShareCenterID().getId().toString(), billTypeIds, baseSql);
            logger.info((Object)("---map " + (map == null ? "" : map.toString())));
            String tarSql = (String)map.get(billTypeIds.get(0));
            tarSql = tarSql.replaceAll("\\?", " '" + jobInfo.getId().toString() + "' ");
            logger.info((Object)("---tarSql " + (tarSql == null ? "" : tarSql)));
            tarSql = "/*dialect*/ " + tarSql;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tarSql);
            return rs.next();
        }
        catch (Exception e) {
            logger.error((Object)"---\u67e5\u8be2\u662f\u9700\u8981\u8d70\u4fe1\u7528\u7b97\u6cd5\u903b\u8f91", (Throwable)e);
            return false;
        }
    }

    public static boolean hasBill(Context ctx, String scId, String billTypeId) throws EASBizException, BOSException {
        CreditParamsInfo cpInfo = CreditParamsFacadeFactory.getLocalInstance(ctx).getCreditParamsInfoInCache(scId);
        if (null == cpInfo) {
            return false;
        }
        CreditParamsEntryCollection entrys = cpInfo.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            if (!entrys.get(i).getBillType().getId().toString().equals(billTypeId)) continue;
            return true;
        }
        return false;
    }

    public static String getUserId(Context ctx, String jobId) throws BOSException {
        String querySql = "select FDinamicValue from T_SSC_DynValueHis where FJobIDID=? and FDynamicIDID='4VBUlqSUQuO8g8sPkTkXsZvLn80='";
        String ret = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{jobId});
            if (rs.next()) {
                ret = rs.getString("FDinamicValue");
            }
            if (StringUtils.isEmpty(ret)) {
                querySql = "select FDinamicValue from T_SSC_DynamicValue where FJobIDID=? and FDynamicIDID='4VBUlqSUQuO8g8sPkTkXsZvLn80='";
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{jobId});
                if (rs.next()) {
                    ret = rs.getString("FDinamicValue");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"-----get creator err", (Throwable)e);
        }
        return ret;
    }

    public static CreditScoreCollection getAllCreditScore(Context ctx) throws BOSException {
        CreditScoreCollection creditScore = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreCollection();
        return creditScore;
    }

    public static int parseMap(CreditScoreCollection creditScorColl, Map<Integer, CreditScoreInfo> cache) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < creditScorColl.size(); ++i) {
            CreditScoreInfo cur = creditScorColl.get(i);
            cache.put(cur.getSeqNo(), cur);
            if (cur.getSeqNo() <= result) continue;
            result = cur.getSeqNo();
        }
        return result;
    }

    public static CreditCaculateEntry judgeOne(List<CreditCaculateEntry> ruleList) {
        if (ruleList == null) {
            return null;
        }
        CreditCaculateEntry ret = null;
        int tmpLvl = Integer.MIN_VALUE;
        int len = ruleList.size();
        for (int i = 0; i < len; ++i) {
            CreditCaculateEntry cur = ruleList.get(i);
            int targetLvl = cur.getCurrentLevelSeq() + cur.getReduceLevelNum() > cur.getMinLevelSeq() ? cur.getMinLevelSeq() : cur.getCurrentLevelSeq() + cur.getReduceLevelNum();
            targetLvl = cur.getScoreLvlMinSeq() >= targetLvl ? targetLvl : cur.getScoreLvlMinSeq();
            cur.setTargetLevelSeq(targetLvl);
            if (targetLvl <= tmpLvl) continue;
            ret = cur;
            tmpLvl = targetLvl;
        }
        return ret;
    }

    public static CreditScoreInfo getCreditInfo(Context ctx, BigDecimal num) {
        try {
            CreditScoreCollection csColl = CreditUtils.getAllCreditScore(ctx);
            if (csColl != null && csColl.size() != 0) {
                for (int i = 0; i < csColl.size(); ++i) {
                    CreditScoreInfo csInfo = csColl.get(i);
                    BigDecimal leftScore = csInfo.getCreditScopeL();
                    BigDecimal rightScore = csInfo.getCreditScopeH();
                    if (num.compareTo(leftScore) >= 0 && num.compareTo(rightScore) < 0) {
                        return csInfo;
                    }
                    if (num.compareTo(new BigDecimal("100.0")) != 0 || num.compareTo(rightScore) != 0) continue;
                    return csInfo;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static CreditScoreInfo getMaxCreditScoreInfo(Context ctx, CreditScoreCollection creditScore) {
        CreditScoreInfo cur = creditScore.get(0);
        for (int j = 1; j < creditScore.size(); ++j) {
            if (cur.getSeqNo() <= creditScore.get(j).getSeqNo()) continue;
            cur = creditScore.get(j);
        }
        return cur;
    }

    public static CreditScoreInfo getMinCreditScoreInfo(Context ctx, CreditScoreCollection creditScore) {
        CreditScoreInfo cur = creditScore.get(0);
        for (int j = 1; j < creditScore.size(); ++j) {
            if (cur.getSeqNo() >= creditScore.get(j).getSeqNo()) continue;
            cur = creditScore.get(j);
        }
        return cur;
    }

    public static Map getCreditScoreMap(Context ctx) {
        HashMap<Integer, CreditScoreInfo> tMap = new HashMap<Integer, CreditScoreInfo>();
        try {
            CreditScoreCollection tCreScoreColl = CreditUtils.getAllCreditScore(ctx);
            if (tCreScoreColl != null && tCreScoreColl.size() > 0) {
                for (int index = 0; index < tCreScoreColl.size(); ++index) {
                    CreditScoreInfo tCreditScoreInfo = tCreScoreColl.get(index);
                    tMap.put(tCreditScoreInfo.getSeqNo(), tCreditScoreInfo);
                }
            }
        }
        catch (BOSException e) {
            tMap = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return tMap;
    }

    public static CreditFilesCollection _getCreditFilesNewCollectionByUserId(Context ctx, List<String> userIdList) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("*"));
        tSelectColl.add(new SelectorItemInfo("creditFilesNew.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", new HashSet<String>(userIdList), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CreditFilesCollection infos = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection(viewInfo);
        return infos;
    }

    public static CreditFilesNewCollection _getCreditFilesNewCollectionByCreditFilesId(Context ctx, List<String> creditFilesIdList) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("userAccount"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(creditFilesIdList), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CreditFilesCollection oldinfos = CreditFilesFactory.getLocalInstance(ctx).getCreditFilesCollection(viewInfo);
        if (oldinfos != null && oldinfos.size() > 0) {
            HashSet<String> userAccount = new HashSet<String>();
            for (int i = 0; i < oldinfos.size(); ++i) {
                userAccount.add(oldinfos.get(i).getUserAccount());
            }
            viewInfo = new EntityViewInfo();
            tSelectColl = new SelectorItemCollection();
            tSelectColl.add(new SelectorItemInfo("*"));
            viewInfo.setSelector(tSelectColl);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("userAccount", userAccount, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            CreditFilesNewCollection infos = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewCollection(viewInfo);
            return infos;
        }
        return null;
    }
}

