/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.satisfaction;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.DynValueHisCollection;
import com.kingdee.eas.base.ssc.DynValueHisFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeFactory;
import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleEntryCollection;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleEntryInfo;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleFactory;
import com.kingdee.eas.base.ssc.SatisfactionDataFilteringRuleInfo;
import com.kingdee.eas.base.ssc.SatisfactionSettingCollection;
import com.kingdee.eas.base.ssc.SatisfactionSettingEntryCollection;
import com.kingdee.eas.base.ssc.SatisfactionSettingEntryInfo;
import com.kingdee.eas.base.ssc.SatisfactionSettingFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingInfo;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.satisfaction.DealInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SatisfactionParamsUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.satisfaction.SatisfactionParamsUtils");

    public static boolean isMatchSatisfaction(Context ctx, String shareCenterId, String jobId) {
        try {
            String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(shareCenterId), (String)"SSC_SatisfactionControl");
            if (!"true".equals(isSatisfaction)) {
                logger.error((Object)("\u6ee1\u610f\u5ea6\u53c2\u6570\u6ca1\u6709\u5f00\u542f*******************SSC_SatisfactionControl**isSatisfaction" + isSatisfaction));
                return false;
            }
            return SatisfactionParamsUtils.isMatchSatisfactionParam(ctx, jobId);
        }
        catch (Exception e) {
            logger.error((Object)("\u4fe1\u7528\u53c2\u6570-\u53d1\u751f\u4e86Exception\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[shareCenterId:[" + shareCenterId + "]jobId:" + jobId + "]"));
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isMatchSatisfactionParam(Context ctx, String jobId) {
        try {
            JobHisInfo jobHisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("select *, bussAttrID.* where id = '" + jobId + "'");
            SatisfactionSettingCollection setingColl = SatisfactionSettingFactory.getLocalInstance(ctx).getSatisfactionSettingCollection("where sCOrg.id = '" + jobHisInfo.getShareCenterID().getId().toString() + "'");
            if (setingColl == null || setingColl.size() == 0) {
                logger.error((Object)"\u6ee1\u610f\u5ea6\u53c2\u6570\u8bbe\u7f6e\u672a\u53d6\u5230");
                return false;
            }
            SatisfactionSettingEntryCollection paramsEntryColl = setingColl.get(0).getEntrys();
            for (int i = 0; paramsEntryColl != null && i < paramsEntryColl.size(); ++i) {
                String dataFilteringRule;
                SatisfactionSettingEntryInfo entryInfo = paramsEntryColl.get(i);
                if (!entryInfo.getBilltypeName().getId().toString().equals(jobHisInfo.getBussAttrID().getBillType().getId().toString())) continue;
                String string = dataFilteringRule = entryInfo.getDataFilterRule() == null ? "" : entryInfo.getDataFilterRule().toString();
                if (StringUtils.isBlank((CharSequence)dataFilteringRule)) {
                    return true;
                }
                return SatisfactionParamsUtils.isMatchCreditRule(ctx, dataFilteringRule, jobHisInfo);
            }
            logger.error((Object)("\u6ee1\u610f\u5ea6\u53c2\u6570-\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[jobId:" + jobId + "]"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("\u6ee1\u610f\u5ea6\u53c2\u6570-\u53d1\u751f\u4e86Exception\u6700\u7ec8\u5339\u914d\u7684\u7ed3\u679c\u662ffalse-[jobId:" + jobId + "]"));
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isMatchCreditRule(Context ctx, String dataFilteringRule, JobHisInfo jobHisInfo) throws EASBizException, BOSException, SQLException {
        SatisfactionDataFilteringRuleInfo dataFilterInfo = SatisfactionDataFilteringRuleFactory.getLocalInstance(ctx).getSatisfactionDataFilteringRuleInfo(" select *,entrys.* where id = '" + dataFilteringRule + "'");
        SatisfactionDataFilteringRuleEntryCollection ruleEntryColl = dataFilterInfo.getEntrys();
        if (ruleEntryColl == null || ruleEntryColl.size() == 0) {
            return true;
        }
        ArrayList<DealInfo> listBool = new ArrayList<DealInfo>();
        for (int i = 0; ruleEntryColl != null && i < ruleEntryColl.size(); ++i) {
            DealInfo dealInfo = new DealInfo();
            SatisfactionDataFilteringRuleEntryInfo entryInfo = ruleEntryColl.get(i);
            String comparisonValue = entryInfo.getComparisonValue();
            String propId = entryInfo.getPropertyId();
            if (StringUtils.isBlank((CharSequence)propId)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(" SELECT b.FDYNAMICIDID ,b.FDINAMICVALUE ,c.FNUMBER,a.FISLASTLEVEL ,a.FSHARECENTERID   FROM t_ssc_jobhis a ");
                buffer.append(" inner join T_SSC_DynValueHis b on a.FID =b.fjobidid ");
                buffer.append(" inner join T_SSC_DynamicAttribute c on c.FID =b.fdynamicidid ");
                buffer.append(" where a.fid = ? and c.fnumber = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{jobHisInfo.getId().toString(), entryInfo.getProperty()});
                if (rs.next()) {
                    propId = rs.getString("FDYNAMICIDID");
                } else {
                    logger.error((Object)("\u6ee1\u610f\u5ea6\u6839\u636e\u52a8\u6001\u5c5e\u6027\u540d\u79f0\u548c\u4efb\u52a1id\u67e5\u8be2\u52a8\u6001\u5c5e\u6027id\u4e3a\u7a7a;[dataFilteringRule:" + dataFilteringRule + ";jobHisInfo:" + jobHisInfo.getId().toString() + "]"));
                    return false;
                }
            }
            DynamicAttributeInfo dyAttrInfo = DynamicAttributeFactory.getLocalInstance(ctx).getDynamicAttributeInfo(H.PK(propId));
            DynValueHisCollection dyValueColl = DynValueHisFactory.getLocalInstance(ctx).getDynValueHisCollection("select * where jobID.id = '" + jobHisInfo.getId().toString() + "' and dynamicID.id = '" + propId + "'");
            String comparKey = "";
            if (dyValueColl != null && dyValueColl.size() > 0) {
                comparKey = FieldType.NUMBER.equals((Object)dyAttrInfo.getType()) ? dyValueColl.get(0).getDigiValue().toString() : dyValueColl.get(0).getDinamicValue();
            }
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            boolean b = SSCCompareUtils.compareS(entryInfo.getComparisonOper(), comparKey, comparisonValue);
            dealInfo.setBool(b);
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            dealInfo.setLuogi(entryInfo.getLogicalCondition());
            listBool.add(dealInfo);
        }
        boolean endBool = true;
        String luoj = " && ";
        if (listBool.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < listBool.size(); ++j) {
                DealInfo dealInfo = (DealInfo)listBool.get(j);
                sb.append(StringUtils.isEmpty((CharSequence)dealInfo.getLeftBracket()) ? "" : dealInfo.getLeftBracket());
                sb.append(dealInfo.isBool());
                sb.append(StringUtils.isEmpty((CharSequence)dealInfo.getRightBracket()) ? "" : dealInfo.getRightBracket());
                String luoji = dealInfo.getLuogi();
                if (luoji != null && "and".equalsIgnoreCase(luoji.trim())) {
                    dealInfo.setLuogi(" && ");
                } else if (luoji != null && "or".equalsIgnoreCase(luoji.trim())) {
                    dealInfo.setLuogi(" || ");
                }
                dealInfo.setLuogi(" " + dealInfo.getLuogi() + " ");
                if (j >= listBool.size() - 1) continue;
                if (!StringUtils.isEmpty((CharSequence)luoji)) {
                    sb.append(dealInfo.getLuogi());
                    continue;
                }
                sb.append(luoj);
            }
            try {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("JavaScript");
                engine.eval("function t() {return " + sb.toString() + ";}");
                Invocable invocable = (Invocable)((Object)engine);
                Object o = invocable.invokeFunction("t", new Object[0]);
                endBool = Boolean.parseBoolean(o.toString());
                return endBool;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return endBool;
    }

    public static String getSatisfactionTitle(Context ctx, SatisfactionSettingInfo ssInfo, String billID) throws BOSException, EASBizException {
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        HashSet<String> jobStateSet = new HashSet<String>();
        jobStateSet.add(JobState.Passed.getValue());
        jobStateSet.add(JobState.ToVouchered.getValue());
        filter1.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        filter1.getFilterItems().add(new FilterItemInfo("isLastLevel", (Object)1));
        filter1.getFilterItems().add(new FilterItemInfo("jobState", jobStateSet, CompareType.INCLUDE));
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("shareCenterID");
        sic1.add("bussAttrID.billType.id");
        sic1.add("sscBillID");
        sic1.add("billID");
        view1.setFilter(filter1);
        view1.setSelector(sic1);
        JobHisCollection coll1 = JobHisFactory.getLocalInstance(ctx).getJobHisCollection(view1);
        JobHisInfo jobHisInfo = coll1.get(0);
        if (jobHisInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("001", "\u5171\u4eab\u4e2d\u5fc3\u4e0d\u5b58\u5728\u6b64\u5355\u636e\u7684\u4efb\u52a1\uff01"));
        }
        for (int i = 0; i < ssInfo.getEntrys().size(); ++i) {
            if (!ssInfo.getEntrys().get(i).getBilltypeName().getId().toString().equals(jobHisInfo.getBussAttrID().getBillType().getId().toString())) continue;
            String title = ssInfo.getEntrys().get(i).getTitle();
            String regex = "\\{(.*?)}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(title);
            while (matcher.find()) {
                String mactcheValue = "{" + matcher.group(1) + "}";
                String realValue = SSCBaseBillUtils.getEntityProperty(ctx, jobHisInfo, mactcheValue);
                title = title.replace(mactcheValue, realValue);
            }
            return title;
        }
        return "";
    }

    public static Map<String, Object> getSatisfactionHisInfo(Context ctx, String billId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "select FID from t_ssc_jobhis where FBillID = '" + billId + "' and FIsLastLevel = 1 and FJobState in ('3','10') ";
        IRowSet rs = null;
        String jobhisId = "";
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                jobhisId = rs.getString("FID");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)jobhisId)) {
            result.put("msg", "\u6839\u636e\u5355\u636e\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5df2\u5b8c\u6210\u4efb\u52a1\uff01");
            return result;
        }
        sql = "select a.FIsEvaluate,a.FEvaluateResult,a.FEvaluateContent,a.funreason,a.FDimensionStr from T_SSC_SatisfactionBillInquire a where a.FJobhisID = '" + jobhisId + "' ";
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                result.put("isEvaluate", "1".equals(rs.getString("FIsEvaluate")) ? "true" : "false");
                result.put("evaluateContent", rs.getString("FEvaluateContent"));
                String dimension = rs.getString("FDimensionStr");
                if (!StringUtils.isEmpty((CharSequence)dimension)) {
                    JSONArray arr = JSONArray.parseArray((String)dimension);
                    for (int i = 0; i < arr.size(); ++i) {
                        if ("totalSatis".equals(arr.getJSONObject(i).getString("number"))) {
                            arr.remove(i);
                            --i;
                            continue;
                        }
                        int score = Integer.parseInt(arr.getJSONObject(i).getString("score"));
                        arr.getJSONObject(i).put("score", (Object)Math.abs(score - 4));
                    }
                    result.put("dimension", arr.toJSONString());
                }
                result.put("evaluateResult", rs.getString("FEvaluateResult"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result != null && result.size() == 0) {
            result.put("msg", "\u6839\u636e\u5355\u636e\u627e\u4e0d\u5230\u4efb\u52a1\u7684\u6ee1\u610f\u5ea6\u4fe1\u606f\uff01");
            return result;
        }
        sql = "select b.FUnReasonID from T_SSC_SatisfactionBillInquire a left join T_SSC_SatisfactionBillUnRea b on a.FID = b.FSatisfactionBillID where a.FJobhisID = '" + jobhisId + "' ";
        ArrayList<String> reasonList = new ArrayList<String>();
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                reasonList.add(rs.getString("FUnReasonID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        result.put("reason", reasonList);
        return result;
    }
}

