/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.shrssc.vo.ShrFilterItemData;
import com.kingdee.eas.base.ssc.shr.bean.RealDataFetcher;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_GETQUERYSOURCEDATA
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_GETQUERYSOURCEDATA.class);

    @Override
    public Object operation(Context ctx, Map<String, Object> query) throws BOSException {
        String queryPK = (String)query.get("queryPK");
        int displayNum = Integer.parseInt(String.valueOf(query.get("displayNum")));
        String defaultVal = (String)query.get("defaultValue");
        boolean isSelf = defaultVal == null ? false : defaultVal.toLowerCase(CtrlFormatUtilities.getFormatLocale()).equals("self");
        try {
            String filterItems = (String)query.get("filterItems");
            FilterInfo finfo = !StringUtils.isEmpty((String)filterItems) ? new FilterInfo(filterItems) : new FilterInfo();
            IQueryExecutor queryExecutor = this.getQueryExecutor(ctx, queryPK, null, finfo, null);
            int totalCount = queryExecutor.getRowCount();
            List getDatas = this.getDatas(queryExecutor, displayNum + 1, 1, totalCount);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = user.getId().toString();
            String personId = user.getPerson() == null ? null : user.getPerson().getId().toString();
            boolean hasUser = false;
            ArrayList<ShrFilterItemData> enumData = new ArrayList<ShrFilterItemData>();
            for (int i = 0; i < getDatas.size(); ++i) {
                String name;
                HashMap hm = (HashMap)getDatas.get(i);
                String id = hm.get("id") == null ? "" : hm.get("id").toString();
                String string = name = hm.get("name") == null ? "" : hm.get("name").toString();
                if (isSelf && (id.equals(userId) || id.equals(personId))) {
                    enumData.add(0, new ShrFilterItemData((Object)id, name, true));
                    hasUser = true;
                    continue;
                }
                enumData.add(new ShrFilterItemData((Object)id, name, false));
            }
            if (isSelf && !hasUser && enumData.size() > 0) {
                String id;
                IRowSet rs;
                IQueryExecutor qe;
                BOSObjectType bosType = BOSUuid.read((String)((ShrFilterItemData)enumData.get(0)).getValue().toString()).getType();
                if (bosType.equals((Object)new UserInfo().getBOSType())) {
                    finfo.mergeFilter(new FilterInfo("id='" + userId + "'"), "AND");
                    qe = this.getQueryExecutor(ctx, queryPK, null, finfo, null);
                    rs = qe.executeQuery();
                    while (rs.next()) {
                        id = rs.getString("id");
                        String name = rs.getString("name");
                        enumData.add(0, new ShrFilterItemData((Object)id, name, true));
                    }
                } else if (bosType.equals((Object)new PersonInfo().getBOSType())) {
                    finfo.mergeFilter(new FilterInfo("id='" + personId + "'"), "AND");
                    qe = this.getQueryExecutor(ctx, queryPK, null, finfo, null);
                    rs = qe.executeQuery();
                    while (rs.next()) {
                        id = rs.getString("id");
                        String name = rs.getString("name");
                        enumData.add(0, new ShrFilterItemData((Object)id, name, true));
                    }
                }
            }
            return enumData;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    private IQueryExecutor getQueryExecutor(Context ctx, String queryPK, String selector, FilterInfo filterInfo, String sorterItems) throws BOSException, ParserException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    private List getDatas(IQueryExecutor queryExecutor, int rows, int page, int totalCount) throws BOSException {
        List getDatas = new ArrayList();
        if (totalCount > 0) {
            RealDataFetcher vdf = RealDataFetcher.createInstance((IQueryExecutor)queryExecutor, (int)((page - 1) * rows), (int)rows);
            getDatas = vdf.getData();
        }
        return getDatas;
    }
}

