/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.shrssc.ShrTaskOperationException;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.SysAttrOrgSCMapFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_IMPORTORG
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_IMPORTORG.class);
    public static final int OnceImportOrgAmount = 5000;
    private static final String SYSTEM_ATTRIBURE = "qSRO0PdERume6Ov+F0oes8uCaH0=";

    @Override
    public Object operation(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String extendERPId = (String)params.get("extendERPId");
        String sharecenterId = (String)params.get("sharecenterId");
        String synced = (String)params.get("synced");
        String orgType = (String)params.get("orgType");
        if (StringUtils.isEmpty((String)extendERPId) || StringUtils.isEmpty((String)sharecenterId) || StringUtils.isEmpty((String)synced) || StringUtils.isEmpty((String)orgType)) {
            throw new ShrTaskOperationException(ShrTaskOperationException.PARAMS_IS_NULL);
        }
        try {
            if (synced.equalsIgnoreCase("false")) {
                OrgType sscOrgType = OrgType.getEnum((int)Integer.parseInt(orgType));
                String sql = "update T_SSC_ExtendERP set FImpOrgType = ? where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sscOrgType.getValue(), extendERPId});
            }
            List<String> orgIds = this.importAllOrgs(ctx, params, extendERPId);
            SysAttrOrgSCMapFactory.getLocalInstance((Context)ctx).savaSysAttrOrgSCMapCollection(sharecenterId, SYSTEM_ATTRIBURE, orgIds);
        }
        catch (Exception e) {
            logger.error("importOrg error:" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return "SUCCESS";
    }

    private List<String> importAllOrgs(Context ctx, Map result, String extendERPId) throws InterruptedException, ExecutionException, BOSException {
        ArrayList<String> sscOrgIDs = new ArrayList<String>();
        List list = JSONObject.parseArray((String)((String)result.get("OrgDatas")), Map.class);
        if (list != null && !list.isEmpty()) {
            logger.info(Thread.currentThread().getName() + "\u7ebf\u7a0b\u672c\u6b21\u5bfc\u5165\u7ec4\u7ec7\u6570\uff1a" + list.size());
            int poolSize = new Double(Math.ceil((double)list.size() / 5000.0)).intValue();
            ExecutorService service = Executors.newFixedThreadPool(poolSize);
            ArrayList<Future<IObjectPK[]>> futureList = new ArrayList<Future<IObjectPK[]>>(poolSize);
            for (int i = 0; i < poolSize; ++i) {
                List<Map<String, String>> childList = list.subList(i * 5000, i * 5000 + 5000 > list.size() ? list.size() : i * 5000 + 5000);
                importOrgThread importOrgThread2 = new importOrgThread(ctx, childList, extendERPId);
                Future<IObjectPK[]> future = service.submit(importOrgThread2);
                futureList.add(future);
                childList = null;
            }
            int importOrgSize = 0;
            while (futureList.size() > 0) {
                Iterator iterable = futureList.iterator();
                while (iterable.hasNext()) {
                    Future future = (Future)iterable.next();
                    if (future.isDone() && !future.isCancelled()) {
                        IObjectPK[] sscOrg = future.get() == null ? new IObjectPK[]{} : (IObjectPK[])future.get();
                        importOrgSize = sscOrg == null ? 0 : sscOrg.length;
                        for (int i = 0; i < sscOrg.length; ++i) {
                            sscOrgIDs.add(sscOrg[i].toString());
                        }
                        iterable.remove();
                        continue;
                    }
                    Thread.sleep(1L);
                }
            }
            service.shutdown();
            logger.info(Thread.currentThread().getName() + "\u7ebf\u7a0b\u5b8c\u6210\u5bfc\u5165\u7ec4\u7ec7\u6570\uff1a" + importOrgSize);
        }
        return sscOrgIDs;
    }

    class importOrgThread
    implements Callable<IObjectPK[]> {
        private List<Map<String, String>> list;
        private String extendERPId;
        private Context ctx;

        public importOrgThread(Context ctx, List<Map<String, String>> list, String extendERPId) {
            this.list = list;
            this.extendERPId = extendERPId;
            this.ctx = ctx;
        }

        @Override
        public IObjectPK[] call() throws Exception {
            if (this.list != null && this.list.size() > 0) {
                try {
                    OrgCollection orgColl = new OrgCollection();
                    for (int j = 0; j < this.list.size(); ++j) {
                        Map<String, String> map = this.list.get(j);
                        OrgInfo orgInfo = new OrgInfo();
                        orgInfo.setOrgID(map.get("id"));
                        orgInfo.setParent(map.get("parent.id") != null ? map.get("parent.id") : null);
                        orgInfo.setNumber(map.get("number"));
                        orgInfo.setName(map.get("name"));
                        orgInfo.setIsLeaf(map.get("isLeaf") != null ? Boolean.parseBoolean(map.get("isLeaf")) : true);
                        orgInfo.setLevel((map.get("level") != null ? Integer.valueOf(Integer.parseInt(map.get("level"))) : null).intValue());
                        orgInfo.setLongNumber(map.get("longNumber"));
                        orgInfo.setDisplayName(map.get("displayName"));
                        orgColl.add(orgInfo);
                    }
                    IObjectPK[] pkList = OrgFactory.getLocalInstance((Context)this.ctx).importOrg(orgColl, this.extendERPId, "importAllOrg");
                    if (pkList != null && pkList.length > 0) {
                        return pkList;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }
    }
}

