/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.shrssc.util.ShrTaskOperationUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_JOBTREND
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_JOBTREND.class);

    @Override
    public Object operation(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        String userId = (String)params.get("userId");
        String bussAttributeStr = (String)params.get("bussAttribute");
        String typeStr = (String)params.get("dateType");
        int type = Integer.parseInt(typeStr);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<Map<String, Object>> result = null;
        try {
            Map<String, Date> dateTrendMap = this.assembleDateTrendMap(type, sdf);
            String sql = this.getSql(ctx, dateTrendMap, bussAttributeStr, userId);
            result = this.assembleResult(ctx, sql, type, sdf, dateTrendMap);
        }
        catch (ParseException e) {
            logger.error("=== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND ParseException:" + e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("=== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND SQLException:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getSql(Context ctx, Map<String, Date> dateTrendMap, String bussAttributeStr, String userId) throws EASBizException, BOSException {
        Date beginTimeDate = dateTrendMap.get("beginTimeDate");
        Date endTimeDate = dateTrendMap.get("endTimeDate");
        Date lastBeginTimeDate = dateTrendMap.get("lastBeginTimeDate");
        Date lastEndTimeDate = dateTrendMap.get("lastEndTimeDate");
        String beginTimeSql = ShrTaskOperationUtil.genTimeSql(beginTimeDate, true);
        String endTimeSql = ShrTaskOperationUtil.genTimeSql(endTimeDate, true);
        String lastBeginTimeSql = ShrTaskOperationUtil.genTimeSql(lastBeginTimeDate, true);
        String lastEndTimeSql = ShrTaskOperationUtil.genTimeSql(lastEndTimeDate, true);
        String[] bussAttributes = bussAttributeStr.split(",");
        boolean isManageOrgControl = ShrTaskOperationUtil.isManageOrgControl(ctx);
        StringBuffer sb = new StringBuffer();
        if (isManageOrgControl) {
            sb.append("SELECT jobhis.FCOMPLETETME a ");
            sb.append(" FROM t_ssc_jobhis jobhis");
            sb.append(" LEFT JOIN V_SSC_UserAdminBussAttrOrg AS UABAO ON jobhis.FBussAttrIDID = UABAO.FBussAttrId AND jobhis.FOrgIDID = UABAO.FOrgId");
            sb.append(" where ((jobhis.FCOMPLETETME >= " + beginTimeSql + " and jobhis.FCOMPLETETME <" + endTimeSql + ")");
            sb.append(" or (jobhis.FCOMPLETETME >= " + lastBeginTimeSql + " and jobhis.FCOMPLETETME <" + lastEndTimeSql + "))");
            sb.append(" and jobhis.FBUSSATTRIDID in " + ShrTaskOperationUtil.getStrFromArray(bussAttributes));
            sb.append(" and UABAO.FUSERID = '" + userId + "'");
        } else {
            sb.append("SELECT FCOMPLETETME a ");
            sb.append(" FROM t_ssc_jobhis");
            sb.append(" where ((FCOMPLETETME >= " + beginTimeSql + " and FCOMPLETETME <" + endTimeSql + ")");
            sb.append(" or (FCOMPLETETME >= " + lastBeginTimeSql + " and FCOMPLETETME <" + lastEndTimeSql + "))");
            sb.append(" and FBUSSATTRIDID in " + ShrTaskOperationUtil.getStrFromArray(bussAttributes));
        }
        return sb.toString();
    }

    private List<Map<String, Object>> assembleResult(Context ctx, String sql, int type, SimpleDateFormat sdf, Map<String, Date> dateTrendMap) throws BOSException, EASBizException, SQLException, ParseException {
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date beginTimeDate = dateTrendMap.get("beginTimeDate");
        Date endTimeDate = dateTrendMap.get("endTimeDate");
        Date lastBeginTimeDate = dateTrendMap.get("lastBeginTimeDate");
        Date lastEndTimeDate = dateTrendMap.get("lastEndTimeDate");
        HashMap<String, Integer> tmpMap = new HashMap<String, Integer>();
        HashMap<String, String> tmpStrMap = new HashMap<String, String>();
        ArrayList<String> xAxis = new ArrayList<String>();
        Date tmpN = beginTimeDate;
        Date tmpL = lastBeginTimeDate;
        if (type == 3) {
            sdf = new SimpleDateFormat("yyyy-MM");
        }
        while (tmpN.before(endTimeDate)) {
            tmpMap.put(sdf.format(tmpN), 0);
            tmpMap.put(sdf.format(tmpL), 0);
            HashMap map = new HashMap();
            if (!xAxis.contains(sdf.format(tmpN))) {
                xAxis.add(sdf.format(tmpN));
            }
            tmpStrMap.put(sdf.format(tmpN), sdf.format(tmpL));
            tmpN = ShrTaskOperationUtil.addOneDay(tmpN);
            tmpL = ShrTaskOperationUtil.addOneDay(tmpL);
        }
        String tmpString = null;
        logger.debug("======== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND.assembleResult type:" + type + "; tmpMap:" + tmpMap);
        while (rowSet.next()) {
            tmpString = sdf.format(rowSet.getDate("a"));
            logger.debug("======== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND.assembleResult tmpString:" + tmpString);
            try {
                if (null != tmpMap.get(tmpString)) {
                    int count = (Integer)tmpMap.get(tmpString);
                    tmpMap.put(tmpString, count + 1);
                    continue;
                }
                logger.debug("======== error com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND.assembleResult tmpString:" + tmpString + "; jobhis.fid :" + rowSet.getString("b"));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("======== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND.assembleResult :" + tmpString + "; tmpMap:" + tmpMap);
            }
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DecimalFormat df = new DecimalFormat("#.00");
        for (int i = 0; i < xAxis.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String xAixStr = (String)xAxis.get(i);
            map.put("xAxis", ShrTaskOperationUtil.formatDate(ctx, xAixStr, type));
            int data1 = tmpMap.get(xAixStr) == null ? 0 : (Integer)tmpMap.get(xAixStr);
            map.put("data1", data1);
            String lastXAixStr = (String)tmpStrMap.get(xAixStr);
            map.put("data2", tmpMap.get(lastXAixStr) == null ? 0 : (Integer)tmpMap.get(lastXAixStr));
            if (i == 0) {
                map.put("data3", 0);
            } else {
                int beforeValue = 0;
                try {
                    beforeValue = Integer.parseInt(((Map)result.get(i - 1)).get("data1").toString());
                }
                catch (Exception e) {
                    logger.error("======== com.kingdee.eas.base.shrssc.impl.ShrTaskOperation_JOBTREND beforeValue error :" + e.getMessage(), (Throwable)e);
                    map.put("data3", 0);
                }
                if (beforeValue == 0) {
                    map.put("data3", 0);
                } else {
                    float f = ((float)data1 - (float)beforeValue) / (float)beforeValue * 100.0f;
                    map.put("data3", df.format(f));
                }
            }
            result.add(map);
        }
        return result;
    }

    private Map<String, Date> assembleDateTrendMap(int type, SimpleDateFormat sdf) throws ParseException {
        Date beginTimeDate = null;
        Date endTimeDate = null;
        Date lastBeginTimeDate = null;
        Date lastEndTimeDate = null;
        if (type == 1) {
            beginTimeDate = ShrTaskOperationUtil.getTimesWeekBegin();
            endTimeDate = ShrTaskOperationUtil.getTimesWeekEnd();
            lastBeginTimeDate = ShrTaskOperationUtil.getLastWeek(beginTimeDate);
            lastEndTimeDate = ShrTaskOperationUtil.getLastWeek(endTimeDate);
        } else if (type == 2) {
            beginTimeDate = ShrTaskOperationUtil.getTimesMonthBegin();
            endTimeDate = ShrTaskOperationUtil.getTimesMonthEnd();
            lastBeginTimeDate = ShrTaskOperationUtil.getLastMonth(beginTimeDate);
            lastEndTimeDate = ShrTaskOperationUtil.getLastMonth(endTimeDate);
        } else if (type == 3) {
            int year = DateTimeUtils.getYear((Date)new Date());
            beginTimeDate = sdf.parse(year + "-1-1");
            endTimeDate = sdf.parse(year + 1 + "-1-1");
            lastBeginTimeDate = ShrTaskOperationUtil.getLastYear(beginTimeDate);
            lastEndTimeDate = ShrTaskOperationUtil.getLastYear(endTimeDate);
        }
        HashMap<String, Date> result = new HashMap<String, Date>();
        result.put("beginTimeDate", beginTimeDate);
        result.put("endTimeDate", endTimeDate);
        result.put("lastBeginTimeDate", lastBeginTimeDate);
        result.put("lastEndTimeDate", lastEndTimeDate);
        return result;
    }
}

