/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBUpdateUtils;
import com.kingdee.eas.base.uict.app.AbstractCloudMainMenuFacadeControllerBean;
import com.kingdee.eas.base.uict.mainmenu.DBFnMenu;
import com.kingdee.eas.base.uict.mainmenu.DBFnMenuTree;
import com.kingdee.eas.base.uict.mainmenu.DeployedMenuInfo;
import com.kingdee.eas.base.uict.mainmenu.FnMenu;
import com.kingdee.eas.base.uict.mainmenu.FnMenuModel;
import com.kingdee.eas.base.uict.mainmenu.FnMenuTree;
import com.kingdee.eas.base.uict.mainmenu.FnMenuTreeModel;
import com.kingdee.eas.base.uict.mainmenu.TableHelper;
import com.kingdee.eas.base.uict.mainmenu.XMLConfiguration;
import com.kingdee.util.STConverter;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CloudMainMenuFacadeControllerBean
extends AbstractCloudMainMenuFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uict.app.CloudMainMenuFacadeControllerBean");
    private FnMenuTreeModel menuTreeModel;
    private DBFnMenuTree treeModel;
    private String menuInfo;
    public static String MENU_TABLENAME = "T_PM_MainMenuItem";
    private static final String SQL_UPDATE_CACHE = "UPDATE T_BAS_MenuCache SET FMenuCaheTime = ?";
    private Connection conn = null;
    private PreparedStatement stmt = null;
    private ResultSet rs = null;
    public static String SQL_UPDATE_ALL_ITEMS = "UPDATE " + MENU_TABLENAME + " SET FUiClassName = ?,FName_L2 = ?,FDescription_L2= ?,FLevel= ?," + " FShortcutCode = ?,FLastUpdateTime = ?,FParent = ?," + "FIsLeaf = ?,FUiOprt = ?,FUiClassParam = ?,FIsReport = ?,FSimpleName=?,FNumber=?," + "FLongNumber=?,FName_L3=?,FDescription_L3=?, FVisible =1,FEnabled =1,FFunction=?, FImagePath=? " + " where FID= ?";
    public static String SQL_INSERT_ALL_MENU_ITEMS = "INSERT INTO " + MENU_TABLENAME + "(FUiClassName,FID,FName_L2,FNumber,FDescription_L2,FLevel,FLongNumber," + "FShortcutCode,FCreateTime,FLastUpdateTime,FParent,FIsLeaf,FUiOprt,FUiClassParam,FIsReport,FSimpleName,FName_L3,FDescription_L3,FVisible,FEnabled,FFunction, FImagePath,FMenutype)" + "  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,1,1,?,?,?)";
    public static String SQL_HAS_SAME_MENU = "SELECT FUiClassName FROM " + MENU_TABLENAME + " WHERE FID = ?";
    public static String SQL_SELECT_ALL = "SELECT * FROM " + MENU_TABLENAME + " WHERE FName_L2 is not null and FMenutype=5";
    public static String SQL_DELETE_MENU_ITEM = "DELETE FROM " + MENU_TABLENAME + " WHERE FID = ?";

    protected void _storeMainMenuInfo(Context ctx, String menuInfo) throws BOSException {
        this.menuInfo = menuInfo;
        try {
            this.load(ctx);
            this.synchronizeMenus(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String _loadMainMenuInfo(Context ctx) throws BOSException {
        this.treeModel = new DBFnMenuTree();
        List list = new ArrayList();
        Hashtable table = new Hashtable();
        DBFnMenu root = new DBFnMenu();
        root.setName("\u6839\u83dc\u5355");
        root.setLevel(0);
        root.setLeaf(false);
        root.setNumber("0000");
        root.setLongNumber(null);
        this.treeModel.setRoot(root);
        try {
            list = this.queryALlMenuRecords(ctx, table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list.size() > 0 && list.get(0) instanceof Hashtable) {
            Hashtable table1 = (Hashtable)list.get(0);
            Iterator ite = table1.keySet().iterator();
            while (ite.hasNext()) {
                FnMenuModel item = (FnMenuModel)table1.get(ite.next());
                if (((DBFnMenu)item).getParentId() != null) continue;
                DBFnMenu item1 = (DBFnMenu)this.treeModel.getRoot();
                ((DBFnMenu)item).setParent(item1);
                item1.addChild(item, true);
            }
        }
        for (int i = list.size(); i > 0; --i) {
            if (list.get(i - 1) == null || !(list.get(i - 1) instanceof Hashtable)) continue;
            Hashtable table1 = (Hashtable)list.get(i - 1);
            Iterator ite = table1.keySet().iterator();
            while (ite.hasNext()) {
                Hashtable table2;
                FnMenuModel item1;
                FnMenuModel item = (FnMenuModel)table1.get(ite.next());
                if (i <= 1 || list.get(i - 2) == null || !(list.get(i - 2) instanceof Hashtable) || (item1 = (FnMenuModel)(table2 = (Hashtable)list.get(i - 2)).get(((DBFnMenu)item).getParentId())) == null) continue;
                ((DBFnMenu)item).setParent((DBFnMenu)item1);
                ((DBFnMenu)item1).addChild(item, true);
            }
        }
        XMLConfiguration _xmlConfig = XMLConfiguration.newInstance();
        _xmlConfig.removeAll();
        _xmlConfig.addConfigItem(((DBFnMenu)this.treeModel.getRoot()).toXML());
        return _xmlConfig.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadAllMenuFromDB(Context ctx) {
        HashMap<String, DBFnMenu> map = new HashMap<String, DBFnMenu>();
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_SELECT_ALL);
            this.rs = this.stmt.executeQuery();
            while (this.rs.next()) {
                String s = this.rs.getString("FID");
                DBFnMenu menu = new DBFnMenu();
                menu.setDesc("");
                menu.setIconImage("");
                menu.setId(s);
                if (ctx.getLocale() != null && (ctx.getLocale().getLanguage().equalsIgnoreCase("l2") || ctx.getLocale().getLanguage().equalsIgnoreCase("zh_CN"))) {
                    menu.setName(this.rs.getString("FName_L2"));
                    menu.setDesc(this.rs.getString("FDescription_L2"));
                } else {
                    menu.setName(this.rs.getString("FName_L3"));
                    menu.setDesc(this.rs.getString("FDescription_L3"));
                }
                menu.setLeaf(this.rs.getBoolean("FisLeaf"));
                menu.setNumber(this.rs.getString("FNumber"));
                menu.setLongNumber(this.rs.getString("FLongNumber"));
                menu.setUiClass(this.rs.getString("FUiClassName"));
                menu.setLevel(this.rs.getInt("FLevel"));
                menu.setParentId(this.rs.getString("FParent"));
                menu.setState(this.rs.getString("FUiOprt"));
                if (this.rs.getString("FNumber") != null && this.rs.getString("FNumber").startsWith("BIM")) {
                    menu.setSystem(false);
                } else {
                    menu.setSystem(true);
                }
                menu.setBizUnitPk(menu.isSystem() ? null : this.rs.getString("FSimpleName"));
                menu.setReportPk(menu.isSystem() ? null : this.rs.getString("FUiClassParam"));
                menu.setFunctionId(this.rs.getString("FFunction"));
                menu.setIconImage(this.rs.getString("FImagePath"));
                menu.setType(this.rs.getInt("FMenutype"));
                map.put(menu.getId(), menu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Map map2 = null;
            return map2;
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
        return map;
    }

    protected void _addMenu(Context ctx, DeployedMenuInfo menuInfo) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllMenu(Context ctx, List list) throws BOSException {
        if (list.isEmpty()) {
            return;
        }
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_INSERT_ALL_MENU_ITEMS);
            for (int i = 0; i < list.size(); ++i) {
                DeployedMenuInfo menuInfo = (DeployedMenuInfo)list.get(i);
                this.stmt.setString(1, menuInfo.getUiClassName());
                this.stmt.setString(2, menuInfo.getId());
                if (ctx.getLocale() != null && (ctx.getLocale().getLanguage().equalsIgnoreCase("l2") || ctx.getLocale().getLanguage().equalsIgnoreCase("zh_CN"))) {
                    this.stmt.setString(3, menuInfo.getName());
                    this.stmt.setString(5, menuInfo.getDes());
                    if (menuInfo.getName() != null) {
                        this.stmt.setString(17, STConverter.sc2tc((String)menuInfo.getName()));
                    } else {
                        this.stmt.setString(17, menuInfo.getName());
                    }
                    if (menuInfo.getDes() != null) {
                        this.stmt.setString(18, STConverter.sc2tc((String)menuInfo.getDes()));
                    } else {
                        this.stmt.setString(18, menuInfo.getDes());
                    }
                } else {
                    if (menuInfo.getName() != null) {
                        this.stmt.setString(3, STConverter.tc2sc((String)menuInfo.getName()));
                    } else {
                        this.stmt.setString(3, menuInfo.getName());
                    }
                    if (menuInfo.getDes() != null) {
                        this.stmt.setString(5, STConverter.tc2sc((String)menuInfo.getDes()));
                    } else {
                        this.stmt.setString(5, menuInfo.getDes());
                    }
                    this.stmt.setString(17, menuInfo.getName());
                    this.stmt.setString(18, menuInfo.getDes());
                }
                this.stmt.setString(4, menuInfo.getNumber());
                this.stmt.setInt(6, Integer.parseInt(menuInfo.getLevel()));
                this.stmt.setString(7, menuInfo.getFullNumber());
                this.stmt.setString(8, null);
                this.stmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                this.stmt.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
                this.stmt.setString(11, menuInfo.getParentId());
                this.stmt.setInt(12, menuInfo.isLeaf() ? 1 : 0);
                this.stmt.setString(13, menuInfo.getState());
                this.stmt.setString(14, menuInfo.getUiClassParam());
                this.stmt.setInt(15, menuInfo.isReport() ? 1 : 0);
                this.stmt.setString(16, menuInfo.getBizunitPk());
                this.stmt.setString(19, menuInfo.getFunctionId());
                this.stmt.setString(20, menuInfo.getIconImage());
                this.stmt.setInt(21, menuInfo.getType());
                this.stmt.addBatch();
            }
            this.stmt.executeBatch();
            this.updateCache(ctx);
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle.getLocalizedMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    protected boolean _menuExist(Context ctx, DeployedMenuInfo menuInfo) throws BOSException {
        boolean isExist = false;
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_HAS_SAME_MENU);
            this.stmt.setString(1, menuInfo.getId());
            this.rs = this.stmt.executeQuery();
            if (this.rs.next()) {
                isExist = true;
            }
            return isExist;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return false;
        }
    }

    private void updateCache(Context ctx) throws SQLException {
        try {
            this.stmt = this.conn.prepareStatement(SQL_UPDATE_CACHE);
            this.stmt.setString(1, Long.toString(System.currentTimeMillis()));
            this.stmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void _updataMenu(Context ctx, DeployedMenuInfo menuInfo) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllMenus(Context ctx, List list) {
        if (list.isEmpty()) {
            return;
        }
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_UPDATE_ALL_ITEMS);
            for (int i = 0; i < list.size(); ++i) {
                DeployedMenuInfo menuInfo = (DeployedMenuInfo)list.get(i);
                this.stmt.setString(1, menuInfo.getUiClassName());
                this.stmt.setInt(4, Integer.parseInt(menuInfo.getLevel()));
                this.stmt.setString(5, null);
                this.stmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                this.stmt.setString(7, menuInfo.getParentId());
                this.stmt.setInt(8, menuInfo.isLeaf() ? 1 : 0);
                this.stmt.setString(9, menuInfo.getState());
                this.stmt.setString(10, menuInfo.getUiClassParam());
                this.stmt.setInt(11, menuInfo.isReport() ? 1 : 0);
                this.stmt.setString(12, menuInfo.getBizunitPk());
                this.stmt.setString(13, menuInfo.getNumber());
                this.stmt.setString(14, menuInfo.getFullNumber());
                if (ctx.getLocale() != null && (ctx.getLocale().getLanguage().equalsIgnoreCase("l2") || ctx.getLocale().getLanguage().equalsIgnoreCase("zh_CN"))) {
                    this.stmt.setString(2, menuInfo.getName());
                    this.stmt.setString(3, menuInfo.getDes());
                    if (menuInfo.getName() != null) {
                        this.stmt.setString(15, STConverter.sc2tc((String)menuInfo.getName()));
                    } else {
                        this.stmt.setString(15, menuInfo.getName());
                    }
                    if (menuInfo.getDes() != null) {
                        this.stmt.setString(16, STConverter.sc2tc((String)menuInfo.getDes()));
                    } else {
                        this.stmt.setString(16, menuInfo.getDes());
                    }
                } else {
                    if (menuInfo.getName() != null) {
                        this.stmt.setString(2, STConverter.tc2sc((String)menuInfo.getName()));
                    } else {
                        this.stmt.setString(2, menuInfo.getName());
                    }
                    if (menuInfo.getDes() != null) {
                        this.stmt.setString(3, STConverter.tc2sc((String)menuInfo.getDes()));
                    } else {
                        this.stmt.setString(3, menuInfo.getDes());
                    }
                    this.stmt.setString(15, menuInfo.getName());
                    this.stmt.setString(16, menuInfo.getDes());
                }
                this.stmt.setString(17, menuInfo.getFunctionId());
                this.stmt.setString(18, menuInfo.getIconImage());
                this.stmt.setString(19, menuInfo.getId());
                this.stmt.addBatch();
            }
            this.stmt.executeBatch();
            this.updateCache(ctx);
        }
        catch (Exception sqle) {
            System.out.println(sqle.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    private void load(Context ctx) throws Exception {
        if (this.menuInfo != null) {
            this.menuTreeModel = new FnMenuTree();
            try {
                ((FnMenuTree)this.menuTreeModel).load(this.menuInfo, false);
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
    }

    private void synchronizeMenus(Context ctx) throws Exception {
        FnMenuModel element;
        String id;
        if (this.menuInfo == null) {
            return;
        }
        List models = this.getMenus();
        HashMap<String, FnMenu> xmlMenuMap = new HashMap<String, FnMenu>();
        Iterator ite = models.iterator();
        while (ite.hasNext()) {
            FnMenu menu = (FnMenu)ite.next();
            if (menu == null || menu.getId() == null || menu.getType() != 5) continue;
            xmlMenuMap.put(menu.getId(), menu);
        }
        if (xmlMenuMap == null || xmlMenuMap.keySet().size() == 0) {
            return;
        }
        Map dbMenuMap = this.loadAllMenuFromDB(ctx);
        Set dbSet = dbMenuMap.keySet();
        Set xmlSet = xmlMenuMap.keySet();
        ArrayList<String> deleteList = new ArrayList<String>();
        ArrayList<DeployedMenuInfo> updateList = new ArrayList<DeployedMenuInfo>();
        ArrayList<DeployedMenuInfo> insertList = new ArrayList<DeployedMenuInfo>();
        Iterator ite2 = dbSet.iterator();
        while (ite2.hasNext()) {
            id = ite2.next().toString();
            if (xmlSet.contains(id)) continue;
            deleteList.add(id);
        }
        ite2 = xmlSet.iterator();
        while (ite2.hasNext()) {
            id = ite2.next().toString();
            if (dbSet.contains(id) || !(xmlMenuMap.get(id) instanceof FnMenuModel)) continue;
            element = (FnMenuModel)xmlMenuMap.get(id);
            DeployedMenuInfo menu = this.convertModel(element);
            insertList.add(menu);
        }
        Iterator iter = dbSet.iterator();
        while (iter.hasNext()) {
            DBFnMenu dbMenu;
            DeployedMenuInfo xmlMenu;
            id = iter.next().toString();
            if (id == null || xmlMenuMap.get(id) == null || dbMenuMap.get(id) == null || !(xmlMenuMap.get(id) instanceof FnMenuModel) || !(dbMenuMap.get(id) instanceof DBFnMenu) || !this.needUpdate(xmlMenu = this.convertModel(element = (FnMenuModel)xmlMenuMap.get(id)), dbMenu = (DBFnMenu)dbMenuMap.get(id))) continue;
            updateList.add(xmlMenu);
        }
        this.deleteAll(ctx, deleteList);
        this.updateAllMenus(ctx, updateList);
        this.addAllMenu(ctx, insertList);
    }

    private boolean needUpdate(DeployedMenuInfo xml, DBFnMenu db) {
        String xmlid = xml.getId();
        String dbid = db.getId();
        if (xmlid == null || dbid == null) {
            return false;
        }
        if (!xmlid.equals(dbid)) {
            return true;
        }
        if (xml.getLevel() != null && !xml.getLevel().equals(String.valueOf(db.getLevel()))) {
            return true;
        }
        if (!(this.isEquals(xml.getName(), db.getName()) && this.isEquals(xml.getName(), db.getName()) && this.isEquals(xml.getNumber(), db.getNumber()) && this.isEquals(xml.getFullNumber(), db.getLongNumber()) && this.isEquals(xml.getState(), db.getState()) && this.isEquals(xml.getUiClassName(), db.getUiClass()) && this.isEquals(xml.getParentId(), db.getParentId()) && this.isEquals(xml.getUiClassParam(), db.getParameters()) && this.isEquals(xml.getIconImage(), db.getIconImage()) && this.isEquals(xml.getFunctionId(), db.getFunctionId()) && this.isEquals(xml.getName(), db.getName()) && this.isEquals(xml.getDes(), db.getDesc()))) {
            return true;
        }
        return xml.getType() != db.getType();
    }

    private boolean isEquals(String e1, String e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAll(Context ctx, List list) {
        if (list.isEmpty()) {
            return;
        }
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_DELETE_MENU_ITEM);
            for (int i = 0; i < list.size(); ++i) {
                String s = list.get(i).toString();
                this.stmt.setString(1, s);
                this.stmt.addBatch();
            }
            this.stmt.executeBatch();
            this.updateCache(ctx);
        }
        catch (SQLException e) {
            logger.error((Object)e.getStackTrace());
        }
        catch (SQLDataException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    void createParentMenu(Context ctx, FnMenuModel parentMenuModel) throws Exception {
        if (parentMenuModel == null || parentMenuModel.getLevel() == 0) {
            return;
        }
        this.createParentMenu(ctx, parentMenuModel.getParentMenu());
        DeployedMenuInfo menu = this.convertModel(parentMenuModel);
        boolean bExsit = this.menuExist(ctx, menu);
        if (bExsit) {
            this.updataMenu(ctx, menu);
        } else {
            this.addMenu(ctx, menu);
        }
    }

    private DeployedMenuInfo convertModel(FnMenuModel menuModel) {
        DeployedMenuInfo rt = new DeployedMenuInfo();
        rt.setId(menuModel.getId());
        rt.setLevel(String.valueOf(menuModel.getLevel()));
        rt.setLeaf(menuModel.isLeaf());
        rt.setName(menuModel.getName());
        rt.setNumber(menuModel.getNumber());
        rt.setFullNumber(menuModel.getLongNumber());
        rt.setState(menuModel.getState());
        rt.setUiClassName(menuModel.getUiClass());
        rt.setParentId(menuModel.getParentMenu() == null ? null : menuModel.getParentMenu().getId());
        rt.setReport(menuModel.getReportPk() != null);
        rt.setUiClassParam(menuModel.getParameters());
        rt.setBizunitPk(menuModel.getBizUnitPk());
        rt.setDes(menuModel.getDesc());
        rt.setFunctionId(menuModel.getFunctionId());
        rt.setIconImage(menuModel.getIconImage());
        rt.setType(menuModel.getType());
        return rt;
    }

    private List getMenus() throws Exception {
        if (this.menuTreeModel != null) {
            return this.menuTreeModel.getAllChildren();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryALlMenuRecords(Context ctx, Hashtable tab) throws SQLException {
        try {
            int i;
            ArrayList<Object> menulist = new ArrayList<Object>();
            ArrayList<TableHelper> list = new ArrayList<TableHelper>();
            Hashtable[] table = new Hashtable[10];
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.prepareStatement(SQL_SELECT_ALL);
            this.rs = this.stmt.executeQuery();
            int count = 0;
            while (this.rs.next()) {
                ++count;
                String s = this.rs.getString("FID");
                System.out.println(s);
                tab.put(s, s);
                DBFnMenu menu = new DBFnMenu();
                menu.setDesc("");
                menu.setIconImage("");
                menu.setId(s);
                if (ctx.getLocale() != null && (ctx.getLocale().getLanguage().equalsIgnoreCase("l2") || ctx.getLocale().getLanguage().equalsIgnoreCase("zh_CN"))) {
                    menu.setName(this.rs.getString("FName_L2"));
                    menu.setDesc(this.rs.getString("FDescription_L2"));
                } else {
                    menu.setName(this.rs.getString("FName_L3"));
                    menu.setDesc(this.rs.getString("FDescription_L3"));
                }
                menu.setLeaf(this.rs.getBoolean("FisLeaf"));
                menu.setNumber(this.rs.getString("FNumber"));
                menu.setLongNumber(this.rs.getString("FLongNumber"));
                menu.setUiClass(this.rs.getString("FUiClassName"));
                menu.setLevel(this.rs.getInt("FLevel"));
                menu.setParentId(this.rs.getString("FParent"));
                menu.setState(this.rs.getString("FUiOprt"));
                if (this.rs.getString("FNumber") != null && this.rs.getString("FNumber").startsWith("BIM")) {
                    menu.setSystem(false);
                } else {
                    menu.setSystem(true);
                }
                menu.setBizUnitPk(menu.isSystem() ? null : this.rs.getString("FSimpleName"));
                menu.setReportPk(menu.isSystem() ? null : this.rs.getString("FUiClassParam"));
                menu.setFunctionId(this.rs.getString("FFunction"));
                menu.setIconImage(this.rs.getString("FImagePath"));
                menu.setType(this.rs.getInt("FMenutype"));
                int i2 = menu.getLevel();
                if (table[i2] == null) {
                    table[i2] = new Hashtable();
                    table[i2].put(menu.getId(), menu);
                    TableHelper h = new TableHelper(i2, table[i2]);
                    list.add(h);
                    continue;
                }
                table[i2].put(menu.getId(), menu);
            }
            TableHelper[] helper = new TableHelper[list.size()];
            for (i = 0; i < list.size(); ++i) {
                TableHelper hep = (TableHelper)list.get(i);
                if (hep.getId() - 1 >= list.size()) continue;
                helper[hep.getId() - 1] = hep;
            }
            for (i = 0; i < helper.length; ++i) {
                if (helper[i] == null) continue;
                Object obj = helper[i].getObject();
                menulist.add(obj);
            }
            ArrayList<Object> arrayList = menulist;
            return arrayList;
        }
        catch (SQLDataException e) {
            e.printStackTrace();
            List list = null;
            return list;
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    protected boolean _synchronizeTables(Context ctx, IMetaDataPK[] pks) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        ArrayList<DataTableInfo> tables = new ArrayList<DataTableInfo>();
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            DataTableInfo tableInfo = loader.getDataTable(pks[i]);
            if (tableInfo == null || tableInfo.getColumns() == null || tableInfo.getColumns().size() == 0) continue;
            tables.add(tableInfo);
        }
        AbstractTableInfo[] tableInfos = tables.toArray(new AbstractTableInfo[tables.size()]);
        SolutionInfo solutionInfo = loader.getSolution();
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            DBUpdateList updateList = KDBUpdateUtils.generateDBUpdateList((Connection)cn, (SolutionInfo)solutionInfo, (AbstractTableInfo[])tableInfos);
            KDBUpdateUtils.updateDatabase((Connection)cn, (DBUpdateList)updateList);
        }
        catch (Exception ex) {
            throw new BOSException("synchronize tables error!", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return false;
    }
}

