/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uict.mainmenu;

import com.kingdee.eas.base.uict.mainmenu.ConfigurationException;
import com.kingdee.eas.base.uict.mainmenu.ConfigurationItem;
import com.kingdee.eas.base.uict.mainmenu.XMLConfigurable;
import java.util.ArrayList;
import java.util.List;

public class SampleConfigurationObject
implements XMLConfigurable {
    protected ConfigurationItem configItem;
    protected SampleConfigurationObject parent;

    public SampleConfigurationObject(String name) {
        this.configItem = new ConfigurationItem(name);
    }

    public SampleConfigurationObject(ConfigurationItem item) {
        this.configItem = item;
    }

    public ConfigurationItem toXML() throws ConfigurationException {
        return this.configItem;
    }

    public void fromXML(ConfigurationItem item) throws ConfigurationException {
        this.configItem = item;
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.configItem.removeProperty(key);
        } else {
            this.configItem.setProperty(key, value);
        }
    }

    public String getProperty(String key, String defalueValue) {
        return this.configItem.getProperty(key, defalueValue);
    }

    public String getProperty(String key) {
        return this.configItem.getProperty(key);
    }

    public String getConfigItemName() {
        return this.configItem.getName();
    }

    public void addChild(SampleConfigurationObject child) throws ConfigurationException {
        ConfigurationItem childItem = child.toXML();
        this.configItem.addChild(childItem);
        child.parent = this;
    }

    public void removeChild(SampleConfigurationObject child) throws ConfigurationException {
        ConfigurationItem childItem = child.toXML();
        this.configItem.removeChild(childItem);
        child.parent = null;
    }

    public List getChildern(String name) {
        List configItems = this.configItem.getChildren(name);
        ArrayList<SampleConfigurationObject> objects = new ArrayList<SampleConfigurationObject>();
        for (int i = 0; i < configItems.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)configItems.get(i);
            SampleConfigurationObject obj = new SampleConfigurationObject(item);
            obj.parent = this;
            objects.add(obj);
        }
        return objects;
    }

    public SampleConfigurationObject getChild(String name) {
        ConfigurationItem item = this.configItem.getChild(name);
        if (item == null) {
            return null;
        }
        SampleConfigurationObject obj = new SampleConfigurationObject(item);
        obj.parent = this;
        return obj;
    }

    public List getAllChildern() {
        List configItems = this.configItem.getAllChildren();
        ArrayList<SampleConfigurationObject> objects = new ArrayList<SampleConfigurationObject>();
        for (int i = 0; i < configItems.size(); ++i) {
            ConfigurationItem item = (ConfigurationItem)configItems.get(i);
            SampleConfigurationObject obj = new SampleConfigurationObject(item);
            obj.parent = this;
            objects.add(obj);
        }
        return objects;
    }

    public void setParent(SampleConfigurationObject parent) {
        this.parent = parent;
    }

    public SampleConfigurationObject getParent() {
        return this.parent;
    }

    public void dipose() {
        this.detach();
        this.configItem = null;
    }

    public void detach() {
        this.parent = null;
    }

    public void copy(SampleConfigurationObject src) {
        if (src == null) {
            return;
        }
        this.configItem.copy(src.configItem);
    }
}

