/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryServiceManager;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.IServerLoginContextFilter;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.management.SimpleSolution;
import com.kingdee.bos.metadata.access.management.SolutionSelect;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.log.ILoginAndLogout;
import com.kingdee.eas.base.log.LoginAndLogoutFactory;
import com.kingdee.eas.base.myeas.IMessageOption;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MessageOptionFactory;
import com.kingdee.eas.base.myeas.MessageOptionInfo;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.IMainFrameServiceFacade;
import com.kingdee.eas.base.uiframe.LoginContextConstant;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.util.PropertiesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LoginContextFilterImpl
implements IServerLoginContextFilter {
    private static final String CONTEXT_ID = "CONTEXT_ID";
    protected static final Logger logger = Logger.getLogger(LoginContextFilterImpl.class);

    public void doFilter(Context ctx) throws BOSLoginException {
        boolean onOff = Boolean.valueOf((String)ctx.get((Object)"SwitchToNewLoginFlow"));
        if (onOff) {
            this.setTimeZone(ctx);
            try {
                this.setOrgUnit(ctx);
            }
            catch (Exception e) {
                throw new BOSLoginException((Throwable)e);
            }
            this.setLocalesToEnv(ctx);
            this.setClientHostInfo(ctx);
            this.setSameUserList(ctx);
            this.setMyEasSetting(ctx);
            this.setQueryServiceURL(ctx);
            try {
                this.setIsDemoVervison(ctx);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (LicenseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.saveLoginLog(ctx);
            this.setMenuCache(ctx);
            this.setOther(ctx);
        }
        this.saveUMRegistryInfo(ctx);
    }

    private Context clone(Context ctx) {
        Context userContext = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
        userContext.setUserName(ctx.getUserName());
        userContext.put((Object)CONTEXT_ID, (Object)ctx.getContextID());
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        userContext.put((Object)"UserInfo", (Object)userInfo);
        userContext.put((Object)"ClientIP", ctx.get((Object)"ClientIP"));
        userContext.put((Object)"ClientName", ctx.get((Object)"ClientName"));
        userContext.put((Object)OrgType.ControlUnit, ctx.get((Object)OrgType.ControlUnit));
        return userContext;
    }

    private void setIsDemoVervison(Context ctx) throws BOSException, LicenseException {
        ILicenseSrvAgent agent = (ILicenseSrvAgent)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.eas.base.license.agent.LicenseSrvAgent");
        ctx.put(LoginContextConstant.IS_DEMO_VERSION, (Object)new Boolean(agent.isDemoVersion()));
    }

    private void saveLoginLog(Context ctx) {
        try {
            ILoginAndLogout iLoginAndLogout = LoginAndLogoutFactory.getLocalInstance((Context)ctx);
            iLoginAndLogout.UserLogin();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setMenuCache(Context ctx) {
        String fullName = PropertiesUtil.getDefaultProFullName((String)"jnlp.properties");
        Properties prop = PropertiesUtil.getProperties((String)fullName);
        String menuCacheTime = prop.getProperty("menuCacheTime");
        if (menuCacheTime != null) {
            ctx.put((Object)"menuCache", (Object)menuCacheTime);
        }
    }

    private void setOther(Context ctx) {
        try {
            IMessageOption imp = MessageOptionFactory.getLocalInstance((Context)ctx);
            MessageOptionInfo info = null;
            info = (MessageOptionInfo)imp.getUserOptionInfo(ctx.getCaller().toString());
            if (info == null) {
                info = (MessageOptionInfo)imp.getUserOptionInfo("00000000-0000-0000-0000-00000000000013B7DE7F");
            }
            if (info != null) {
                ctx.put((Object)"messageRefreshTime", (Object)info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setQueryServiceURL(Context ctx) {
        try {
            IQueryServiceManager queryServiceMgr = (IQueryServiceManager)BOSObjectFactory.createBOSObject((Context)ctx, (String)"com.kingdee.bos.dao.query.QueryServiceManager");
            String url = queryServiceMgr.getQueryServiceURL();
            ctx.put((Object)"QueryServiceURL", (Object)url);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveUMRegistryInfo(Context ctx) {
        UMRegistryInfo reg = this.createUMRegistryInfo(ctx);
        if (reg.getId() == null || reg.getId().trim().length() == 0) {
            StringBuffer detail = new StringBuffer();
            detail.append("User monitor register err info" + UIFrameUtils.getRes("res_1") + "session ID is empty");
            detail.append(System.getProperty("line.separator"));
            detail.append("UMRegistry detail info" + UIFrameUtils.getRes("res_1"));
            detail.append(reg.toString());
            logger.error((Object)detail.toString());
        } else {
            try {
                IUserMonitor iUserMonitor = UserMonitorFactory.getLocalInstance((Context)ctx);
                iUserMonitor.addnew(reg);
            }
            catch (Exception e) {
                logger.info((Object)"LoginContextFilterImpl IP is NULL");
            }
        }
    }

    private UMRegistryInfo createUMRegistryInfo(Context ctx) {
        CtrlUnitInfo cuInfo;
        UMRegistryInfo reg = new UMRegistryInfo();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String id = ctx.getContextID();
        if (ctx.get((Object)CONTEXT_ID) != null) {
            id = (String)ctx.get((Object)CONTEXT_ID);
        }
        reg.setId(id);
        String clientIP = (String)ctx.get((Object)"ClientIP");
        String clientName = (String)ctx.get((Object)"ClientName");
        if ((clientIP == null || clientIP.trim().isEmpty()) && ctx.getClientHostIP() != null) {
            clientIP = ctx.getClientHostIP();
            ctx.put((Object)"ClientIP", (Object)ctx.getClientHostIP());
        }
        if ((clientName == null || clientName.trim().isEmpty()) && ctx.getClientHostName() != null) {
            clientName = ctx.getClientHostName();
            ctx.put((Object)"ClientName", (Object)ctx.getClientHostName());
        }
        reg.setClientIPAddress(clientIP);
        reg.setUserId(userInfo.getId().toString());
        reg.setUserName(ctx.getUserName());
        reg.setUserRealName(userInfo.getName());
        reg.setUserType(userInfo.getType().getValue());
        reg.setDataCenterName(ctx.getAIS());
        if (userInfo.getCU() != null) {
            reg.setUserCUName(userInfo.getCU().getName());
        }
        if ((cuInfo = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)) != null) {
            reg.setCurrentMainBizUnitName(cuInfo.getName());
        }
        if (cuInfo != null) {
            reg.setCurrentCtrlUnitId(cuInfo.getId().toString());
        }
        return reg;
    }

    private void setMyEasSetting(Context ctx) {
        try {
            IMyEasInvokeEntry iMyeasInvoke = MyEasInvokeEntryFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            String userID = userInfo.getId().toString();
            HashMap map = iMyeasInvoke.getMyEasSetting(userID);
            ctx.put((Object)"MyEasSettings", (Object)map);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setSameUserList(Context ctx) {
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getLocalInstance((Context)ctx);
            List userList = iUserMonitor.findUsers(ctx.getAIS(), ctx.getUserName());
            if (userList != null && !userList.isEmpty()) {
                ctx.put((Object)"SameUserList", (Object)userList);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setLocalesToEnv(Context ctx) {
        SimpleSolution solution = null;
        try {
            SolutionSelect select = new SolutionSelect();
            select.languageSelect().select(new String[]{"postfix", "localeString"});
            solution = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        catch (Exception e) {
            logger.error((Object)"load solution error.", (Throwable)e);
        }
        ctx.put((Object)"locals", solution);
    }

    private void setClientHostInfo(Context ctx) {
        String clientIP = (String)ctx.get((Object)"ClientIP");
        String clientName = (String)ctx.get((Object)"ClientName");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ClientIP", clientIP);
        map.put("ClientName", clientName);
        try {
            IContextManager contextManager = ContextManagerFactory.getLocalInstance((Context)ctx);
            contextManager.setContext(map);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setTimeZone(Context ctx) {
        try {
            IMainFrameServiceFacade iMainFrameServiceFacade = MainFrameServiceFacadeFactory.getLocalInstance(ctx);
            ctx.put((Object)"ServerTimeZone", (Object)iMainFrameServiceFacade.getServerTimeZone());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setOrgUnit(Context ctx) throws BOSException, EASBizException {
        IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx);
        String ouId = null;
        ouId = (String)ctx.get((Object)"defOrgID");
        if (ouId == null || "".equals(ouId)) {
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            ouId = userInfo.getDefOrgUnit().getId().toString();
        }
        HashMap map = iSwitch.getOrgs(ouId);
        ctx.put((Object)"OrgUnits", (Object)map);
    }

    private void putAll(Context ctx, HashMap map) {
        for (Map.Entry entry : map.entrySet()) {
            ctx.put(entry.getKey(), entry.getValue());
        }
    }

    class FilterThread
    extends Thread {
        private Context ctx = null;

        public FilterThread(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            LoginContextFilterImpl.this.saveUMRegistryInfo(this.ctx);
        }
    }
}

