/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class LoginParamCacheServerUtil {
    private static final Logger logger = Logger.getLogger(LoginParamCacheServerUtil.class);
    private static final String[] deployFileNames = new String[]{"SSLConfig.properties", "OrgConfig.xml", "PermParam.properties"};
    private static final String[] easHomeFileNames = new String[]{"datacenters.xml"};
    private static final String LoginParamLastUpdateTime = "LoginParamLastUpdateTime.txt";

    public static long getLastUpdateTime() {
        long lastUpdateConfigFileTime;
        long paramLastUpdateTime = LoginParamCacheServerUtil.getParamLastUpdateTime();
        if (paramLastUpdateTime > (lastUpdateConfigFileTime = LoginParamCacheServerUtil.getLastUpdateConfigFileTime())) {
            return paramLastUpdateTime;
        }
        return lastUpdateConfigFileTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getParamLastUpdateTime() {
        File file = new File(LoginParamCacheServerUtil.getEasHomeFullFileName(LoginParamLastUpdateTime));
        if (!file.exists()) {
            return LoginParamCacheServerUtil.updateLastUpdateTime();
        }
        FileReader reader = null;
        try {
            long time;
            reader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(reader);
            String line = bufReader.readLine().trim();
            long l = time = Long.parseLong(line);
            return l;
        }
        catch (Exception e) {
            logger.error((Object)"getLastUpdateTime:", (Throwable)e);
            long l = LoginParamCacheServerUtil.updateLastUpdateTime();
            return l;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)"reader.close:", (Throwable)e);
                }
            }
        }
    }

    private static String getEasHomeFullFileName(String fileName) {
        return System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "properties" + File.separator + fileName;
    }

    private static String getDeployFullFileName(String fileName) {
        return new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append(fileName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long updateLastUpdateTime() {
        File file = new File(LoginParamCacheServerUtil.getEasHomeFullFileName(LoginParamLastUpdateTime));
        FileWriter writer = null;
        long updateTime = System.currentTimeMillis();
        try {
            writer = new FileWriter(file);
            writer.write(String.valueOf(updateTime));
        }
        catch (IOException e) {
            logger.error((Object)"updateLastUpdateTime:", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close:", (Throwable)e);
                }
            }
        }
        return updateTime;
    }

    private static long getLastUpdateConfigFileTime() {
        long lastUpdateTime = 0L;
        List paths = LoginParamCacheServerUtil.getAllListenedFilePaths();
        int size = paths.size();
        for (int i = 0; i < size; ++i) {
            long lastModified;
            String path = paths.get(i).toString();
            File file = new File(path);
            if (!file.exists() || (lastModified = file.lastModified()) <= lastUpdateTime) continue;
            lastUpdateTime = lastModified;
        }
        return lastUpdateTime;
    }

    private static List getAllListenedFilePaths() {
        int i;
        ArrayList<String> paths = new ArrayList<String>();
        for (i = 0; i < deployFileNames.length; ++i) {
            paths.add(LoginParamCacheServerUtil.getDeployFullFileName(deployFileNames[i]));
        }
        for (i = 0; i < easHomeFileNames.length; ++i) {
            paths.add(LoginParamCacheServerUtil.getEasHomeFullFileName(easHomeFileNames[i]));
        }
        paths.add(LoginParamCacheServerUtil.getConfigMetadataJarPath());
        return paths;
    }

    private static String getConfigMetadataJarPath() {
        return ConfigureResourceLoader.getConfigureJar((Context)ContextUtils.getContextFromSessionNoException());
    }
}

