/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.uiframe.SSOToYZJException;
import com.kingdee.eas.base.uiframe.app.AbstractSSOToYZJFacadeControllerBean;
import com.kingdee.eas.base.uiframe.ssoyzj.SSOToYZJConfigInfo;
import com.kingdee.eas.base.uiframe.ssoyzj.SSOToYZJService;
import com.kingdee.eas.base.uiframe.ssoyzj.helper.SSOToYZJHelper;
import com.kingdee.eas.base.uiframe.utils.XunTongHelper;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSOToYZJFacadeControllerBean
extends AbstractSSOToYZJFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.SSOToYZJFacadeControllerBean");
    private static final String res = "com.kingdee.eas.base.uiframe.UIFrameResource";
    private static Map<String, Object> urlMap = new HashMap<String, Object>();
    private static Map<String, Object> expireMap = new HashMap<String, Object>();

    @Override
    protected Map _getSSOUrl(Context ctx, String userId) throws BOSException, EASBizException {
        String cacheKey;
        Locale l = ContextUtils.getLocaleFromEnv();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (userId == null) {
            result.put("success", false);
            result.put("errorMsg", EASCommonResource.getString((String)res, (String)"USER_IS_NULL", (Locale)l));
            return result;
        }
        if (SSOToYZJHelper.checkSecretChange(ctx)) {
            this.clearCache();
        }
        String loginUrl = urlMap.get(cacheKey = ctx.getAIS() + userId) == null ? null : urlMap.get(cacheKey).toString();
        boolean flag = true;
        if (StringUtils.isEmpty((String)loginUrl)) {
            flag = false;
        } else {
            long expireTime = (Long)expireMap.get(cacheKey);
            long nowTime = System.currentTimeMillis();
            if (nowTime > expireTime) {
                flag = false;
            }
        }
        if (flag) {
            result.put("success", true);
            result.put("ssoLoginUrl", loginUrl);
            return result;
        }
        try {
            SSOToYZJService service = new SSOToYZJService(ctx);
            String eid = this.getEid(ctx);
            if (StringUtils.isEmpty((String)eid)) {
                result.put("success", false);
                result.put("errorMsg", EASCommonResource.getString((String)res, (String)"EID_IS_NULL", (Locale)l));
                return result;
            }
            String openId = XunTongHelper.getOpenIdByUserId(ctx, userId);
            if (StringUtils.isEmpty((String)openId)) {
                result.put("success", false);
                result.put("errorMsg", EASCommonResource.getString((String)res, (String)"USER_IS_NOTBIND", (Locale)l));
                return result;
            }
            JSONObject acqCode = service.getAcqCode(eid, openId);
            logger.info((Object)acqCode.toJSONString());
            if (acqCode.getInteger("errorCode") != 100) {
                result.put("success", false);
                result.put("errorMsg", acqCode.getString("error"));
                return result;
            }
            long codeExpireTime = System.currentTimeMillis() + (long)(acqCode.getIntValue("expireTime") * 1000);
            String code = acqCode.getJSONObject("data").getString("code");
            JSONObject acqssoInfo = service.getAcqssoInfo(eid, openId, code);
            logger.info((Object)acqssoInfo.toJSONString());
            if (acqssoInfo.getInteger("errorCode") != 100) {
                result.put("success", false);
                result.put("errorMsg", acqCode.getString("error"));
                return result;
            }
            JSONObject acqssoInfoData = acqssoInfo.getJSONObject("data");
            JSONObject webLoginToken = service.getWebLoginToken(acqssoInfoData.getString("oauth_token"), acqssoInfoData.getString("oauth_token_secret"));
            logger.info((Object)webLoginToken.toJSONString());
            if (!webLoginToken.getBooleanValue("success")) {
                result.put("success", false);
                result.put("errorMsg", webLoginToken.getString("error"));
                return result;
            }
            SSOToYZJConfigInfo config = service.getConfig();
            String ssoLoginUrl = config.getSsoLoginUrl() + "?lgtk=" + webLoginToken.getString("lgtk") + "&logintype=0&scode=" + code + "&toNetworkId=" + acqssoInfoData.get((Object)"wbNetworkId").toString() + "&to=" + config.getRedirect();
            result.put("success", true);
            result.put("ssoLoginUrl", ssoLoginUrl);
            urlMap.put(cacheKey, ssoLoginUrl);
            expireMap.put(cacheKey, codeExpireTime);
            return result;
        }
        catch (EASBizException e) {
            SSOToYZJException err = (SSOToYZJException)e;
            result.put("success", false);
            result.put("errorMsg", err.getMessage());
            return result;
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put("success", false);
            result.put("errorMsg", EASCommonResource.getString((String)res, (String)"GET_LOGIN_ERROR", (Locale)l));
            return result;
        }
    }

    private String getEid(Context ctx) {
        return EasXtSyncUtil.getInstance((Context)ctx).getEid();
    }

    private void clearCache() {
        urlMap.clear();
        expireMap.clear();
    }
}

