/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.eas.base.uiframe.IValidateCode;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;

public class ValidateCode
extends ORMObject
implements IValidateCode {
    private static int width = 67;
    private static int height = 28;
    private static int codeCount = 4;
    private static int xx = 14;
    private static int tt = 5;
    private static int fontHeight = 20;
    private static int codeY = 20;
    private static char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final String VALIDATECODE_CONFIGITEM = "ValidateCodeParam";
    private static final String ISENABLEVALIDATECODE = "isEnableValidateCode";
    private static ConfigurationItem configItem = null;

    private static ConfigurationItem getConfigItem() {
        if (configItem == null && (configItem = PortalConfig.getConfigurationItem((String)VALIDATECODE_CONFIGITEM)) == null) {
            configItem = ValidateCode.createValidateCodeParamConfig();
        }
        return configItem;
    }

    private static ConfigurationItem createValidateCodeParamConfig() {
        ConfigurationItem configItem = new ConfigurationItem(VALIDATECODE_CONFIGITEM);
        configItem.setProperty(ISENABLEVALIDATECODE, "false");
        XMLConfiguration config = PortalConfig.getConfiguration();
        config.addConfigItem(configItem);
        config.store();
        return configItem;
    }

    @Override
    public byte[] generatorValidateCode() throws Exception {
        int y;
        int x;
        int i;
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics gd = buffImg.getGraphics();
        Random random = new Random();
        gd.setColor(new Color(234, 234, 234));
        gd.fillRect(0, 0, width, height);
        Font font = new Font("Microsoft YaHei", 1, fontHeight);
        gd.setFont(font);
        gd.setColor(this.getRandColor(140, 255));
        for (i = 0; i < 5; ++i) {
            x = random.nextInt(width);
            y = random.nextInt(height);
            int xl = random.nextInt(width);
            int yl = random.nextInt(height);
            gd.drawLine(x, y, xl, yl);
        }
        for (i = 0; i < 30; ++i) {
            x = random.nextInt(width);
            y = random.nextInt(height);
            gd.drawLine(x, y, x, y);
        }
        StringBuffer randomCode = new StringBuffer();
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i2 = 0; i2 < codeCount; ++i2) {
            String code = String.valueOf(codeSequence[random.nextInt(36)]);
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
            gd.setColor(new Color(46, 167, 234));
            gd.drawString(code, i2 * xx + tt, codeY);
            randomCode.append(code);
        }
        RPCServerSession session = RPCServerSession.getCurrentSession();
        session.putContext((Object)"easguiValidataCode", (Object)randomCode.toString());
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)buffImg, "jpeg", tmp);
        return tmp.toByteArray();
    }

    private Color getRandColor(int lower, int upper) {
        Random random = new Random();
        if (upper > 255) {
            upper = 255;
        }
        if (upper < 1) {
            upper = 1;
        }
        if (lower < 1) {
            lower = 1;
        }
        if (lower > 255) {
            lower = 255;
        }
        int r = lower + random.nextInt(upper - lower);
        int g = lower + random.nextInt(upper - lower);
        int b = lower + random.nextInt(upper - lower);
        return new Color(r, g, b);
    }

    @Override
    public boolean checkValidateCode(String code) throws Exception {
        RPCServerSession session = RPCServerSession.getCurrentSession();
        String easguiValidataCode = (String)session.getContext((Object)"easguiValidataCode");
        if (easguiValidataCode != null && easguiValidataCode.equalsIgnoreCase(code)) {
            session.putContext((Object)"easguiValidataCode", (Object)"");
            return true;
        }
        return false;
    }

    @Override
    public boolean checkValidateCodeOnly(String code) throws Exception {
        RPCServerSession session = RPCServerSession.getCurrentSession();
        String easguiValidataCode = (String)session.getContext((Object)"easguiValidataCode");
        return easguiValidataCode != null && easguiValidataCode.equalsIgnoreCase(code);
    }

    @Override
    public int getErrorCountForShowValidateCode() {
        boolean isEnableValidateCode = false;
        int errorCount = -1;
        Properties properties = null;
        try {
            properties = GlobleLoginConfigFactory.getLocalInstance().getBizConfig();
            if (properties != null) {
                String authType = properties.getProperty("authType");
                if (!StringUtils.isEmpty((String)authType)) {
                    if ("1".equals(authType)) {
                        isEnableValidateCode = true;
                        String errNum = properties.getProperty("errNum");
                        if (!StringUtils.isEmpty((String)errNum)) {
                            errorCount = Integer.parseInt(errNum);
                            if (errorCount == -1) {
                                return 0;
                            }
                            return errorCount;
                        }
                    }
                } else {
                    isEnableValidateCode = ValidateCode.isEnableValidateCode();
                }
            } else {
                isEnableValidateCode = ValidateCode.isEnableValidateCode();
            }
            if (isEnableValidateCode) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return errorCount;
        }
    }

    public static final boolean isEnableValidateCode() {
        String isEnableValidateCode = "false";
        isEnableValidateCode = ValidateCode.getConfigItem().getProperty(ISENABLEVALIDATECODE);
        return Boolean.valueOf(isEnableValidateCode);
    }
}

