/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.globlelogin;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.uiframe.GlobleLoginException;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigInfo;
import com.kingdee.eas.base.uiframe.globlelogin.IGlobleLoginConfigService;
import com.kingdee.eas.base.uiframe.globlelogin.ILoginConfigCache;
import com.kingdee.eas.base.uiframe.globlelogin.LoginConfigCache;
import com.kingdee.eas.base.uiframe.globlelogin.util.SyncClusterFileUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.web.validatecode.ValidateCodeParamUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobleLoginConfigService
extends AbstractBOSObject
implements IGlobleLoginConfigService {
    private static Logger logger = LoggerFactory.getLogger(GlobleLoginConfigService.class);
    public static final String YZJ = "KingdeeCloud";
    public static final String EAS = "BaseDB";
    public static final String QRCODE = "QrCodeToken";
    public static final int NONE = 0;
    public static final int VALIDATECODE = 1;
    public static final int SMSVALIDATECODE = 2;
    public static final int ERRNUM = -1;
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.properties.dir";
    private static final String QRCODETOKEN_PROP_NAME = "QrCodeToken.properties";
    private static final String GLOBLE_LOGIN_PROP_NAME = "GlobleLogin.properties";
    private static final String AUTH_URL = "http://do.yunzhijia.com/openauth2/api/appAuth2";
    private static Properties props = null;

    public GlobleLoginConfigService() throws EASBizException, BOSException {
    }

    public GlobleLoginConfigService(Context ctx) throws EASBizException, BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + GLOBLE_LOGIN_PROP_NAME;
        FileInputStream fis = null;
        try {
            File file = new File(configFile);
            if (!file.exists()) {
                return;
            }
            props = new Properties();
            fis = new FileInputStream(file);
            props.load(fis);
            if (props.getProperty("authType") == null) {
                GlobleLoginConfigService.initCode(configFile);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6GlobleLogin.properties\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void initCode(String configFile) {
        try {
            boolean enableValidateCode = ValidateCodeParamUtil.isEnableValidateCode();
            PropertiesConfiguration config = new PropertiesConfiguration(configFile);
            if (enableValidateCode) {
                config.setProperty("authType", (Object)1);
                config.setProperty("codeVerifyType", (Object)-1);
                config.save();
                props.setProperty("authType", "1");
                props.setProperty("codeVerifyType", "-1");
            } else {
                config.setProperty("authType", (Object)0);
                config.save();
                props.setProperty("authType", "0");
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Properties getBizConfig() {
        if (props == null) {
            GlobleLoginConfigService.init();
        }
        return props;
    }

    @Override
    public GlobleLoginConfigInfo getGlobleConfig(Context ctx) throws BOSException, EASBizException {
        if (props == null) {
            GlobleLoginConfigService.init();
        }
        if (props == null) {
            String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + QRCODETOKEN_PROP_NAME;
            FileInputStream fis = null;
            try {
                File file = new File(configFile);
                if (!file.exists()) {
                    throw new BOSException("qrcode\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                this.copyFile(file);
                Properties pro = new Properties();
                fis = new FileInputStream(file);
                pro.load(fis);
                boolean enableValidateCode = ValidateCodeParamUtil.isEnableValidateCode();
                if (enableValidateCode) {
                    pro.setProperty("authType", "1");
                    pro.setProperty("codeVerifyType", "-1");
                } else {
                    pro.setProperty("authType", "0");
                }
                GlobleLoginConfigInfo info = this.propsTransInfo(ctx, pro);
                this.saveConfig(null, info);
                GlobleLoginConfigInfo globleLoginConfigInfo = info;
                return globleLoginConfigInfo;
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6qrcode\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!");
                throw new BOSException((Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        GlobleLoginConfigInfo propsTransInfo = this.propsTransInfo(ctx, props);
        if (propsTransInfo.isSave()) {
            this.saveConfig(null, propsTransInfo);
        }
        return propsTransInfo;
    }

    @Override
    public boolean saveConfig(Context ctx, GlobleLoginConfigInfo info) throws BOSException, EASBizException {
        this.verify(info);
        String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + GLOBLE_LOGIN_PROP_NAME;
        File file = new File(configFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25!");
                throw new BOSException((Throwable)e);
            }
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configFile);
            String type = info.getDefaultLogin();
            config.setProperty("eas.defaultLoginType", (Object)type);
            if (QRCODE.equals(type)) {
                config.setProperty("portal.isqrcodedefault", (Object)true);
            } else {
                config.setProperty("portal.isqrcodedefault", (Object)false);
            }
            config.setProperty("portal.enableqrcode", (Object)info.isPortalEnableQrcode());
            config.setProperty("app.id", (Object)info.getAppId());
            if (!StringUtils.isEmpty((String)info.getSecret())) {
                config.setProperty("app.secret", (Object)info.getSecret());
            }
            config.setProperty("app.callback.url", (Object)info.getCallBackUrl());
            config.setProperty("app.dd.secret", (Object)info.getDd_secret());
            config.setProperty("app.dd.id", (Object)info.getDd_appId());
            config.setProperty("app.dd.token.url", (Object)info.getDd_tokenUrl());
            config.setProperty("app.tickttoken.url", (Object)info.getOpenIdUrl());
            config.setProperty("app.auth.url", (Object)info.getAuthURL());
            config.setProperty("app.logincode.url", (Object)info.getQrcodeUrl());
            config.setProperty("authType", (Object)info.getAuthType());
            if (info.getAuthType() == 1 || info.getAuthType() == 2) {
                config.setProperty("errNum", (Object)info.getErrNum());
            }
            config.setProperty("privacyStatement", (Object)info.getPrivacyStatement());
            config.save();
            this.clearBizCache();
            this.syncConfig(ctx, info);
        }
        catch (ConfigurationException e) {
            logger.error("\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            throw new BOSException((Throwable)e);
        }
        GlobleLoginConfigService.init();
        return true;
    }

    @Override
    public boolean clearCache() throws BOSException {
        props = null;
        return true;
    }

    public BOSObjectType getType() {
        return null;
    }

    private GlobleLoginConfigInfo propsTransInfo(Context ctx, Properties pro) {
        GlobleLoginConfigInfo info = new GlobleLoginConfigInfo();
        info.setAppId(pro.getProperty("app.id"));
        info.setSecret(pro.getProperty("app.secret"));
        info.setCallBackUrl(pro.getProperty("app.callback.url"));
        info.setDd_appId(pro.getProperty("app.dd.id"));
        info.setDd_secret(pro.getProperty("app.dd.secret"));
        info.setDd_tokenUrl(pro.getProperty("app.dd.token.url"));
        info.setOpenIdUrl(pro.getProperty("app.tickttoken.url"));
        info.setAuthURL(pro.getProperty("app.auth.url") == null ? AUTH_URL : pro.getProperty("app.auth.url"));
        info.setQrcodeUrl(pro.getProperty("app.logincode.url"));
        info.setPortalEnableQrcode(StringUtils.isEmpty((String)pro.getProperty("portal.enableqrcode")) ? false : Boolean.parseBoolean(pro.getProperty("portal.enableqrcode")));
        info.setGuiEnableQrcode(StringUtils.isEmpty((String)pro.getProperty("gui.enableqrcode")) ? false : Boolean.parseBoolean(pro.getProperty("gui.enableqrcode")));
        boolean isOnlineSubscript = ControlPolicy.isBySubscriptionRegOnline((Context)ctx);
        info.setCloudPublic(isOnlineSubscript);
        if (StringUtils.isEmpty((String)pro.getProperty("eas.defaultLoginType"))) {
            info.setDefaultLogin(StringUtils.isEmpty((String)pro.getProperty("portal.isqrcodedefault")) ? QRCODE : (isOnlineSubscript ? YZJ : EAS));
        } else {
            String defaultLoginType = pro.getProperty("eas.defaultLoginType");
            if (!isOnlineSubscript && YZJ.equals(defaultLoginType)) {
                info.setSave(true);
                info.setDefaultLogin(EAS);
            } else {
                info.setDefaultLogin(defaultLoginType);
            }
        }
        int authType = Integer.parseInt(pro.getProperty("authType"));
        info.setAuthType(authType);
        if (1 == authType || 2 == authType) {
            int errNum = Integer.parseInt(pro.getProperty("errNum") == null ? "-1" : pro.getProperty("errNum"));
            info.setErrNum(errNum);
        }
        info.setPrivacyStatement(pro.getProperty("privacyStatement"));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file) throws IOException {
        String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + GLOBLE_LOGIN_PROP_NAME;
        File file0 = new File(configFile);
        if (!file0.exists()) {
            file0.createNewFile();
            OutputStream output = null;
            FileInputStream input = null;
            try {
                int bytesRead;
                input = new FileInputStream(file);
                output = new FileOutputStream(file0);
                byte[] buf = new byte[1024];
                while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                    output.write(buf, 0, bytesRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void verify(GlobleLoginConfigInfo info) throws GlobleLoginException {
        if (StringUtils.isEmpty((String)info.getAppId())) {
            throw new GlobleLoginException(GlobleLoginException.APPID_NULL);
        }
        if (StringUtils.isEmpty((String)info.getQrcodeUrl())) {
            throw new GlobleLoginException(GlobleLoginException.QRCODEURL_NULL);
        }
        if (StringUtils.isEmpty((String)info.getAuthURL())) {
            throw new GlobleLoginException(GlobleLoginException.AUTHURL_NULL);
        }
        if (StringUtils.isEmpty((String)info.getOpenIdUrl())) {
            throw new GlobleLoginException(GlobleLoginException.OPENIDURL_NULL);
        }
        if (StringUtils.isEmpty((String)info.getCallBackUrl())) {
            throw new GlobleLoginException(GlobleLoginException.CALLBACKURL_NULL);
        }
    }

    private void clearBizCache() {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            logger.error("sv\u4e3a\u7a7a");
            new LoginConfigCache().clearCache();
            return;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || GlobleLoginConfigService.isLocal(url)) continue;
            try {
                ILoginConfigCache qct = (ILoginConfigCache)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.base.uiframe.globlelogin.LoginConfigCache", ILoginConfigCache.class);
                qct.clearCache();
                continue;
            }
            catch (Exception e) {
                logger.error("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean syncClusterConfig(Context ctx, GlobleLoginConfigInfo info) throws BOSException, EASBizException {
        String configFile = System.getProperty(PROPERTIES_DIR_ENV_NAME) + File.separator + GLOBLE_LOGIN_PROP_NAME;
        File file = new File(configFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25!");
                throw new BOSException((Throwable)e);
            }
        }
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(configFile);
            String type = info.getDefaultLogin();
            config.setProperty("eas.defaultLoginType", (Object)type);
            if (QRCODE.equals(type)) {
                config.setProperty("portal.isqrcodedefault", (Object)true);
            } else {
                config.setProperty("portal.isqrcodedefault", (Object)false);
            }
            config.setProperty("portal.enableqrcode", (Object)info.isPortalEnableQrcode());
            config.setProperty("app.id", (Object)info.getAppId());
            config.setProperty("app.secret", (Object)info.getSecret());
            config.setProperty("app.callback.url", (Object)info.getCallBackUrl());
            config.setProperty("app.dd.id", (Object)info.getDd_appId());
            config.setProperty("app.dd.secret", (Object)info.getDd_secret());
            config.setProperty("app.dd.token.url", (Object)info.getDd_tokenUrl());
            config.setProperty("app.tickttoken.url", (Object)info.getOpenIdUrl());
            config.setProperty("app.auth.url", (Object)info.getAuthURL());
            config.setProperty("app.logincode.url", (Object)info.getQrcodeUrl());
            config.setProperty("authType", (Object)info.getAuthType());
            if (info.getAuthType() == 1) {
                config.setProperty("errNum", (Object)info.getErrNum());
            }
            config.save();
        }
        catch (ConfigurationException e) {
            logger.error("\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private void syncConfig(Context ctx, GlobleLoginConfigInfo info) {
        try {
            String syncUrl = SyncClusterFileUtil.getSyncUrl();
            if (StringUtils.isEmpty((String)syncUrl)) {
                logger.error("syncUrl\u4e3a\u7a7a");
                return;
            }
            IGlobleLoginConfigService srv = (IGlobleLoginConfigService)RPCEngineFactory.getEngine((String)syncUrl).createObject("com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigService", IGlobleLoginConfigService.class);
            srv.syncClusterConfig(ctx, info);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4ece\u673a\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

