/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.weibo.app.AbstractEcaFacadeControllerBean;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.mcloud.admin.action.xt.base.secruity.RSAUtils;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.util.ConfigurationItem;
import java.io.File;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class EcaFacadeControllerBean
extends AbstractEcaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.EcaFacadeControllerBean");

    @Override
    protected boolean _checkIsOpen(Context ctx) throws BOSException {
        ConfigurationItem xtItem = PortalConfig.getConfiguration().getConfigItem("XT_EAS");
        if (xtItem == null) {
            return false;
        }
        String cust3gNo = xtItem.getProperty("cust3gNo");
        String xtUrl = xtItem.getProperty("xtUrl");
        String xtAgentUrl = xtItem.getProperty("xtAgentUrl");
        String keyPath = System.getProperty("EAS_HOME");
        keyPath = keyPath + Constant.SYSTEM_PATH_SEPARATOR + xtItem.getProperty("keyPath");
        return cust3gNo != null && !cust3gNo.equals("") && xtUrl != null && !xtUrl.equals("") && xtAgentUrl != null && !xtAgentUrl.equals("") && keyPath != null && !keyPath.equals("");
    }

    @Override
    protected Map _login(Context ctx, String userId) throws BOSException {
        return null;
    }

    @Override
    protected String _sendMessage(Context ctx, String userId, String toUsers, String content) throws BOSException {
        return null;
    }

    @Override
    protected String _sendFile(Context ctx, String userId, String toUsers, byte[] content) throws BOSException {
        return null;
    }

    @Override
    protected List _searchUser(Context ctx, String userId, String word) throws BOSException {
        return null;
    }

    @Override
    protected HashMap _getInitConfig(Context ctx) throws BOSException {
        ConfigurationItem xtItem = PortalConfig.getConfiguration().getConfigItem("XT_EAS");
        HashMap<String, String> hm = new HashMap<String, String>();
        String personId = this.getCurrentPersonId(ctx);
        String keyPath = System.getProperty("EAS_HOME");
        keyPath = keyPath + Constant.SYSTEM_PATH_SEPARATOR + xtItem.getProperty("keyPath");
        String token = this.genXtToken(keyPath, xtItem.getProperty("cust3gNo"), personId);
        hm.put("cust3gNo", xtItem.getProperty("cust3gNo"));
        hm.put("xtUrl", xtItem.getProperty("xtUrl"));
        hm.put("xtAgentUrl", xtItem.getProperty("xtAgentUrl"));
        hm.put("personId", personId);
        hm.put("token", token);
        logger.error((Object)("getInitConfig result:personId=" + personId + ",token=" + token));
        return hm;
    }

    private String getCurrentPersonId(Context ctx) {
        String personId = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getPerson() != null) {
            personId = userInfo.getPerson().getId().toString();
        }
        return personId;
    }

    private String genXtToken(String keyPath, String cust3gNo, String personId) {
        String token = null;
        try {
            PublicKey publicKey = this.getPublicKey(keyPath, cust3gNo);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            String src = cust3gNo + "|" + personId;
            byte[] rsaBytes = cipher.doFinal(src.getBytes());
            byte[] base64Bytes = Base64.encodeBase64((byte[])rsaBytes);
            token = new String(base64Bytes);
            logger.error((Object)("genXtToken:" + token));
        }
        catch (Exception e) {
            logger.error((Object)"genXtToken error!", (Throwable)e);
        }
        return token;
    }

    private PublicKey getPublicKey(String keyPath, String cust3gNo) {
        try {
            PublicKey publicKey = RSAUtils.restorePublicKey(FileUtils.readFileToByteArray((File)new File(keyPath + cust3gNo + ".pub.key")));
            return publicKey;
        }
        catch (Exception e) {
            logger.error((Object)"getPrivateKey error!", (Throwable)e);
            return null;
        }
    }
}

